/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.EnumLength;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.layoutmgr.inline.ImageLayout;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.render.RendererEventProducer;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FoUnitsConverter;
import org.apache.fop.render.rtf.ListAttributesConverter;
import org.apache.fop.render.rtf.PageAttributesConverter;
import org.apache.fop.render.rtf.RTFEventProducer;
import org.apache.fop.render.rtf.TableAttributesConverter;
import org.apache.fop.render.rtf.TextAttributesConverter;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAfter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBefore;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfDocumentArea;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraphBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSection;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;
import org.apache.fop.render.rtf.rtflib.tools.BuilderContext;
import org.apache.fop.render.rtf.rtflib.tools.PercentContext;
import org.apache.fop.render.rtf.rtflib.tools.TableContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RTFHandler
extends FOEventHandler {
    private RtfFile rtfFile;
    private final OutputStream os;
    private static Log log = LogFactory.getLog(RTFHandler.class);
    private RtfSection sect;
    private RtfDocumentArea docArea;
    private boolean bDefer;
    private boolean bPrevHeaderSpecified;
    private boolean bPrevFooterSpecified;
    private boolean bHeaderSpecified;
    private boolean bFooterSpecified;
    private BuilderContext builderContext = new BuilderContext(null);
    private SimplePageMaster pagemaster;
    private int nestedTableDepth = 1;
    private PercentContext percentManager = new PercentContext();
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_EMF, ImageFlavor.RAW_PNG, ImageFlavor.RAW_JPEG};

    public RTFHandler(FOUserAgent fOUserAgent, OutputStream outputStream) {
        super(fOUserAgent);
        this.os = outputStream;
        this.bDefer = true;
        boolean bl = false;
        FontSetup.setup((FontInfo)this.fontInfo, null, (InternalResourceResolver)fOUserAgent.getResourceResolver(), (boolean)bl);
    }

    protected void handleIOTrouble(IOException iOException) {
        RendererEventProducer rendererEventProducer = RendererEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
        rendererEventProducer.ioError((Object)this, iOException);
    }

    public void startDocument() throws SAXException {
        try {
            this.rtfFile = new RtfFile((Writer)new OutputStreamWriter(this.os));
            this.docArea = this.rtfFile.startDocumentArea();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.rtfFile.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPageSequence(PageSequence pageSequence) {
        try {
            String string;
            if (this.pagemaster == null) {
                string = pageSequence.getMasterReference();
                this.pagemaster = pageSequence.getRoot().getLayoutMasterSet().getSimplePageMaster(string);
                if (this.pagemaster == null) {
                    RTFEventProducer rTFEventProducer = RTFEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                    rTFEventProducer.onlySPMSupported((Object)this, string, pageSequence.getLocator());
                    PageSequenceMaster pageSequenceMaster = pageSequence.getRoot().getLayoutMasterSet().getPageSequenceMaster(string);
                    if (pageSequence.getMainFlow() != null) {
                        this.pagemaster = pageSequenceMaster.getNextSimplePageMaster(false, false, false, false, pageSequence.getMainFlow().getFlowName(), false);
                    }
                }
            }
            if (this.bDefer) {
                return;
            }
            this.sect = this.docArea.newSection();
            if (this.pagemaster != null) {
                this.sect.getRtfAttributes().set(PageAttributesConverter.convertPageAttributes((SimplePageMaster)this.pagemaster));
            } else {
                string = RTFEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                string.noSPMFound((Object)this, pageSequence.getLocator());
            }
            this.builderContext.pushContainer((RtfContainer)this.sect);
            int n2 = this.pagemaster.getPageWidth().getValue() - this.pagemaster.getCommonMarginBlock().marginLeft.getValue() - this.pagemaster.getCommonMarginBlock().marginRight.getValue() - this.sect.getRtfAttributes().getValueAsInteger("margl") - this.sect.getRtfAttributes().getValueAsInteger("margr");
            this.percentManager.setDimension((FObj)pageSequence, n2);
            this.bHeaderSpecified = false;
            this.bFooterSpecified = false;
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
    }

    public void endPageSequence(PageSequence pageSequence) {
        if (this.bDefer) {
            this.bDefer = false;
            this.recurseFONode((FONode)((Object)pageSequence));
            this.pagemaster = null;
            this.bDefer = true;
            return;
        }
        this.builderContext.popContainer(RtfSection.class, this);
        this.pagemaster = null;
    }

    public void startFlow(Flow flow) {
        if (this.bDefer) {
            return;
        }
        try {
            log.debug((Object)("starting flow: " + flow.getFlowName()));
            boolean bl = false;
            Region region = this.pagemaster.getRegion(58);
            Region region2 = this.pagemaster.getRegion(57);
            Region region3 = this.pagemaster.getRegion(56);
            if (flow.getFlowName().equals(region.getRegionName())) {
                IRtfBeforeContainer iRtfBeforeContainer;
                RtfAttributes rtfAttributes;
                if (this.bPrevHeaderSpecified && !this.bHeaderSpecified) {
                    rtfAttributes = new RtfAttributes();
                    rtfAttributes.set("header");
                    iRtfBeforeContainer = (IRtfBeforeContainer)this.builderContext.getContainer(IRtfBeforeContainer.class, true, (Object)this);
                    iRtfBeforeContainer.newBefore(rtfAttributes);
                }
                if (this.bPrevFooterSpecified && !this.bFooterSpecified) {
                    rtfAttributes = new RtfAttributes();
                    rtfAttributes.set("footer");
                    iRtfBeforeContainer = (IRtfAfterContainer)this.builderContext.getContainer(IRtfAfterContainer.class, true, (Object)this);
                    iRtfBeforeContainer.newAfter(rtfAttributes);
                }
                bl = true;
            } else if (region2 != null && flow.getFlowName().equals(region2.getRegionName())) {
                this.bHeaderSpecified = true;
                this.bPrevHeaderSpecified = true;
                IRtfBeforeContainer iRtfBeforeContainer = (IRtfBeforeContainer)this.builderContext.getContainer(IRtfBeforeContainer.class, true, (Object)this);
                RtfAttributes rtfAttributes = ((RtfElement)iRtfBeforeContainer).getRtfAttributes();
                if (rtfAttributes == null) {
                    rtfAttributes = new RtfAttributes();
                }
                rtfAttributes.set("header");
                RtfBefore rtfBefore = iRtfBeforeContainer.newBefore(rtfAttributes);
                this.builderContext.pushContainer((RtfContainer)rtfBefore);
                bl = true;
            } else if (region3 != null && flow.getFlowName().equals(region3.getRegionName())) {
                this.bFooterSpecified = true;
                this.bPrevFooterSpecified = true;
                IRtfAfterContainer iRtfAfterContainer = (IRtfAfterContainer)this.builderContext.getContainer(IRtfAfterContainer.class, true, (Object)this);
                RtfAttributes rtfAttributes = ((RtfElement)iRtfAfterContainer).getRtfAttributes();
                if (rtfAttributes == null) {
                    rtfAttributes = new RtfAttributes();
                }
                rtfAttributes.set("footer");
                RtfAfter rtfAfter = iRtfAfterContainer.newAfter(rtfAttributes);
                this.builderContext.pushContainer((RtfContainer)rtfAfter);
                bl = true;
            }
            if (!bl) {
                log.warn((Object)("A " + flow.getLocalName() + " has been skipped: " + flow.getFlowName()));
            }
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startFlow: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endFlow(Flow flow) {
        if (this.bDefer) {
            return;
        }
        try {
            Region region = this.pagemaster.getRegion(58);
            Region region2 = this.pagemaster.getRegion(57);
            Region region3 = this.pagemaster.getRegion(56);
            if (!flow.getFlowName().equals(region.getRegionName())) {
                if (region2 != null && flow.getFlowName().equals(region2.getRegionName())) {
                    this.builderContext.popContainer(RtfBefore.class, this);
                } else if (region3 != null && flow.getFlowName().equals(region3.getRegionName())) {
                    this.builderContext.popContainer(RtfAfter.class, this);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("endFlow: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void startBlock(Block block) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttributes = TextAttributesConverter.convertAttributes((Block)block);
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addParagraphBreak();
            rtfTextrun.pushBlockAttributes(rtfAttributes);
            rtfTextrun.addBookmark(block.getId());
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startBlock: " + exception.getMessage()));
            throw new RuntimeException("Exception: " + exception);
        }
    }

    public void endBlock(Block block) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            RtfParagraphBreak rtfParagraphBreak = rtfTextrun.addParagraphBreak();
            RtfTableCell rtfTableCell = (RtfTableCell)rtfTextrun.getParentOfClass(RtfTableCell.class);
            if (rtfTableCell != null && rtfParagraphBreak != null) {
                rtfTableCell.setLastParagraph(rtfParagraphBreak);
            }
            int n2 = this.toRtfBreakValue(block.getBreakAfter());
            rtfTextrun.popBlockAttributes(n2);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startBlock:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void startBlockContainer(BlockContainer blockContainer) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttributes = TextAttributesConverter.convertBlockContainerAttributes((BlockContainer)blockContainer);
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addParagraphBreak();
            rtfTextrun.pushBlockAttributes(rtfAttributes);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startBlock: " + exception.getMessage()));
            throw new RuntimeException("Exception: " + exception);
        }
    }

    public void endBlockContainer(BlockContainer blockContainer) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addParagraphBreak();
            int n2 = this.toRtfBreakValue(blockContainer.getBreakAfter());
            rtfTextrun.popBlockAttributes(n2);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startBlock:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    private int toRtfBreakValue(int n2) {
        switch (n2) {
            case 104: {
                return 1;
            }
            case 44: {
                return 3;
            }
            case 100: {
                return 4;
            }
            case 28: {
                return 2;
            }
        }
        return 0;
    }

    public void startTable(Table table) {
        if (this.bDefer) {
            return;
        }
        TableContext tableContext = new TableContext(this.builderContext);
        try {
            IRtfTableContainer iRtfTableContainer = (IRtfTableContainer)this.builderContext.getContainer(IRtfTableContainer.class, true, null);
            RtfAttributes rtfAttributes = TableAttributesConverter.convertTableAttributes((Table)table);
            RtfTable rtfTable = iRtfTableContainer.newTable(rtfAttributes, (ITableColumnsInfo)tableContext);
            rtfTable.setNestedTableDepth(this.nestedTableDepth);
            ++this.nestedTableDepth;
            CommonBorderPaddingBackground commonBorderPaddingBackground = table.getCommonBorderPaddingBackground();
            RtfAttributes rtfAttributes2 = new RtfAttributes();
            BorderAttributesConverter.makeBorder((CommonBorderPaddingBackground)commonBorderPaddingBackground, (int)0, (RtfAttributes)rtfAttributes2, (String)"clbrdrt");
            BorderAttributesConverter.makeBorder((CommonBorderPaddingBackground)commonBorderPaddingBackground, (int)1, (RtfAttributes)rtfAttributes2, (String)"clbrdrb");
            BorderAttributesConverter.makeBorder((CommonBorderPaddingBackground)commonBorderPaddingBackground, (int)2, (RtfAttributes)rtfAttributes2, (String)"clbrdrl");
            BorderAttributesConverter.makeBorder((CommonBorderPaddingBackground)commonBorderPaddingBackground, (int)3, (RtfAttributes)rtfAttributes2, (String)"clbrdrr");
            rtfTable.setBorderAttributes(rtfAttributes2);
            this.builderContext.pushContainer((RtfContainer)rtfTable);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startTable:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
        this.builderContext.pushTableContext(tableContext);
    }

    public void endTable(Table table) {
        if (this.bDefer) {
            return;
        }
        --this.nestedTableDepth;
        this.builderContext.popTableContext();
        this.builderContext.popContainer(RtfTable.class, this);
    }

    public void startColumn(TableColumn tableColumn) {
        if (this.bDefer) {
            return;
        }
        try {
            int n2 = tableColumn.getColumnWidth().getValue((PercentBaseContext)this.percentManager);
            this.percentManager.setDimension((FObj)tableColumn, n2);
            Float f2 = Float.valueOf(FoUnitsConverter.getInstance().convertMptToTwips(n2));
            this.builderContext.getTableContext().setNextColumnWidth(f2);
            this.builderContext.getTableContext().setNextColumnRowSpanning(Integer.valueOf(0), null);
            this.builderContext.getTableContext().setNextFirstSpanningCol(false);
        }
        catch (Exception exception) {
            log.error((Object)("startColumn: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endColumn(TableColumn tableColumn) {
    }

    public void startHeader(TableHeader tableHeader) {
        this.builderContext.pushPart((FObj)tableHeader);
        this.startPart((TablePart)tableHeader);
    }

    public void endHeader(TableHeader tableHeader) {
        this.builderContext.popPart(tableHeader.getClass(), this);
        this.endPart((TablePart)tableHeader);
    }

    public void startFooter(TableFooter tableFooter) {
        this.builderContext.pushPart((FObj)tableFooter);
        this.startPart((TablePart)tableFooter);
    }

    public void endFooter(TableFooter tableFooter) {
        this.builderContext.popPart(tableFooter.getClass(), this);
        this.endPart((TablePart)tableFooter);
    }

    public void startInline(Inline inline) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttributes = TextAttributesConverter.convertCharacterAttributes((Inline)inline);
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.pushInlineAttributes(rtfAttributes);
            rtfTextrun.addBookmark(inline.getId());
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (FOPException fOPException) {
            log.error((Object)("startInline:" + fOPException.getMessage()));
            throw new RuntimeException(fOPException.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)("startInline:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endInline(Inline inline) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.popInlineAttributes();
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startInline:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void startPart(TablePart tablePart) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttributes = TableAttributesConverter.convertTablePartAttributes((TablePart)tablePart);
            RtfTable rtfTable = (RtfTable)this.builderContext.getContainer(RtfTable.class, true, (Object)this);
            rtfTable.setHeaderAttribs(rtfAttributes);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startPart: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void endPart(TablePart tablePart) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable rtfTable = (RtfTable)this.builderContext.getContainer(RtfTable.class, true, (Object)this);
            rtfTable.setHeaderAttribs(null);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("endPart: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void startBody(TableBody tableBody) {
        this.builderContext.pushPart((FObj)tableBody);
        this.startPart((TablePart)tableBody);
    }

    public void endBody(TableBody tableBody) {
        this.builderContext.popPart(TableBody.class, this);
        this.endPart((TablePart)tableBody);
    }

    public void startRow(TableRow tableRow) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable rtfTable = (RtfTable)this.builderContext.getContainer(RtfTable.class, true, null);
            RtfAttributes rtfAttributes = TableAttributesConverter.convertRowAttributes((TableRow)tableRow, (RtfAttributes)rtfTable.getHeaderAttribs());
            if (tableRow.getParent() instanceof TableHeader) {
                rtfAttributes.set("trhdr");
            }
            this.builderContext.pushContainer((RtfContainer)rtfTable.newTableRow(rtfAttributes));
            this.builderContext.getTableContext().selectFirstColumn();
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startRow: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endRow(TableRow tableRow) {
        if (this.bDefer) {
            return;
        }
        try {
            TableContext tableContext = this.builderContext.getTableContext();
            RtfTableRow rtfTableRow = (RtfTableRow)this.builderContext.getContainer(RtfTableRow.class, true, null);
            while (tableContext.getNumberOfColumns() > tableContext.getColumnIndex() && tableContext.getColumnRowSpanningNumber() > 0) {
                RtfTableCell rtfTableCell = rtfTableRow.newTableCellMergedVertically((int)tableContext.getColumnWidth(), tableContext.getColumnRowSpanningAttrs());
                if (!tableContext.getFirstSpanningCol()) {
                    rtfTableCell.setHMerge(2);
                }
                tableContext.selectNextColumn();
            }
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("endRow: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
        this.builderContext.popContainer(RtfTableRow.class, this);
        this.builderContext.getTableContext().decreaseRowSpannings();
    }

    public void startCell(TableCell tableCell) {
        if (this.bDefer) {
            return;
        }
        try {
            TableContext tableContext = this.builderContext.getTableContext();
            RtfTableRow rtfTableRow = (RtfTableRow)this.builderContext.getContainer(RtfTableRow.class, true, null);
            int n2 = tableCell.getNumberRowsSpanned();
            int n3 = tableCell.getNumberColumnsSpanned();
            while (tableContext.getNumberOfColumns() > tableContext.getColumnIndex() && tableContext.getColumnRowSpanningNumber() > 0) {
                RtfTableCell rtfTableCell = rtfTableRow.newTableCellMergedVertically((int)tableContext.getColumnWidth(), tableContext.getColumnRowSpanningAttrs());
                if (!tableContext.getFirstSpanningCol()) {
                    rtfTableCell.setHMerge(2);
                }
                tableContext.selectNextColumn();
            }
            float f2 = tableContext.getColumnWidth();
            RtfAttributes rtfAttributes = TableAttributesConverter.convertCellAttributes((TableCell)tableCell);
            RtfTableCell rtfTableCell = rtfTableRow.newTableCell((int)f2, rtfAttributes);
            if (n2 > 1) {
                rtfTableCell.setVMerge(1);
                tableContext.setCurrentColumnRowSpanning(Integer.valueOf(n2), rtfTableCell.getRtfAttributes());
            } else {
                tableContext.setCurrentColumnRowSpanning(Integer.valueOf(n2), null);
            }
            if (n3 > 0) {
                tableContext.setCurrentFirstSpanningCol(true);
                for (int i2 = 0; i2 < n3 - 1; ++i2) {
                    tableContext.selectNextColumn();
                    f2 += tableContext.getColumnWidth();
                    tableContext.setCurrentFirstSpanningCol(false);
                    RtfTableCell rtfTableCell2 = rtfTableRow.newTableCellMergedHorizontally(0, null);
                    if (n2 > 1) {
                        rtfTableCell2.setVMerge(1);
                        tableContext.setCurrentColumnRowSpanning(Integer.valueOf(n2), rtfTableCell.getRtfAttributes());
                        continue;
                    }
                    tableContext.setCurrentColumnRowSpanning(Integer.valueOf(n2), rtfTableCell.getRtfAttributes());
                }
            }
            this.percentManager.setDimension((FObj)tableCell, (int)f2 * 50);
            this.builderContext.pushContainer((RtfContainer)rtfTableCell);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startCell: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endCell(TableCell tableCell) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTableCell rtfTableCell = (RtfTableCell)this.builderContext.getContainer(RtfTableCell.class, false, (Object)this);
            rtfTableCell.finish();
        }
        catch (Exception exception) {
            log.error((Object)("endCell: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
        this.builderContext.popContainer(RtfTableCell.class, this);
        this.builderContext.getTableContext().selectNextColumn();
    }

    public void startList(ListBlock listBlock) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfListContainer iRtfListContainer = (IRtfListContainer)this.builderContext.getContainer(IRtfListContainer.class, true, (Object)this);
            RtfList rtfList = iRtfListContainer.newList(ListAttributesConverter.convertAttributes((ListBlock)listBlock));
            this.builderContext.pushContainer((RtfContainer)rtfList);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (FOPException fOPException) {
            log.error((Object)("startList: " + fOPException.getMessage()));
            throw new RuntimeException(fOPException.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)("startList: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endList(ListBlock listBlock) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer(RtfList.class, this);
    }

    public void startListItem(ListItem listItem) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfList rtfList = (RtfList)this.builderContext.getContainer(RtfList.class, true, (Object)this);
            if (rtfList.getChildCount() > 0) {
                this.endListBody(null);
                this.endList((ListBlock)((Object)listItem.getParent()));
                this.startList((ListBlock)((Object)listItem.getParent()));
                this.startListBody(null);
                rtfList = (RtfList)this.builderContext.getContainer(RtfList.class, true, (Object)this);
            }
            this.builderContext.pushContainer((RtfContainer)rtfList.newListItem());
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startList: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endListItem(ListItem listItem) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer(RtfListItem.class, this);
    }

    public void startListLabel(ListItemLabel listItemLabel) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfListItem rtfListItem;
            RtfListItem rtfListItem2 = rtfListItem = (RtfListItem)this.builderContext.getContainer(RtfListItem.class, true, (Object)this);
            Objects.requireNonNull(rtfListItem2);
            RtfListItem.RtfListItemLabel rtfListItemLabel = new RtfListItem.RtfListItemLabel(rtfListItem2, rtfListItem);
            this.builderContext.pushContainer((RtfContainer)rtfListItemLabel);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startPageNumber: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endListLabel(ListItemLabel listItemLabel) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer(RtfListItem.RtfListItemLabel.class, this);
    }

    public void startListBody(ListItemBody listItemBody) {
    }

    public void endListBody(ListItemBody listItemBody) {
    }

    public void startStatic(StaticContent staticContent) {
    }

    public void endStatic(StaticContent staticContent) {
    }

    public void startMarkup() {
    }

    public void endMarkup() {
    }

    public void startLink(BasicLink basicLink) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            RtfHyperLink rtfHyperLink = rtfTextrun.addHyperlink(new RtfAttributes());
            if (basicLink.hasExternalDestination()) {
                rtfHyperLink.setExternalURL(basicLink.getExternalDestination());
            } else {
                rtfHyperLink.setInternalURL(basicLink.getInternalDestination());
            }
            this.builderContext.pushContainer((RtfContainer)rtfHyperLink);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startLink: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endLink(BasicLink basicLink) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer(RtfHyperLink.class, this);
    }

    public void image(ExternalGraphic externalGraphic) {
        if (this.bDefer) {
            return;
        }
        String string = externalGraphic.getURL();
        ImageInfo imageInfo = null;
        try {
            FOUserAgent fOUserAgent = externalGraphic.getUserAgent();
            ImageManager imageManager = fOUserAgent.getImageManager();
            imageInfo = imageManager.getImageInfo(string, fOUserAgent.getImageSessionContext());
            this.putGraphic((AbstractGraphics)externalGraphic, imageInfo);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError((Object)this, string, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound((Object)this, imageInfo != null ? imageInfo.toString() : string, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError((Object)this, imageInfo != null ? imageInfo.toString() : string, iOException, null);
        }
    }

    public void endInstreamForeignObject(InstreamForeignObject instreamForeignObject) {
        if (this.bDefer) {
            return;
        }
        try {
            XMLObj xMLObj = instreamForeignObject.getChildXMLObj();
            Document document = xMLObj.getDOMDocument();
            String string = xMLObj.getNamespaceURI();
            ImageInfo imageInfo = new ImageInfo(null, null);
            FOUserAgent fOUserAgent = instreamForeignObject.getUserAgent();
            ImageSize imageSize = new ImageSize();
            imageSize.setResolution((double)fOUserAgent.getSourceResolution());
            Point2D.Float float_ = new Point2D.Float(-1.0f, -1.0f);
            Point2D point2D = xMLObj.getDimension((Point2D)float_);
            if (point2D == null) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                resourceEventProducer.ifoNoIntrinsicSize((Object)this, xMLObj.getLocator());
                return;
            }
            imageSize.setSizeInMillipoints((int)Math.round(point2D.getX() * 1000.0), (int)Math.round(point2D.getY() * 1000.0));
            imageSize.calcPixelsFromSize();
            imageInfo.setSize(imageSize);
            ImageXMLDOM imageXMLDOM = new ImageXMLDOM(imageInfo, document, string);
            FOUserAgent fOUserAgent2 = instreamForeignObject.getUserAgent();
            ImageManager imageManager = fOUserAgent2.getImageManager();
            Map map = ImageUtil.getDefaultHints((ImageSessionContext)fOUserAgent.getImageSessionContext());
            Image image = imageManager.convertImage((Image)imageXMLDOM, FLAVORS, map);
            this.putGraphic((AbstractGraphics)instreamForeignObject, image);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError((Object)this, null, imageException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError((Object)this, null, iOException, null);
        }
    }

    private void putGraphic(AbstractGraphics abstractGraphics, ImageInfo imageInfo) throws IOException {
        try {
            FOUserAgent fOUserAgent = abstractGraphics.getUserAgent();
            ImageManager imageManager = fOUserAgent.getImageManager();
            ImageSessionContext imageSessionContext = fOUserAgent.getImageSessionContext();
            Map map = ImageUtil.getDefaultHints((ImageSessionContext)imageSessionContext);
            Image image = imageManager.getImage(imageInfo, FLAVORS, map, imageSessionContext);
            this.putGraphic(abstractGraphics, image);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError((Object)this, null, imageException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putGraphic(AbstractGraphics abstractGraphics, Image image) throws IOException {
        Object object;
        Object object2;
        byte[] byArray = null;
        final ImageInfo imageInfo = image.getInfo();
        if (image instanceof ImageRawStream) {
            object2 = (ImageRawStream)image;
            object = object2.createInputStream();
            try {
                byArray = IOUtils.toByteArray((InputStream)object);
            }
            finally {
                IOUtils.closeQuietly((InputStream)object);
            }
        }
        if (byArray == null) {
            object2 = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            object2.imageWritingError((Object)this, null);
            return;
        }
        this.percentManager.setDimension((FObj)abstractGraphics);
        object2 = new PercentBaseContext(){

            public int getBaseLength(int n2, FObj fObj) {
                switch (n2) {
                    case 7: {
                        return imageInfo.getSize().getWidthMpt();
                    }
                    case 8: {
                        return imageInfo.getSize().getHeightMpt();
                    }
                }
                return RTFHandler.this.percentManager.getBaseLength(n2, fObj);
            }
        };
        object = new ImageLayout(abstractGraphics, (PercentBaseContext)object2, image.getInfo().getSize().getDimensionMpt());
        IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
        RtfExternalGraphic rtfExternalGraphic = iRtfTextrunContainer.getTextrun().newImage();
        if (imageInfo.getOriginalURI() != null) {
            rtfExternalGraphic.setURL(imageInfo.getOriginalURI());
        }
        rtfExternalGraphic.setImageData(byArray);
        FoUnitsConverter foUnitsConverter = FoUnitsConverter.getInstance();
        Dimension dimension = ((ImageLayout)object).getViewportSize();
        Rectangle rectangle = ((ImageLayout)object).getPlacement();
        int n2 = Math.round(foUnitsConverter.convertMptToTwips(-rectangle.x));
        int n3 = Math.round(foUnitsConverter.convertMptToTwips(-rectangle.y));
        int n4 = Math.round(foUnitsConverter.convertMptToTwips(-1 * (dimension.width - rectangle.x - rectangle.width)));
        int n5 = Math.round(foUnitsConverter.convertMptToTwips(-1 * (dimension.height - rectangle.y - rectangle.height)));
        rtfExternalGraphic.setCropping(n2, n3, n4, n5);
        int n6 = Math.round(foUnitsConverter.convertMptToTwips(dimension.width));
        int n7 = Math.round(foUnitsConverter.convertMptToTwips(dimension.height));
        rtfExternalGraphic.setWidthTwips(n6 += n2 + n4);
        rtfExternalGraphic.setHeightTwips(n7 += n3 + n5);
        int n8 = 0;
        if (n8 != 0 && !rtfExternalGraphic.setCompressionRate(n8)) {
            log.warn((Object)("The compression rate " + n8 + " is invalid. The value has to be between 1 and 100 %."));
        }
    }

    public void pageRef() {
    }

    public void startFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            RtfFootnote rtfFootnote = rtfTextrun.addFootnote();
            this.builderContext.pushContainer((RtfContainer)rtfFootnote);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startFootnote: " + exception.getMessage()));
            throw new RuntimeException("Exception: " + exception);
        }
    }

    public void endFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer(RtfFootnote.class, this);
    }

    public void startFootnoteBody(FootnoteBody footnoteBody) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(RtfFootnote.class, true, (Object)this);
            rtfFootnote.startBody();
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startFootnoteBody: " + exception.getMessage()));
            throw new RuntimeException("Exception: " + exception);
        }
    }

    public void endFootnoteBody(FootnoteBody footnoteBody) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(RtfFootnote.class, true, (Object)this);
            rtfFootnote.endBody();
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("endFootnoteBody: " + exception.getMessage()));
            throw new RuntimeException("Exception: " + exception);
        }
    }

    public void startLeader(Leader leader) {
        if (this.bDefer) {
            return;
        }
        try {
            this.percentManager.setDimension((FObj)leader);
            RtfAttributes rtfAttributes = TextAttributesConverter.convertLeaderAttributes((Leader)leader, (PercentBaseContext)this.percentManager);
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addLeader(rtfAttributes);
        }
        catch (IOException iOException) {
            log.error((Object)("startLeader: " + iOException.getMessage()));
            throw new RuntimeException(iOException.getMessage());
        }
        catch (FOPException fOPException) {
            log.error((Object)("startLeader: " + fOPException.getMessage()));
            throw new RuntimeException(fOPException.getMessage());
        }
    }

    public void text(FOText fOText, CharSequence charSequence) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            RtfAttributes rtfAttributes = TextAttributesConverter.convertCharacterAttributes((FOText)fOText);
            rtfTextrun.pushInlineAttributes(rtfAttributes);
            rtfTextrun.addString(charSequence.toString());
            rtfTextrun.popInlineAttributes();
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("characters:" + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void startPageNumber(PageNumber pageNumber) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttributes = TextAttributesConverter.convertCharacterAttributes((PageNumber)pageNumber);
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addPageNumber(rtfAttributes);
        }
        catch (IOException iOException) {
            this.handleIOTrouble(iOException);
        }
        catch (Exception exception) {
            log.error((Object)("startPageNumber: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void endPageNumber(PageNumber pageNumber) {
    }

    public void startPageNumberCitation(PageNumberCitation pageNumberCitation) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addPageNumberCitation(pageNumberCitation.getRefId());
        }
        catch (Exception exception) {
            log.error((Object)("startPageNumberCitation: " + exception.getMessage()));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void startPageNumberCitationLast(PageNumberCitationLast pageNumberCitationLast) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer iRtfTextrunContainer = (IRtfTextrunContainer)this.builderContext.getContainer(IRtfTextrunContainer.class, true, (Object)this);
            RtfTextrun rtfTextrun = iRtfTextrunContainer.getTextrun();
            rtfTextrun.addPageNumberCitation(pageNumberCitationLast.getRefId());
        }
        catch (RtfException rtfException) {
            log.error((Object)("startPageNumberCitationLast: " + rtfException.getMessage()));
            throw new RuntimeException(rtfException.getMessage());
        }
        catch (IOException iOException) {
            log.error((Object)("startPageNumberCitationLast: " + iOException.getMessage()));
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private void prepareTable(Table table) {
        this.percentManager.setDimension((FObj)table);
        int n2 = table.getCommonBorderPaddingBackground().getBorderStartWidth(false) / 2 + table.getCommonBorderPaddingBackground().getBorderEndWidth(false);
        if (!(table.getInlineProgressionDimension().getMaximum(null).getLength() instanceof EnumLength)) {
            this.percentManager.setDimension((FObj)table, table.getInlineProgressionDimension().getMaximum(null).getLength().getValue((PercentBaseContext)this.percentManager) - n2);
        } else {
            this.percentManager.setDimension((FObj)table, this.percentManager.getBaseLength(5, (FObj)table) - n2);
        }
        ColumnSetup columnSetup = new ColumnSetup(table);
        float f2 = this.percentManager.getBaseLength(5, (FObj)table);
        float f3 = columnSetup.computeTableUnit((PercentBaseContext)this.percentManager, Math.round(f2), null);
        this.percentManager.setTableUnit(table, Math.round(f3));
    }

    private void invokeDeferredEvent(FONode fONode, boolean bl) {
        if (fONode instanceof PageSequence) {
            if (bl) {
                this.startPageSequence((PageSequence)((Object)fONode));
            } else {
                this.endPageSequence((PageSequence)((Object)fONode));
            }
        } else if (fONode instanceof Flow) {
            if (bl) {
                this.startFlow((Flow)fONode);
            } else {
                this.endFlow((Flow)fONode);
            }
        } else if (fONode instanceof StaticContent) {
            if (bl) {
                this.startStatic(null);
            } else {
                this.endStatic(null);
            }
        } else if (fONode instanceof ExternalGraphic) {
            if (bl) {
                this.image((ExternalGraphic)((Object)fONode));
            }
        } else if (fONode instanceof InstreamForeignObject) {
            if (bl) {
                this.endInstreamForeignObject((InstreamForeignObject)((Object)fONode));
            }
        } else if (fONode instanceof Block) {
            if (bl) {
                this.startBlock((Block)fONode);
            } else {
                this.endBlock((Block)fONode);
            }
        } else if (fONode instanceof BlockContainer) {
            if (bl) {
                this.startBlockContainer((BlockContainer)((Object)fONode));
            } else {
                this.endBlockContainer((BlockContainer)((Object)fONode));
            }
        } else if (fONode instanceof BasicLink) {
            if (bl) {
                this.startLink((BasicLink)fONode);
            } else {
                this.endLink(null);
            }
        } else if (fONode instanceof Inline) {
            if (bl) {
                this.startInline((Inline)fONode);
            } else {
                this.endInline((Inline)fONode);
            }
        } else if (fONode instanceof FOText) {
            if (bl) {
                FOText fOText = (FOText)fONode;
                this.text(fOText, fOText.getCharSequence());
            }
        } else if (fONode instanceof Character) {
            if (bl) {
                Character character = (Character)fONode;
                this.character(character);
            }
        } else if (fONode instanceof PageNumber) {
            if (bl) {
                this.startPageNumber((PageNumber)((Object)fONode));
            } else {
                this.endPageNumber((PageNumber)((Object)fONode));
            }
        } else if (fONode instanceof Footnote) {
            if (bl) {
                this.startFootnote((Footnote)fONode);
            } else {
                this.endFootnote((Footnote)fONode);
            }
        } else if (fONode instanceof FootnoteBody) {
            if (bl) {
                this.startFootnoteBody((FootnoteBody)fONode);
            } else {
                this.endFootnoteBody((FootnoteBody)fONode);
            }
        } else if (fONode instanceof ListBlock) {
            if (bl) {
                this.startList((ListBlock)((Object)fONode));
            } else {
                this.endList((ListBlock)((Object)fONode));
            }
        } else if (fONode instanceof ListItemBody) {
            if (bl) {
                this.startListBody(null);
            } else {
                this.endListBody(null);
            }
        } else if (fONode instanceof ListItem) {
            if (bl) {
                this.startListItem((ListItem)((Object)fONode));
            } else {
                this.endListItem((ListItem)((Object)fONode));
            }
        } else if (fONode instanceof ListItemLabel) {
            if (bl) {
                this.startListLabel(null);
            } else {
                this.endListLabel(null);
            }
        } else if (fONode instanceof Table) {
            if (bl) {
                this.startTable((Table)((Object)fONode));
            } else {
                this.endTable((Table)((Object)fONode));
            }
        } else if (fONode instanceof TableHeader) {
            if (bl) {
                this.startHeader((TableHeader)fONode);
            } else {
                this.endHeader((TableHeader)fONode);
            }
        } else if (fONode instanceof TableFooter) {
            if (bl) {
                this.startFooter((TableFooter)fONode);
            } else {
                this.endFooter((TableFooter)fONode);
            }
        } else if (fONode instanceof TableBody) {
            if (bl) {
                this.startBody((TableBody)fONode);
            } else {
                this.endBody((TableBody)fONode);
            }
        } else if (fONode instanceof TableColumn) {
            if (bl) {
                this.startColumn((TableColumn)((Object)fONode));
            } else {
                this.endColumn((TableColumn)((Object)fONode));
            }
        } else if (fONode instanceof TableRow) {
            if (bl) {
                this.startRow((TableRow)((Object)fONode));
            } else {
                this.endRow((TableRow)((Object)fONode));
            }
        } else if (fONode instanceof TableCell) {
            if (bl) {
                this.startCell((TableCell)fONode);
            } else {
                this.endCell((TableCell)fONode);
            }
        } else if (fONode instanceof Leader) {
            if (bl) {
                this.startLeader((Leader)fONode);
            }
        } else if (fONode instanceof PageNumberCitation) {
            if (bl) {
                this.startPageNumberCitation((PageNumberCitation)fONode);
            } else {
                this.endPageNumberCitation((PageNumberCitation)fONode);
            }
        } else if (fONode instanceof PageNumberCitationLast) {
            if (bl) {
                this.startPageNumberCitationLast((PageNumberCitationLast)fONode);
            } else {
                this.endPageNumberCitationLast((PageNumberCitationLast)fONode);
            }
        } else {
            RTFEventProducer rTFEventProducer = RTFEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            rTFEventProducer.ignoredDeferredEvent((Object)this, fONode, bl, fONode.getLocator());
        }
    }

    public boolean endContainer(Class clazz) {
        if (clazz == RtfTableRow.class) {
            this.endRow(null);
            return true;
        }
        return false;
    }

    private void recurseFONode(FONode fONode) {
        this.invokeDeferredEvent(fONode, true);
        if (fONode instanceof PageSequence) {
            FONode fONode2;
            Region e2;
            FONode object;
            PageSequence pageSequence = (PageSequence)((Object)fONode);
            Region region = this.pagemaster.getRegion(57);
            if (region != null && (object = pageSequence.getFlowMap().get(region.getRegionName())) != null) {
                this.recurseFONode(object);
            }
            if ((e2 = this.pagemaster.getRegion(56)) != null && (fONode2 = pageSequence.getFlowMap().get(e2.getRegionName())) != null) {
                this.recurseFONode(fONode2);
            }
            this.recurseFONode((FONode)pageSequence.getMainFlow());
        } else if (fONode instanceof Table) {
            Object object;
            Table table = (Table)((Object)fONode);
            if (table.getColumns() != null) {
                this.prepareTable(table);
                for (Object e2 : table.getColumns()) {
                    this.recurseFONode((FONode)e2);
                }
            } else {
                object = RTFEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                object.explicitTableColumnsRequired((Object)this, table.getLocator());
            }
            if (table.getTableHeader() != null) {
                this.recurseFONode((FONode)table.getTableHeader());
            }
            if (table.getTableFooter() != null) {
                this.recurseFONode((FONode)table.getTableFooter());
            }
            if (fONode.getChildNodes() != null) {
                object = fONode.getChildNodes();
                while (object.hasNext()) {
                    this.recurseFONode((FONode)object.next());
                }
            }
        } else if (fONode instanceof ListItem) {
            ListItem listItem = (ListItem)((Object)fONode);
            this.recurseFONode((FONode)((Object)listItem.getLabel()));
            this.recurseFONode((FONode)listItem.getBody());
        } else if (fONode instanceof Footnote) {
            Footnote footnote = (Footnote)fONode;
            this.recurseFONode((FONode)footnote.getFootnoteCitation());
            this.recurseFONode((FONode)footnote.getFootnoteBody());
        } else if (fONode.getChildNodes() != null) {
            FONode.FONodeIterator fONodeIterator = fONode.getChildNodes();
            while (fONodeIterator.hasNext()) {
                FONode fONode3 = (FONode)fONodeIterator.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  ChildNode for " + fONode3 + " (" + fONode3.getName() + ")"));
                }
                this.recurseFONode(fONode3);
            }
        }
        this.invokeDeferredEvent(fONode, false);
    }
}

