/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFLinearization;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFTextUtil;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.pdf.CTMHelper;

public class PDFContentGenerator {
    protected static final boolean WRITE_COMMENTS = true;
    private PDFDocument document;
    private OutputStream outputStream;
    private PDFResourceContext resourceContext;
    private PDFStream currentStream;
    private PDFColorHandler colorHandler;
    protected PDFPaintingState currentState;
    protected PDFTextUtil textutil;
    private boolean inMarkedContentSequence;
    private boolean inArtifactMode;
    private AffineTransform transform;
    private IFContext context;
    private int ocNameIndex;

    public PDFContentGenerator(PDFDocument pDFDocument, OutputStream outputStream, PDFResourceContext pDFResourceContext) {
        this(pDFDocument, outputStream, pDFResourceContext, null);
    }

    public PDFContentGenerator(PDFDocument pDFDocument, OutputStream outputStream, PDFResourceContext pDFResourceContext, IFContext iFContext) {
        this.document = pDFDocument;
        this.outputStream = outputStream;
        this.resourceContext = pDFResourceContext;
        this.currentStream = pDFDocument.getFactory().makeStream("content", false);
        this.textutil = new PDFTextUtil(){

            protected void write(String string) {
                PDFContentGenerator.this.currentStream.add(string);
            }

            protected void write(StringBuffer stringBuffer) {
                PDFContentGenerator.this.currentStream.add(stringBuffer);
            }
        };
        this.currentState = new PDFPaintingState();
        this.colorHandler = new PDFColorHandler(pDFDocument.getResources(), pDFResourceContext);
        this.context = iFContext;
    }

    public AffineTransform getAffineTransform() {
        return this.transform;
    }

    public PDFDocument getDocument() {
        return this.document;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public PDFResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public PDFStream getStream() {
        return this.currentStream;
    }

    public PDFPaintingState getState() {
        return this.currentState;
    }

    public PDFTextUtil getTextUtil() {
        return this.textutil;
    }

    public void flushPDFDoc() throws IOException {
        if (this.document.isLinearizationEnabled()) {
            new PDFLinearization(this.document).outputPages(this.outputStream);
        }
        this.document.output(this.outputStream);
    }

    protected void comment(String string) {
        this.getStream().add("% " + string + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.getState().save();
        this.getStream().add("q\n");
    }

    protected void saveGraphicsState(String string) {
        this.endTextObject();
        this.getState().save();
        this.maybeBeginLayer(string);
        this.getStream().add("q\n");
    }

    protected void saveGraphicsState(String string, int n2) {
        this.endTextObject();
        this.getState().save();
        this.beginMarkedContentSequence(string, n2);
        this.getStream().add("q\n");
    }

    protected void beginMarkedContentSequence(String string, int n2) {
        this.beginMarkedContentSequence(string, n2, null);
    }

    protected void beginMarkedContentSequence(String string, int n2, String string2) {
        assert (!this.inMarkedContentSequence);
        assert (!this.inArtifactMode);
        if (string != null) {
            String string3 = string2 == null ? "" : " /ActualText " + PDFText.escapeText((String)string2);
            this.getStream().add(string + " <</MCID " + String.valueOf(n2) + string3 + ">>\nBDC\n");
        } else {
            if (this.context != null && this.context.getRegionType() != null) {
                this.getStream().add("/Artifact\n<</Type /Pagination\n/Subtype /" + this.context.getRegionType() + ">>\nBDC\n");
            } else {
                this.getStream().add("/Artifact\nBMC\n");
            }
            this.inArtifactMode = true;
        }
        this.inMarkedContentSequence = true;
    }

    void endMarkedContentSequence() {
        this.getStream().add("EMC\n");
        this.inMarkedContentSequence = false;
        this.inArtifactMode = false;
    }

    protected void restoreGraphicsState(boolean bl) {
        this.endTextObject();
        this.getStream().add("Q\n");
        this.maybeEndLayer();
        if (bl) {
            this.getState().restore();
        }
    }

    protected void restoreGraphicsState() {
        this.restoreGraphicsState(true);
    }

    protected void restoreGraphicsStateAccess() {
        this.endTextObject();
        this.getStream().add("Q\n");
        if (this.inMarkedContentSequence) {
            this.endMarkedContentSequence();
        }
        this.getState().restore();
    }

    private void maybeBeginLayer(String string) {
        if (string != null && string.length() > 0) {
            this.getState().setLayer(string);
            this.beginOptionalContent(string);
        }
    }

    private void maybeEndLayer() {
        if (this.getState().getLayerChanged()) {
            this.endOptionalContent();
        }
    }

    private void beginOptionalContent(String string) {
        Object object;
        PDFReference pDFReference = this.document.resolveExtensionReference(string);
        if (pDFReference != null) {
            object = "oc" + ++this.ocNameIndex;
            this.document.getResources().addProperty((String)object, pDFReference);
        } else {
            object = "unknown";
        }
        this.getStream().add("/OC /" + (String)object + " BDC\n");
    }

    private void endOptionalContent() {
        this.getStream().add("EMC\n");
    }

    protected void beginTextObject() {
        if (!this.textutil.isInTextObject()) {
            this.textutil.beginTextObject();
        }
    }

    protected void beginTextObject(String string, int n2) {
        this.beginTextObject(string, n2, null);
    }

    protected void beginTextObject(String string, int n2, String string2) {
        if (!this.textutil.isInTextObject()) {
            this.beginMarkedContentSequence(string, n2, string2);
            this.textutil.beginTextObject();
        }
    }

    protected void endTextObject() {
        if (this.textutil.isInTextObject()) {
            this.textutil.endTextObject();
            if (this.inMarkedContentSequence) {
                this.endMarkedContentSequence();
            }
        }
    }

    public void concatenate(AffineTransform affineTransform) {
        this.transform = affineTransform;
        if (!affineTransform.isIdentity()) {
            this.getState().concatenate(affineTransform);
            this.getStream().add(CTMHelper.toPDFString((AffineTransform)affineTransform, (boolean)false) + " cm\n");
        }
    }

    public void clipRect(Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.x / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.y / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.width / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.height / 1000.0f)).append(" re W n\n");
        this.add(stringBuffer.toString());
    }

    public void add(String string) {
        this.getStream().add(string);
    }

    public static final String format(float f2) {
        return PDFNumber.doubleOut((double)f2);
    }

    public void updateLineWidth(float f2) {
        if (this.getState().setLineWidth(f2)) {
            this.getStream().add(PDFContentGenerator.format(f2) + " w\n");
        }
    }

    public void updateCharacterSpacing(float f2) {
        if (this.getState().setCharacterSpacing(f2)) {
            this.getStream().add(PDFContentGenerator.format(f2) + " Tc\n");
        }
    }

    public void resetCharacterSpacing() {
        if (this.getState().setCharacterSpacing(0.0f)) {
            this.getStream().add(PDFContentGenerator.format(0.0f) + " Tc\n");
        }
    }

    public void setColor(Color color, boolean bl, PDFStream pDFStream) {
        assert (pDFStream != null);
        StringBuffer stringBuffer = new StringBuffer();
        this.setColor(color, bl, stringBuffer);
        pDFStream.add(stringBuffer.toString());
    }

    public void setColor(Color color, boolean bl) {
        this.setColor(color, bl, this.getStream());
    }

    protected void setColor(Color color, boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            this.colorHandler.establishColor(stringBuffer, color, bl, true);
        } else {
            this.setColor(color, bl, this.getStream());
        }
    }

    public void updateColor(Color color, boolean bl, StringBuffer stringBuffer) {
        if (color == null) {
            return;
        }
        boolean bl2 = false;
        bl2 = bl ? this.getState().setBackColor(color) : this.getState().setColor(color);
        if (bl2) {
            this.setColor(color, bl, stringBuffer);
        }
    }

    public void placeImage(float f2, float f3, float f4, float f5, PDFXObject pDFXObject) {
        this.saveGraphicsState();
        this.resetToOpaqueBlack();
        this.add(PDFContentGenerator.format(f4) + " 0 0 " + PDFContentGenerator.format(-f5) + " " + PDFContentGenerator.format(f2) + " " + PDFContentGenerator.format(f3 + f5) + " cm\n" + pDFXObject.getName() + " Do\n");
        this.restoreGraphicsState();
    }

    public void placeImage(AffineTransform affineTransform, String string) {
        this.saveGraphicsState();
        this.resetToOpaqueBlack();
        this.concatenate(affineTransform);
        this.add(string);
        this.restoreGraphicsState();
    }

    public void placeImage(float f2, float f3, float f4, float f5, PDFXObject pDFXObject, String string, int n2) {
        this.saveGraphicsState(string, n2);
        this.resetToOpaqueBlack();
        this.add(PDFContentGenerator.format(f4) + " 0 0 " + PDFContentGenerator.format(-f5) + " " + PDFContentGenerator.format(f2) + " " + PDFContentGenerator.format(f3 + f5) + " cm\n" + pDFXObject.getName() + " Do\n");
        this.restoreGraphicsStateAccess();
    }

    private void resetToOpaqueBlack() {
        this.updateColor(Color.black, true, null);
        this.updateColor(Color.black, false, null);
    }
}

