/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlock;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.flow.ChangeBar;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.DummyPercentBaseContext;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.XMLHandlerConfigurator;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.Visibility;
import org.w3c.dom.Document;

public abstract class AbstractRenderer
implements Renderer,
Constants {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.render.AbstractRenderer");
    protected FOUserAgent userAgent;
    protected int currentBPPosition;
    protected int currentIPPosition;
    protected int containingBPPosition;
    protected int containingIPPosition;
    protected int columnStartIPPosition;
    protected int columnEndIPPosition;
    protected int columnLeftIPPosition;
    protected int columnRightIPPosition;
    protected int columnCount;
    protected int columnIndex;
    protected int columnWidth;
    protected int columnGap;
    protected Direction blockProgressionDirection;
    protected Direction inlineProgressionDirection;
    protected boolean bindingOnStartEdge;
    protected boolean bindingOnEndEdge;
    private int beginOffset;
    protected PageViewport currentPageViewport;
    private Set warnedXMLHandlers;
    private Stack<String> layers;
    private HashMap<Area, List<ChangeBar>> paintedChangeBarsBeforeFootnotes = null;
    private boolean isRenderingFootnotes;
    private HashMap<Area, List<ChangeBar>> paintedChangeBars = new HashMap(100);
    protected Deque<Area> blockAreas = new ArrayDeque<Area>(20);
    private HashMap<Area, Integer> relYY = new HashMap();
    private HashMap<Area, Integer> relXX = new HashMap();

    public abstract void setupFontInfo(FontInfo var1) throws FOPException;

    public AbstractRenderer(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("FOUserAgent has not been set on Renderer");
        }
    }

    public void stopRenderer() throws IOException {
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void setDocumentLocale(Locale locale) {
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return null;
    }

    public ImageAdapter getImageAdapter() {
        return null;
    }

    protected PageViewport getCurrentPageViewport() {
        return this.currentPageViewport;
    }

    public void preparePage(PageViewport pageViewport) {
    }

    protected String convertTitleToString(LineArea lineArea) {
        List list = lineArea.getInlineAreas();
        String string = this.convertToString(list);
        return string.trim();
    }

    private String convertToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e2 : list) {
            InlineArea inlineArea = (InlineArea)((Object)e2);
            if (inlineArea instanceof TextArea) {
                stringBuffer.append(((TextArea)((Object)inlineArea)).getText());
                continue;
            }
            if (inlineArea instanceof InlineParent) {
                stringBuffer.append(this.convertToString(((InlineParent)inlineArea).getChildAreas()));
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void startPageSequence(LineArea lineArea) {
    }

    public void startPageSequence(PageSequence pageSequence) {
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        this.paintedChangeBars.clear();
        this.currentPageViewport = pageViewport;
        try {
            Page page = pageViewport.getPage();
            this.renderPageAreas(page);
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected void renderPageAreas(Page page) {
        RegionViewport regionViewport = page.getRegionViewport(57);
        if (regionViewport != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(61)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(58)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(59)) != null) {
            this.renderRegionViewport(regionViewport);
        }
        if ((regionViewport = page.getRegionViewport(56)) != null) {
            this.renderRegionViewport(regionViewport);
        }
    }

    protected void renderRegionViewport(RegionViewport regionViewport) {
        this.currentBPPosition = 0;
        this.currentIPPosition = 0;
        RegionReference regionReference = regionViewport.getRegionReference();
        this.handleRegionTraits(regionViewport);
        this.startVParea(regionReference.getCTM(), regionViewport.getClipRectangle());
        if (regionReference.getRegionClass() == 58) {
            assert (regionReference instanceof BodyRegion);
            this.renderBodyRegion((BodyRegion)regionReference);
        } else {
            this.renderRegion(regionReference);
        }
        this.endVParea();
    }

    protected abstract void startVParea(CTM var1, Rectangle var2);

    protected abstract void endVParea();

    protected void handleRegionTraits(RegionViewport regionViewport) {
    }

    protected void renderRegion(RegionReference regionReference) {
        this.renderBlocks(null, regionReference.getBlocks());
    }

    protected void renderBodyRegion(BodyRegion bodyRegion) {
        Footnote footnote;
        MainReference mainReference;
        BeforeFloat beforeFloat = bodyRegion.getBeforeFloat();
        if (beforeFloat != null) {
            this.renderBeforeFloat(beforeFloat);
        }
        if ((mainReference = bodyRegion.getMainReference()) != null) {
            this.renderMainReference(mainReference);
        }
        if ((footnote = bodyRegion.getFootnote()) != null) {
            this.renderFootnote(footnote);
        }
    }

    protected void renderBeforeFloat(BeforeFloat beforeFloat) {
        List list = beforeFloat.getChildAreas();
        if (list != null) {
            this.renderBlocks(null, list);
            Block block = beforeFloat.getSeparator();
            if (block != null) {
                this.renderBlock(block);
            }
        }
    }

    protected void renderFootnote(Footnote footnote) {
        this.isRenderingFootnotes = true;
        this.paintedChangeBarsBeforeFootnotes = new HashMap<Area, List<ChangeBar>>(this.paintedChangeBars);
        this.currentBPPosition += footnote.getTop();
        List list = footnote.getChildAreas();
        if (list != null) {
            Block block = footnote.getSeparator();
            if (block != null) {
                this.renderBlock(block);
            }
            this.renderBlocks(null, list);
        }
        this.isRenderingFootnotes = false;
        this.paintedChangeBarsBeforeFootnotes = null;
    }

    protected void renderMainReference(MainReference mainReference) {
        Span span = null;
        List list = mainReference.getSpans();
        int n2 = this.currentBPPosition;
        int n3 = this.currentIPPosition;
        int n4 = n2;
        for (Object e2 : list) {
            span = (Span)e2;
            this.columnCount = span.getColumnCount();
            this.columnGap = span.getColumnGap();
            this.columnWidth = span.getColumnWidth();
            this.blockProgressionDirection = (Direction)span.getTrait(Trait.BLOCK_PROGRESSION_DIRECTION);
            this.inlineProgressionDirection = (Direction)span.getTrait(Trait.INLINE_PROGRESSION_DIRECTION);
            int n5 = span.getBidiLevel();
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n5 & 1) == 1) {
                this.currentIPPosition += span.getIPD();
                this.currentIPPosition += this.columnGap;
            }
            this.columnIndex = 0;
            while (this.columnIndex < this.columnCount) {
                boolean bl;
                NormalFlow normalFlow = span.getNormalFlow(this.columnIndex);
                boolean bl2 = bl = this.inlineProgressionDirection == null || this.inlineProgressionDirection.getEnumValue() == 199;
                if (normalFlow != null) {
                    int n6 = this.currentPageViewport.getPageIndex();
                    this.bindingOnStartEdge = false;
                    this.bindingOnEndEdge = false;
                    if (bl) {
                        this.columnStartIPPosition = 0;
                        this.columnEndIPPosition = this.columnWidth;
                        this.columnLeftIPPosition = 0;
                        this.columnRightIPPosition = this.columnWidth;
                        if (this.blockProgressionDirection == null || this.blockProgressionDirection.isVertical()) {
                            if (n6 % 2 == 0) {
                                this.bindingOnStartEdge = true;
                            } else {
                                this.bindingOnEndEdge = true;
                            }
                        }
                    } else {
                        this.columnStartIPPosition = this.columnWidth;
                        this.columnEndIPPosition = 0;
                        this.columnLeftIPPosition = 0;
                        this.columnRightIPPosition = this.columnWidth;
                        if (this.blockProgressionDirection == null || this.blockProgressionDirection.isVertical()) {
                            if (n6 % 2 == 0) {
                                this.bindingOnEndEdge = true;
                            } else {
                                this.bindingOnStartEdge = true;
                            }
                        }
                    }
                    this.currentBPPosition = n4;
                    if ((n5 & 1) == 1) {
                        this.currentIPPosition -= normalFlow.getIPD();
                        this.currentIPPosition -= this.columnGap;
                    }
                    this.renderFlow(normalFlow);
                    if ((n5 & 1) == 0) {
                        this.currentIPPosition += normalFlow.getIPD();
                        this.currentIPPosition += this.columnGap;
                    }
                }
                ++this.columnIndex;
            }
            this.currentIPPosition = n3;
            n4 = this.currentBPPosition = n4 + span.getHeight();
        }
        this.currentBPPosition = n2;
    }

    protected void renderFlow(NormalFlow normalFlow) {
        List list = normalFlow.getChildAreas();
        if (list != null) {
            this.renderBlocks(null, list);
        }
    }

    protected void handleBlockTraits(Block block) {
    }

    protected void renderBlockViewport(BlockViewport blockViewport, List list) {
        boolean bl = false;
        if (this.maybeStartLayer((Area)blockViewport)) {
            bl = true;
        }
        if (blockViewport.getPositioning() == 2) {
            int n2 = this.currentIPPosition;
            int n3 = this.currentBPPosition;
            Rectangle rectangle = null;
            if (blockViewport.hasClip()) {
                rectangle = new Rectangle(n2, n3, blockViewport.getIPD(), blockViewport.getBPD());
            }
            CTM cTM = blockViewport.getCTM();
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.startVParea(cTM, rectangle);
            this.handleBlockTraits(blockViewport);
            this.renderBlocks(blockViewport, list);
            this.endVParea();
            this.currentIPPosition = n2;
            this.currentBPPosition = n3;
        } else {
            int n4 = this.currentIPPosition;
            int n5 = this.currentBPPosition;
            this.handleBlockTraits(blockViewport);
            this.renderBlocks(blockViewport, list);
            this.currentIPPosition = n4;
            this.currentBPPosition = n5 + blockViewport.getAllocBPD();
        }
        this.maybeEndLayer((Area)blockViewport, bl);
    }

    protected abstract void renderReferenceArea(Block var1);

    protected void renderBlocks(Block block, List list) {
        int n2 = this.currentIPPosition;
        if (block != null && !block.getTraitAsBoolean(Trait.IS_VIEWPORT_AREA)) {
            this.currentBPPosition += block.getBorderAndPaddingWidthBefore();
        }
        int n3 = this.currentBPPosition;
        int n4 = this.currentIPPosition;
        this.containingBPPosition = this.currentBPPosition;
        this.containingIPPosition = this.currentIPPosition;
        for (Object e2 : list) {
            if (e2 instanceof Block) {
                this.currentIPPosition = n4;
                this.containingBPPosition = n3;
                this.containingIPPosition = n4;
                this.renderBlock((Block)e2);
                this.containingBPPosition = n3;
                this.containingIPPosition = n4;
            } else if (e2 instanceof LineArea) {
                LineArea lineArea = (LineArea)e2;
                if (block != null) {
                    int n5 = block.getBidiLevel();
                    this.currentIPPosition = n5 == -1 || (n5 & 1) == 0 ? (this.currentIPPosition += block.getStartIndent()) : (this.currentIPPosition += block.getEndIndent());
                }
                this.renderLineArea(lineArea);
                this.currentBPPosition += lineArea.getAllocBPD();
            }
            this.currentIPPosition = n2;
        }
    }

    protected void renderBlock(Block block) {
        boolean bl;
        assert (block != null);
        List list = block.getChangeBarList();
        if (list != null && !list.isEmpty()) {
            int n2 = this.currentIPPosition;
            int bl2 = this.currentBPPosition;
            this.drawChangeBars((Area)block, list);
            this.currentIPPosition = n2;
            this.currentBPPosition = bl2;
        }
        List list2 = block.getChildAreas();
        boolean bl3 = false;
        if (this.maybeStartLayer((Area)block)) {
            bl = true;
        }
        if (block instanceof BlockViewport) {
            if (list2 != null) {
                this.renderBlockViewport((BlockViewport)block, list2);
            } else {
                this.handleBlockTraits(block);
                this.currentBPPosition += block.getAllocBPD();
            }
        } else if (block.getTraitAsBoolean(Trait.IS_REFERENCE_AREA)) {
            this.renderReferenceArea(block);
        } else {
            int n2 = this.currentIPPosition;
            int n3 = this.currentBPPosition;
            this.currentIPPosition += block.getXOffset();
            this.currentBPPosition += block.getYOffset();
            this.currentBPPosition += block.getSpaceBefore();
            this.handleBlockTraits(block);
            if (list2 != null && block.getTrait(Trait.VISIBILITY) != Visibility.HIDDEN) {
                this.renderBlocks(block, list2);
            }
            if (block.getPositioning() == 2) {
                this.currentBPPosition = n3;
            } else {
                this.currentIPPosition = n2;
                this.currentBPPosition = n3 + block.getAllocBPD();
            }
        }
        this.maybeEndLayer((Area)block, bl);
    }

    protected void renderInlineBlock(InlineBlock inlineBlock) {
        this.renderBlock(inlineBlock.getBlock());
    }

    protected abstract void startLayer(String var1);

    protected abstract void endLayer();

    protected boolean maybeStartLayer(Area area) {
        String string = (String)area.getTrait(Trait.LAYER);
        if (string != null) {
            if (this.layers == null) {
                this.layers = new Stack();
            }
            if (this.layers.empty() || !this.layers.peek().equals(string)) {
                this.layers.push(string);
                this.startLayer(string);
                return true;
            }
        }
        return false;
    }

    protected void maybeEndLayer(Area area, boolean bl) {
        if (bl) {
            assert (this.layers != null);
            assert (!this.layers.empty());
            String string = (String)area.getTrait(Trait.LAYER);
            assert (string != null);
            assert (this.layers.peek().equals(string));
            this.endLayer();
            this.layers.pop();
        }
    }

    protected void renderLineArea(LineArea lineArea) {
        List list = lineArea.getInlineAreas();
        int n2 = this.currentBPPosition;
        this.currentBPPosition += lineArea.getSpaceBefore();
        int n3 = lineArea.getBidiLevel();
        this.currentIPPosition = n3 >= 0 ? ((n3 & 1) == 0 ? (this.currentIPPosition += lineArea.getStartIndent()) : (this.currentIPPosition += lineArea.getEndIndent())) : (this.currentIPPosition += lineArea.getStartIndent());
        for (Object e2 : list) {
            InlineArea inlineArea = (InlineArea)((Object)e2);
            this.renderInlineArea(inlineArea);
        }
        this.currentBPPosition = n2;
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        List list = inlineArea.getChangeBarList();
        if (list != null && !list.isEmpty()) {
            this.drawChangeBars(inlineArea, list);
        }
        if (inlineArea instanceof TextArea) {
            this.renderText((TextArea)((Object)inlineArea));
        } else if (inlineArea instanceof WordArea) {
            this.renderWord((WordArea)inlineArea);
        } else if (inlineArea instanceof SpaceArea) {
            this.renderSpace((SpaceArea)inlineArea);
        } else if (inlineArea instanceof InlineBlock) {
            this.renderInlineBlock((InlineBlock)inlineArea);
        } else if (inlineArea instanceof InlineParent) {
            this.renderInlineParent((InlineParent)inlineArea);
        } else if (inlineArea instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)inlineArea);
        } else if (inlineArea instanceof Space) {
            this.renderInlineSpace((Space)inlineArea);
        } else if (inlineArea instanceof InlineViewport) {
            this.renderInlineViewport((InlineViewport)inlineArea);
        } else if (inlineArea instanceof Leader) {
            this.renderLeader((Leader)inlineArea);
        }
    }

    protected abstract void renderInlineAreaBackAndBorders(InlineArea var1);

    protected void renderInlineSpace(Space space) {
        this.renderInlineAreaBackAndBorders((InlineArea)space);
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderLeader(Leader leader) {
        this.currentIPPosition += leader.getAllocIPD();
    }

    protected void renderText(TextArea textArea) {
        List list = textArea.getChildAreas();
        int n2 = this.currentIPPosition;
        int n3 = this.currentBPPosition;
        List list2 = textArea.getChangeBarList();
        if (list2 != null && !list2.isEmpty()) {
            this.currentIPPosition = n2;
            this.currentBPPosition = n3;
        }
        for (Object e2 : list) {
            InlineArea inlineArea = (InlineArea)((Object)e2);
            this.renderInlineArea(inlineArea);
        }
        this.currentIPPosition = n2 + textArea.getAllocIPD();
    }

    protected void renderWord(WordArea wordArea) {
        this.currentIPPosition += wordArea.getAllocIPD();
    }

    protected void renderSpace(SpaceArea spaceArea) {
        this.currentIPPosition += spaceArea.getAllocIPD();
    }

    protected void renderInlineParent(InlineParent inlineParent) {
        int n2;
        boolean bl = false;
        if (this.maybeStartLayer((Area)inlineParent)) {
            bl = true;
        }
        int n3 = inlineParent.getBidiLevel();
        List list = inlineParent.getChildAreas();
        this.renderInlineAreaBackAndBorders((InlineArea)inlineParent);
        int n4 = this.currentIPPosition;
        int n5 = this.currentBPPosition;
        if (inlineParent instanceof FilledArea && (n3 & 1) != 0) {
            int n6 = 0;
            for (Object object : list) {
                InlineArea inlineArea = (InlineArea)((Object)object);
                n6 += inlineArea.getAllocIPD();
            }
            n2 = inlineParent.getAllocIPD() - n6;
        } else {
            n2 = 0;
        }
        if (n3 == -1 || (n3 & 1) == 0) {
            this.currentIPPosition += inlineParent.getBorderAndPaddingWidthStart();
        } else {
            this.currentIPPosition += inlineParent.getBorderAndPaddingWidthEnd();
            if (n2 > 0) {
                this.currentIPPosition += n2;
            }
        }
        this.currentBPPosition += inlineParent.getBlockProgressionOffset();
        for (Iterator iterator : list) {
            Object object;
            object = (InlineArea)((Object)iterator);
            this.renderInlineArea((InlineArea)((Object)object));
        }
        this.currentIPPosition = n4 + inlineParent.getAllocIPD();
        this.currentBPPosition = n5;
        this.maybeEndLayer((Area)inlineParent, bl);
    }

    protected void renderInlineBlockParent(InlineBlockParent inlineBlockParent) {
        int n2 = inlineBlockParent.getBidiLevel();
        this.renderInlineAreaBackAndBorders((InlineArea)inlineBlockParent);
        this.currentIPPosition = n2 == -1 || (n2 & 1) == 0 ? (this.currentIPPosition += inlineBlockParent.getBorderAndPaddingWidthStart()) : (this.currentIPPosition += inlineBlockParent.getBorderAndPaddingWidthEnd());
        int n3 = this.currentBPPosition;
        this.currentBPPosition += inlineBlockParent.getBlockProgressionOffset();
        this.renderBlock(inlineBlockParent.getChildArea());
        this.currentBPPosition = n3;
    }

    protected void renderInlineViewport(InlineViewport inlineViewport) {
        Area area = inlineViewport.getContent();
        int n2 = this.currentBPPosition;
        this.currentBPPosition += inlineViewport.getBlockProgressionOffset();
        Rectangle2D rectangle2D = inlineViewport.getContentPosition();
        if (area instanceof Image) {
            this.renderImage((Image)area, rectangle2D);
        } else if (area instanceof Container) {
            this.renderContainer((Container)area);
        } else if (area instanceof ForeignObject) {
            this.renderForeignObject((ForeignObject)area, rectangle2D);
        } else if (area instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)area);
        }
        this.currentIPPosition += inlineViewport.getAllocIPD();
        this.currentBPPosition = n2;
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        List list = image.getChangeBarList();
        if (list != null && !list.isEmpty()) {
            this.drawChangeBars((Area)image, list);
        }
    }

    protected void renderContainer(Container container) {
        int n2 = this.currentIPPosition;
        int n3 = this.currentBPPosition;
        List list = container.getBlocks();
        this.renderBlocks(null, list);
        this.currentIPPosition = n2;
        this.currentBPPosition = n3;
    }

    protected void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
        List list = foreignObject.getChangeBarList();
        if (list != null && !list.isEmpty()) {
            this.drawChangeBars((Area)foreignObject, list);
        }
    }

    public void renderXML(RendererContext rendererContext, Document document, String string) {
        XMLHandler xMLHandler = this.userAgent.getXMLHandlerRegistry().getXMLHandler((Renderer)this, string);
        if (xMLHandler != null) {
            try {
                XMLHandlerConfigurator xMLHandlerConfigurator = new XMLHandlerConfigurator(this.userAgent);
                xMLHandlerConfigurator.configure(rendererContext, string);
                xMLHandler.handleXML(rendererContext, document, string);
            }
            catch (Exception exception) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)rendererContext.getUserAgent().getEventBroadcaster());
                resourceEventProducer.foreignXMLProcessingError((Object)this, document, string, exception);
            }
        } else {
            if (this.warnedXMLHandlers == null) {
                this.warnedXMLHandlers = new HashSet();
            }
            if (!this.warnedXMLHandlers.contains(string)) {
                this.warnedXMLHandlers.add(string);
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)rendererContext.getUserAgent().getEventBroadcaster());
                resourceEventProducer.foreignXMLNoHandler((Object)this, document, string);
            }
        }
    }

    protected AffineTransform mptToPt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = dArray[4] / 1000.0;
        dArray[5] = dArray[5] / 1000.0;
        return new AffineTransform(dArray);
    }

    protected AffineTransform ptToMpt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = Math.round(dArray[4] * 1000.0);
        dArray[5] = Math.round(dArray[5] * 1000.0);
        return new AffineTransform(dArray);
    }

    private boolean isAbsoluteAreaPart(Area area) {
        Iterator<Area> iterator = this.blockAreas.iterator();
        boolean bl = false;
        while (iterator.hasNext() && area != iterator.next()) {
        }
        Area area2 = area;
        for (int i2 = 0; !bl && i2 < 3; ++i2) {
            if (area2 instanceof BlockViewport && ((BlockViewport)area2).getPositioning() == 2) {
                bl = true;
            }
            if (!iterator.hasNext()) break;
            area2 = iterator.next();
        }
        return bl;
    }

    private List<ChangeBar> removeOverlaps(Area area, List<ChangeBar> list) {
        boolean bl = true;
        if (this.isAbsoluteAreaPart(area)) {
            bl = false;
        }
        if (bl) {
            list = this.removeBarsOverlappingWithAncestors(area, list);
            if (this.isRenderingFootnotes) {
                list = this.removeFootnotesBarsOverlappingWithOnesPaintedBefore(list);
            }
        }
        this.paintedChangeBars.put(area, list);
        return list;
    }

    private String dumpCBS(List<ChangeBar> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (ChangeBar changeBar : list) {
            stringBuilder.append(this.dumpCB(changeBar));
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String dumpCB(ChangeBar changeBar) {
        return changeBar.getColor().toString();
    }

    private List<ChangeBar> removeFootnotesBarsOverlappingWithOnesPaintedBefore(List<ChangeBar> list) {
        ArrayList<ChangeBar> arrayList = new ArrayList<ChangeBar>(list);
        Iterator iterator = arrayList.iterator();
        block0: while (iterator.hasNext()) {
            ChangeBar changeBar = (ChangeBar)iterator.next();
            Set<Map.Entry<Area, List<ChangeBar>>> set = this.paintedChangeBarsBeforeFootnotes.entrySet();
            for (Map.Entry<Area, List<ChangeBar>> entry : set) {
                if (!entry.getValue().contains(changeBar)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return arrayList;
    }

    private List<ChangeBar> removeBarsOverlappingWithAncestors(Area area, List<ChangeBar> list) {
        InlineArea inlineArea;
        ArrayList<ChangeBar> arrayList = new ArrayList<ChangeBar>(list);
        Iterator<Area> iterator = this.blockAreas.iterator();
        if (area instanceof InlineArea) {
            inlineArea = (InlineArea)area;
            Area area2 = inlineArea.getParentArea();
            while (area2 != null && !arrayList.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Scan parent of inline " + area2));
                }
                List<ChangeBar> list2 = this.paintedChangeBars.get(area2);
                this.filterAncestorBars(arrayList, list2);
                if (area2 instanceof InlineArea) {
                    area2 = ((InlineArea)area2).getParentArea();
                    continue;
                }
                break;
            }
        } else if (area instanceof Block) {
            iterator.next();
        }
        if (!arrayList.isEmpty()) {
            while (iterator.hasNext()) {
                inlineArea = iterator.next();
                this.filterAncestorBars(arrayList, this.paintedChangeBars.get((Object)inlineArea));
            }
        }
        return arrayList;
    }

    private void filterAncestorBars(List<ChangeBar> list, List<ChangeBar> list2) {
        if (list2 != null) {
            Iterator<ChangeBar> iterator = list.iterator();
            while (iterator.hasNext()) {
                ChangeBar changeBar = iterator.next();
                if (!list2.contains(changeBar)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Skip CH " + this.dumpCB(changeBar) + "  already painted by the parent. "));
                }
                iterator.remove();
            }
        }
    }

    protected void drawChangeBars(Area area, List<ChangeBar> list) {
        if (area.getTraitAsBoolean(Trait.IS_REFERENCE_AREA)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("DRAW CB " + area.getTrait(Trait.PROD_ID) + " " + area + " CBS: " + this.dumpCBS(list)));
        }
        list = this.removeOverlaps(area, list);
        int n2 = this.currentIPPosition;
        int n3 = this.currentBPPosition;
        int n4 = this.columnStartIPPosition;
        int n5 = this.columnEndIPPosition;
        int n6 = this.columnLeftIPPosition;
        int n7 = this.columnRightIPPosition;
        for (ChangeBar changeBar : list) {
            boolean bl = this.inlineProgressionDirection == null || this.inlineProgressionDirection.getEnumValue() == 199;
            Block block = new Block();
            this.currentIPPosition = 0;
            this.currentBPPosition = n3;
            int n8 = changeBar.getWidth().getValue();
            int n9 = changeBar.getOffset().getValue();
            if (bl) {
                n4 = this.columnStartIPPosition - n8;
                n6 = this.columnLeftIPPosition - n8;
            } else {
                n5 = this.columnEndIPPosition - n8;
                n6 = this.columnLeftIPPosition - n8;
            }
            int n10 = n4;
            int n11 = -1;
            switch (changeBar.getPlacement()) {
                case 135: {
                    n10 = n4;
                    n11 = -1;
                    break;
                }
                case 39: {
                    n10 = n5;
                    n11 = 1;
                    break;
                }
                case 73: {
                    n10 = n6;
                    n11 = bl ? -1 : 1;
                    break;
                }
                case 120: {
                    n10 = n7;
                    n11 = bl ? 1 : -1;
                    break;
                }
                case 68: {
                    if (this.bindingOnStartEdge) {
                        n10 = n4;
                        n11 = -1;
                        break;
                    }
                    if (this.bindingOnEndEdge) {
                        n10 = n5;
                        n11 = 1;
                        break;
                    }
                    n10 = n4;
                    n11 = -1;
                    break;
                }
                case 102: {
                    if (this.bindingOnStartEdge) {
                        n10 = this.columnEndIPPosition;
                        n11 = 1;
                        break;
                    }
                    if (this.bindingOnEndEdge) {
                        n10 = this.columnStartIPPosition;
                        n11 = -1;
                        break;
                    }
                    n10 = this.columnStartIPPosition;
                    n11 = -1;
                    break;
                }
                case 198: {
                    if (this.columnCount == 2) {
                        if (this.columnIndex == 0) {
                            n10 = this.columnStartIPPosition;
                            n11 = -1;
                            break;
                        }
                        n10 = this.columnEndIPPosition;
                        n11 = 1;
                        break;
                    }
                    if (this.bindingOnStartEdge) {
                        n10 = this.columnEndIPPosition;
                        n11 = 1;
                        break;
                    }
                    if (this.bindingOnEndEdge) {
                        n10 = this.columnStartIPPosition;
                        n11 = -1;
                        break;
                    }
                    n10 = this.columnStartIPPosition;
                    n11 = -1;
                    break;
                }
            }
            n10 = bl ? (n10 += n11 * n9) : (n10 -= n11 * n9);
            n10 += this.getBeginOffset();
            block.setAreaClass(2);
            block.setIPD(0);
            BorderProps borderProps = BorderProps.makeRectangular((int)changeBar.getStyle(), (int)n8, (Color)changeBar.getColor(), (BorderProps.Mode)BorderProps.Mode.SEPARATE);
            block.addTrait(Trait.BORDER_START, (Object)borderProps);
            block.addTrait(Trait.BORDER_END, (Object)borderProps);
            block.setXOffset(n10);
            int n12 = area.getAllocBPD();
            if (area instanceof BlockParent) {
                block.setBPD(n12);
                block.setYOffset(0);
                this.renderBlock(block);
            } else {
                if (n12 > 0) {
                    Property property = changeBar.getLineHeight().getOptimum((PercentBaseContext)DummyPercentBaseContext.getInstance());
                    int n13 = property.getLength().getValue();
                    block.setBPD(n13);
                    block.setYOffset(n12 - n13);
                }
                this.renderInlineBlock(new InlineBlock(block));
            }
            this.currentIPPosition = n2;
            this.currentBPPosition = n3;
        }
    }

    protected int getBeginOffset() {
        return this.beginOffset;
    }

    protected void setBeginOffset(int n2) {
        this.beginOffset = n2;
    }

    protected void saveAreaCoordinatesRelativeToItsParent(Area area) {
        this.blockAreas.push(area);
        int n2 = this.currentIPPosition + area.getBorderAndPaddingWidthStart();
        int n3 = this.currentBPPosition + area.getBorderAndPaddingWidthBefore();
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getTraceIndent() + " SAVE  " + area.getTrait(Trait.PROD_ID) + "  (" + n2 + ", " + n3 + ")(" + area.getIPD() + "," + area.getBPD() + ")" + area));
        }
        this.relXX.put(area, n2);
        this.relYY.put(area, n3);
    }

    protected void removeAreaCoordinatesRelativeToItsParent() {
        Area area = this.blockAreas.pop();
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getTraceIndent() + "  POP  " + area.getTrait(Trait.PROD_ID)));
        }
        this.relYY.remove(area);
        this.relXX.remove(area);
    }

    private String getTraceIndent() {
        int n2 = this.blockAreas.size();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private int getPaddingBefore(Area area) {
        int n2 = 0;
        Integer n3 = (Integer)area.getTrait(Trait.PADDING_BEFORE);
        if (n3 != null) {
            n2 += n3.intValue();
        }
        return n2;
    }

    private int getPaddingAfter(Area area) {
        int n2 = 0;
        Integer n3 = (Integer)area.getTrait(Trait.PADDING_AFTER);
        if (n3 != null) {
            n2 += n3.intValue();
        }
        return n2;
    }

    private int getPaddingStart(Area area) {
        int n2 = 0;
        Integer n3 = (Integer)area.getTrait(Trait.PADDING_START);
        if (n3 != null) {
            n2 += n3.intValue();
        }
        return n2;
    }

    private int getPaddingEnd(Area area) {
        int n2 = 0;
        Integer n3 = (Integer)area.getTrait(Trait.PADDING_END);
        if (n3 != null) {
            n2 += n3.intValue();
        }
        return n2;
    }

    protected Point getCoordinatesForFOReferenceAreaRelativeToCSSReferenceArea() {
        Iterator<Area> iterator;
        Point point = new Point();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Searching for DELTA coordinates for " + this.blockAreas.peek().getTrait(Trait.PROD_ID) + " X " + this.relXX.get(this.blockAreas.peek()) + " Y " + this.relXX.get(this.blockAreas.peek())));
        }
        if ((iterator = this.blockAreas.iterator()).hasNext()) {
            iterator.next();
        }
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Area area = iterator.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("  " + area + " " + area.getTrait(Trait.PROD_ID)));
            }
            if (area.getTrait(Trait.IS_REFERENCE_AREA) != null) {
                log.trace((Object)"FOUND a FO reference area, start computing its coordinates relative to the positioned ancestor. ");
                bl = true;
            }
            if (!bl) continue;
            if (area instanceof BlockViewport && (((BlockViewport)area).getPositioning() == 2 || ((BlockViewport)area).getPositioning() == 1 || ((BlockViewport)area).getPositioning() == 3)) {
                log.trace((Object)"   FOUND a positioned parent.");
                point.x += this.getPaddingStart(area);
                point.y += this.getPaddingBefore(area);
                bl2 = true;
                break;
            }
            if (area instanceof BlockViewport) {
                point.x += this.relXX.get(area).intValue();
                point.y += this.relYY.get(area).intValue();
                point.x += area.getSpaceStart();
                point.y += area.getSpaceBefore();
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("     rel x - " + this.relXX.get(area)));
                log.trace((Object)("     rel y - " + this.relYY.get(area)));
                log.trace((Object)("     pad x - " + this.getPaddingStart(area)));
                log.trace((Object)("     pad y - " + this.getPaddingBefore(area)));
                log.trace((Object)("        => " + point.x + "," + point.y));
                continue;
            }
            if (area instanceof Block) {
                log.trace((Object)"IGNORE the block");
                continue;
            }
            log.warn((Object)("Unexpected parent area " + area));
        }
        if (!bl2) {
            log.trace((Object)"   NOT FOUND a positioned parent. Using the page as reference.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(" Return " + point));
        }
        return point;
    }

    protected Point getAbsolutPointRelativeToFOReferenceArea(BlockViewport blockViewport, Point point) {
        int n2;
        int n3;
        int[] nArray = blockViewport.getAbsoluteTLBR();
        log.trace((Object)("ABSOLTE TLBR " + Arrays.toString(nArray)));
        if (nArray != null) {
            int n4;
            n3 = this.relXX.get((Object)blockViewport);
            n2 = this.relYY.get((Object)blockViewport);
            int n5 = nArray[0];
            int n6 = nArray[1];
            int n7 = nArray[2];
            int n8 = nArray[3];
            if (n6 != -1) {
                n3 = blockViewport.getXOffset() - point.x;
            }
            if (n5 != -1) {
                n2 = blockViewport.getYOffset() - point.y;
            }
            if (n8 != -1 && (n4 = this.getRightX(blockViewport, n8, point.x)) != -1) {
                n3 = n4;
            }
            if (n7 != -1 && (n4 = this.getBottomY(blockViewport, n7, point.y)) != -1) {
                n2 = n4;
            }
        } else {
            n3 = blockViewport.getXOffset();
            n2 = blockViewport.getYOffset();
        }
        log.trace((Object)("RET " + n3 + ", " + n2));
        return new Point(n3, n2);
    }

    protected BlockViewport getCSSReferenceArea() {
        BlockViewport blockViewport = null;
        Iterator<Area> iterator = this.blockAreas.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Area area = iterator.next();
            if (!(area instanceof BlockViewport) || ((BlockViewport)area).getPositioning() != 2 && ((BlockViewport)area).getPositioning() != 1 && ((BlockViewport)area).getPositioning() != 3) continue;
            blockViewport = (BlockViewport)area;
            break;
        }
        return blockViewport;
    }

    protected int getRightX(BlockViewport blockViewport, int n2, int n3) {
        int n4 = -1;
        BlockViewport blockViewport2 = this.getCSSReferenceArea();
        n4 = blockViewport2 != null ? this.getPaddingStart((Area)blockViewport2) + blockViewport2.getIPD() + this.getPaddingEnd((Area)blockViewport2) - blockViewport.getIPD() - n2 - n3 : this.currentPageViewport.getBodyRegion().getIPD() - blockViewport.getIPD() - n2 - n3;
        return n4;
    }

    protected int getBottomY(BlockViewport blockViewport, int n2, int n3) {
        int n4 = -1;
        BlockViewport blockViewport2 = this.getCSSReferenceArea();
        n4 = blockViewport2 != null ? this.getPaddingBefore((Area)blockViewport2) + blockViewport2.getBPD() + this.getPaddingAfter((Area)blockViewport2) - blockViewport.getAllocBPD() - n2 - n3 : this.currentPageViewport.getBodyRegion().getBPD() - blockViewport.getBPD() - n2 - n3;
        return n4;
    }
}

