/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;

public class PDFStream
extends AbstractPDFStream {
    protected StreamCache data;
    private transient Writer streamWriter;
    private transient char[] charBuffer;

    public PDFStream() {
        this.setUp();
    }

    public PDFStream(PDFDictionary pDFDictionary) {
        super(pDFDictionary);
        this.setUp();
    }

    public PDFStream(PDFDictionary pDFDictionary, boolean bl) {
        super(pDFDictionary, bl);
        this.setUp();
    }

    public PDFStream(boolean bl) {
        super(bl);
        this.setUp();
    }

    private void setUp() {
        try {
            this.data = this.getData();
            this.streamWriter = new OutputStreamWriter(this.getBufferOutputStream(), "ISO-8859-1");
            this.streamWriter = new BufferedWriter(this.streamWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected StreamCache getData() throws IOException {
        return StreamCacheFactory.getInstance().createStreamCache();
    }

    public void add(String string) {
        try {
            this.streamWriter.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void add(StringBuffer stringBuffer) {
        try {
            int n2 = stringBuffer.length();
            if (this.charBuffer == null) {
                this.charBuffer = new char[n2 * 2];
            } else {
                int n3 = this.charBuffer.length;
                if (n3 < n2) {
                    int n4;
                    for (n4 = n3; n4 < n2; n4 *= 2) {
                    }
                    this.charBuffer = new char[n4];
                }
            }
            stringBuffer.getChars(0, n2, this.charBuffer, 0);
            this.streamWriter.write(this.charBuffer, 0, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void flush() throws IOException {
        this.streamWriter.flush();
    }

    public Writer getBufferWriter() {
        return this.streamWriter;
    }

    public OutputStream getBufferOutputStream() throws IOException {
        if (this.streamWriter != null) {
            this.flush();
        }
        return this.data.getOutputStream();
    }

    public void setData(byte[] byArray) throws IOException {
        this.data.clear();
        this.data.write(byArray);
    }

    public int getDataLength() {
        try {
            this.flush();
            return this.data.getSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    protected int getSizeHint() throws IOException {
        this.flush();
        return this.data.getSize();
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.flush();
        this.data.outputContents(outputStream);
    }

    public int output(OutputStream outputStream) throws IOException {
        int n2 = super.output(outputStream);
        return n2;
    }

    public String streamHashCode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.outputRawStreamData(byteArrayOutputStream);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException);
        }
    }
}

