/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PDFLinkQuadPointsBuilder {
    private static final int RESOLUTION = 20;
    private Shape shape;

    public PDFLinkQuadPointsBuilder(Shape shape) {
        this.shape = shape;
    }

    public String getQuadPoints() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.shape != null && !(this.shape instanceof Rectangle2D)) {
            List<Rectangle2D> list = this.decomposeShape(20);
            stringBuilder.append("/QuadPoints [ ");
            for (Rectangle2D rectangle2D : list) {
                float[] fArray;
                float f2 = (float)rectangle2D.getX();
                float f3 = (float)(rectangle2D.getY() + rectangle2D.getHeight());
                float f4 = (float)(rectangle2D.getX() + rectangle2D.getWidth());
                float f5 = (float)rectangle2D.getY();
                for (float f6 : fArray = new float[]{f2, f5, f4, f5, f4, f3, f2, f3}) {
                    stringBuilder.append(f6);
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(" ]\n");
        }
        return stringBuilder.toString();
    }

    List<Rectangle2D> decomposeShape(int n2) {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(n2 * n2 * 2 / 3);
        double d2 = rectangle2D.getWidth() / (double)n2;
        double d3 = rectangle2D.getHeight() / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            Rectangle2D.Double double_ = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX() + (double)i3 * d2, rectangle2D.getY() + (double)i2 * d3, d2, d3);
                double_ = this.addRectangle(double_, double_2, arrayList);
            }
        }
        this.joinStackedRectangles(arrayList);
        return arrayList;
    }

    private void joinStackedRectangles(List<Rectangle2D> list) {
        boolean bl = false;
        while (!bl) {
            bl = true;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                Rectangle2D rectangle2D;
                Rectangle2D rectangle2D2 = list.get(i2);
                if (!this.onTop(rectangle2D2, rectangle2D = list.get(i2 + 1))) continue;
                list.set(i2, new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() + rectangle2D.getHeight()));
                list.remove(i2 + 1);
                --n2;
                bl = false;
            }
        }
    }

    private boolean onTop(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.eq(rectangle2D.getX(), rectangle2D2.getX()) && this.eq(rectangle2D.getWidth(), rectangle2D2.getWidth()) && this.eq(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY());
    }

    private Rectangle2D.Double addRectangle(Rectangle2D.Double double_, Rectangle2D.Double double_2, List<Rectangle2D> list) {
        if (this.shape.contains(double_2)) {
            if (double_ == null) {
                list.add(double_2);
                double_ = double_2;
            } else if (this.eq(double_.getX() + double_.getWidth(), double_2.getX())) {
                double_.width = double_2.getX() - double_.getX() + double_2.width;
            } else {
                list.add(double_2);
                double_ = double_2;
            }
        } else {
            double_ = null;
        }
        return double_;
    }

    private final boolean eq(double d2, double d3) {
        return Math.abs(d2 - d3) < 0.01;
    }
}

