/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFCIELabColorSpace;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFSeparationColorSpace;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;
import org.apache.xmlgraphics.util.DoubleFormatUtil;

public class PDFColorHandler {
    private Log log = LogFactory.getLog(PDFColorHandler.class);
    private PDFResources resources;
    private PDFResourceContext resourceContext;
    private Map<String, PDFCIELabColorSpace> cieLabColorSpaces;
    private int previousAlpha = 255;

    public PDFColorHandler(PDFResources pDFResources, PDFResourceContext pDFResourceContext) {
        this.resources = pDFResources;
        this.resourceContext = pDFResourceContext;
    }

    private PDFDocument getDocument() {
        return this.resources.getDocumentSafely();
    }

    public void establishColor(StringBuffer stringBuffer, Color color, boolean bl, boolean bl2) {
        boolean bl3;
        if (color instanceof ColorWithAlternatives) {
            Color[] colorArray;
            ColorWithAlternatives colorWithAlternatives = (ColorWithAlternatives)color;
            for (Color color2 : colorArray = colorWithAlternatives.getAlternativeColors()) {
                boolean bl4 = this.establishColorFromColor(stringBuffer, color2, bl);
                if (!bl4) continue;
                return;
            }
            if (this.log.isDebugEnabled() && colorArray.length > 0) {
                this.log.debug((Object)("None of the alternative colors are supported. Using fallback: " + color));
            }
        }
        if (!(bl3 = this.establishColorFromColor(stringBuffer, color, bl))) {
            this.establishDeviceRGB(stringBuffer, color, bl, bl2);
        }
    }

    private boolean establishColorFromColor(StringBuffer stringBuffer, Color color, boolean bl) {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace instanceof DeviceCMYKColorSpace) {
            this.establishDeviceCMYK(stringBuffer, color, bl);
            return true;
        }
        if (!colorSpace.isCS_sRGB()) {
            if (colorSpace instanceof ICC_ColorSpace) {
                PDFICCBasedColorSpace pDFICCBasedColorSpace = this.getICCBasedColorSpace((ICC_ColorSpace)colorSpace);
                this.establishColor(stringBuffer, (PDFColorSpace)pDFICCBasedColorSpace, color, bl);
                return true;
            }
            if (colorSpace instanceof NamedColorSpace) {
                PDFSeparationColorSpace pDFSeparationColorSpace = this.getSeparationColorSpace((NamedColorSpace)colorSpace);
                this.establishColor(stringBuffer, (PDFColorSpace)pDFSeparationColorSpace, color, bl);
                return true;
            }
            if (colorSpace instanceof CIELabColorSpace) {
                CIELabColorSpace cIELabColorSpace = (CIELabColorSpace)colorSpace;
                PDFCIELabColorSpace pDFCIELabColorSpace = this.getCIELabColorSpace(cIELabColorSpace);
                this.selectColorSpace(stringBuffer, (PDFColorSpace)pDFCIELabColorSpace, bl);
                float[] fArray = color.getColorComponents(null);
                float[] fArray2 = cIELabColorSpace.toNativeComponents(fArray);
                this.writeColor(stringBuffer, fArray2, cIELabColorSpace.getNumComponents(), bl ? "sc" : "SC");
                return true;
            }
        }
        return false;
    }

    private PDFICCBasedColorSpace getICCBasedColorSpace(ICC_ColorSpace iCC_ColorSpace) {
        PDFICCBasedColorSpace pDFICCBasedColorSpace;
        ICC_Profile iCC_Profile = iCC_ColorSpace.getProfile();
        String string = ColorProfileUtil.getICCProfileDescription((ICC_Profile)iCC_Profile);
        if (this.log.isDebugEnabled()) {
            this.log.trace((Object)("ICC profile encountered: " + string));
        }
        if ((pDFICCBasedColorSpace = this.resources.getICCColorSpaceByProfileName(string)) == null) {
            PDFFactory pDFFactory = this.getDocument().getFactory();
            PDFICCStream pDFICCStream = pDFFactory.makePDFICCStream();
            PDFDeviceColorSpace pDFDeviceColorSpace = PDFDeviceColorSpace.toPDFColorSpace((ColorSpace)iCC_ColorSpace);
            pDFICCStream.setColorSpace(iCC_Profile, pDFDeviceColorSpace);
            pDFICCBasedColorSpace = pDFFactory.makeICCBasedColorSpace(null, string, pDFICCStream);
        }
        return pDFICCBasedColorSpace;
    }

    private PDFSeparationColorSpace getSeparationColorSpace(NamedColorSpace namedColorSpace) {
        PDFName pDFName = new PDFName(namedColorSpace.getColorName());
        PDFSeparationColorSpace pDFSeparationColorSpace = (PDFSeparationColorSpace)this.resources.getColorSpace(pDFName);
        if (pDFSeparationColorSpace == null) {
            PDFFactory pDFFactory = this.getDocument().getFactory();
            pDFSeparationColorSpace = pDFFactory.makeSeparationColorSpace(null, namedColorSpace);
        }
        return pDFSeparationColorSpace;
    }

    private PDFCIELabColorSpace getCIELabColorSpace(CIELabColorSpace cIELabColorSpace) {
        if (this.cieLabColorSpaces == null) {
            this.cieLabColorSpaces = new HashMap<String, PDFCIELabColorSpace>();
        }
        float[] fArray = cIELabColorSpace.getWhitePoint();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(fArray[i2]);
        }
        String string = stringBuilder.toString();
        PDFCIELabColorSpace pDFCIELabColorSpace = this.cieLabColorSpaces.get(string);
        if (pDFCIELabColorSpace == null) {
            float[] fArray2 = new float[]{fArray[0] / 100.0f, fArray[1] / 100.0f, fArray[2] / 100.0f};
            pDFCIELabColorSpace = new PDFCIELabColorSpace(fArray2, null);
            this.getDocument().registerObject((PDFObject)pDFCIELabColorSpace);
            this.resources.addColorSpace((PDFColorSpace)pDFCIELabColorSpace);
            this.cieLabColorSpaces.put(string, pDFCIELabColorSpace);
        }
        return pDFCIELabColorSpace;
    }

    private void establishColor(StringBuffer stringBuffer, PDFColorSpace pDFColorSpace, Color color, boolean bl) {
        this.selectColorSpace(stringBuffer, pDFColorSpace, bl);
        this.writeColor(stringBuffer, color, pDFColorSpace.getNumComponents(), bl ? "sc" : "SC");
    }

    private void selectColorSpace(StringBuffer stringBuffer, PDFColorSpace pDFColorSpace, boolean bl) {
        stringBuffer.append(new PDFName(pDFColorSpace.getName()));
        if (bl) {
            stringBuffer.append(" cs ");
        } else {
            stringBuffer.append(" CS ");
        }
    }

    private void establishDeviceRGB(StringBuffer stringBuffer, Color color, boolean bl, boolean bl2) {
        float[] fArray;
        if (color.getColorSpace().isCS_sRGB()) {
            fArray = color.getColorComponents(null);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Converting color to sRGB as a fallback: " + color));
            }
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            fArray = color.getColorComponents(colorSpace, null);
        }
        if (bl2) {
            this.writeAlpha(color, stringBuffer, bl);
        }
        if (ColorUtil.isGray((Color)color)) {
            fArray = new float[]{fArray[0]};
            this.writeColor(stringBuffer, fArray, 1, bl ? "g" : "G");
        } else {
            this.writeColor(stringBuffer, fArray, 3, bl ? "rg" : "RG");
        }
    }

    private void writeAlpha(Color color, StringBuffer stringBuffer, boolean bl) {
        int n2 = color.getAlpha();
        if ((n2 != 255 || n2 == 255 && n2 != this.previousAlpha) && this.resourceContext != null) {
            HashMap<String, Float> hashMap = new HashMap<String, Float>();
            if (bl) {
                hashMap.put("ca", Float.valueOf((float)n2 / 255.0f));
            } else {
                hashMap.put("ca", Float.valueOf((float)n2 / 255.0f));
                hashMap.put("CA", Float.valueOf((float)n2 / 255.0f));
            }
            PDFGState pDFGState = this.getDocument().getFactory().makeGState(hashMap, PDFGState.DEFAULT);
            this.resourceContext.addGState(pDFGState);
            stringBuffer.append("/").append(pDFGState.getName()).append(" gs\n");
            if (n2 != 255) {
                this.previousAlpha = n2;
            }
        }
    }

    private void establishDeviceCMYK(StringBuffer stringBuffer, Color color, boolean bl) {
        this.writeAlpha(color, stringBuffer, bl);
        this.writeColor(stringBuffer, color, 4, bl ? "k" : "K");
    }

    private void writeColor(StringBuffer stringBuffer, Color color, int n2, String string) {
        float[] fArray = color.getColorComponents(null);
        this.writeColor(stringBuffer, fArray, n2, string);
    }

    private void writeColor(StringBuffer stringBuffer, float[] fArray, int n2, String string) {
        if (fArray.length != n2) {
            throw new IllegalStateException("Color with unexpected component count encountered");
        }
        for (float f2 : fArray) {
            DoubleFormatUtil.formatDouble((double)f2, (int)4, (int)4, (StringBuffer)stringBuffer);
            stringBuffer.append(" ");
        }
        stringBuffer.append(string).append("\n");
    }
}

