/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.FootenoteUtil;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.PageBreaker;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.RowGroupLayoutManager;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableHeaderFooterPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableRowIterator;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

public class TableContentLayoutManager
implements PercentBaseContext {
    private static final Log LOG = LogFactory.getLog(TableContentLayoutManager.class);
    private TableLayoutManager tableLM;
    protected TableRowIterator bodyIter;
    private TableRowIterator headerIter;
    private TableRowIterator footerIter;
    private LinkedList headerList;
    private LinkedList footerList;
    private int headerNetHeight;
    private int footerNetHeight;
    private int startXOffset;
    private int usedBPD;
    private TableStepper stepper;
    private final Map<TableColumn, MinOptMax> baseLength = new LinkedHashMap<TableColumn, MinOptMax>();
    private boolean headerIsBeingRepeated;
    private boolean atLeastOnce;

    TableContentLayoutManager(TableLayoutManager tableLayoutManager) {
        this.tableLM = tableLayoutManager;
        Table table = this.getTableLM().getTable();
        this.bodyIter = new TableRowIterator(table, 0);
        if (table.getTableHeader() != null) {
            this.headerIter = new TableRowIterator(table, 1);
        }
        if (table.getTableFooter() != null) {
            this.footerIter = new TableRowIterator(table, 2);
        }
        this.stepper = new TableStepper(this);
    }

    TableLayoutManager getTableLM() {
        return this.tableLM;
    }

    boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    ColumnSetup getColumns() {
        return this.getTableLM().getColumns();
    }

    protected int getHeaderNetHeight() {
        return this.headerNetHeight;
    }

    protected int getFooterNetHeight() {
        return this.footerNetHeight;
    }

    protected LinkedList getHeaderElements() {
        return this.headerList;
    }

    protected LinkedList getFooterElements() {
        return this.footerList;
    }

    public void setBaseLength(TableColumn tableColumn, MinOptMax minOptMax) {
        this.baseLength.put(tableColumn, minOptMax);
    }

    public final MinOptMax getBaseLength(FObj fObj) {
        MinOptMax minOptMax = this.baseLength.get(fObj);
        return minOptMax;
    }

    private boolean setBaseLength(PrimaryGridUnit primaryGridUnit, LayoutContext layoutContext, Pass pass) {
        boolean bl;
        int n2;
        int n3;
        Object object = true;
        Table table = this.tableLM.getTable();
        int n4 = primaryGridUnit.getColIndex();
        int n5 = n4 + primaryGridUnit.getCell().getNumberColumnsSpanned();
        TableColumn tableColumn = table.getColumn(n4);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n3 = n4; n3 < n5; ++n3) {
            int n9;
            TableColumn tableColumn2 = table.getColumn(n3);
            int n10 = tableColumn2.getColumnWidth().getValue((PercentBaseContext)this.tableLM);
            n6 += n10;
            if (tableColumn2.isAutoLayout()) {
                MinOptMax minOptMax = this.getBaseLength((FObj)tableColumn2);
                if (minOptMax != null) {
                    n2 = minOptMax.getMin();
                    n9 = minOptMax.getMax();
                } else {
                    n2 = n10;
                    n9 = n10;
                }
            } else {
                n2 = n10;
                n9 = n10;
            }
            n7 += n2;
            n8 += n9;
        }
        n3 = primaryGridUnit.getCellLM().getRefIPD();
        int n11 = primaryGridUnit.getCellLM().getMaximumIPD();
        n2 = primaryGridUnit.getCellLM().getMinimumIPD();
        MinOptMax minOptMax = this.getBaseLength((FObj)tableColumn);
        boolean bl2 = bl = n4 != n5 - 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("       ================= (" + primaryGridUnit.getRowIndex() + ", " + primaryGridUnit.getColIndex() + ") " + pass));
            LOG.debug((Object)("       columnSpanWidth = " + n6));
            LOG.debug((Object)("       IPD             = " + n3));
            LOG.debug((Object)("       minIPD          = " + n2));
            LOG.debug((Object)("       maxIPD          = " + n11));
            LOG.debug((Object)("       baseLength      = " + minOptMax));
            LOG.debug((Object)("       spansColumns    = " + bl));
        }
        if (n6 == 0 || minOptMax == null) {
            MinOptMax minOptMax2 = null;
            if (!(pass != Pass.ALL_CELLS && pass != Pass.ONE_UNIT_CELLS || bl)) {
                minOptMax2 = MinOptMax.getInstance((int)n2, (int)n11, (int)n11);
            } else if (pass == Pass.ALL_CELLS && bl) {
                minOptMax2 = MinOptMax.getInstance((int)n2, (int)n11, (int)n11);
            }
            if (minOptMax2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"       Initializing the column.");
                    LOG.debug((Object)("         - Set Base Length (" + primaryGridUnit.getRowIndex() + ", " + primaryGridUnit.getColIndex() + ") = " + minOptMax2));
                }
                this.baseLength.put(tableColumn, minOptMax2);
                object = false;
            }
        } else if (!(pass != Pass.ALL_CELLS && pass != Pass.ONE_UNIT_CELLS || bl)) {
            if (n6 < n3 || minOptMax.getMin() < n2 || minOptMax.getMax() < n11) {
                MinOptMax minOptMax3 = MinOptMax.getInstance((int)Math.max(minOptMax.getMin(), n2), (int)Math.max(minOptMax.getOpt(), n11), (int)Math.max(minOptMax.getMax(), n11));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"       Cell needs more space. ");
                    LOG.debug((Object)("         - Set Base Length (" + primaryGridUnit.getRowIndex() + ", " + primaryGridUnit.getColIndex() + ") = " + minOptMax3 + " / " + minOptMax));
                }
                this.baseLength.put(tableColumn, minOptMax3);
                object = minOptMax.equals((Object)minOptMax3);
            }
        } else if (pass == Pass.ALL_CELLS && bl) {
            boolean bl3;
            boolean bl4 = n7 < n2;
            boolean bl5 = n6 < n3;
            boolean bl6 = bl3 = n8 < n11;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("       This primary spans multiple columns which may have to be resized: " + bl4 + " " + bl5 + " " + bl3));
            }
            if (bl4 || bl5 || bl3) {
                ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
                for (TableColumn tableColumn3 : table.getColumns().subList(n4, n5)) {
                    int n12;
                    if (tableColumn3.isAutoLayout()) {
                        n12 = tableColumn3.getColumnWidth().getValue((PercentBaseContext)this.tableLM);
                        if (this.tableLM.getPossibleWidths(tableColumn3, layoutContext) == null) continue;
                        arrayList.add(tableColumn3);
                        continue;
                    }
                    n12 = tableColumn3.getColumnWidth().getValue((PercentBaseContext)this.tableLM);
                    n6 -= n12;
                    n7 -= n12;
                    n3 -= n12;
                    n2 -= n12;
                }
                if (arrayList.isEmpty()) {
                    if (n2 > 0 || n3 > 0) {
                        LOG.warn((Object)"       No columns to resize to fit a table-cell spanning these columns, expect overflows");
                    }
                } else {
                    Object object2;
                    if (n7 < n2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)("       Cell (" + primaryGridUnit.getColIndex() + "," + primaryGridUnit.getRowIndex() + ") spanning " + primaryGridUnit.getCell().getNumberColumnsSpanned() + " columns requires at least " + n2 + " -> widening MIN its spanned columns: " + arrayList));
                        }
                        object2 = new boolean[1];
                        int n13 = this.increaseMinimumWidthOfSpannedColumns(arrayList, n7, n2, layoutContext, (boolean[])object2);
                        object = object2[0];
                        n6 += n13;
                    }
                    if (n8 < n11) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)("       Cell (" + primaryGridUnit.getColIndex() + "," + primaryGridUnit.getRowIndex() + ") spanning " + primaryGridUnit.getCell().getNumberColumnsSpanned() + " columns requires at least " + n2 + " -> widening /MAX its spanned columns: " + arrayList));
                        }
                        object2 = new boolean[1];
                        int n14 = this.increaseMaximumWidthOfSpannedColumns(arrayList, n8, n11, layoutContext, (boolean[])object2);
                        object = object2[0];
                        n6 += n14;
                    }
                }
            }
        } else {
            LOG.debug((Object)"       Cell spans multiple columns. Will be resolved in the next pass. ");
            LOG.debug((Object)"         - Set Base Length remains unchanged");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("         - return same = " + object));
        }
        return object;
    }

    private int increaseMinimumWidthOfSpannedColumns(List<TableColumn> list, int n2, int n3, LayoutContext layoutContext, boolean[] blArray) {
        int n4 = 0;
        for (TableColumn tableColumn : list) {
            MinOptMax minOptMax = this.tableLM.getPossibleWidths(tableColumn, layoutContext);
            double d2 = (double)minOptMax.getMin() / (double)n2;
            int n5 = n3 - n2;
            int n6 = (int)Math.ceil(d2 * (double)n5);
            MinOptMax minOptMax2 = MinOptMax.getInstance((int)(minOptMax.getMin() + n6), (int)(minOptMax.getOpt() + n6), (int)(minOptMax.getMax() + n6));
            MinOptMax minOptMax3 = this.baseLength.get((Object)tableColumn);
            this.setBaseLength(tableColumn, minOptMax2);
            boolean bl = blArray[0] = minOptMax3 != null ? minOptMax3.equals((Object)minOptMax2) : false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("          - (MIN) Set Base Length " + tableColumn.getColumnNumber() + " = " + minOptMax2 + " same " + blArray[0]));
            }
            n4 += n6;
        }
        return n4;
    }

    private int increaseMaximumWidthOfSpannedColumns(List<TableColumn> list, int n2, int n3, LayoutContext layoutContext, boolean[] blArray) {
        int n4 = 0;
        for (TableColumn tableColumn : list) {
            MinOptMax minOptMax = this.tableLM.getPossibleWidths(tableColumn, layoutContext);
            double d2 = (double)minOptMax.getMax() / (double)n2;
            int n5 = n3 - n2;
            int n6 = (int)Math.ceil(d2 * (double)n5);
            MinOptMax minOptMax2 = MinOptMax.getInstance((int)minOptMax.getMin(), (int)(minOptMax.getOpt() + n6), (int)(minOptMax.getMax() + n6));
            MinOptMax minOptMax3 = this.baseLength.get((Object)tableColumn);
            this.setBaseLength(tableColumn, minOptMax2);
            boolean bl = blArray[0] = minOptMax3 != null ? minOptMax3.equals((Object)minOptMax2) : false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("          - (MAX) Set Base Length " + tableColumn.getColumnNumber() + " = " + minOptMax2 + " original max: " + minOptMax.getMax() + "  same " + blArray[0]));
            }
            n4 += n6;
        }
        return n4;
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        Object object;
        List<FootnoteBodyLayoutManager> list;
        TableHeaderFooterPosition tableHeaderFooterPosition;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> Columns: " + this.getTableLM().getColumns()));
        }
        KnuthBox knuthBox = null;
        KnuthBox knuthBox2 = null;
        KnuthBox knuthBox3 = null;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        int n3 = 0;
        if (this.headerIter != null && this.headerList == null) {
            this.headerList = this.getKnuthElementsForRowIterator(this.headerIter, layoutContext, n2, 1);
            this.headerNetHeight = ElementListUtils.calcContentLength((List)this.headerList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> Header: " + this.headerNetHeight + " - " + this.headerList));
            }
            tableHeaderFooterPosition = new TableHeaderFooterPosition((LayoutManager)((Object)this.getTableLM()), true, this.headerList);
            list = FootenoteUtil.getFootnotes(this.headerList);
            Object object2 = object = list.isEmpty() || !this.getTableLM().getTable().omitHeaderAtBreak() ? new KnuthBox(this.headerNetHeight, (Position)tableHeaderFooterPosition, false) : new KnuthBlockBox(this.headerNetHeight, list, (Position)tableHeaderFooterPosition, false);
            if (this.getTableLM().getTable().omitHeaderAtBreak()) {
                knuthBox = object;
            } else {
                if (!list.isEmpty()) {
                    List list2 = PageBreaker.getFootnoteKnuthElements((FlowLayoutManager)this.getTableLM().getPSLM().getFlowLayoutManager(), (LayoutContext)layoutContext, list);
                    this.getTableLM().setHeaderFootnotes(list2);
                    n3 = this.getFootnotesBPD(list2);
                    linkedList.add((ListElement)new KnuthBlockBox(-n3, list, new Position((LayoutManager)((Object)this.getTableLM())), true));
                    this.headerNetHeight += n3;
                }
                knuthBox2 = object;
            }
        }
        if (this.footerIter != null && this.footerList == null) {
            this.footerList = this.getKnuthElementsForRowIterator(this.footerIter, layoutContext, n2, 2);
            this.footerNetHeight = ElementListUtils.calcContentLength((List)this.footerList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> Footer: " + this.footerNetHeight + " - " + this.footerList));
            }
            tableHeaderFooterPosition = new TableHeaderFooterPosition((LayoutManager)((Object)this.getTableLM()), false, this.footerList);
            list = FootenoteUtil.getFootnotes(this.footerList);
            Object object3 = knuthBox3 = list.isEmpty() ? new KnuthBox(this.footerNetHeight, (Position)tableHeaderFooterPosition, false) : new KnuthBlockBox(this.footerNetHeight, list, (Position)tableHeaderFooterPosition, false);
            if (!this.getTableLM().getTable().omitFooterAtBreak() && !list.isEmpty()) {
                object = PageBreaker.getFootnoteKnuthElements((FlowLayoutManager)this.getTableLM().getPSLM().getFlowLayoutManager(), (LayoutContext)layoutContext, list);
                this.getTableLM().setFooterFootnotes((List<List<KnuthElement>>)object);
                this.footerNetHeight += this.getFootnotesBPD((List<List<KnuthElement>>)object);
            }
        }
        linkedList.addAll(this.getKnuthElementsForRowIterator(this.bodyIter, layoutContext, n2, 0));
        if (knuthBox != null) {
            int n4 = 0;
            if (linkedList.size() > 0 && ((ListElement)linkedList.getFirst()).isForcedBreak()) {
                ++n4;
            }
            linkedList.add(n4, (ListElement)knuthBox);
        } else if (knuthBox2 != null) {
            int n5 = linkedList.size();
            if (linkedList.size() > 0 && linkedList.getLast().isForcedBreak()) {
                --n5;
            }
            linkedList.add(n5, (ListElement)knuthBox2);
        }
        if (knuthBox3 != null) {
            int n6 = linkedList.size();
            if (linkedList.size() > 0 && linkedList.getLast().isForcedBreak()) {
                --n6;
            }
            linkedList.add(n6, (ListElement)knuthBox3);
        }
        if (n3 != 0) {
            linkedList.add((ListElement)new KnuthBox(n3, new Position((LayoutManager)((Object)this.getTableLM())), true));
        }
        return linkedList;
    }

    private int getFootnotesBPD(List<List<KnuthElement>> list) {
        int n2 = 0;
        for (List<KnuthElement> list2 : list) {
            n2 += ElementListUtils.calcContentLength(list2);
        }
        return n2;
    }

    private LinkedList getKnuthElementsForRowIterator(TableRowIterator tableRowIterator, LayoutContext layoutContext, int n2, int n3) {
        int n4;
        Object object;
        ListIterator listIterator;
        LinkedList linkedList = new LinkedList();
        EffRow[] effRowArray = tableRowIterator.getNextRowGroup();
        layoutContext.clearKeepsPending();
        layoutContext.setBreakBefore(9);
        layoutContext.setBreakAfter(9);
        Keep keep = Keep.KEEP_AUTO;
        int n5 = 9;
        if (effRowArray != null) {
            listIterator = new RowGroupLayoutManager(this.getTableLM(), effRowArray, this.stepper);
            object = ((RowGroupLayoutManager)((Object)listIterator)).getNextKnuthElements(layoutContext, n2, n3);
            keep = keep.compare(layoutContext.getKeepWithPreviousPending());
            n5 = layoutContext.getBreakBefore();
            int n6 = layoutContext.getBreakAfter();
            linkedList.addAll(object);
            while ((effRowArray = tableRowIterator.getNextRowGroup()) != null) {
                ListIterator listIterator2;
                ListElement listElement;
                listIterator = new RowGroupLayoutManager(this.getTableLM(), effRowArray, this.stepper);
                Keep keep2 = layoutContext.getKeepWithNextPending();
                layoutContext.clearKeepWithNextPending();
                object = ((RowGroupLayoutManager)((Object)listIterator)).getNextKnuthElements(layoutContext, n2, n3);
                Keep keep3 = keep2.compare(layoutContext.getKeepWithPreviousPending());
                layoutContext.clearKeepWithPreviousPending();
                keep3 = keep3.compare(this.getTableLM().getKeepTogether());
                int n7 = keep3.getPenalty();
                int n8 = keep3.getContext();
                n6 = BreakUtil.compareBreakClasses((int)n6, (int)layoutContext.getBreakBefore());
                if (n6 != 9) {
                    n7 = -1000;
                    n8 = n6;
                }
                BreakElement breakElement = (listElement = (ListElement)(listIterator2 = linkedList.listIterator(linkedList.size())).previous()) instanceof KnuthGlue ? (BreakElement)((Object)listIterator2.previous()) : (BreakElement)listElement;
                breakElement.setPenaltyValue(n7);
                breakElement.setBreakClass(n8);
                linkedList.addAll(object);
                n6 = layoutContext.getBreakAfter();
            }
        }
        if (!linkedList.isEmpty()) {
            listIterator = linkedList.listIterator(linkedList.size());
            object = (ListElement)listIterator.previous();
            if (object instanceof KnuthGlue) {
                BreakElement breakElement = (BreakElement)((Object)listIterator.previous());
                breakElement.setPenaltyValue(1000);
            } else {
                listIterator.remove();
            }
        }
        layoutContext.updateKeepWithPreviousPending(keep);
        layoutContext.setBreakBefore(n5);
        int n9 = this.getTableLM().getTable().getWidowContentLimit().getValue();
        if (n9 != 0 && n3 == 0) {
            ElementListUtils.removeLegalBreaks(linkedList, (int)n9);
        }
        if ((n4 = this.getTableLM().getTable().getOrphanContentLimit().getValue()) != 0 && n3 == 0) {
            ElementListUtils.removeLegalBreaksFromEnd(linkedList, (int)n4);
        }
        return linkedList;
    }

    protected int getXOffsetOfGridUnit(PrimaryGridUnit primaryGridUnit) {
        return this.getXOffsetOfGridUnit(primaryGridUnit.getColIndex(), primaryGridUnit.getCell().getNumberColumnsSpanned());
    }

    protected int getXOffsetOfGridUnit(int n2, int n3) {
        return this.startXOffset + this.getTableLM().getColumns().getXOffset(n2 + 1, n3, (PercentBaseContext)this.getTableLM());
    }

    void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        boolean bl;
        Object object;
        this.usedBPD = 0;
        RowPainter rowPainter = new RowPainter(this, layoutContext);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        List<ListElement> list = null;
        List<ListElement> list2 = null;
        Position position = null;
        Position position2 = null;
        Position position3 = null;
        while (positionIterator.hasNext()) {
            Position position4 = positionIterator.next();
            if (position4 instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                position4 = ((SpaceResolver.SpaceHandlingBreakPosition)position4).getOriginalBreakPosition();
            }
            if (position4 == null) continue;
            if (position == null) {
                position = position4;
            }
            position2 = position4;
            if (position4.getIndex() >= 0) {
                position3 = position4;
            }
            if (position4 instanceof TableHeaderFooterPosition) {
                object = (TableHeaderFooterPosition)position4;
                if (((TableHeaderFooterPosition)((Object)object)).header) {
                    list = ((TableHeaderFooterPosition)((Object)object)).nestedElements;
                    continue;
                }
                list2 = ((TableHeaderFooterPosition)((Object)object)).nestedElements;
                continue;
            }
            if (position4 instanceof TableHFPenaltyPosition) continue;
            if (position4 instanceof TableContentPosition) {
                arrayList.add(position4);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ignoring position: " + position4));
        }
        boolean bl2 = layoutContext.treatAsArtifact();
        if (position2 instanceof TableHFPenaltyPosition) {
            object = (TableHFPenaltyPosition)position2;
            LOG.debug((Object)"Break at penalty!");
            if (object.headerElements != null) {
                list = object.headerElements;
            }
            if (object.footerElements != null) {
                list2 = object.footerElements;
                bl2 = true;
            }
        }
        this.tableLM.clearTableFragmentMarkers();
        object = this.getTableLM().getTable().getMarkers();
        if (object != null) {
            this.getTableLM().getCurrentPV().registerMarkers((Map)object, true, this.getTableLM().isFirst(position), this.getTableLM().isLast(position3));
        }
        if (list != null) {
            bl = layoutContext.treatAsArtifact();
            if (this.headerIsBeingRepeated) {
                layoutContext.setTreatAsArtifact(true);
                if (!this.getTableLM().getHeaderFootnotes().isEmpty()) {
                    this.getTableLM().getPSLM().addTableHeaderFootnotes(this.getTableLM().getHeaderFootnotes());
                }
            }
            this.addHeaderFooterAreas(list, (TablePart)this.tableLM.getTable().getTableHeader(), rowPainter, false);
            if (!bl) {
                this.headerIsBeingRepeated = true;
            }
            layoutContext.setTreatAsArtifact(bl);
        }
        if (arrayList.isEmpty()) {
            LOG.error((Object)"tablePositions empty. Please send your FO file to fop-users@xmlgraphics.apache.org");
        } else {
            this.addBodyAreas(arrayList.iterator(), rowPainter, list2 == null);
        }
        this.tableLM.setRepeateHeader(this.atLeastOnce);
        this.tableLM.repeatAddAreasForSavedTableHeaderTableCellLayoutManagers();
        this.atLeastOnce = true;
        if (list2 != null && !list2.isEmpty()) {
            bl = layoutContext.treatAsArtifact();
            layoutContext.setTreatAsArtifact(bl2);
            this.addHeaderFooterAreas(list2, (TablePart)this.tableLM.getTable().getTableFooter(), rowPainter, true);
            if (position2 instanceof TableHFPenaltyPosition && !this.tableLM.getFooterFootnotes().isEmpty()) {
                this.tableLM.getPSLM().addTableFooterFootnotes(this.getTableLM().getFooterFootnotes());
            }
            layoutContext.setTreatAsArtifact(bl);
        }
        this.usedBPD += rowPainter.getAccumulatedBPD();
        if (object != null) {
            this.getTableLM().getCurrentPV().registerMarkers((Map)object, false, this.getTableLM().isFirst(position), this.getTableLM().isLast(position3));
        }
    }

    private void addHeaderFooterAreas(List list, TablePart tablePart, RowPainter rowPainter, boolean bl) {
        ArrayList<TableContentPosition> arrayList = new ArrayList<TableContentPosition>(list.size());
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(list);
        while (knuthPossPosIter.hasNext()) {
            Position position = (Position)knuthPossPosIter.next();
            if (!(position instanceof TableContentPosition)) continue;
            arrayList.add((TableContentPosition)position);
        }
        this.addTablePartAreas(arrayList, rowPainter, tablePart, true, true, true, bl);
    }

    private void addBodyAreas(Iterator iterator, RowPainter rowPainter, boolean bl) {
        rowPainter.startBody();
        ArrayList<TableContentPosition> arrayList = new ArrayList<TableContentPosition>();
        TableContentPosition tableContentPosition = (TableContentPosition)iterator.next();
        boolean bl2 = tableContentPosition.getFlag(1) && tableContentPosition.getRow().getFlag(0);
        TablePart tablePart = tableContentPosition.getTablePart();
        arrayList.add(tableContentPosition);
        while (iterator.hasNext()) {
            tableContentPosition = (TableContentPosition)iterator.next();
            if (tableContentPosition.getTablePart() != tablePart) {
                this.addTablePartAreas(arrayList, rowPainter, tablePart, bl2, true, false, false);
                bl2 = true;
                arrayList.clear();
                tablePart = tableContentPosition.getTablePart();
            }
            arrayList.add(tableContentPosition);
        }
        boolean bl3 = tableContentPosition.getFlag(2) && tableContentPosition.getRow().getFlag(1);
        this.addTablePartAreas(arrayList, rowPainter, tablePart, bl2, bl3, true, bl);
        rowPainter.endBody();
    }

    private void addTablePartAreas(List list, RowPainter rowPainter, TablePart tablePart, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.getTableLM().getCurrentPV().registerMarkers(tablePart.getMarkers(), true, bl, bl2);
        if (tablePart instanceof TableBody) {
            this.getTableLM().registerMarkers(tablePart.getMarkers(), true, bl, bl2);
        }
        rowPainter.startTablePart(tablePart);
        HashMap<String, Marker> hashMap = this.getRowMarkers(list, true);
        if (hashMap != null) {
            this.getTableLM().getCurrentPV().registerMarkers(hashMap, true, bl, bl2);
            if (tablePart instanceof TableBody) {
                this.getTableLM().registerMarkers(hashMap, true, bl, bl2);
            }
        }
        for (Object e2 : list) {
            rowPainter.handleTableContentPosition((TableContentPosition)e2);
        }
        if (hashMap != null) {
            hashMap = this.getRowMarkers(list, false);
            this.getTableLM().getCurrentPV().registerMarkers(hashMap, false, bl, bl2);
            if (tablePart instanceof TableBody) {
                this.getTableLM().registerMarkers(hashMap, false, bl, bl2);
            }
        }
        this.getTableLM().getCurrentPV().registerMarkers(tablePart.getMarkers(), false, bl, bl2);
        if (tablePart instanceof TableBody) {
            this.getTableLM().registerMarkers(tablePart.getMarkers(), false, bl, bl2);
        }
        rowPainter.endTablePart(bl3, bl4);
    }

    private HashMap<String, Marker> getRowMarkers(List<TableContentPosition> list, boolean bl) {
        HashMap<String, Marker> hashMap = null;
        int n2 = -1;
        for (TableContentPosition tableContentPosition : list) {
            Map map;
            int n3;
            TableContentPosition tableContentPosition2 = tableContentPosition;
            EffRow effRow = tableContentPosition2.getRow();
            if (effRow == null || (n3 = effRow.getIndex()) == n2) continue;
            n2 = n3;
            TableRow tableRow = effRow.getTableRow();
            if (tableRow == null || (map = tableRow.getMarkers()) == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Marker>(map);
                continue;
            }
            this.copyMarkers(bl, map, hashMap);
        }
        return hashMap;
    }

    private void copyMarkers(boolean bl, Map<String, Marker> map, HashMap<String, Marker> hashMap) {
        if (bl) {
            Set<Map.Entry<String, Marker>> set = map.entrySet();
            for (Map.Entry<String, Marker> entry : set) {
                if (hashMap.containsKey(entry.getKey())) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        } else {
            hashMap.putAll(map);
        }
    }

    void setStartXOffset(int n2) {
        this.startXOffset = n2;
    }

    int getUsedBPD() {
        return this.usedBPD;
    }

    public int getBaseLength(int n2, FObj fObj) {
        return this.tableLM.getBaseLength(n2, fObj);
    }

    public void determineMinMaxWidths(LayoutContext layoutContext, int n2, Pass pass) {
        Table table = this.getTableLM().getTable();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"\n\n\n");
            LOG.debug((Object)(">>>>>> START Determine Auto Layout Widths for " + pass));
        }
        if (table.getTableHeader() != null) {
            this.determineMinMaxWidthsInRows(new TableRowIterator(table, 1), layoutContext, n2, 1, pass);
        }
        this.determineMinMaxWidthsInRows(new TableRowIterator(table, 0), layoutContext, n2, 0, pass);
        if (table.getTableFooter() != null) {
            this.determineMinMaxWidthsInRows(new TableRowIterator(table, 2), layoutContext, n2, 2, pass);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>>>>> END Determine Auto Layout Widths for " + pass));
            Set<TableColumn> set = this.baseLength.keySet();
            for (TableColumn tableColumn : set) {
                LOG.debug((Object)("   " + tableColumn + " " + this.baseLength.get((Object)tableColumn)));
            }
        }
    }

    private boolean determineMinMaxWidthsInRows(TableRowIterator tableRowIterator, LayoutContext layoutContext, int n2, int n3, Pass pass) {
        EffRow[] effRowArray;
        boolean bl = true;
        LinkedList<PrimaryGridUnit> linkedList = new LinkedList<PrimaryGridUnit>();
        while ((effRowArray = tableRowIterator.getNextRowGroup()) != null) {
            for (EffRow effRow : effRowArray) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"\n");
                    LOG.debug((Object)("      >> START Row " + effRow.getIndex()));
                }
                for (GridUnit gridUnit : effRow.getGridUnits()) {
                    boolean bl2;
                    if (!gridUnit.isPrimary()) continue;
                    PrimaryGridUnit primaryGridUnit = gridUnit.getPrimary();
                    if (ChemistryExtensions.isFill((FObj)primaryGridUnit.getCell())) {
                        TableColumn tableColumn = this.getTableLM().getColumns().getColumn(1 + primaryGridUnit.getColIndex());
                        tableColumn.setFill(true);
                    }
                    if (primaryGridUnit.getCell().getNumberColumnsSpanned() > 1) {
                        LOG.debug((Object)"Will revisit first row");
                        linkedList.add(primaryGridUnit);
                    }
                    bl = (bl2 = this.determineMinMaxWidthsOfPrimary(primaryGridUnit, layoutContext, n2, pass)) && bl;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("      >> End Row " + effRow.getIndex()));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"      >> START Scanning colspanning primary ");
        }
        LOG.debug((Object)("       Same:  " + bl));
        LOG.debug((Object)"      >> End  Scanning colspanning primary ");
        return bl;
    }

    private boolean determineMinMaxWidthsOfPrimary(PrimaryGridUnit primaryGridUnit, LayoutContext layoutContext, int n2, Pass pass) {
        primaryGridUnit.createCellLM();
        TableCellLayoutManager tableCellLayoutManager = primaryGridUnit.getCellLM();
        tableCellLayoutManager.setParent((LayoutManager)((Object)this.tableLM));
        int n3 = 0;
        ListIterator<FONode> listIterator = this.tableLM.getTable().getColumns().listIterator(primaryGridUnit.getColIndex());
        int n4 = primaryGridUnit.getCell().getNumberColumnsSpanned();
        for (int i2 = 0; i2 < n4; ++i2) {
            Length length = ((TableColumn)((Object)listIterator.next())).getColumnWidth();
            int n5 = length.getValue((PercentBaseContext)this.tableLM);
            n3 += n5;
        }
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
        if (this.tableLM.getTable().getColumns().size() == 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"   refIDP - Ugly workaround for a single column. Passing the entire ref IPD to the column.");
            }
            layoutContext2.setRefIPD(layoutContext.getRefIPD());
        } else {
            layoutContext2.setRefIPD(n3);
        }
        List<ListElement> list = tableCellLayoutManager.getNextKnuthElements(layoutContext2, n2);
        primaryGridUnit.setElements(list);
        boolean bl = this.setBaseLength(primaryGridUnit, layoutContext, pass);
        primaryGridUnit.setElements(null);
        return bl;
    }

    public int getBaselineOffset() {
        Table table = this.getTableLM().getTable();
        int n2 = 0;
        if (table.getTableHeader() != null) {
            n2 = this.getBaselineOffsetInRows(new TableRowIterator(table, 1));
        }
        if (n2 <= 0) {
            n2 = this.getBaselineOffsetInRows(new TableRowIterator(table, 0));
        }
        if (n2 <= 0 && table.getTableFooter() != null) {
            n2 = this.getBaselineOffsetInRows(new TableRowIterator(table, 2));
        }
        return n2;
    }

    public boolean hasLineAreaDescendant() {
        return true;
    }

    private int getBaselineOffsetInRows(TableRowIterator tableRowIterator) {
        EffRow[] effRowArray;
        int n2 = 0;
        block0: while ((effRowArray = tableRowIterator.getNextRowGroup()) != null) {
            int n3 = 1;
            for (EffRow effRow : effRowArray) {
                for (GridUnit gridUnit : effRow.getGridUnits()) {
                    PrimaryGridUnit primaryGridUnit;
                    TableCellLayoutManager tableCellLayoutManager;
                    if (!gridUnit.isPrimary() || !(tableCellLayoutManager = (primaryGridUnit = gridUnit.getPrimary()).getCellLM()).hasLineAreaDescendant()) continue;
                    int n4 = primaryGridUnit.getBeforeBorderWidth(0, n3);
                    int n5 = tableCellLayoutManager.getBaselineOffset();
                    n2 = Math.max(n2, n5 + n4);
                }
                if (n2 != 0) continue block0;
                n3 = 0;
            }
        }
        return n2;
    }

    public static enum Pass {
        ONE_UNIT_CELLS,
        ALL_CELLS;

    }
}

