/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

class RowGroupLayoutManager {
    private static Log log = LogFactory.getLog(RowGroupLayoutManager.class);
    private static final MinOptMax MAX_STRETCH = MinOptMax.getInstance((int)0, (int)0, (int)Integer.MAX_VALUE);
    private EffRow[] rowGroup;
    private TableLayoutManager tableLM;
    private TableStepper tableStepper;

    RowGroupLayoutManager(TableLayoutManager tableLayoutManager, EffRow[] effRowArray, TableStepper tableStepper) {
        this.tableLM = tableLayoutManager;
        this.rowGroup = effRowArray;
        this.tableStepper = tableStepper;
    }

    public LinkedList<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, int n3) {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        this.createElementsForRowGroup(layoutContext, n2, n3, linkedList);
        layoutContext.updateKeepWithPreviousPending(this.rowGroup[0].getKeepWithPrevious());
        layoutContext.updateKeepWithNextPending(this.rowGroup[this.rowGroup.length - 1].getKeepWithNext());
        int n4 = 9;
        TableRow tableRow = this.rowGroup[0].getTableRow();
        if (tableRow != null) {
            n4 = tableRow.getBreakBefore();
        }
        layoutContext.setBreakBefore(BreakUtil.compareBreakClasses((int)n4, (int)this.rowGroup[0].getBreakBefore()));
        int n5 = 9;
        TableRow tableRow2 = this.rowGroup[this.rowGroup.length - 1].getTableRow();
        if (tableRow2 != null) {
            n5 = tableRow2.getBreakAfter();
        }
        layoutContext.setBreakAfter(BreakUtil.compareBreakClasses((int)n5, (int)this.rowGroup[this.rowGroup.length - 1].getBreakAfter()));
        return linkedList;
    }

    private void createElementsForRowGroup(LayoutContext layoutContext, int n2, int n3, LinkedList linkedList) {
        log.debug((Object)("Handling row group with " + this.rowGroup.length + " rows..."));
        Object object = this.rowGroup;
        int n4 = ((EffRow[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            EffRow effRow;
            EffRow effRow2 = effRow = object[i2];
            for (GridUnit gridUnit : effRow2.getGridUnits()) {
                GridUnit gridUnit2 = gridUnit;
                if (!gridUnit2.isPrimary()) continue;
                PrimaryGridUnit primaryGridUnit = gridUnit2.getPrimary();
                primaryGridUnit.createCellLM();
                primaryGridUnit.getCellLM().setParent((LayoutManager)((Object)this.tableLM));
                int n5 = 0;
                ListIterator<FONode> listIterator = this.tableLM.getTable().getColumns().listIterator(primaryGridUnit.getColIndex());
                int n6 = primaryGridUnit.getCell().getNumberColumnsSpanned();
                for (int i3 = 0; i3 < n6; ++i3) {
                    n5 += ((TableColumn)((Object)listIterator.next())).getColumnWidth().getValue((PercentBaseContext)this.tableLM);
                }
                LayoutContext layoutContext2 = LayoutContext.newInstance();
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutContext2.setRefIPD(n5);
                List<ListElement> list = primaryGridUnit.getCellLM().getNextKnuthElements(layoutContext2, n2);
                ElementListObserver.observe(list, (String)"table-cell", (String)primaryGridUnit.getCell().getId());
                primaryGridUnit.setElements(list);
            }
        }
        this.computeRowHeights();
        object = this.tableStepper.getCombinedKnuthElementsForRowGroup(layoutContext, this.rowGroup, n3);
        linkedList.addAll(object);
    }

    private void computeRowHeights() {
        log.debug((Object)"rowGroup:");
        MinOptMax[] minOptMaxArray = new MinOptMax[this.rowGroup.length];
        for (int i2 = 0; i2 < this.rowGroup.length; ++i2) {
            MinOptMax minOptMax;
            EffRow effRow = this.rowGroup[i2];
            int n2 = this.tableLM.getTable().getColumns().size();
            int[] nArray = RowPainter.computeBaselineAdjustments(n2, effRow);
            TableRow tableRow = this.rowGroup[i2].getTableRow();
            if (tableRow == null) {
                minOptMaxArray[i2] = MAX_STRETCH;
                minOptMax = MAX_STRETCH;
            } else {
                LengthRangeProperty lengthRangeProperty = tableRow.getBlockProgressionDimension();
                minOptMaxArray[i2] = lengthRangeProperty.toMinOptMax((PercentBaseContext)this.tableLM);
                minOptMax = lengthRangeProperty.toMinOptMax((PercentBaseContext)this.tableLM);
            }
            for (Object e2 : effRow.getGridUnits()) {
                GridUnit gridUnit = (GridUnit)e2;
                if (gridUnit.isEmpty() || gridUnit.getColSpanIndex() != 0 || !gridUnit.isLastGridUnitRowSpan()) continue;
                PrimaryGridUnit primaryGridUnit = gridUnit.getPrimary();
                int n3 = 0;
                LengthRangeProperty lengthRangeProperty = primaryGridUnit.getCell().getBlockProgressionDimension();
                if (!lengthRangeProperty.getMinimum((PercentBaseContext)this.tableLM).isAuto()) {
                    n3 = lengthRangeProperty.getMinimum((PercentBaseContext)this.tableLM).getLength().getValue((PercentBaseContext)this.tableLM);
                }
                if (!lengthRangeProperty.getOptimum((PercentBaseContext)this.tableLM).isAuto()) {
                    n3 = lengthRangeProperty.getOptimum((PercentBaseContext)this.tableLM).getLength().getValue((PercentBaseContext)this.tableLM);
                }
                if (gridUnit.getRowSpanIndex() == 0) {
                    n3 = Math.max(n3, minOptMax.getOpt());
                }
                n3 = Math.max(n3, primaryGridUnit.getContentLength());
                int n4 = primaryGridUnit.getBeforeAfterBorderWidth();
                int n5 = 0;
                CommonBorderPaddingBackground commonBorderPaddingBackground = primaryGridUnit.getCell().getCommonBorderPaddingBackground();
                n5 += commonBorderPaddingBackground.getPaddingBefore(false, primaryGridUnit.getCellLM());
                int n6 = n3 + (n5 += commonBorderPaddingBackground.getPaddingAfter(false, primaryGridUnit.getCellLM())) + n4;
                n6 += nArray[primaryGridUnit.getColIndex()];
                List list = primaryGridUnit.getElements();
                int n7 = nArray[primaryGridUnit.getColIndex()];
                if (n7 != 0 && list != null) {
                    list.add(0, new KnuthGlue(n7, 0, 0, new Position(null), true));
                    primaryGridUnit.setElements(list);
                }
                for (int i3 = i2 - 1; i3 >= i2 - gridUnit.getRowSpanIndex(); --i3) {
                    n6 -= minOptMaxArray[i3].getOpt();
                }
                if (n6 <= minOptMaxArray[i2].getMin()) continue;
                minOptMaxArray[i2] = minOptMaxArray[i2].extendMinimum(n6);
            }
            effRow.setHeight(minOptMaxArray[i2]);
            effRow.setExplicitHeight(minOptMax);
        }
    }
}

