/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.expr.RelativeNumericProperty;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class ColumnSetup {
    private static Log log = LogFactory.getLog(ColumnSetup.class);
    private Table table;
    private WritingModeTraitsGetter wmTraits;
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    private List<Length> colWidths = new ArrayList<Length>();
    private int maxColIndexReferenced;

    public ColumnSetup(Table table) {
        assert (table != null);
        this.table = table;
        this.wmTraits = WritingModeTraits.getWritingModeTraitsGetter((FONode)((Object)table));
        this.prepareColumns();
        this.initializeColumnWidths();
    }

    private void prepareColumns() {
        List<FONode> list = this.table.getColumns();
        if (list != null) {
            int n2 = 1;
            for (FONode object : list) {
                TableColumn tableColumn = (TableColumn)((Object)object);
                if (tableColumn == null) continue;
                n2 = tableColumn.getColumnNumber();
                for (int i2 = 0; i2 < tableColumn.getNumberColumnsRepeated(); ++i2) {
                    while (n2 > this.columns.size()) {
                        this.columns.add(null);
                    }
                    this.columns.set(n2 - 1, tableColumn);
                    ++n2;
                }
            }
            int n3 = 1;
            for (TableColumn tableColumn : this.columns) {
                TableColumn tableColumn2 = tableColumn;
                if (tableColumn2 == null) assert (false);
                ++n3;
            }
        }
    }

    public TableColumn getColumn(int n2) {
        int n3 = this.columns.size();
        if (n2 > n3) {
            if (n2 > this.maxColIndexReferenced) {
                this.maxColIndexReferenced = n2;
                TableColumn tableColumn = this.getColumn(1);
                if (n3 != 1 || !tableColumn.isImplicitColumn()) {
                    assert (false);
                    log.warn((Object)FONode.decorateWithContextInfo("There are fewer table-columns than are needed. Column " + n2 + " was accessed, but only " + n3 + " columns have been defined. The last defined column will be reused.", (FONode)((Object)this.table)));
                    if (!this.table.isAutoLayout()) {
                        log.warn((Object)"Please note that according XSL-FO 1.0 (7.26.9) says that the 'column-width' property must be specified for every column, unless the automatic table layout is used.");
                    }
                }
            }
            return this.columns.get(n3 - 1);
        }
        return this.columns.get(n2 - 1);
    }

    public String toString() {
        return this.columns.toString();
    }

    public int getColumnCount() {
        if (this.maxColIndexReferenced > this.columns.size()) {
            return this.maxColIndexReferenced;
        }
        return this.columns.size();
    }

    public Iterator iterator() {
        return this.columns.iterator();
    }

    private void initializeColumnWidths() {
        int n2 = this.columns.size();
        while (--n2 >= 0) {
            if (this.columns.get(n2) == null) continue;
            TableColumn tableColumn = this.columns.get(n2);
            Length length = tableColumn.getColumnWidth();
            this.colWidths.add(0, length);
        }
        this.colWidths.add(0, null);
    }

    protected double computeTableUnit(TableLayoutManager tableLayoutManager, LayoutContext layoutContext) {
        return this.computeTableUnit((PercentBaseContext)tableLayoutManager, tableLayoutManager.getContentAreaIPD(), layoutContext);
    }

    public float computeTableUnit(PercentBaseContext percentBaseContext, int n2, LayoutContext layoutContext) {
        int n3 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (Length length : this.colWidths) {
            Length length2 = length;
            if (length2 == null) continue;
            n3 += length2.getValue(percentBaseContext);
            if (length2 instanceof RelativeNumericProperty) {
                f2 = (float)((double)f2 + ((RelativeNumericProperty)length2).getTableUnits());
                continue;
            }
            if (!(length2 instanceof TableColLength)) continue;
            f2 = (float)((double)f2 + ((TableColLength)length2).getTableUnits());
        }
        if (f2 > 0.0f) {
            if (n3 < n2) {
                f3 = (float)(n2 - n3) / f2;
            } else {
                if (percentBaseContext instanceof TableLayoutManager && layoutContext.isInAutoLayoutDeterminationMode() || n3 == n2) {
                    return f3;
                }
                log.warn((Object)("No space remaining to distribute over columns: " + n3 + " " + f2 + " " + n2));
            }
        }
        return f3;
    }

    public int getXOffset(int n2, int n3, PercentBaseContext percentBaseContext) {
        if (this.wmTraits != null && this.wmTraits.getColumnProgressionDirection() == Direction.RL) {
            return this.getXOffsetRTL(n2, n3, percentBaseContext);
        }
        return this.getXOffsetLTR(n2, percentBaseContext);
    }

    private int getXOffsetRTL(int n2, int n3, PercentBaseContext percentBaseContext) {
        int n4 = 0;
        int n5 = n2 + n3 - 1;
        int n6 = this.colWidths.size();
        while (++n5 < n6) {
            int n7 = n5;
            if (this.colWidths.get(n7) == null) continue;
            n4 += this.colWidths.get(n7).getValue(percentBaseContext);
        }
        return n4;
    }

    private int getXOffsetLTR(int n2, PercentBaseContext percentBaseContext) {
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            int n5 = n4 < this.colWidths.size() ? n4 : this.colWidths.size() - 1;
            if (this.colWidths.get(n5) == null) continue;
            n3 += this.colWidths.get(n5).getValue(percentBaseContext);
        }
        return n3;
    }

    public int getSumOfColumnWidths(PercentBaseContext percentBaseContext) {
        int n2 = 0;
        int n3 = this.getColumnCount();
        for (int i2 = 1; i2 <= n3; ++i2) {
            int n4 = i2;
            if (i2 >= this.colWidths.size()) {
                n4 = this.colWidths.size() - 1;
            }
            if (this.colWidths.get(n4) == null) continue;
            n2 += this.colWidths.get(n4).getValue(percentBaseContext);
        }
        return n2;
    }

    public int computeOptimalColumnWidthsForAutoLayout(TableLayoutManager tableLayoutManager, LayoutContext layoutContext) {
        int n2;
        if (log.isDebugEnabled()) {
            log.debug((Object)">>>>>> START Compute Optimal Column Widths ");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = tableLayoutManager.getContentAreaIPD();
        for (Object object : this.columns) {
            if (object == null) continue;
            if (object.isAutoLayout()) {
                MinOptMax minOptMax = tableLayoutManager.getPossibleWidths((TableColumn)((Object)object), layoutContext);
                if (minOptMax == null) continue;
                n3 += minOptMax.getOpt();
                n4 += minOptMax.getMin();
                continue;
            }
            int n6 = object.getColumnWidth().getValue((PercentBaseContext)tableLayoutManager);
            n3 += n6;
            n4 += n6;
        }
        log.debug((Object)"       =============================");
        log.debug((Object)("       minSumCols= " + n4));
        log.debug((Object)("       maxSumCols= " + n3));
        log.debug((Object)("       contentAreaIPD= " + n5));
        if (layoutContext.isChildOfAutoLayoutElement() && layoutContext.isInAutoLayoutDeterminationMode()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"       Table in another auto table.");
            }
            n2 = n3;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("       Spec Width: " + ((Table)tableLayoutManager.getFObj()).isSpecifiedWidth()));
            }
            if (n3 > n5 || ((Table)tableLayoutManager.getFObj()).isSpecifiedWidth()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"       The maxSumCols greater than the contentAreaIPD. ");
                }
                if (n4 < n5) {
                    Object object;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"       It is possible to redistribute. ");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("       Sum (" + n3 + ") > Available Area (" + n5 + "): Redistributing"));
                    }
                    object = new ArrayList();
                    object.addAll(this.columns);
                    this.redistribute(tableLayoutManager, n5, n3, (List<TableColumn>)object, layoutContext);
                    n2 = -1;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"       It is not possible to redistribute. ");
                    }
                    if (n4 != n5) {
                        log.warn((Object)("Column(s) too wide in the auto table. Increasing table content area for " + tableLayoutManager.getFObj().getContextInfo()));
                    }
                    int n7 = 0;
                    for (TableColumn tableColumn : this.columns) {
                        MinOptMax minOptMax = tableLayoutManager.getPossibleWidths(tableColumn, layoutContext);
                        if (tableColumn.isAutoLayout()) {
                            if (minOptMax == null) continue;
                            int n8 = minOptMax.getMin();
                            int n9 = minOptMax.getMax();
                            MinOptMax minOptMax2 = MinOptMax.getInstance((int)n8, (int)n8, (int)n9);
                            tableLayoutManager.setPossibleWidths(tableColumn, minOptMax2);
                            n7 += n8;
                            continue;
                        }
                        if (minOptMax == null) continue;
                        n7 += minOptMax.getMin();
                    }
                    if (n7 > n5) {
                        log.debug((Object)"       Increased the table content area, but is possible to bleed out.");
                        n2 = n7;
                    } else {
                        n2 = n5;
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"       Can increase the content area to accomodate the maximum size of the columns. ");
                }
                n2 = n3;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("       Resulted new content area IPD: " + n2 + ", initial was: " + n5));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)">>>>>> END Compute Optimal Column Widths ");
        }
        return n2;
    }

    private boolean redistribute(TableLayoutManager tableLayoutManager, int n2, int n3, List<TableColumn> list, LayoutContext layoutContext) {
        boolean bl = false;
        int n4 = 0;
        for (TableColumn tableColumn : list) {
            if (!tableColumn.isFill()) continue;
            ++n4;
        }
        bl = n4 > 0 ? this.redistributeToFillable(n4, tableLayoutManager, n2, n3, list, layoutContext) : this.redistributeProportionally(tableLayoutManager, n2, n3, list, layoutContext);
        return bl;
    }

    private boolean redistributeProportionally(TableLayoutManager tableLayoutManager, int n2, int n3, List<TableColumn> list, LayoutContext layoutContext) {
        int n4;
        int n5;
        MinOptMax minOptMax;
        double d2 = (double)n2 / (double)n3;
        for (TableColumn tableColumn : list) {
            if (!tableColumn.isAutoLayout()) {
                int n6 = tableColumn.getColumnWidth().getValue((PercentBaseContext)tableLayoutManager);
                n2 -= n6;
                n3 -= n6;
                list.remove((Object)tableColumn);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("| Col " + tableColumn.getColumnNumber() + " -> STATIC(" + n6 + ") |"));
                }
                return this.redistributeProportionally(tableLayoutManager, n2, n3, list, layoutContext);
            }
            minOptMax = tableLayoutManager.getPossibleWidths(tableColumn, layoutContext);
            if (minOptMax == null) {
                list.remove((Object)tableColumn);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("| Col " + tableColumn.getColumnNumber() + " -> EMPTY (0) |"));
                }
                return this.redistributeProportionally(tableLayoutManager, n2, n3, list, layoutContext);
            }
            n5 = minOptMax.getMax();
            if (!((double)n5 * d2 < (double)(n4 = minOptMax.getMin()))) continue;
            MinOptMax minOptMax2 = MinOptMax.getInstance((int)n4, (int)n4, (int)n5);
            tableLayoutManager.setPossibleWidths(tableColumn, minOptMax2);
            n2 -= n4;
            n3 -= n5;
            list.remove((Object)tableColumn);
            if (log.isDebugEnabled()) {
                log.debug((Object)("| Col " + tableColumn.getColumnNumber() + " -> MIN(" + n4 + ") |"));
            }
            return this.redistributeProportionally(tableLayoutManager, n2, n3, list, layoutContext);
        }
        for (TableColumn tableColumn : list) {
            minOptMax = tableLayoutManager.getPossibleWidths(tableColumn, layoutContext);
            n5 = minOptMax.getMax();
            n4 = minOptMax.getMin();
            int n7 = (int)((double)n5 * d2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("| Col " + tableColumn.getColumnNumber() + " -> OPT(" + n7 + ") |"));
            }
            MinOptMax minOptMax3 = MinOptMax.getInstance((int)n4, (int)n7, (int)n7);
            tableLayoutManager.setPossibleWidths(tableColumn, minOptMax3);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Redistribution finished");
        }
        return true;
    }

    private boolean redistributeToFillable(int n2, TableLayoutManager tableLayoutManager, int n3, int n4, List<TableColumn> list, LayoutContext layoutContext) {
        int n5 = (n3 - n4) / n2;
        for (TableColumn tableColumn : list) {
            if (!tableColumn.isFill()) continue;
            MinOptMax minOptMax = tableLayoutManager.getPossibleWidths(tableColumn, layoutContext);
            int n6 = minOptMax.getMax();
            int n7 = minOptMax.getMin();
            int n8 = n6 + n5;
            MinOptMax minOptMax2 = MinOptMax.getInstance((int)n7, (int)n8, (int)n8);
            tableLayoutManager.setPossibleWidths(tableColumn, minOptMax2);
        }
        return true;
    }
}

