/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.ChangeBar;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontFeatureSettings;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.GlyphMapping;
import org.apache.fop.fonts.TextFragment;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ListUtil;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private static final int SOFT_HYPHEN_PENALTY = 1;
    private static final Log LOG = LogFactory.getLog(TextLayoutManager.class);
    private final List<GlyphMapping> mappings;
    private static final String BREAK_CHARS = "-/";
    private final FOText foText;
    private final MinOptMax[] letterSpaceAdjustArray;
    private Font spaceFont;
    private int nextStart;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private boolean hasChanged;
    private int[] returnedIndices = new int[]{0, 0};
    private int changeOffset;
    private int thisStart;
    private int tempStart;
    private List<PendingChange> changeList = new LinkedList<PendingChange>();
    private AlignmentContext alignmentContext;
    private int lineStartBAP;
    private int lineEndBAP;
    private boolean keepTogether;
    private final Position auxiliaryPosition = new LeafPosition((LayoutManager)((Object)this), -1);
    private int minimumIPD = -1;
    private int maximumIPD = -1;
    private boolean overflowWrap;
    private Font originalFont;
    private FOUserAgent userAgent;

    public TextLayoutManager(FOText fOText, FOUserAgent fOUserAgent) {
        this.foText = fOText;
        this.letterSpaceAdjustArray = new MinOptMax[fOText.length() + 1];
        this.mappings = new ArrayList<GlyphMapping>();
        this.userAgent = fOUserAgent;
    }

    private KnuthPenalty makeZeroWidthPenalty(int n2) {
        return new KnuthPenalty(0, n2, false, this.auxiliaryPosition, true);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthInlineBox(0, null, this.notifyPos((Position)new LeafPosition((LayoutManager)((Object)this), -1)), true);
    }

    public void initialize() {
        this.foText.resetBuffer();
        this.spaceFont = FontSelector.selectFontForCharacterInText((char)' ', (FOText)this.foText, (PercentBaseContext)this);
        this.spaceCharIPD = this.spaceFont.getCharWidth(' ');
        this.hyphIPD = this.foText.getCommonHyphenation().getHyphIPD(this.spaceFont);
        SpaceVal spaceVal = SpaceVal.makeLetterSpacing((Property)this.foText.getLetterSpacing());
        SpaceVal spaceVal2 = SpaceVal.makeWordSpacing((Property)this.foText.getWordSpacing(), (SpaceVal)spaceVal, (Font)this.spaceFont);
        this.letterSpaceIPD = spaceVal.getSpace();
        this.wordSpaceIPD = MinOptMax.getInstance((int)this.spaceCharIPD).plus(spaceVal2.getSpace());
        this.keepTogether = this.foText.getKeepTogether().getWithinLine().getEnum() == 7;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        MinOptMax minOptMax = MinOptMax.ZERO;
        GlyphMapping glyphMapping = null;
        while (positionIterator.hasNext()) {
            Position position = positionIterator.next();
            assert (position instanceof LeafPosition);
            LeafPosition leafPosition = (LeafPosition)position;
            if (leafPosition == null || leafPosition.getLeafPos() == -1) continue;
            GlyphMapping glyphMapping2 = this.mappings.get(leafPosition.getLeafPos());
            if (glyphMapping == null || glyphMapping2.font != glyphMapping.font || glyphMapping2.level != glyphMapping.level) {
                if (glyphMapping != null) {
                    this.addMappingAreas(glyphMapping, n2, n3, n4, n5, minOptMax, layoutContext);
                }
                n4 = leafPosition.getLeafPos();
                n2 = 0;
                n3 = 0;
                minOptMax = MinOptMax.ZERO;
            }
            n2 += glyphMapping2.wordSpaceCount;
            n3 += glyphMapping2.letterSpaceCount;
            minOptMax = minOptMax.plus(glyphMapping2.areaIPD);
            n5 = leafPosition.getLeafPos();
            glyphMapping = glyphMapping2;
        }
        if (glyphMapping != null) {
            this.addMappingAreas(glyphMapping, n2, n3, n4, n5, minOptMax, layoutContext);
        }
    }

    private void addMappingAreas(GlyphMapping glyphMapping, int n2, int n3, int n4, int n5, MinOptMax minOptMax, LayoutContext layoutContext) {
        double d2;
        int n6 = glyphMapping.getWordLength();
        if (glyphMapping.letterSpaceCount == n6 && !glyphMapping.isHyphenated && layoutContext.isLastArea()) {
            minOptMax = minOptMax.minus(this.letterSpaceIPD);
            --n3;
        }
        for (int i2 = glyphMapping.startIndex; i2 < glyphMapping.endIndex; ++i2) {
            MinOptMax minOptMax2 = this.letterSpaceAdjustArray[i2 + 1];
            if (minOptMax2 == null || !minOptMax2.isElastic()) continue;
            ++n3;
        }
        if (layoutContext.isLastArea() && glyphMapping.isHyphenated) {
            minOptMax = minOptMax.plus(this.hyphIPD);
        }
        int n7 = (d2 = layoutContext.getIPDAdjust()) > 0.0 ? (int)((double)minOptMax.getStretch() * d2) : (int)((double)minOptMax.getShrink() * d2);
        int n8 = this.letterSpaceIPD.getOpt();
        n8 = d2 > 0.0 ? (n8 += (int)((double)this.letterSpaceIPD.getStretch() * d2)) : (n8 += (int)((double)this.letterSpaceIPD.getShrink() * d2));
        int n9 = (n8 - this.letterSpaceIPD.getOpt()) * n3;
        int n10 = this.wordSpaceIPD.getOpt();
        if (n2 > 0) {
            n10 += (n7 - n9) / n2;
        }
        if ((n9 += (n10 - this.wordSpaceIPD.getOpt()) * n2) != n7) {
            LOG.trace((Object)("TextLM.addAreas: error in word / letter space adjustment = " + (n9 - n7)));
            n9 = n7;
        }
        TextArea textArea = new TextAreaBuilder(minOptMax, n9, layoutContext, n4, n5, layoutContext.isLastArea(), glyphMapping.font).build();
        textArea.setChangeBarList(this.getChangeBarList());
        textArea.setTextLetterSpaceAdjust(n8);
        textArea.setTextWordSpaceAdjust(n10 - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        textArea.setFromFootnote(this.isFromFootnote());
        if (layoutContext.getIPDAdjust() != 0.0) {
            textArea.setSpaceDifference(this.wordSpaceIPD.getOpt() - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        }
        this.parentLayoutManager.addChildArea((Area)textArea);
    }

    private void addGlyphMapping(GlyphMapping glyphMapping) {
        this.addGlyphMapping(this.mappings.size(), glyphMapping);
    }

    private void addGlyphMapping(int n2, GlyphMapping glyphMapping) {
        this.mappings.add(n2, glyphMapping);
    }

    private void removeGlyphMapping(int n2) {
        this.mappings.remove(n2);
    }

    private GlyphMapping getGlyphMapping(int n2) {
        return this.mappings.get(n2);
    }

    public List<KnuthSequence> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        boolean bl;
        boolean bl2;
        LineBreakStatus lineBreakStatus;
        this.lineStartBAP = layoutContext.getLineStartBorderAndPaddingWidth();
        this.lineEndBAP = layoutContext.getLineEndBorderAndPaddingWidth();
        this.alignmentContext = layoutContext.getAlignmentContext();
        LinkedList<KnuthSequence> linkedList = new LinkedList<KnuthSequence>();
        InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
        GlyphMapping glyphMapping = null;
        GlyphMapping glyphMapping2 = null;
        linkedList.add((KnuthSequence)inlineKnuthSequence);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GK: [" + this.nextStart + "," + this.foText.length() + "]"));
        }
        if ((lineBreakStatus = layoutContext.getLineBreakStatus()) == null) {
            bl2 = this.foText.getCommonHyphenation().breakLineAtHyphens.getEnum() == 176 || this.foText.getCommonHyphenation().avoidBreakingLineAtHyphens.getEnum() == 149;
            bl = this.foText.getCommonHyphenation().breakLineAtHyphens.getEnum() == 7;
            lineBreakStatus = new LineBreakStatus(bl2, bl);
        }
        this.thisStart = this.nextStart;
        bl2 = false;
        bl = false;
        char c2 = '\u0000';
        int n3 = -1;
        int n4 = -1;
        boolean bl3 = false;
        Font font = null;
        int n5 = -1;
        int n6 = -1;
        while (this.nextStart < this.foText.length()) {
            Object object;
            c2 = this.foText.charAt(this.nextStart);
            n3 = this.foText.bidiLevelAt(this.nextStart);
            boolean bl4 = false;
            byte by = this.keepTogether ? (byte)4 : (byte)lineBreakStatus.nextChar(c2, this.nextStart - n6);
            switch (by) {
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    bl4 = true;
                    break;
                }
                default: {
                    LOG.error((Object)("Unexpected breakAction: " + by));
                }
            }
            if (bl4) {
                n6 = this.nextStart;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GK: { index = " + this.nextStart + ", char = " + CharUtilities.charToNCRef((int)c2) + ", level = " + n3 + ", levelPrev = " + n4 + ", inWord = " + bl2 + ", inSpace = " + bl + "}"));
            }
            if (bl2) {
                boolean bl5;
                boolean bl6 = bl5 = bl4 || GlyphMapping.isSpace(c2) || CharUtilities.isExplicitBreak((int)c2) || n4 != -1 && n3 != n4;
                if (!bl5 && this.foText.getCommonFont().getFontSelectionStrategy() == 25) {
                    if (font == null || n5 != this.nextStart - 1) {
                        font = FontSelector.selectFontForCharactersInText((CharSequence)this.foText, (int)(this.nextStart - 1), (int)this.nextStart, (FOText)this.foText, (PercentBaseContext)this);
                    }
                    bl5 = (object = FontSelector.selectFontForCharactersInText((CharSequence)this.foText, (int)this.nextStart, (int)(this.nextStart + 1), (FOText)this.foText, (PercentBaseContext)this)) != font;
                    font = object;
                    n5 = this.nextStart;
                }
                if (bl5) {
                    glyphMapping2 = this.processWord(n2, (KnuthSequence)inlineKnuthSequence, glyphMapping2, c2, bl4, true, n4, bl3);
                }
            } else if (bl) {
                if (c2 != ' ' || bl4) {
                    glyphMapping2 = this.processWhitespace(n2, (KnuthSequence)inlineKnuthSequence, bl4, n4);
                }
            } else {
                if (glyphMapping != null) {
                    glyphMapping2 = glyphMapping;
                    this.processLeftoverGlyphMapping(n2, (KnuthSequence)inlineKnuthSequence, glyphMapping, c2 == ' ' || bl4);
                    glyphMapping = null;
                }
                if (by == 5) {
                    inlineKnuthSequence = this.processLinebreak(linkedList, (KnuthSequence)inlineKnuthSequence);
                }
            }
            if (c2 == ' ' && this.foText.getWhitespaceTreatment() == 108 || c2 == '\u00a0') {
                Font font2 = FontSelector.selectFontForCharacterInText((char)c2, (FOText)this.foText, (PercentBaseContext)this);
                font2.mapChar(c2);
                object = glyphMapping2 != null && glyphMapping2.isSpace ? this.wordSpaceIPD.minus(this.letterSpaceIPD) : this.wordSpaceIPD;
                Font font3 = this.spaceFont;
                if (c2 == '\u00a0') {
                    font3 = font2;
                }
                glyphMapping = new GlyphMapping(this.nextStart, this.nextStart + 1, 1, 0, (MinOptMax)object, false, true, bl4, font3, n3, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isFixedWidthSpace((int)c2) || CharUtilities.isZeroWidthSpace((int)c2)) {
                Font font4 = FontSelector.selectFontForCharacterInText((char)c2, (FOText)this.foText, (PercentBaseContext)this);
                object = MinOptMax.getInstance((int)font4.getCharWidth(c2));
                glyphMapping = new GlyphMapping(this.nextStart, this.nextStart + 1, 0, 0, (MinOptMax)object, false, true, bl4, font4, n3, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isExplicitBreak((int)c2)) {
                this.thisStart = this.nextStart + 1;
            }
            bl2 = !GlyphMapping.isSpace(c2) && !CharUtilities.isExplicitBreak((int)c2);
            bl = c2 == ' ' && this.foText.getWhitespaceTreatment() != 108;
            n4 = n3;
            ++this.nextStart;
        }
        if (bl2) {
            this.processWord(n2, (KnuthSequence)inlineKnuthSequence, glyphMapping2, c2, false, false, n4, bl3);
        } else if (bl) {
            this.processWhitespace(n2, (KnuthSequence)inlineKnuthSequence, !this.keepTogether, n4);
        } else if (glyphMapping != null) {
            this.processLeftoverGlyphMapping(n2, (KnuthSequence)inlineKnuthSequence, glyphMapping, c2 == '\u200b');
        } else if (CharUtilities.isExplicitBreak((int)c2)) {
            this.processLinebreak(linkedList, (KnuthSequence)inlineKnuthSequence);
            lineBreakStatus.reset();
        }
        if (((List)ListUtil.getLast(linkedList)).isEmpty()) {
            ListUtil.removeLast(linkedList);
        }
        this.setFinished(true);
        if (linkedList.isEmpty()) {
            return null;
        }
        this.determineMinMaxIPD(linkedList, layoutContext);
        return linkedList;
    }

    private void determineMinMaxIPD(List list, LayoutContext layoutContext) {
        this.minimumIPD = 0;
        this.maximumIPD = 0;
        ListIterator listIterator = list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            KnuthSequence knuthSequence = (KnuthSequence)listIterator.next();
            ListIterator listIterator2 = knuthSequence.listIterator();
            int n3 = 0;
            while (listIterator2.hasNext()) {
                KnuthElement knuthElement = (KnuthElement)((Object)listIterator2.next());
                if (knuthElement instanceof KnuthBox) {
                    this.minimumIPD = Math.max(this.minimumIPD, knuthElement.getWidth());
                    n3 += knuthElement.getWidth();
                    continue;
                }
                if (!(knuthElement instanceof KnuthGlue)) continue;
                n3 += knuthElement.getWidth();
            }
            n2 = Math.max(n2, n3);
        }
        this.maximumIPD = n2;
    }

    private KnuthSequence processLinebreak(List list, KnuthSequence knuthSequence) {
        if (this.lineEndBAP != 0) {
            knuthSequence.add((Object)new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, true));
        }
        knuthSequence.endSequence();
        knuthSequence = new InlineKnuthSequence();
        list.add(knuthSequence);
        return knuthSequence;
    }

    private void processLeftoverGlyphMapping(int n2, KnuthSequence knuthSequence, GlyphMapping glyphMapping, boolean bl) {
        this.addGlyphMapping(glyphMapping);
        glyphMapping.breakOppAfter = bl;
        this.addElementsForASpace((List)knuthSequence, n2, glyphMapping, this.mappings.size() - 1);
    }

    private GlyphMapping processWhitespace(int n2, KnuthSequence knuthSequence, boolean bl, int n3) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PS: [" + this.thisStart + "," + this.nextStart + "]"));
        }
        assert (this.nextStart >= this.thisStart);
        GlyphMapping glyphMapping = new GlyphMapping(this.thisStart, this.nextStart, this.nextStart - this.thisStart, 0, this.wordSpaceIPD.mult(this.nextStart - this.thisStart), false, true, bl, this.spaceFont, n3, null);
        this.addGlyphMapping(glyphMapping);
        this.addElementsForASpace((List)knuthSequence, n2, glyphMapping, this.mappings.size() - 1);
        this.thisStart = this.nextStart;
        return glyphMapping;
    }

    private GlyphMapping processWord(int n2, KnuthSequence knuthSequence, GlyphMapping glyphMapping, char c2, boolean bl, boolean bl2, int n3, boolean bl3) {
        int n4;
        for (n4 = this.nextStart; n4 > 0 && this.foText.charAt(n4 - 1) == '\u00ad'; --n4) {
        }
        boolean bl4 = bl2 && this.foText.charAt(n4) == '\u00ad';
        this.saveOriginalFont();
        Font font = FontSelector.selectFontForCharactersInText((CharSequence)this.foText, (int)this.thisStart, (int)n4, (FOText)this.foText, (PercentBaseContext)this);
        FontFeatureSettings fontFeatureSettings = this.foText.getCommonFont().getFontFeatureSettings();
        char c3 = bl ? c2 : (char)'\u0000';
        char c4 = glyphMapping != null && !glyphMapping.isSpace && glyphMapping.endIndex > 0 ? this.foText.charAt(glyphMapping.endIndex - 1) : (char)'\u0000';
        GlyphMapping glyphMapping2 = GlyphMapping.doGlyphMapping((TextFragment)this.foText, this.thisStart, n4, font, this.letterSpaceIPD, this.letterSpaceAdjustArray, c4, c3, bl4, n3, false, false, bl3, fontFeatureSettings);
        this.setSpaceThatFollowsWordIntoMapping(n4, glyphMapping2);
        glyphMapping = glyphMapping2;
        this.addGlyphMapping(glyphMapping2);
        this.tempStart = this.nextStart;
        this.addElementsForAWordFragment((List)knuthSequence, n2, glyphMapping2, this.mappings.size() - 1);
        this.thisStart = this.nextStart;
        return glyphMapping;
    }

    private void saveOriginalFont() {
        FontInfo fontInfo = this.foText.getFOEventHandler().getFontInfo();
        CommonFont commonFont = this.foText.getCommonFont();
        FontTriplet[] fontTripletArray = commonFont.getFontState(fontInfo);
        this.originalFont = fontInfo.getFontInstance(fontTripletArray[0], commonFont.fontSize.getValue((PercentBaseContext)this));
    }

    private void setSpaceThatFollowsWordIntoMapping(int n2, GlyphMapping glyphMapping) {
        Character c2 = null;
        if (n2 < this.foText.length()) {
            char c3 = this.foText.charAt(n2);
            if (c3 == '\n') {
                c3 = ' ';
            }
            if (c3 == ' ' || CharUtilities.isFixedWidthSpace((int)c3) && !CharUtilities.isNonBreakableSpace((int)c3)) {
                c2 = Character.valueOf(c3);
            }
        }
        glyphMapping.spaceThatFollows = c2;
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list) {
        return this.addALetterSpaceTo(list, 0);
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list, int n2) {
        ListIterator<ListElement> listIterator = list.listIterator();
        KnuthElement knuthElement = (KnuthElement)listIterator.next();
        Position position = knuthElement.getPosition();
        Position position2 = position.getPosition(n2);
        assert (position2 instanceof LeafPosition);
        LeafPosition leafPosition = (LeafPosition)position2;
        int n3 = leafPosition.getLeafPos();
        if (n3 > -1) {
            GlyphMapping glyphMapping = this.getGlyphMapping(n3);
            ++glyphMapping.letterSpaceCount;
            glyphMapping.addToAreaIPD(this.letterSpaceIPD);
            if (BREAK_CHARS.indexOf(this.foText.charAt(this.tempStart - 1)) >= 0) {
                listIterator = list.listIterator(list.size());
                listIterator.add((ListElement)new KnuthPenalty(0, 50, true, this.auxiliaryPosition, false));
                listIterator.add((ListElement)new KnuthGlue(this.letterSpaceIPD, this.auxiliaryPosition, false));
            } else if (this.letterSpaceIPD.isStiff()) {
                listIterator.set((ListElement)new KnuthInlineBox(glyphMapping.areaIPD.getOpt(), this.alignmentContext, position, false));
            } else {
                listIterator.next();
                listIterator.next();
                listIterator.set((ListElement)new KnuthGlue(this.letterSpaceIPD.mult(glyphMapping.letterSpaceCount), this.auxiliaryPosition, true));
            }
        }
        return list;
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        int n2 = ((LeafPosition)position).getLeafPos() + this.changeOffset;
        GlyphMapping glyphMapping = this.getGlyphMapping(n2);
        int n3 = glyphMapping.startIndex;
        boolean bl = true;
        Font font = glyphMapping.font;
        this.overflowWrap = hyphContext.isOverflowWrapBreakWord();
        if (this.foText.getCommonHyphenation().hyphenate.getEnum() == 149 || this.overflowWrap) {
            int n4 = -1;
            while (n3 < glyphMapping.endIndex) {
                int n5;
                int n6;
                boolean bl2;
                MinOptMax minOptMax = MinOptMax.ZERO;
                int n7 = n3 + hyphContext.getNextHyphPoint();
                if (hyphContext.hasMoreHyphPoints() && n7 <= glyphMapping.endIndex) {
                    bl2 = true;
                } else {
                    bl2 = false;
                    n7 = glyphMapping.endIndex;
                }
                hyphContext.updateOffset(n7 - n3);
                for (n6 = n3; n6 < n7; ++n6) {
                    n5 = Character.codePointAt((CharSequence)this.foText, n6);
                    minOptMax = minOptMax.plus(font.getCharWidth(n5));
                    if ((n6 += Character.charCount(n5) - 1) >= n7) continue;
                    MinOptMax minOptMax2 = this.letterSpaceAdjustArray[n6 + 1];
                    if (n6 == n7 - 1 && bl2) {
                        minOptMax2 = null;
                    }
                    if (minOptMax2 == null) continue;
                    minOptMax = minOptMax.plus(minOptMax2);
                }
                n6 = n7 == glyphMapping.endIndex && glyphMapping.letterSpaceCount < glyphMapping.getWordLength() ? 1 : 0;
                int n8 = n5 = n6 != 0 ? n7 - n3 - 1 : n7 - n3;
                assert (n5 >= 0);
                minOptMax = minOptMax.plus(this.letterSpaceIPD.mult(n5));
                n4 = Math.max(minOptMax.getMin(), n4);
                if (!bl || n7 != glyphMapping.endIndex || bl2) {
                    this.changeList.add(new PendingChange(new GlyphMapping(n3, n7, 0, n5, minOptMax, bl2, false, false, font, -1, null), n2));
                    bl = false;
                }
                n3 = n7;
            }
            if (this.minimumIPD > n4) {
                this.minimumIPD = n4;
            }
            this.hasChanged |= !bl;
        } else {
            int n9 = glyphMapping.endIndex;
            hyphContext.updateOffset(n9 - n3);
        }
        if (glyphMapping.spaceThatFollows != null && !this.changeList.isEmpty()) {
            PendingChange pendingChange = this.changeList.get(this.changeList.size() - 1);
            pendingChange.mapping.spaceThatFollows = glyphMapping.spaceThatFollows;
        }
    }

    public boolean applyChanges(List<ListElement> list) {
        return this.applyChanges(list, 0);
    }

    public boolean applyChanges(List<ListElement> list, int n2) {
        Position position;
        Position position2;
        this.setFinished(false);
        if (list.isEmpty()) {
            return false;
        }
        LeafPosition leafPosition = null;
        LeafPosition leafPosition2 = null;
        ListIterator<ListElement> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            position2 = ((KnuthElement)listIterator.next()).getPosition();
            position = position2.getPosition(n2);
            assert (position == null || position instanceof LeafPosition);
            leafPosition = (LeafPosition)position;
            if (leafPosition == null || leafPosition.getLeafPos() == -1) continue;
            break;
        }
        listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            position2 = ((KnuthElement)listIterator.previous()).getPosition();
            position = position2.getPosition(n2);
            assert (position instanceof LeafPosition);
            leafPosition2 = (LeafPosition)position;
            if (leafPosition2 == null || leafPosition2.getLeafPos() == -1) continue;
            break;
        }
        this.returnedIndices[0] = (leafPosition != null ? leafPosition.getLeafPos() : -1) + this.changeOffset;
        this.returnedIndices[1] = (leafPosition2 != null ? leafPosition2.getLeafPos() : -1) + this.changeOffset;
        int n3 = 0;
        int n4 = 0;
        if (!this.changeList.isEmpty()) {
            int n5 = -1;
            Iterator<PendingChange> iterator = this.changeList.iterator();
            while (iterator.hasNext()) {
                int n6;
                PendingChange pendingChange;
                PendingChange pendingChange2 = pendingChange = iterator.next();
                if (pendingChange2.index == n5) {
                    n6 = pendingChange2.index + ++n3 - n4;
                } else {
                    n5 = pendingChange2.index;
                    n6 = pendingChange2.index + ++n3 - ++n4;
                    this.removeGlyphMapping(n6);
                }
                this.addGlyphMapping(n6, pendingChange2.mapping);
            }
            this.changeList.clear();
        }
        this.returnedIndices[1] = this.returnedIndices[1] + (n3 - n4);
        this.changeOffset += n3 - n4;
        return this.hasChanged;
    }

    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        while (this.returnedIndices[0] <= this.returnedIndices[1]) {
            GlyphMapping glyphMapping = this.getGlyphMapping(this.returnedIndices[0]);
            if (glyphMapping.wordSpaceCount == 0) {
                this.addElementsForAWordFragment(linkedList, n2, glyphMapping, this.returnedIndices[0]);
            } else {
                this.addElementsForASpace(linkedList, n2, glyphMapping, this.returnedIndices[0]);
            }
            this.returnedIndices[0] = this.returnedIndices[0] + 1;
        }
        this.setFinished(this.returnedIndices[0] == this.mappings.size() - 1);
        return linkedList;
    }

    public String getWordChars(Position position) {
        int n2 = ((LeafPosition)position).getLeafPos() + this.changeOffset;
        if (n2 != -1) {
            GlyphMapping glyphMapping = this.getGlyphMapping(n2);
            StringBuffer stringBuffer = new StringBuffer(glyphMapping.getWordLength());
            for (int i2 = glyphMapping.startIndex; i2 < glyphMapping.endIndex; ++i2) {
                stringBuffer.append(this.foText.charAt(i2));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private void addElementsForASpace(List list, int n2, GlyphMapping glyphMapping, int n3) {
        LeafPosition leafPosition = new LeafPosition((LayoutManager)((Object)this), n3);
        if (!glyphMapping.breakOppAfter) {
            if (n2 == 70) {
                list.add(this.makeAuxiliaryZeroWidthBox());
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(glyphMapping.areaIPD, (Position)leafPosition, false));
            } else {
                list.add(new KnuthInlineBox(glyphMapping.areaIPD.getOpt(), null, (Position)leafPosition, true));
            }
        } else if (this.foText.charAt(glyphMapping.startIndex) != ' ' || this.foText.getWhitespaceTreatment() == 108) {
            list.addAll(this.getElementsForBreakingSpace(n2, glyphMapping, this.auxiliaryPosition, 0, (Position)leafPosition, glyphMapping.areaIPD.getOpt(), true));
        } else {
            list.addAll(this.getElementsForBreakingSpace(n2, glyphMapping, (Position)leafPosition, glyphMapping.areaIPD.getOpt(), this.auxiliaryPosition, 0, false));
        }
    }

    private List getElementsForBreakingSpace(int n2, GlyphMapping glyphMapping, Position position, int n3, Position position2, int n4, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        switch (n2) {
            case 23: {
                arrayList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                arrayList.add(this.makeZeroWidthPenalty(0));
                arrayList.add(new KnuthGlue(n3 - (this.lineStartBAP + this.lineEndBAP), -20016, 0, position, false));
                arrayList.add(this.makeAuxiliaryZeroWidthBox());
                arrayList.add(this.makeZeroWidthPenalty(1000));
                arrayList.add(new KnuthGlue(this.lineStartBAP + n4, 10008, 0, position2, false));
                break;
            }
            case 39: 
            case 135: {
                if (bl || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    KnuthGlue knuthGlue = new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false);
                    arrayList.add(knuthGlue);
                    arrayList.add(this.makeZeroWidthPenalty(0));
                    knuthGlue = new KnuthGlue(n3 - (this.lineStartBAP + this.lineEndBAP), -10008, 0, position, false);
                    arrayList.add(knuthGlue);
                    arrayList.add(this.makeAuxiliaryZeroWidthBox());
                    arrayList.add(this.makeZeroWidthPenalty(1000));
                    knuthGlue = new KnuthGlue(this.lineStartBAP + n4, 0, 0, position2, false);
                    arrayList.add(knuthGlue);
                    break;
                }
                KnuthGlue knuthGlue = new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false);
                arrayList.add(knuthGlue);
                arrayList.add(this.makeZeroWidthPenalty(0));
                knuthGlue = new KnuthGlue(glyphMapping.areaIPD.getOpt(), -10008, 0, position, false);
                arrayList.add(knuthGlue);
                break;
            }
            case 70: {
                arrayList.addAll(this.getElementsForJustifiedText(glyphMapping, position, n3, position2, n4, bl, glyphMapping.areaIPD.getShrink()));
                break;
            }
            default: {
                arrayList.addAll(this.getElementsForJustifiedText(glyphMapping, position, n3, position2, n4, bl, 0));
            }
        }
        return arrayList;
    }

    private List getElementsForJustifiedText(GlyphMapping glyphMapping, Position position, int n2, Position position2, int n3, boolean bl, int n4) {
        int n5 = glyphMapping.areaIPD.getStretch();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
            arrayList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
            arrayList.add(this.makeZeroWidthPenalty(0));
            arrayList.add(new KnuthGlue(n2 - (this.lineStartBAP + this.lineEndBAP), n5, n4, position, false));
            arrayList.add(this.makeAuxiliaryZeroWidthBox());
            arrayList.add(this.makeZeroWidthPenalty(1000));
            arrayList.add(new KnuthGlue(this.lineStartBAP + n3, 0, 0, position2, false));
        } else {
            arrayList.add(new KnuthGlue(glyphMapping.areaIPD.getOpt(), n5, n4, position, false));
        }
        return arrayList;
    }

    private void addElementsForAWordFragment(List list, int n2, GlyphMapping glyphMapping, int n3) {
        boolean bl;
        LeafPosition leafPosition = new LeafPosition((LayoutManager)((Object)this), n3);
        boolean bl2 = bl = glyphMapping.breakOppAfter && !glyphMapping.isHyphenated;
        if (this.letterSpaceIPD.isStiff()) {
            list.add(new KnuthInlineBox(bl ? glyphMapping.areaIPD.getOpt() - this.letterSpaceIPD.getOpt() : glyphMapping.areaIPD.getOpt(), this.alignmentContext, this.notifyPos((Position)leafPosition), false));
        } else {
            int n4 = bl ? glyphMapping.letterSpaceCount - 1 : glyphMapping.letterSpaceCount;
            list.add(new KnuthInlineBox(glyphMapping.areaIPD.getOpt() - glyphMapping.letterSpaceCount * this.letterSpaceIPD.getOpt(), this.alignmentContext, this.notifyPos((Position)leafPosition), false));
            list.add(this.makeZeroWidthPenalty(1000));
            list.add(new KnuthGlue(this.letterSpaceIPD.mult(n4), this.auxiliaryPosition, true));
            list.add(this.makeAuxiliaryZeroWidthBox());
        }
        if (glyphMapping.isHyphenated) {
            MinOptMax minOptMax = null;
            if (glyphMapping.endIndex < this.foText.length()) {
                minOptMax = this.letterSpaceAdjustArray[glyphMapping.endIndex];
            }
            this.addElementsForAHyphen(list, n2, this.hyphIPD, minOptMax, glyphMapping.breakOppAfter);
        } else if (bl) {
            this.addElementsForAHyphen(list, n2, 0, this.letterSpaceIPD, true);
        }
    }

    private void addElementsForAHyphen(List list, int n2, int n3, MinOptMax minOptMax, boolean bl) {
        int n4;
        if (minOptMax == null) {
            minOptMax = MinOptMax.ZERO;
        }
        int n5 = n4 = bl ? 1 : 50;
        if (this.overflowWrap) {
            n3 = 0;
        }
        switch (n2) {
            case 23: {
                list.add(this.makeZeroWidthPenalty(1000));
                if (!this.overflowWrap) {
                    list.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, true));
                }
                list.add(new KnuthPenalty(n3, n4, !bl, this.auxiliaryPosition, false));
                if (!this.overflowWrap) {
                    list.add(new KnuthGlue(-(this.lineEndBAP + this.lineStartBAP), -20016, 0, this.auxiliaryPosition, false));
                }
                list.add(this.makeAuxiliaryZeroWidthBox());
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(this.lineStartBAP, 10008, 0, this.auxiliaryPosition, true));
                break;
            }
            case 39: 
            case 135: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    list.add(this.makeZeroWidthPenalty(1000));
                    if (!this.overflowWrap) {
                        list.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                    }
                    list.add(new KnuthPenalty(n3, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                    if (!this.overflowWrap) {
                        list.add(new KnuthGlue(minOptMax.getOpt() - (this.lineStartBAP + this.lineEndBAP), -10008, 0, this.auxiliaryPosition, false));
                    }
                    list.add(this.makeAuxiliaryZeroWidthBox());
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                list.add(this.makeZeroWidthPenalty(1000));
                if (!this.overflowWrap) {
                    list.add(new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false));
                }
                list.add(new KnuthPenalty(n3, n4, !bl, this.auxiliaryPosition, false));
                if (this.overflowWrap) break;
                list.add(new KnuthGlue(minOptMax.getOpt(), -10008, 0, this.auxiliaryPosition, false));
                break;
            }
            default: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    list.add(new KnuthPenalty(n3, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                    if (minOptMax.isNonZero()) {
                        list.add(new KnuthGlue(minOptMax.getOpt() - (this.lineStartBAP + this.lineEndBAP), minOptMax.getStretch(), minOptMax.getShrink(), this.auxiliaryPosition, false));
                    } else {
                        list.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), 0, 0, this.auxiliaryPosition, false));
                    }
                    list.add(this.makeAuxiliaryZeroWidthBox());
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                list.add(new KnuthPenalty(n3, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                if (!minOptMax.isNonZero()) break;
                list.add(new KnuthGlue(minOptMax, this.auxiliaryPosition, false));
            }
        }
    }

    public List<ChangeBar> getChangeBarList() {
        if (this.foText == null) {
            return null;
        }
        return this.foText.getChangeBarList();
    }

    public String toString() {
        return super.toString() + "{chars = '" + CharUtilities.toNCRefs((String)this.foText.getCharSequence().toString()) + "', len = " + this.foText.length() + "}";
    }

    public int getMinimumIPD() {
        assert (this.minimumIPD > -1);
        return this.minimumIPD;
    }

    public int getMaximumIPD() {
        assert (this.maximumIPD > -1);
        return this.maximumIPD;
    }

    public void addSpaceThatFollowsIfLastMapping(LeafPosition leafPosition) {
        int n2 = leafPosition.getLeafPos();
        if (n2 == this.mappings.size() - 1) {
            GlyphMapping glyphMapping = this.mappings.get(n2);
            if (glyphMapping.spaceThatFollows == null) {
                glyphMapping.spaceThatFollows = Character.valueOf(' ');
            }
        }
    }

    private final class TextAreaBuilder {
        private final MinOptMax width;
        private final int adjust;
        private final LayoutContext context;
        private final int firstIndex;
        private final int lastIndex;
        private final boolean isLastArea;
        private final Font font;
        private TextArea textArea;
        private int blockProgressionDimension;
        private GlyphMapping mapping;
        private StringBuffer wordChars;
        private int[] letterSpaceAdjust;
        private int letterSpaceAdjustIndex;
        private int[] wordLevels;
        private int wordLevelsIndex;
        private int wordIPD;
        private int[][] gposAdjustments;
        private int gposAdjustmentsIndex;

        private TextAreaBuilder(MinOptMax minOptMax, int n2, LayoutContext layoutContext, int n3, int n4, boolean bl, Font font) {
            this.width = minOptMax;
            this.adjust = n2;
            this.context = layoutContext;
            this.firstIndex = n3;
            this.lastIndex = n4;
            this.isLastArea = bl;
            this.font = font;
        }

        private TextArea build() {
            this.createTextArea();
            this.setInlineProgressionDimension();
            this.calcBlockProgressionDimension();
            this.setBlockProgressionDimension();
            this.setBaselineOffset();
            this.setBlockProgressionOffset();
            this.setText();
            TraitSetter.addFontTraits((Area)this.textArea, this.font);
            this.textArea.addTrait(Trait.COLOR, TextLayoutManager.this.foText.getColor());
            TraitSetter.addTextDecoration((Area)this.textArea, TextLayoutManager.this.foText.getTextDecoration());
            if (!this.context.treatAsArtifact()) {
                TraitSetter.addStructureTreeElement((Area)this.textArea, TextLayoutManager.this.foText.getStructureTreeElement());
            }
            return this.textArea;
        }

        private void createTextArea() {
            this.textArea = this.context.getIPDAdjust() == 0.0 ? new TextArea() : new TextArea(this.width.getStretch(), this.width.getShrink(), this.adjust);
            this.textArea.setChangeBarList(TextLayoutManager.this.getChangeBarList());
        }

        private void setInlineProgressionDimension() {
            this.textArea.setIPD(this.width.getOpt() + this.adjust);
        }

        private void calcBlockProgressionDimension() {
            this.blockProgressionDimension = TextLayoutManager.this.originalFont != null ? TextLayoutManager.this.originalFont.getAscender() - TextLayoutManager.this.originalFont.getDescender() : this.font.getAscender() - this.font.getDescender();
        }

        private void setBlockProgressionDimension() {
            this.textArea.setBPD(this.blockProgressionDimension);
        }

        private void setBaselineOffset() {
            if (TextLayoutManager.this.originalFont != null) {
                this.textArea.setBaselineOffset(TextLayoutManager.this.originalFont.getAscender());
            } else {
                this.textArea.setBaselineOffset(this.font.getAscender());
            }
        }

        private void setBlockProgressionOffset() {
            if (TextLayoutManager.this.alignmentContext != null) {
                if (this.blockProgressionDimension == TextLayoutManager.this.alignmentContext.getHeight()) {
                    this.textArea.setBlockProgressionOffset(0);
                } else {
                    this.textArea.setBlockProgressionOffset(TextLayoutManager.this.alignmentContext.getOffset());
                }
            }
        }

        private void setText() {
            int n2 = -1;
            int n3 = 0;
            for (int i2 = this.firstIndex; i2 <= this.lastIndex; ++i2) {
                this.mapping = TextLayoutManager.this.getGlyphMapping(i2);
                this.textArea.updateLevel(this.mapping.level);
                if (this.mapping.isSpace) {
                    this.addSpaces();
                    continue;
                }
                if (n2 == -1) {
                    n2 = i2;
                    n3 = 0;
                }
                n3 += this.mapping.getWordLength();
                if (!this.isWordEnd(i2)) continue;
                this.addWord(n2, i2, n3);
                n2 = -1;
            }
        }

        private boolean isWordEnd(int n2) {
            return n2 == this.lastIndex || TextLayoutManager.this.getGlyphMapping((int)(n2 + 1)).isSpace;
        }

        private void addWord(int n2, int n3, int n4) {
            int n5 = 0;
            boolean bl = false;
            if (this.isHyphenated(n3)) {
                ++n4;
            }
            this.initWord(n4);
            Character c2 = null;
            for (int i2 = n2; i2 <= n3; ++i2) {
                GlyphMapping glyphMapping = TextLayoutManager.this.getGlyphMapping(i2);
                this.addWordChars(glyphMapping);
                this.addLetterAdjust(glyphMapping);
                if (this.addGlyphPositionAdjustments(glyphMapping)) {
                    bl = true;
                }
                c2 = glyphMapping.spaceThatFollows;
            }
            if (this.isHyphenated(n3)) {
                this.addHyphenationChar();
            }
            if (!bl) {
                this.gposAdjustments = null;
            }
            this.textArea.addWord(this.wordChars.toString(), this.wordIPD, this.letterSpaceAdjust, this.getNonEmptyLevels(), this.gposAdjustments, n5, false);
            this.textArea.setSpaceThatFollows(c2);
        }

        private boolean isWordSpace(int n2) {
            return TextLayoutManager.this.userAgent.isAccessibilityEnabled() && n2 < TextLayoutManager.this.mappings.size() - 1 && TextLayoutManager.this.getGlyphMapping((int)n2).isSpace;
        }

        private int[] getNonEmptyLevels() {
            if (this.wordLevels != null) {
                assert (this.wordLevelsIndex <= this.wordLevels.length);
                boolean bl = true;
                int n2 = this.wordLevelsIndex;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.wordLevels[i2] < 0) continue;
                    bl = false;
                    break;
                }
                return bl ? null : this.wordLevels;
            }
            return null;
        }

        private void initWord(int n2) {
            this.wordChars = new StringBuffer(n2);
            this.letterSpaceAdjust = new int[n2];
            this.letterSpaceAdjustIndex = 0;
            this.wordLevels = new int[n2];
            this.wordLevelsIndex = 0;
            Arrays.fill(this.wordLevels, -1);
            this.gposAdjustments = new int[n2][4];
            this.gposAdjustmentsIndex = 0;
            this.wordIPD = 0;
        }

        private boolean isHyphenated(int n2) {
            return this.isLastArea && n2 == this.lastIndex && this.mapping.isHyphenated;
        }

        private void addHyphenationChar() {
            Character c2 = TextLayoutManager.this.foText.getCommonHyphenation().getHyphChar(this.font);
            if (c2 != null && !TextLayoutManager.this.overflowWrap) {
                this.wordChars.append(c2);
            }
            this.textArea.setHyphenated();
        }

        private void addWordChars(GlyphMapping glyphMapping) {
            int n2 = glyphMapping.startIndex;
            int n3 = glyphMapping.endIndex;
            if (glyphMapping.mapping != null) {
                this.wordChars.append(glyphMapping.mapping);
                this.addWordLevels(this.getMappingBidiLevels(glyphMapping));
            } else {
                for (int i2 = n2; i2 < n3; ++i2) {
                    this.wordChars.append(TextLayoutManager.this.foText.charAt(i2));
                }
                this.addWordLevels(TextLayoutManager.this.foText.getBidiLevels(n2, n3));
            }
            this.wordIPD += glyphMapping.areaIPD.getOpt();
        }

        private int[] getMappingBidiLevels(GlyphMapping glyphMapping) {
            if (glyphMapping.mapping != null) {
                int n2 = glyphMapping.endIndex - glyphMapping.startIndex;
                int n3 = glyphMapping.mapping.length();
                int[] nArray = TextLayoutManager.this.foText.getBidiLevels(glyphMapping.startIndex, glyphMapping.endIndex);
                if (nArray == null) {
                    return null;
                }
                if (n3 == n2) {
                    return nArray;
                }
                if (n3 > n2) {
                    int n4;
                    int n5;
                    int[] nArray2 = new int[n3];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    int n6 = nArray2.length;
                    int n7 = n5 = n4 > 0 ? nArray[n4 - 1] : 0;
                    for (n4 = nArray.length; n4 < n6; ++n4) {
                        nArray2[n4] = n5;
                    }
                    return nArray2;
                }
                int[] nArray3 = new int[n3];
                System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
                return nArray3;
            }
            return TextLayoutManager.this.foText.getBidiLevels(glyphMapping.startIndex, glyphMapping.endIndex);
        }

        private void addWordLevels(int[] nArray) {
            int n2;
            int n3 = n2 = nArray != null ? nArray.length : 0;
            if (n2 > 0) {
                int n4 = this.wordLevelsIndex + n2;
                if (n4 <= this.wordLevels.length) {
                    System.arraycopy(nArray, 0, this.wordLevels, this.wordLevelsIndex, n2);
                } else {
                    throw new IllegalStateException("word levels array too short: expect at least " + n4 + " entries, but has only " + this.wordLevels.length + " entries");
                }
            }
            this.wordLevelsIndex += n2;
        }

        private void addLetterAdjust(GlyphMapping glyphMapping) {
            int n2 = glyphMapping.letterSpaceCount;
            int n3 = glyphMapping.getWordLength();
            int n4 = this.textArea.getTextLetterSpaceAdjust();
            int n5 = n3;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = this.letterSpaceAdjustIndex + i2;
                if (n6 > 0) {
                    int n7 = glyphMapping.startIndex + i2;
                    MinOptMax minOptMax = n7 < TextLayoutManager.this.letterSpaceAdjustArray.length ? TextLayoutManager.this.letterSpaceAdjustArray[n7] : null;
                    int n8 = this.letterSpaceAdjust[n6] = minOptMax == null ? 0 : minOptMax.getOpt();
                }
                if (n2 <= 0) continue;
                int n9 = n6;
                this.letterSpaceAdjust[n9] = this.letterSpaceAdjust[n9] + n4;
                --n2;
            }
            this.letterSpaceAdjustIndex += n3;
        }

        private boolean addGlyphPositionAdjustments(GlyphMapping glyphMapping) {
            boolean bl = false;
            int[][] nArray = glyphMapping.gposAdjustments;
            int n2 = nArray != null ? nArray.length : 0;
            int n3 = glyphMapping.getWordLength();
            if (n2 > 0) {
                int n4 = this.gposAdjustmentsIndex + n2;
                if (n4 <= this.gposAdjustments.length) {
                    int n5 = n3;
                    int n6 = 0;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        if (i2 >= n2) continue;
                        int[] nArray2 = this.gposAdjustments[this.gposAdjustmentsIndex + i2];
                        int[] nArray3 = nArray[n6++];
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int n7 = nArray3[i3];
                            if (n7 == 0) continue;
                            int n8 = i3;
                            nArray2[n8] = nArray2[n8] + n7;
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalStateException("gpos adjustments array too short: expect at least " + n4 + " entries, but has only " + this.gposAdjustments.length + " entries");
                }
            }
            this.gposAdjustmentsIndex += n3;
            return bl;
        }

        private void addSpaces() {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            for (n3 = this.mapping.startIndex; n3 < this.mapping.endIndex; ++n3) {
                n2 = TextLayoutManager.this.foText.charAt(n3);
                if (!CharUtilities.isZeroWidthSpace((int)n2)) continue;
                ++n5;
            }
            n3 = this.mapping.endIndex - this.mapping.startIndex - n5;
            n2 = this.mapping.areaIPD.getOpt() / (n3 > 0 ? n3 : 1);
            for (int i2 = this.mapping.startIndex; i2 < this.mapping.endIndex; ++i2) {
                char c2 = TextLayoutManager.this.foText.charAt(i2);
                int n6 = TextLayoutManager.this.foText.bidiLevelAt(i2);
                if (CharUtilities.isZeroWidthSpace((int)c2)) continue;
                this.textArea.addSpace(c2, n2, CharUtilities.isAdjustableSpace((int)c2), n4, n6);
            }
        }
    }

    private final class PendingChange {
        private final GlyphMapping mapping;
        private final int index;

        private PendingChange(GlyphMapping glyphMapping, int n2) {
            this.mapping = glyphMapping;
            this.index = n2;
        }
    }
}

