/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.ResolvedPageNumber;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.GlyphMapping;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageNumberLayoutManager
extends LeafNodeLayoutManager {
    private PageNumber fobj;
    private Font font;
    private int cwidth;

    public PageNumberLayoutManager(PageNumber pageNumber) {
        super((FObj)pageNumber);
        this.fobj = pageNumber;
    }

    public void initialize() {
        FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue((PercentBaseContext)this));
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        return new AlignmentContext(this.font, this.fobj.getLineHeight().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), layoutContext.getAlignmentContext());
    }

    public InlineArea get(LayoutContext layoutContext) {
        ResolvedPageNumber resolvedPageNumber = new ResolvedPageNumber();
        String string = this.performSubstitution(this.getCurrentPV().getPageNumberString());
        this.cwidth = this.getStringWidth(string);
        int n2 = this.getBidiLevel();
        resolvedPageNumber.addWord(string, 0, n2);
        resolvedPageNumber.setBidiLevel(n2);
        resolvedPageNumber.setIPD(this.cwidth);
        resolvedPageNumber.setBPD(this.font.getAscender() - this.font.getDescender());
        resolvedPageNumber.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits((Area)resolvedPageNumber, this.font);
        resolvedPageNumber.addTrait(Trait.COLOR, (Object)this.fobj.getColor());
        TraitSetter.addTextDecoration((Area)resolvedPageNumber, this.fobj.getTextDecoration());
        return resolvedPageNumber;
    }

    protected InlineArea getEffectiveArea(LayoutContext layoutContext) {
        ResolvedPageNumber resolvedPageNumber = (ResolvedPageNumber)this.curArea;
        ResolvedPageNumber resolvedPageNumber2 = new ResolvedPageNumber();
        TraitSetter.setProducerID((Area)resolvedPageNumber2, this.fobj.getId());
        resolvedPageNumber2.setIPD(resolvedPageNumber.getIPD());
        resolvedPageNumber2.setBPD(resolvedPageNumber.getBPD());
        resolvedPageNumber2.setBlockProgressionOffset(resolvedPageNumber.getBlockProgressionOffset());
        resolvedPageNumber2.setBaselineOffset(resolvedPageNumber.getBaselineOffset());
        resolvedPageNumber2.addTrait(Trait.COLOR, (Object)this.fobj.getColor());
        resolvedPageNumber2.getTraits().putAll(resolvedPageNumber.getTraits());
        if (!layoutContext.treatAsArtifact()) {
            TraitSetter.addStructureTreeElement((Area)resolvedPageNumber2, this.fobj.getStructureTreeElement());
        }
        this.updateContent(resolvedPageNumber2);
        return resolvedPageNumber2;
    }

    private void updateContent(ResolvedPageNumber resolvedPageNumber) {
        resolvedPageNumber.removeText();
        resolvedPageNumber.addWord(this.performSubstitution(this.getCurrentPV().getPageNumberString()), 0, this.getBidiLevel());
        this.cwidth = this.getStringWidth(resolvedPageNumber.getText());
        resolvedPageNumber.handleIPDVariation(this.cwidth - resolvedPageNumber.getIPD());
        this.areaInfo.ipdArea = MinOptMax.getInstance((int)resolvedPageNumber.getIPD());
    }

    private int getStringWidth(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 += this.font.getCharWidth(string.charAt(i2));
        }
        return n2;
    }

    protected int getBidiLevel() {
        return this.fobj.getBidiLevel();
    }

    private String performSubstitution(CharSequence charSequence) {
        return GlyphMapping.performSubstitution(this.font, charSequence, this.fobj.getCommonFont().getFontFeatureSettings(), this.fobj.getScript(), this.fobj.getLanguage());
    }

    public int getMinimumIPD() {
        int n2 = super.getMinimumIPD();
        int n3 = Math.max(n2, this.cwidth);
        return n3;
    }

    public int getMaximumIPD() {
        int n2 = super.getMaximumIPD();
        int n3 = Math.max(n2, this.cwidth);
        return n3;
    }
}

