/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.Space;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.traits.MinOptMax;

public abstract class InlineStackingLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager,
BreakOpportunity {
    protected MinOptMax extraBPD = MinOptMax.ZERO;
    private Area currentArea;
    protected LayoutContext childLC;

    protected InlineStackingLayoutManager(FObj fObj) {
        super(fObj);
    }

    public void setLMiter(ListIterator listIterator) {
        this.childLMiter = listIterator;
    }

    protected MinOptMax getExtraIPD(boolean bl, boolean bl2) {
        return MinOptMax.ZERO;
    }

    protected boolean hasLeadingFence(boolean bl) {
        return false;
    }

    protected boolean hasTrailingFence(boolean bl) {
        return false;
    }

    protected SpaceProperty getSpaceStart() {
        return null;
    }

    protected SpaceProperty getSpaceEnd() {
        return null;
    }

    protected Area getCurrentArea() {
        return this.currentArea;
    }

    protected void setCurrentArea(Area area) {
        this.currentArea = area;
    }

    protected void setTraits(boolean bl, boolean bl2) {
    }

    protected void setChildContext(LayoutContext layoutContext) {
        this.childLC = layoutContext;
    }

    protected LayoutContext getContext() {
        return this.childLC;
    }

    protected void addSpace(Area area, MinOptMax minOptMax, double d2) {
        if (minOptMax != null) {
            int n2 = minOptMax.getOpt();
            if (d2 > 0.0) {
                n2 += (int)((double)minOptMax.getStretch() * d2);
            } else if (d2 < 0.0) {
                n2 += (int)((double)minOptMax.getShrink() * d2);
            }
            if (n2 != 0) {
                Space space = new Space();
                space.setChangeBarList(this.getChangeBarList());
                space.setIPD(n2);
                int n3 = area.getBidiLevel();
                if (n3 >= 0) {
                    space.setBidiLevel(n3);
                }
                space.setFromFootnote(this.isFromFootnote());
                area.addChildArea((Area)space);
            }
        }
    }

    @Override
    public int getBorderAreaIPD() {
        return this.currentArea.getAllocIPD();
    }

    @Override
    public int getBorderAreaBPD() {
        return this.currentArea.getAllocBPD();
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list) {
        return this.addALetterSpaceTo(list, 0);
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list, int n2) {
        ListIterator<Object> listIterator = list.listIterator(list.size());
        KnuthElement knuthElement = (KnuthElement)listIterator.previous();
        int n3 = n2 + 1;
        Position position = knuthElement.getPosition();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        if (position != null) {
            inlineLevelLayoutManager = (InlineLevelLayoutManager)position.getLM(n3);
        }
        if (inlineLevelLayoutManager == null) {
            return list;
        }
        list = inlineLevelLayoutManager.addALetterSpaceTo(list, n3);
        listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            knuthElement = (KnuthElement)((Object)listIterator.next());
            position = knuthElement.getPosition();
            inlineLevelLayoutManager = null;
            if (position != null) {
                inlineLevelLayoutManager = (InlineLevelLayoutManager)position.getLM(n2);
            }
            if (inlineLevelLayoutManager == this) continue;
            knuthElement.setPosition(this.notifyPos((Position)new NonLeafPosition((LayoutManager)this, knuthElement.getPosition())));
        }
        return list;
    }

    public String getWordChars(Position position) {
        Position position2 = position.getPosition();
        return ((InlineLevelLayoutManager)position2.getLM()).getWordChars(position2);
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        Position position2 = position.getPosition();
        ((InlineLevelLayoutManager)position2.getLM()).hyphenate(position2, hyphContext);
    }

    public boolean applyChanges(List<ListElement> list) {
        return this.applyChanges(list, 0);
    }

    public boolean applyChanges(List<ListElement> list, int n2) {
        ListIterator<ListElement> listIterator = list.listIterator();
        ++n2;
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        int n3 = 0;
        boolean bl = false;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            Position position = knuthElement.getPosition();
            InlineLevelLayoutManager inlineLevelLayoutManager2 = position == null ? null : (InlineLevelLayoutManager)position.getLM(n2);
            if (inlineLevelLayoutManager == null) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager && listIterator.hasNext()) continue;
            if (inlineLevelLayoutManager == this || inlineLevelLayoutManager2 == this) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                continue;
            }
            if (listIterator.hasNext()) {
                bl = inlineLevelLayoutManager.applyChanges(list.subList(n3, listIterator.previousIndex()), n2) || bl;
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                n3 = listIterator.previousIndex();
                continue;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager) {
                bl = inlineLevelLayoutManager != null && inlineLevelLayoutManager.applyChanges(list.subList(n3, list.size()), n2) || bl;
                continue;
            }
            boolean bl2 = bl = inlineLevelLayoutManager.applyChanges(list.subList(n3, listIterator.previousIndex()), n2) || bl;
            if (inlineLevelLayoutManager2 == null) continue;
            bl = inlineLevelLayoutManager2.applyChanges(list.subList(listIterator.previousIndex(), list.size()), n2) || bl;
        }
        return bl;
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2) {
        return this.getChangedKnuthElements(list, n2, 0);
    }

    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2, int n3) {
        ListIterator<ListElement> listIterator = list.listIterator();
        ++n3;
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        int n4 = 0;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            Position position = knuthElement.getPosition();
            InlineLevelLayoutManager inlineLevelLayoutManager2 = position == null ? null : (InlineLevelLayoutManager)position.getLM(n3);
            if (inlineLevelLayoutManager == null) {
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager && listIterator.hasNext()) continue;
            if (listIterator.hasNext()) {
                linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n4, listIterator.previousIndex()), n2, n3));
                inlineLevelLayoutManager = inlineLevelLayoutManager2;
                n4 = listIterator.previousIndex();
                continue;
            }
            if (inlineLevelLayoutManager2 == inlineLevelLayoutManager) {
                if (inlineLevelLayoutManager != null) {
                    linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n4, list.size()), n2, n3));
                    continue;
                }
                knuthElement.setPosition(position.getPosition(n3 - 1));
                linkedList.add(knuthElement);
                continue;
            }
            linkedList.addAll(inlineLevelLayoutManager.getChangedKnuthElements(list.subList(n4, listIterator.previousIndex()), n2, n3));
            if (inlineLevelLayoutManager2 == null) continue;
            linkedList.addAll(inlineLevelLayoutManager2.getChangedKnuthElements(list.subList(listIterator.previousIndex(), list.size()), n2, n3));
        }
        for (Object e2 : linkedList) {
            KnuthElement knuthElement = (KnuthElement)((Object)e2);
            knuthElement.setPosition(this.notifyPos((Position)new NonLeafPosition((LayoutManager)this, knuthElement.getPosition())));
            linkedList2.add(knuthElement);
        }
        return linkedList2;
    }

    public int getBreakBefore() {
        return BreakOpportunityHelper.getBreakBefore((AbstractLayoutManager)this);
    }
}

