/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.BlockKnuthSequence;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.ListUtil;

public class InlineLayoutManager
extends InlineStackingLayoutManager {
    private static Log log = LogFactory.getLog(InlineLayoutManager.class);
    private CommonMarginInline inlineProps;
    private CommonBorderPaddingBackground borderProps;
    private boolean areaCreated;
    private LayoutManager lastChildLM;
    private Font font;
    protected Length alignmentAdjust;
    protected int alignmentBaseline = 12;
    protected Length baselineShift;
    protected int dominantBaseline;
    protected SpaceProperty lineHeight;
    private AlignmentContext alignmentContext;
    private CommonRelativePosition relProps;

    public InlineLayoutManager(InlineLevel inlineLevel) {
        super(inlineLevel);
    }

    @Override
    public void initialize() {
        InlineLevel inlineLevel = (InlineLevel)this.fobj;
        int n2 = 0;
        FontInfo fontInfo = inlineLevel.getFOEventHandler().getFontInfo();
        CommonFont commonFont = inlineLevel.getCommonFont();
        FontTriplet[] fontTripletArray = commonFont.getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], commonFont.fontSize.getValue((PercentBaseContext)this));
        this.lineHeight = inlineLevel.getLineHeight();
        this.borderProps = inlineLevel.getCommonBorderPaddingBackground();
        this.inlineProps = inlineLevel.getCommonMarginInline();
        if (inlineLevel instanceof Inline) {
            this.alignmentAdjust = ((Inline)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((Inline)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((Inline)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((Inline)inlineLevel).getDominantBaseline();
        } else if (inlineLevel instanceof Leader) {
            this.alignmentAdjust = ((Leader)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((Leader)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((Leader)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((Leader)inlineLevel).getDominantBaseline();
        } else if (inlineLevel instanceof BasicLink) {
            this.alignmentAdjust = ((BasicLink)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((BasicLink)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((BasicLink)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((BasicLink)inlineLevel).getDominantBaseline();
        }
        if (this.borderProps != null) {
            n2 = this.borderProps.getPadding(0, false, this);
            n2 += this.borderProps.getBorderWidth(0, false);
            n2 += this.borderProps.getPadding(1, false, this);
            n2 += this.borderProps.getBorderWidth(1, false);
        }
        this.extraBPD = MinOptMax.getInstance((int)n2);
        this.relProps = ((InlineLevel)this.getFObj()).getCommonRelativePosition();
    }

    @Override
    protected MinOptMax getExtraIPD(boolean bl, boolean bl2) {
        int n2 = 0;
        if (this.borderProps != null) {
            n2 = this.borderProps.getPadding(2, bl, this);
            n2 += this.borderProps.getBorderWidth(2, bl);
            n2 += this.borderProps.getPadding(3, bl2, this);
            n2 += this.borderProps.getBorderWidth(3, bl2);
        }
        return MinOptMax.getInstance((int)n2);
    }

    @Override
    protected boolean hasLeadingFence(boolean bl) {
        return this.borderProps != null && (this.borderProps.getPadding(2, bl, this) > 0 || this.borderProps.getBorderWidth(2, bl) > 0);
    }

    @Override
    protected boolean hasTrailingFence(boolean bl) {
        return this.borderProps != null && (this.borderProps.getPadding(3, bl, this) > 0 || this.borderProps.getBorderWidth(3, bl) > 0);
    }

    @Override
    protected SpaceProperty getSpaceStart() {
        return this.inlineProps != null ? this.inlineProps.spaceStart : null;
    }

    @Override
    protected SpaceProperty getSpaceEnd() {
        return this.inlineProps != null ? this.inlineProps.spaceEnd : null;
    }

    protected InlineArea createArea(boolean bl) {
        InlineParent inlineParent;
        if (bl) {
            inlineParent = this.createInlineParent();
            inlineParent.setChangeBarList(this.getChangeBarList());
            inlineParent.setBlockProgressionOffset(0);
        } else {
            inlineParent = new InlineBlockParent();
            inlineParent.setChangeBarList(this.getChangeBarList());
        }
        if (this.fobj instanceof Inline || this.fobj instanceof BasicLink) {
            TraitSetter.setProducerID((Area)inlineParent, this.fobj.getId());
            TraitSetter.setLayer((Area)inlineParent, this.fobj.getLayer());
        }
        this.transferForeignAttributes((AreaTreeObject)inlineParent);
        if (this.relProps.relativePosition == 110) {
            Point point = this.getRelOffset();
            inlineParent.setXOffset(point.x);
            inlineParent.setYOffset(point.y);
            inlineParent.setPositioning(1);
        }
        return inlineParent;
    }

    protected InlineParent createInlineParent() {
        return new InlineParent();
    }

    @Override
    protected void setTraits(boolean bl, boolean bl2) {
        if (this.borderProps != null) {
            TraitSetter.setBorderPaddingTraits(this.getCurrentArea(), this.borderProps, bl, bl2, this);
            TraitSetter.addBackground(this.getCurrentArea(), this.borderProps, this);
        }
    }

    public boolean mustKeepTogether() {
        return this.mustKeepTogether(this.getParent());
    }

    private boolean mustKeepTogether(LayoutManager layoutManager) {
        if (layoutManager instanceof BlockLevelLayoutManager) {
            return ((BlockLevelLayoutManager)layoutManager).mustKeepTogether();
        }
        if (layoutManager instanceof InlineLayoutManager) {
            return ((InlineLayoutManager)layoutManager).mustKeepTogether();
        }
        return this.mustKeepTogether(layoutManager.getParent());
    }

    @Override
    public List<KnuthSequence> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        LayoutManager layoutManager;
        LinkedList<KnuthSequence> linkedList = new LinkedList<KnuthSequence>();
        KnuthSequence knuthSequence = null;
        this.alignmentContext = this.fobj instanceof Title ? new AlignmentContext(this.font, this.lineHeight.getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this), layoutContext.getWritingMode()) : new AlignmentContext(this.font, this.lineHeight.getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this), this.alignmentAdjust, this.alignmentBaseline, this.baselineShift, this.dominantBaseline, layoutContext.getAlignmentContext());
        this.childLC = LayoutContext.copyOf(layoutContext);
        this.childLC.setAlignmentContext(this.alignmentContext);
        if (layoutContext.startsNewArea() && this.getSpaceStart() != null) {
            layoutContext.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), (PercentBaseContext)this));
        }
        StringBuffer stringBuffer = new StringBuffer("InlineLM:");
        boolean bl = false;
        if (this.borderProps != null) {
            this.childLC.setLineStartBorderAndPaddingWidth(layoutContext.getLineStartBorderAndPaddingWidth() + this.borderProps.getPaddingStart(true, this) + this.borderProps.getBorderStartWidth(true));
            this.childLC.setLineEndBorderAndPaddingWidth(layoutContext.getLineEndBorderAndPaddingWidth() + this.borderProps.getPaddingEnd(true, this) + this.borderProps.getBorderEndWidth(true));
        }
        while ((layoutManager = this.getChildLM()) != null) {
            if (!(layoutManager instanceof InlineLevelLayoutManager) && this.borderProps != null) {
                this.childLC.setRefIPD(this.childLC.getRefIPD() - this.borderProps.getPaddingStart(this.lastChildLM != null, this) - this.borderProps.getBorderStartWidth(this.lastChildLM != null) - this.borderProps.getPaddingEnd(this.hasNextChildLM(), this) - this.borderProps.getBorderEndWidth(this.hasNextChildLM()));
            }
            List list = layoutManager.getNextKnuthElements(this.childLC, n2);
            if (linkedList.isEmpty() && this.childLC.isKeepWithPreviousPending()) {
                this.childLC.clearKeepWithPreviousPending();
            }
            if (list == null || list.isEmpty()) continue;
            if (layoutManager instanceof InlineLevelLayoutManager) {
                Object object2;
                layoutContext.clearKeepWithNextPending();
                for (Object object2 : list) {
                    object2.wrapPositions((LayoutManager)this);
                }
                int n3 = 0;
                if (knuthSequence != null && knuthSequence.appendSequenceOrClose((KnuthSequence)list.get(0))) {
                    n3 = 1;
                }
                if (!bl && !list.isEmpty()) {
                    this.addKnuthElementsForBorderPaddingStart((List)list.get(0));
                    bl = true;
                }
                object2 = list.listIterator(n3);
                while (object2.hasNext()) {
                    linkedList.add((KnuthSequence)object2.next());
                }
            } else {
                BlockKnuthSequence blockKnuthSequence = new BlockKnuthSequence(list);
                blockKnuthSequence.wrapPositions((LayoutManager)this);
                boolean bl2 = false;
                if (knuthSequence != null) {
                    if (knuthSequence.canAppendSequence((KnuthSequence)blockKnuthSequence)) {
                        BreakElement breakElement = new BreakElement(new Position((LayoutManager)this), 0, layoutContext);
                        boolean bl3 = this.mustKeepTogether() || layoutContext.isKeepWithNextPending() || this.childLC.isKeepWithPreviousPending();
                        bl2 = knuthSequence.appendSequenceOrClose((KnuthSequence)blockKnuthSequence, bl3, breakElement);
                    } else {
                        knuthSequence.endSequence();
                    }
                }
                if (!bl2) {
                    if (!bl) {
                        this.addKnuthElementsForBorderPaddingStart((List<ListElement>)blockKnuthSequence);
                        bl = true;
                    }
                    linkedList.add((KnuthSequence)blockKnuthSequence);
                }
                layoutContext.updateKeepWithNextPending(this.childLC.getKeepWithNextPending());
                this.childLC.clearKeepsPending();
            }
            knuthSequence = (KnuthSequence)ListUtil.getLast(linkedList);
            this.lastChildLM = layoutManager;
            this.childLC.setFlags(2, false);
        }
        if (knuthSequence != null) {
            this.addKnuthElementsForBorderPaddingEnd((List<ListElement>)knuthSequence);
        }
        this.setFinished(true);
        log.trace((Object)stringBuffer);
        if (linkedList.isEmpty() && (this.fobj.hasId() || this.fobj.hasMarkers())) {
            InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
            inlineKnuthSequence.add((Object)new KnuthInlineBox(0, this.alignmentContext, this.notifyPos(this.getAuxiliaryPosition()), true));
            linkedList.add((KnuthSequence)inlineKnuthSequence);
        }
        return linkedList.isEmpty() ? null : linkedList;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        boolean bl;
        LayoutManager layoutManager;
        this.addId();
        this.setChildContext(LayoutContext.copyOf(layoutContext));
        LinkedList<Position> linkedList = new LinkedList<Position>();
        LayoutManager layoutManager2 = null;
        Position position = null;
        while (positionIterator.hasNext()) {
            Position position2 = positionIterator.next();
            if (position2 == null || position2.getPosition() == null) continue;
            if (this.isFirst(position2)) {
                this.areaCreated = false;
            }
            linkedList.add(position2.getPosition());
            layoutManager2 = position2.getPosition().getLM();
            position = position2;
        }
        if (this.hasLeadingFence(this.areaCreated)) {
            this.getContext().setLeadingSpace(new SpaceSpecifier(false));
            this.getContext().setFlags(16, true);
        } else {
            this.getContext().setFlags(16, false);
        }
        if (this.getSpaceStart() != null) {
            layoutContext.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), (PercentBaseContext)this));
        }
        this.registerMarkers(true, !this.areaCreated, position == null || this.isLast(position));
        InlineArea inlineArea = this.createArea(layoutManager2 == null || layoutManager2 instanceof InlineLevelLayoutManager);
        inlineArea.setBPD(this.alignmentContext.getHeight());
        if (inlineArea instanceof InlineParent) {
            inlineArea.setBlockProgressionOffset(this.alignmentContext.getOffset());
        } else if (inlineArea instanceof InlineBlockParent && this.borderProps != null) {
            inlineArea.setBlockProgressionOffset(this.borderProps.getPaddingBefore(false, this) + this.borderProps.getBorderBeforeWidth(false));
        }
        this.setCurrentArea(inlineArea);
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        LayoutManager layoutManager3 = null;
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            this.getContext().setFlags(8, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutManager.addAreas(positionIterator2, this.getContext());
            this.getContext().setLeadingSpace(this.getContext().getTrailingSpace());
            this.getContext().setFlags(16, true);
            layoutManager3 = layoutManager;
        }
        boolean bl2 = bl = this.getContext().isLastArea() && layoutManager3 == this.lastChildLM;
        if (this.hasTrailingFence(bl)) {
            this.addSpace(this.getCurrentArea(), this.getContext().getTrailingSpace().resolve(false), this.getContext().getSpaceAdjust());
            layoutContext.setTrailingSpace(new SpaceSpecifier(false));
        } else {
            layoutContext.setTrailingSpace(this.getContext().getTrailingSpace());
        }
        if (layoutContext.getTrailingSpace() != null && this.getSpaceEnd() != null) {
            layoutContext.getTrailingSpace().addSpace(new SpaceVal(this.getSpaceEnd(), (PercentBaseContext)this));
        }
        this.setTraits(this.areaCreated, position == null || !this.isLast(position));
        this.getCurrentArea().setFromFootnote(this.isFromFootnote());
        this.parentLayoutManager.addChildArea(this.getCurrentArea());
        this.registerMarkers(false, !this.areaCreated, position == null || this.isLast(position));
        layoutContext.setFlags(8, bl);
        this.areaCreated = true;
        this.checkEndOfLayout(position);
    }

    boolean shouldIncreaseHeightToAccommodateChildren(FObj fObj) {
        boolean bl = false;
        for (int i2 = 0; i2 < 3 && fObj.getNameId() == 35; ++i2) {
            if ("true".equals(fObj.getForeignAttributes().get(ChemistryExtensions.ATT_QNAME_INCREASE_HEIGHT_TO_ACCOMODATE_CHILDREN))) {
                bl = true;
                break;
            }
            FONode fONode = fObj.getParent();
            if (!(fONode instanceof FObj)) continue;
            fObj = (FObj)fONode;
        }
        return bl;
    }

    @Override
    public void addChildArea(Area area) {
        Area area2 = this.getCurrentArea();
        if (this.getContext().resolveLeadingSpace()) {
            this.addSpace(area2, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
        }
        area2.addChildArea(area);
        if (this.shouldIncreaseHeightToAccommodateChildren(this.fobj)) {
            area2.setBPD(Math.max(area2.getBPD(), area.getAllocBPD()));
            int n2 = ((InlineArea)area).getBlockProgressionOffset();
            int n3 = ((InlineArea)area2).getBlockProgressionOffset();
            int n4 = area.getSpaceBefore() + area.getBorderAndPaddingWidthBefore();
            ((InlineArea)area2).setBlockProgressionOffset(n2 + n3 - n4);
            ((InlineArea)area).setBlockProgressionOffset(n4);
        }
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2, int n3) {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        this.addKnuthElementsForBorderPaddingStart(linkedList);
        linkedList.addAll(super.getChangedKnuthElements(list, n2, n3));
        this.addKnuthElementsForBorderPaddingEnd(linkedList);
        return linkedList;
    }

    protected void addKnuthElementsForBorderPaddingStart(List<ListElement> list) {
        int n2;
        if (list instanceof BlockKnuthSequence) {
            return;
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = ((InlineLevel)this.fobj).getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground != null && (n2 = commonBorderPaddingBackground.getBorderStartWidth(false) + commonBorderPaddingBackground.getPaddingStart(false, this)) > 0) {
            list.add(0, (ListElement)new KnuthBox(n2, this.getAuxiliaryPosition(), true));
        }
    }

    protected void addKnuthElementsForBorderPaddingEnd(List<ListElement> list) {
        int n2;
        if (list instanceof BlockKnuthSequence) {
            return;
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = ((InlineLevel)this.fobj).getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground != null && (n2 = commonBorderPaddingBackground.getBorderEndWidth(false) + commonBorderPaddingBackground.getPaddingEnd(false, this)) > 0) {
            list.add((ListElement)new KnuthBox(n2, this.getAuxiliaryPosition(), true));
        }
    }

    protected Position getAuxiliaryPosition() {
        return new NonLeafPosition((LayoutManager)this, null);
    }

    @Override
    public int getMinimumIPD() {
        int n2 = super.getMinimumIPD();
        return n2 + this.getMBP();
    }

    @Override
    public int getMaximumIPD() {
        int n2 = super.getMaximumIPD();
        return n2 + this.getMBP();
    }

    protected int getMBP() {
        int n2 = (int)Math.ceil((double)(this.borderProps.getPaddingStart(false, this) + this.borderProps.getPaddingEnd(false, this) + this.borderProps.getBorderStartWidth(false) + this.borderProps.getBorderEndWidth(false)) + this.inlineProps.marginLeft.getNumericValue((PercentBaseContext)this) + this.inlineProps.marginRight.getNumericValue((PercentBaseContext)this));
        return n2;
    }

    private Point getRelOffset() {
        int n2 = 0;
        int n3 = 0;
        if (this.relProps.left.getEnum() != 9) {
            n2 = this.relProps.left.getValue((PercentBaseContext)this);
        } else if (this.relProps.right.getEnum() != 9) {
            n2 = -this.relProps.right.getValue((PercentBaseContext)this);
        }
        if (this.relProps.top.getEnum() != 9) {
            n3 = this.relProps.top.getValue((PercentBaseContext)this);
        } else if (this.relProps.bottom.getEnum() != 9) {
            n3 = -this.relProps.bottom.getValue((PercentBaseContext)this);
        }
        return new Point(n2, n3);
    }
}

