/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.WritingMode;

public final class LayoutContext {
    public static final int NEW_AREA = 1;
    public static final int SUPPRESS_BREAK_BEFORE = 2;
    public static final int FIRST_AREA = 4;
    public static final int LAST_AREA = 8;
    public static final int RESOLVE_LEADING_SPACE = 16;
    private static final int TREAT_AS_ARTIFACT = 32;
    private static final int IN_AUTO_LAYOUT_DETERMINATION_MODE = 64;
    private static final int IS_CHILD_OF_AUTO_LAYOUT_ELEMENT = 128;
    private static final int DISABLE_COLUMN_BALANCING = 256;
    private static final int IN_ROTATED_BLOCK_LAYOUT_DETERMINATION_MODE = 512;
    private static final int PROPAGATED_FLAGS = 736;
    private int flags;
    private MinOptMax stackLimitBP;
    private int currentSpan = 0;
    private int nextSpan = 0;
    private int refIPD;
    private WritingMode writingMode = WritingMode.LR_TB;
    private SpaceSpecifier trailingSpace;
    private SpaceSpecifier leadingSpace;
    private List<ListElement> pendingAfterMarks;
    private List<ListElement> pendingBeforeMarks;
    private HyphContext hyphContext;
    private int bpAlignment = 135;
    private double ipdAdjust;
    private double dSpaceAdjust;
    private AlignmentContext alignmentContext;
    private int spaceBefore;
    private int spaceAfter;
    private int lineStartBorderAndPaddingWidth;
    private int lineEndBorderAndPaddingWidth;
    private int breakBefore;
    private int breakAfter;
    private Keep pendingKeepWithNext = Keep.KEEP_AUTO;
    private Keep pendingKeepWithPrevious = Keep.KEEP_AUTO;
    private int disableColumnBalancing;
    private LineBreakStatus lineBreakStatus;

    public static LayoutContext newInstance() {
        return new LayoutContext(0);
    }

    public static LayoutContext copyOf(LayoutContext layoutContext) {
        return new LayoutContext(layoutContext);
    }

    public static LayoutContext offspringOf(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.propagateFlagsFrom(layoutContext);
        return layoutContext2;
    }

    private LayoutContext(LayoutContext layoutContext) {
        this.flags = layoutContext.flags;
        this.refIPD = layoutContext.refIPD;
        this.writingMode = layoutContext.writingMode;
        this.setStackLimitBP(layoutContext.getStackLimitBP());
        this.leadingSpace = layoutContext.leadingSpace;
        this.trailingSpace = layoutContext.trailingSpace;
        this.hyphContext = layoutContext.hyphContext;
        this.bpAlignment = layoutContext.bpAlignment;
        this.dSpaceAdjust = layoutContext.dSpaceAdjust;
        this.ipdAdjust = layoutContext.ipdAdjust;
        this.alignmentContext = layoutContext.alignmentContext;
        this.lineStartBorderAndPaddingWidth = layoutContext.lineStartBorderAndPaddingWidth;
        this.lineEndBorderAndPaddingWidth = layoutContext.lineEndBorderAndPaddingWidth;
        this.copyPendingMarksFrom(layoutContext);
        this.pendingKeepWithNext = layoutContext.pendingKeepWithNext;
        this.pendingKeepWithPrevious = layoutContext.pendingKeepWithPrevious;
        this.disableColumnBalancing = layoutContext.disableColumnBalancing;
        this.lineBreakStatus = layoutContext.lineBreakStatus;
    }

    private LayoutContext(int n2) {
        this.flags = n2;
        this.refIPD = 0;
        this.stackLimitBP = MinOptMax.ZERO;
        this.leadingSpace = null;
        this.trailingSpace = null;
    }

    public void copyPendingMarksFrom(LayoutContext layoutContext) {
        if (layoutContext.pendingAfterMarks != null) {
            this.pendingAfterMarks = new ArrayList<ListElement>(layoutContext.pendingAfterMarks);
        }
        if (layoutContext.pendingBeforeMarks != null) {
            this.pendingBeforeMarks = new ArrayList<ListElement>(layoutContext.pendingBeforeMarks);
        }
    }

    public void setFlags(int n2) {
        this.setFlags(n2, true);
    }

    public void setFlags(int n2, boolean bl) {
        this.flags = bl ? (this.flags |= n2) : (this.flags &= ~n2);
    }

    public void unsetFlags(int n2) {
        this.setFlags(n2, false);
    }

    public void propagateFlagsFrom(LayoutContext layoutContext) {
        this.flags = layoutContext.flags & 0x2E0;
    }

    public boolean isStart() {
        return (this.flags & 1) != 0;
    }

    public boolean startsNewArea() {
        return (this.flags & 1) != 0 && this.leadingSpace != null;
    }

    public boolean isFirstArea() {
        return (this.flags & 4) != 0;
    }

    public boolean isLastArea() {
        return (this.flags & 8) != 0;
    }

    public boolean suppressBreakBefore() {
        return (this.flags & 2) != 0;
    }

    public boolean isColumnBalancingDisabled() {
        return (this.flags & 0x100) != 0;
    }

    public void disableColumnBalancing() {
        this.setFlags(256, true);
    }

    public void enableColumnBalancing() {
        this.unsetFlags(256);
    }

    public void setChildOfAutoLayoutElement(boolean bl) {
        this.setFlags(128, bl);
    }

    public boolean isChildOfAutoLayoutElement() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isInAutoLayoutDeterminationMode() {
        return (this.flags & 0x40) != 0;
    }

    public void setInAutoLayoutDeterminationMode(boolean bl) {
        this.setFlags(64, bl);
    }

    public Keep getKeepWithNextPending() {
        return this.pendingKeepWithNext;
    }

    public Keep getKeepWithPreviousPending() {
        return this.pendingKeepWithPrevious;
    }

    public void clearKeepWithNextPending() {
        this.pendingKeepWithNext = Keep.KEEP_AUTO;
    }

    public void clearKeepWithPreviousPending() {
        this.pendingKeepWithPrevious = Keep.KEEP_AUTO;
    }

    public void clearKeepsPending() {
        this.clearKeepWithPreviousPending();
        this.clearKeepWithNextPending();
    }

    public void updateKeepWithNextPending(Keep keep) {
        this.pendingKeepWithNext = this.pendingKeepWithNext.compare(keep);
    }

    public void updateKeepWithPreviousPending(Keep keep) {
        this.pendingKeepWithPrevious = this.pendingKeepWithPrevious.compare(keep);
    }

    public boolean isKeepWithNextPending() {
        return !this.getKeepWithNextPending().isAuto();
    }

    public boolean isKeepWithPreviousPending() {
        return !this.getKeepWithPreviousPending().isAuto();
    }

    public void setLeadingSpace(SpaceSpecifier spaceSpecifier) {
        this.leadingSpace = spaceSpecifier;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.leadingSpace;
    }

    public boolean resolveLeadingSpace() {
        return (this.flags & 0x10) != 0;
    }

    public void setTrailingSpace(SpaceSpecifier spaceSpecifier) {
        this.trailingSpace = spaceSpecifier;
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.trailingSpace;
    }

    public void addPendingAfterMark(UnresolvedListElementWithLength unresolvedListElementWithLength) {
        if (this.pendingAfterMarks == null) {
            this.pendingAfterMarks = new ArrayList<ListElement>();
        }
        this.pendingAfterMarks.add((ListElement)unresolvedListElementWithLength);
    }

    public List<ListElement> getPendingAfterMarks() {
        if (this.pendingAfterMarks != null) {
            return Collections.unmodifiableList(this.pendingAfterMarks);
        }
        return null;
    }

    public void clearPendingMarks() {
        this.pendingBeforeMarks = null;
        this.pendingAfterMarks = null;
    }

    public void addPendingBeforeMark(UnresolvedListElementWithLength unresolvedListElementWithLength) {
        if (this.pendingBeforeMarks == null) {
            this.pendingBeforeMarks = new ArrayList<ListElement>();
        }
        this.pendingBeforeMarks.add((ListElement)unresolvedListElementWithLength);
    }

    public List<ListElement> getPendingBeforeMarks() {
        if (this.pendingBeforeMarks != null) {
            return Collections.unmodifiableList(this.pendingBeforeMarks);
        }
        return null;
    }

    public void setStackLimitBP(MinOptMax minOptMax) {
        this.stackLimitBP = minOptMax;
    }

    public MinOptMax getStackLimitBP() {
        return this.stackLimitBP;
    }

    public void setRefIPD(int n2) {
        this.refIPD = n2;
    }

    public int getRefIPD() {
        return this.refIPD;
    }

    public void setHyphContext(HyphContext hyphContext) {
        this.hyphContext = hyphContext;
    }

    public HyphContext getHyphContext() {
        return this.hyphContext;
    }

    public void setBPAlignment(int n2) {
        this.bpAlignment = n2;
    }

    public int getBPAlignment() {
        return this.bpAlignment;
    }

    public void setSpaceAdjust(double d2) {
        this.dSpaceAdjust = d2;
    }

    public double getSpaceAdjust() {
        return this.dSpaceAdjust;
    }

    public void setIPDAdjust(double d2) {
        this.ipdAdjust = d2;
    }

    public double getIPDAdjust() {
        return this.ipdAdjust;
    }

    public void setAlignmentContext(AlignmentContext alignmentContext) {
        this.alignmentContext = alignmentContext;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public void resetAlignmentContext() {
        if (this.alignmentContext != null) {
            this.alignmentContext = this.alignmentContext.getParentAlignmentContext();
        }
    }

    public int getLineStartBorderAndPaddingWidth() {
        return this.lineStartBorderAndPaddingWidth;
    }

    public void setLineStartBorderAndPaddingWidth(int n2) {
        this.lineStartBorderAndPaddingWidth = n2;
    }

    public int getLineEndBorderAndPaddingWidth() {
        return this.lineEndBorderAndPaddingWidth;
    }

    public void setLineEndBorderAndPaddingWidth(int n2) {
        this.lineEndBorderAndPaddingWidth = n2;
    }

    public int getNextSpan() {
        return this.nextSpan;
    }

    public int getCurrentSpan() {
        return this.currentSpan == 0 ? 95 : this.currentSpan;
    }

    public void signalSpanChange(int n2) {
        switch (n2) {
            case 0: 
            case 5: 
            case 95: {
                this.currentSpan = this.nextSpan;
                this.nextSpan = n2;
                break;
            }
            default: {
                assert (false);
                throw new IllegalArgumentException("Illegal value on signalSpanChange() for span: " + n2);
            }
        }
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }

    public void setWritingMode(WritingMode writingMode) {
        this.writingMode = writingMode;
    }

    public int getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceBefore(int n2) {
        this.spaceBefore = n2;
    }

    public int getSpaceAfter() {
        return this.spaceAfter;
    }

    public void setSpaceAfter(int n2) {
        this.spaceAfter = n2;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public void setBreakBefore(int n2) {
        this.breakBefore = n2;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public void setBreakAfter(int n2) {
        this.breakAfter = n2;
    }

    public String toString() {
        return "Layout Context:\nStack Limit BPD: \t" + (this.getStackLimitBP() == null ? "null" : this.getStackLimitBP().toString()) + "\nTrailing Space: \t" + (this.getTrailingSpace() == null ? "null" : this.getTrailingSpace().toString()) + "\nLeading Space: \t" + (this.getLeadingSpace() == null ? "null" : this.getLeadingSpace().toString()) + "\nReference IPD: \t" + this.getRefIPD() + "\nSpace Adjust: \t" + this.getSpaceAdjust() + "\nIPD Adjust: \t" + this.getIPDAdjust() + "\nResolve Leading Space: \t" + this.resolveLeadingSpace() + "\nSuppress Break Before: \t" + this.suppressBreakBefore() + "\nIs First Area: \t" + this.isFirstArea() + "\nStarts New Area: \t" + this.startsNewArea() + "\nIs Last Area: \t" + this.isLastArea() + "\nKeeps: \t[keep-with-next=" + this.getKeepWithNextPending() + "][keep-with-previous=" + this.getKeepWithPreviousPending() + "] pending\nBreaks: \tforced [" + (this.breakBefore != 9 ? "break-before" : "") + "][" + (this.breakAfter != 9 ? "break-after" : "") + "]";
    }

    public int getDisableColumnBalancing() {
        return this.disableColumnBalancing;
    }

    public void setDisableColumnBalancing(int n2) {
        this.disableColumnBalancing = n2;
    }

    public boolean treatAsArtifact() {
        return (this.flags & 0x20) != 0;
    }

    public void setTreatAsArtifact(boolean bl) {
        this.setFlags(32, bl);
    }

    public void setLineBreakStatus(LineBreakStatus lineBreakStatus) {
        this.lineBreakStatus = lineBreakStatus;
    }

    public LineBreakStatus getLineBreakStatus() {
        return this.lineBreakStatus;
    }

    public void setInRotatedBlockLayoutDeterminationMode(boolean bl) {
        this.setFlags(512, bl);
    }

    public boolean isInRotatedBlockLayoutDeterminationMode() {
        return (this.flags & 0x200) != 0;
    }
}

