/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BorderElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;

public class CSSMarginsUtil {
    private static Log log = LogFactory.getLog(CSSMarginsUtil.class);

    private CSSMarginsUtil() {
    }

    static void moveFirstAbsoluteSiblingAfterSpacesBefore(List<ListElement> list) {
        ListElement listElement;
        int n2 = list.size();
        if (n2 > 2 && CSSMarginsUtil.isAbsoluteBlockArtifact(listElement = list.get(0))) {
            ListElement listElement2 = list.get(1);
            ListElement listElement3 = list.get(2);
            if (listElement2 instanceof BreakElement && listElement3 instanceof UnresolvedListElementWithLength && ((UnresolvedListElementWithLength)listElement3).isFirst()) {
                list.set(0, listElement3);
                list.set(1, listElement);
                list.set(2, listElement2);
            }
        }
    }

    static void moveLastAbsoluteSiblingsBeforeSpacesAfter(List<ListElement> list) {
        ListElement listElement;
        int n2 = list.size();
        if (n2 > 2 && CSSMarginsUtil.isAbsoluteBlockArtifact(listElement = list.get(n2 - 1))) {
            ListElement listElement2 = list.get(n2 - 3);
            ListElement listElement3 = list.get(n2 - 2);
            if (listElement3 instanceof BreakElement && listElement2 instanceof UnresolvedListElementWithLength && ((UnresolvedListElementWithLength)listElement2).isLast()) {
                list.set(n2 - 3, listElement3);
                list.set(n2 - 2, listElement);
                list.set(n2 - 1, listElement2);
            }
        }
    }

    private static boolean isAbsoluteBlockArtifact(ListElement listElement) {
        return listElement.isBox() && ((KnuthBox)listElement).getWidth() == 0;
    }

    public static void collapseSpacesBefore(BlockStackingLayoutManager blockStackingLayoutManager, List<ListElement> list, List<ListElement> list2) {
        SpaceElement spaceElement = CSSMarginsUtil.getFirstElementIfSpaceBefore(list);
        if (spaceElement != null) {
            boolean bl = true;
            if (!list2.isEmpty()) {
                ListElement listElement = list2.get(0);
                SpaceElement spaceElement2 = CSSMarginsUtil.getFirstElementIfSpaceBefore(list2);
                if (spaceElement2 != null) {
                    if (spaceElement.getLength().getOpt() > spaceElement2.getLength().getOpt()) {
                        log.trace((Object)"Space of current element is smaller than space of the child, fixing current space and removing the child space.");
                        spaceElement2.setLength(spaceElement.getLength());
                        list.remove((Object)spaceElement);
                    } else {
                        log.trace((Object)"Space of current element is larger than the space of the child, no fixing.");
                    }
                    bl = false;
                } else if (listElement instanceof BorderElement) {
                    log.trace((Object)"The borders are fencing the margins, no fixing.");
                    bl = false;
                }
            }
            if (bl) {
                log.trace((Object)"Space of current element is missing, fixing with one similar into the child");
                list2.add(0, (ListElement)new SpaceElement(spaceElement, blockStackingLayoutManager.getAuxiliaryPosition()));
                list.remove((Object)spaceElement);
            }
        }
    }

    public static void collapseSpacesAfter(BlockStackingLayoutManager blockStackingLayoutManager, List<ListElement> list, List<ListElement> list2) {
        SpaceElement spaceElement = CSSMarginsUtil.getLastElementIfSpaceAfter(list);
        if (spaceElement != null) {
            boolean bl = true;
            if (!list2.isEmpty()) {
                ListElement listElement = list2.get(list2.size() - 1);
                SpaceElement spaceElement2 = CSSMarginsUtil.getLastElementIfSpaceAfter(list2);
                if (spaceElement2 != null) {
                    if (spaceElement2 == spaceElement) {
                        log.trace((Object)"No space element provided, should add a space.");
                        bl = true;
                    } else if (spaceElement.getLength().getOpt() >= spaceElement2.getLength().getOpt()) {
                        log.trace((Object)"Space of current element is smaller than space of the child, fixing current space and removing the child space.");
                        spaceElement2.setLength(spaceElement.getLength());
                        list.remove((Object)spaceElement);
                        bl = false;
                    } else {
                        log.trace((Object)"Space of current element is larger than the space of the child, no fixing.");
                        bl = false;
                    }
                } else if (listElement instanceof BorderElement) {
                    log.trace((Object)"The borders are fencing the margins, no fixing.");
                    bl = false;
                }
            }
            if (bl) {
                log.trace((Object)"Space of current element is missing, fixing with one similar into the child");
                list2.add((ListElement)new SpaceElement(spaceElement, blockStackingLayoutManager.getAuxiliaryPosition()));
                list2.remove((Object)spaceElement);
            }
        }
    }

    private static SpaceElement getFirstElementIfSpaceBefore(List<ListElement> list) {
        ListElement listElement;
        SpaceElement spaceElement = null;
        if (!list.isEmpty() && (listElement = list.get(0)) instanceof SpaceElement && ((SpaceElement)listElement).isFirst()) {
            spaceElement = (SpaceElement)listElement;
        }
        return spaceElement;
    }

    private static SpaceElement getLastElementIfSpaceAfter(List<ListElement> list) {
        ListElement listElement;
        SpaceElement spaceElement = null;
        if (!list.isEmpty() && (listElement = list.get(list.size() - 1)) instanceof SpaceElement && ((SpaceElement)listElement).isLast()) {
            spaceElement = (SpaceElement)listElement;
        }
        return spaceElement;
    }
}

