/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.LineArea;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class BlockLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager
implements BreakOpportunity {
    private static Log log = LogFactory.getLog(BlockLayoutManager.class);
    private Block curBlockArea;
    protected ListIterator<LayoutManager> proxyLMiter = new ProxyLMiter();
    private int lead = 12000;
    private Length lineHeight;
    private int follow = 2000;

    public BlockLayoutManager(org.apache.fop.fo.flow.Block block) {
        super((FObj)block);
    }

    public void initialize() {
        super.initialize();
        org.apache.fop.fo.flow.Block block = this.getBlockFO();
        FontInfo fontInfo = block.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = block.getCommonFont().getFontState(fontInfo);
        Font font = fontInfo.getFontInstance(fontTripletArray[0], this.getBlockFO().getCommonFont().fontSize.getValue((PercentBaseContext)this));
        this.lead = font.getAscender();
        this.follow = -font.getDescender();
        this.lineHeight = block.getLineHeight().getOptimum((PercentBaseContext)this).getLength();
        this.startIndent = block.getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        this.endIndent = block.getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
        this.foSpaceBefore = new SpaceVal(block.getCommonMarginBlock().spaceBefore, (PercentBaseContext)this).getSpace();
        this.foSpaceAfter = new SpaceVal(block.getCommonMarginBlock().spaceAfter, (PercentBaseContext)this).getSpace();
        this.adjustedSpaceBefore = block.getCommonMarginBlock().spaceBefore.getSpace().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
        this.adjustedSpaceAfter = block.getCommonMarginBlock().spaceAfter.getSpace().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
    }

    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.getBlockFO().getCommonBorderPaddingBackground();
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        return this.getNextKnuthElements(layoutContext, n2, null, null, null);
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        this.resetSpaces();
        return super.getNextKnuthElements(layoutContext, n2, stack, position, layoutManager);
    }

    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n2, Stack stack, Position position, LayoutManager layoutManager2) {
        layoutContext2.copyPendingMarksFrom(layoutContext);
        if (layoutManager instanceof LineLayoutManager) {
            layoutContext2.setRefIPD(this.getContentAreaIPD());
        }
        if (layoutManager == this.childLMs.get(0)) {
            layoutContext2.setFlags(2);
        }
        if (stack == null) {
            return layoutManager.getNextKnuthElements(layoutContext2, n2);
        }
        if (layoutManager instanceof LineLayoutManager) {
            if (!(position instanceof LeafPosition)) {
                position = null;
            }
            return ((LineLayoutManager)layoutManager).getNextKnuthElements(layoutContext2, n2, (LeafPosition)position);
        }
        return layoutManager.getNextKnuthElements(layoutContext2, n2, stack, position, layoutManager2);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public boolean createNextChildLMs(int n2) {
        while (this.proxyLMiter.hasNext()) {
            LayoutManager layoutManager = this.proxyLMiter.next();
            if (layoutManager instanceof InlineLevelLayoutManager) {
                LineLayoutManager lineLayoutManager = this.createLineManager(layoutManager);
                this.addChildLM(lineLayoutManager);
            } else {
                this.addChildLM(layoutManager);
            }
            if (n2 >= this.childLMs.size()) continue;
            return true;
        }
        return false;
    }

    private LineLayoutManager createLineManager(LayoutManager layoutManager) {
        LineLayoutManager lineLayoutManager = new LineLayoutManager(this.getBlockFO(), this.lineHeight, this.lead, this.follow);
        ArrayList<LayoutManager> arrayList = new ArrayList<LayoutManager>();
        arrayList.add(layoutManager);
        while (this.proxyLMiter.hasNext()) {
            LayoutManager layoutManager2 = this.proxyLMiter.next();
            if (layoutManager2 instanceof InlineLevelLayoutManager) {
                arrayList.add(layoutManager2);
                continue;
            }
            this.proxyLMiter.previous();
            break;
        }
        lineLayoutManager.addChildLMs(arrayList);
        return lineLayoutManager;
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getBlockFO().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getBlockFO().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getBlockFO().getKeepWithNext();
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        LayoutManager layoutManager;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance((int)layoutContext.getSpaceBefore()));
        }
        LayoutManager layoutManager2 = null;
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            layoutContext2.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        LinkedList<Position> linkedList = new LinkedList<Position>();
        Position position = null;
        Position position2 = null;
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            Position position4 = position3;
            if (position3 instanceof NonLeafPosition) {
                position4 = position3.getPosition();
            }
            if (position4 == null || position4.getLM() == this && !(position4 instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            linkedList.add(position4);
            layoutManager2 = position4.getLM();
        }
        this.addId();
        this.registerMarkers(true, this.isFirst(position), this.isLast(position2));
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            layoutContext2.setFlags(8, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator2, layoutContext2);
        }
        this.registerMarkers(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addSpaceBeforeAfter((Area)this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        TraitSetter.setVisibility((Area)this.curBlockArea, this.getBlockFO().getVisibility());
        TraitSetter.addBorders((Area)this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.curBlockArea.setIPD(super.getContentAreaIPD());
            this.curBlockArea.setBidiLevel(this.getBlockFO().getBidiLevelRecursive());
            this.transferForeignAttributes((AreaTreeObject)this.curBlockArea);
            TraitSetter.addBreaks((Area)this.curBlockArea, this.getBlockFO().getBreakBefore(), this.getBlockFO().getBreakAfter());
            this.parentLayoutManager.getParentArea((Area)this.curBlockArea);
            TraitSetter.setProducerID((Area)this.curBlockArea, this.getBlockFO().getId());
            TraitSetter.addPadding((Area)this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addMargins((Area)this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, (PercentBaseContext)this);
            TraitSetter.setLayer((Area)this.curBlockArea, this.getBlockFO().getLayer());
            this.curBlockArea.setLocale(this.getBlockFO().getCommonHyphenation().getLocale());
            this.curBlockArea.setLocation(FONode.getLocatorString(this.getBlockFO().getLocator()));
            this.setCurrentArea((BlockParent)this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            if (area instanceof LineArea) {
                this.curBlockArea.addLineArea((LineArea)area);
            } else {
                this.curBlockArea.addBlock((Block)area);
            }
        }
    }

    protected void flush() {
        if (this.curBlockArea != null) {
            TraitSetter.addBackground((Area)this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), (PercentBaseContext)this);
            super.flush();
        }
    }

    protected org.apache.fop.fo.flow.Block getBlockFO() {
        return (org.apache.fop.fo.flow.Block)this.fobj;
    }

    public int getContentAreaIPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getIPD();
        }
        return super.getContentAreaIPD();
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        return -1;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public int getMaximumIPD() {
        int n2 = super.getMaximumIPD() + this.getMBP();
        return n2;
    }

    public int getMinimumIPD() {
        int n2 = super.getMinimumIPD() + this.getMBP();
        return n2;
    }

    public int getMBP() {
        org.apache.fop.fo.flow.Block block = this.getBlockFO();
        CommonMarginBlock commonMarginBlock = block.getCommonMarginBlock();
        CommonBorderPaddingBackground commonBorderPaddingBackground = block.getCommonBorderPaddingBackground();
        int n2 = (int)Math.ceil(commonMarginBlock.marginLeft.getNumericValue((PercentBaseContext)this) + commonMarginBlock.marginRight.getNumericValue((PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingStart(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingEnd(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getBorderStartWidth(false) + (double)commonBorderPaddingBackground.getBorderEndWidth(false));
        return n2;
    }

    protected int getBPIndents() {
        return this.getBlockFO().getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, (PercentBaseContext)this);
    }

    protected class ProxyLMiter
    extends LMiter {
        public ProxyLMiter() {
            super((LayoutManager)((Object)BlockLayoutManager.this));
            this.listLMs = new ArrayList(10);
        }

        public boolean hasNext() {
            return this.curPos < this.listLMs.size() || this.createNextChildLMs(this.curPos);
        }

        protected boolean createNextChildLMs(int n2) {
            List list = BlockLayoutManager.this.createChildLMs(n2 + 1 - this.listLMs.size());
            if (list != null) {
                this.listLMs.addAll(list);
            }
            return n2 < this.listLMs.size();
        }
    }
}

