/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BorderElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.CSSMarginsUtil;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.ExternalGraphicLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.traits.WritingMode;

public class BlockContainerLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager
implements BreakOpportunity {
    private static Log log = LogFactory.getLog(BlockContainerLayoutManager.class);
    private BlockViewport viewportBlockArea;
    private Block referenceArea;
    private CommonAbsolutePosition abProps;
    private FODimension relDims;
    private CTM absoluteCTM;
    private Length width;
    private Length height;
    private Length minHeight;
    private int vpContentBPD;
    private boolean autoHeight = true;
    private boolean inlineElementList;
    private MinOptMax foBlockSpaceBefore;
    private MinOptMax foBlockSpaceAfter;
    private int horizontalOverflow;
    private double contentRectOffsetX;
    private double contentRectOffsetY;
    private CommonRelativePosition relProps;
    private static Class[] IGNORABLE_IMAGE_OVERFLOW_PATH = new Class[]{BlockLayoutManager.class, LineLayoutManager.class, InlineLayoutManager.class, ExternalGraphicLayoutManager.class};

    public BlockContainerLayoutManager(BlockContainer blockContainer) {
        super((FObj)blockContainer);
        this.setGeneratesBlockArea(true);
    }

    public void initialize() {
        this.abProps = this.getBlockContainerFO().getCommonAbsolutePosition();
        this.relProps = this.getBlockContainerFO().getCommonRelativePosition();
        this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore, (PercentBaseContext)this).getSpace();
        this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter, (PercentBaseContext)this).getSpace();
        this.startIndent = this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        this.endIndent = this.getBlockContainerFO().getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
        if (this.blockProgressionDirectionChanges()) {
            this.height = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getLength();
            this.minHeight = this.getBlockContainerFO().getInlineProgressionDimension().getMinimum((PercentBaseContext)this).getLength();
            this.width = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum((PercentBaseContext)this).getLength();
        } else {
            this.height = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum((PercentBaseContext)this).getLength();
            this.minHeight = this.getBlockContainerFO().getBlockProgressionDimension().getMinimum((PercentBaseContext)this).getLength();
            this.width = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getLength();
        }
        this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
        this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
    }

    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.getBlockContainerFO().getCommonBorderPaddingBackground();
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    protected int getRotatedIPD() {
        return this.getBlockContainerFO().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
    }

    private boolean needClip() {
        int n2 = this.getBlockContainerFO().getOverflow();
        return n2 == 57 || n2 == 42;
    }

    private int getBPIndents() {
        int n2 = 0;
        return n2 += this.getBlockContainerFO().getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, (PercentBaseContext)this);
    }

    protected boolean isAbsoluteOrFixed() {
        return this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51;
    }

    private boolean isFixed() {
        return this.abProps.absolutePosition == 51;
    }

    public int getContentAreaBPD() {
        if (this.autoHeight) {
            return -1;
        }
        return this.vpContentBPD;
    }

    public int getBorderAreaBPD() {
        return this.viewportBlockArea.getBPD() + this.getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, (PercentBaseContext)this);
    }

    public int getBorderAreaIPD() {
        return this.viewportBlockArea.getIPD() + this.getCommonBorderPaddingBackground().getIPPaddingAndBorder(false, (PercentBaseContext)this);
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        return this.getNextKnuthElements(layoutContext, n2, null, null, null);
    }

    protected LayoutContext makeChildLayoutContext(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = LayoutContext.newInstance();
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP().minus(MinOptMax.getInstance((int)this.relDims.bpd)));
        layoutContext2.setRefIPD(this.relDims.ipd);
        layoutContext2.setWritingMode(this.getBlockContainerFO().getWritingMode());
        layoutContext2.setInAutoLayoutDeterminationMode(layoutContext.isInAutoLayoutDeterminationMode());
        layoutContext2.setInRotatedBlockLayoutDeterminationMode(layoutContext.isInRotatedBlockLayoutDeterminationMode());
        return layoutContext2;
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        List list = this.getNextKnuthElementsInternal(layoutContext, n2, stack, position, layoutManager);
        this.generateBoxForMinHeight(list, layoutContext);
        return list;
    }

    private List imposeMinHeight(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager, List list) {
        if (this.minHeight.getEnum() != 9) {
            int n3 = ElementListUtils.calcContentLength((List)list);
            if (this.minHeight.getValue((PercentBaseContext)this) > n3) {
                log.info((Object)"The block container is smaller than the minimum width. Doing a relayout.");
                this.height = this.minHeight;
                this.reset();
                this.dump("Before relayout ", list);
                list = this.getNextKnuthElementsInternal(layoutContext, n2, stack, position, layoutManager);
                this.dump("After relayout ", list);
            }
        }
        return list;
    }

    private void dump(String string, List<ListElement> list) {
        if (log.isDebugEnabled()) {
            log.debug((Object)string);
            for (ListElement listElement : list) {
                log.debug((Object)(" " + listElement + "\t" + listElement.getPosition()));
            }
        }
    }

    public List getNextKnuthElementsInternal(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        this.resetSpaces();
        if (this.isAbsoluteOrFixed()) {
            return this.getNextKnuthElementsAbsolute(layoutContext);
        }
        boolean bl = stack != null;
        boolean bl2 = !bl || stack.isEmpty();
        this.setupAreaDimensions(layoutContext);
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList2)) {
            return linkedList2;
        }
        this.addFirstVisibleMarks(linkedList2, layoutContext, n2);
        if (this.autoHeight && this.inlineElementList) {
            LayoutManager layoutManager2;
            LayoutManager layoutManager3 = null;
            if (bl) {
                if (bl2) {
                    assert (layoutManager != null && layoutManager.getParent() == this);
                    layoutManager2 = layoutManager;
                } else {
                    layoutManager2 = (LayoutManager)stack.pop();
                }
                this.setCurrentChildLM(layoutManager2);
            } else {
                layoutManager2 = this.getChildLM();
            }
            while (layoutManager2 != null) {
                List<ListElement> list;
                LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
                if (!bl || bl2) {
                    if (bl) {
                        layoutManager2.reset();
                    }
                    list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n2, null, null, null);
                } else {
                    list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n2, stack, position, layoutManager);
                    bl2 = true;
                }
                if (linkedList.isEmpty() && layoutContext2.isKeepWithPreviousPending()) {
                    layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
                    layoutContext2.clearKeepWithPreviousPending();
                }
                if (list.size() == 1 && ElementListUtils.startsWithForcedBreak(list)) {
                    linkedList.addAll(list);
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                if (layoutManager3 != null) {
                    this.addInBetweenBreak(linkedList, layoutContext, layoutContext2);
                }
                linkedList.addAll(list);
                if (list.isEmpty()) continue;
                if (ElementListUtils.endsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        this.setFinished(true);
                    }
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
                layoutContext2.clearKeepsPending();
                layoutManager3 = layoutManager2;
                layoutManager2 = this.getChildLM();
            }
            CSSMarginsUtil.moveFirstAbsoluteSiblingAfterSpacesBefore(linkedList);
            CSSMarginsUtil.moveLastAbsoluteSiblingsBeforeSpacesAfter(linkedList);
            CSSMarginsUtil.collapseSpacesBefore((BlockStackingLayoutManager)((Object)this), linkedList, linkedList2);
            this.wrapPositionElements(linkedList, linkedList2);
        } else {
            linkedList2.add((ListElement)this.generateNonInlinedBox(layoutContext));
        }
        this.addLastVisibleMarks(linkedList2, layoutContext, n2);
        CSSMarginsUtil.collapseSpacesAfter((BlockStackingLayoutManager)((Object)this), linkedList, linkedList2);
        this.addKnuthElementsForBreakAfter(linkedList2, layoutContext);
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        this.reportHorizontalContentOverflow(layoutContext);
        this.setFinished(true);
        return linkedList2;
    }

    private void generateBoxForMinHeight(List<ListElement> list, LayoutContext layoutContext) {
        if (this.shouldApplyMinHeightConstraint()) {
            int n2 = ElementListUtils.calcContentLength(list);
            int n3 = this.minHeight.getValue() - n2;
            if (n3 > 0) {
                ListElement listElement;
                int n4 = -1;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    listElement = list.get(i2);
                    if (listElement.isBox()) {
                        n4 = i2;
                        continue;
                    }
                    if (!listElement.isUnresolvedElement()) continue;
                    n4 = i2;
                    if (!(listElement instanceof BorderElement)) continue;
                    --n4;
                }
                BreakElement breakElement = new BreakElement(this.getAuxiliaryPosition(), 0, layoutContext);
                listElement = new KnuthBox(n3, (Position)new MinHeightNonLeafPosition(n3), true);
                if (n4 >= 0) {
                    list.add(n4 + 1, (ListElement)breakElement);
                    list.add(n4 + 2, listElement);
                } else {
                    list.add((ListElement)breakElement);
                    list.add(listElement);
                }
            }
        }
    }

    private void setupAreaDimensions(LayoutContext layoutContext) {
        int n2;
        int n3;
        this.autoHeight = false;
        int n4 = layoutContext.getStackLimitBP().getOpt();
        BlockContainer blockContainer = this.getBlockContainerFO();
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            n3 = n4;
            this.autoHeight = true;
            this.inlineElementList = blockContainer.getReferenceOrientation() == 0;
        } else {
            n3 = this.height.getValue((PercentBaseContext)this);
            n3 += this.getBPIndents();
        }
        this.vpContentBPD = n3 - this.getBPIndents();
        this.referenceIPD = layoutContext.getRefIPD();
        if (this.width.getEnum() == 9) {
            this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext);
        } else {
            n2 = this.width.getValue((PercentBaseContext)this);
            this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext, n2);
        }
        this.contentRectOffsetX = 0.0;
        this.contentRectOffsetY = 0.0;
        n2 = blockContainer.getBidiLevel();
        this.contentRectOffsetX = n2 < 0 || (n2 & 1) == 0 ? (this.contentRectOffsetX += (double)blockContainer.getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this)) : (this.contentRectOffsetX += (double)blockContainer.getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this));
        this.contentRectOffsetY += (double)blockContainer.getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.contentRectOffsetY += (double)blockContainer.getCommonBorderPaddingBackground().getPaddingBefore(false, (PercentBaseContext)this);
        this.updateRelDims();
        int n5 = this.referenceIPD - this.getIPIndents();
        if (this.getContentAreaIPD() > n5) {
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(blockContainer.getUserAgent().getEventBroadcaster());
            blockLevelEventProducer.objectTooWide((Object)this, blockContainer.getName(), this.getContentAreaIPD(), layoutContext.getRefIPD(), blockContainer.getLocator());
        }
    }

    private KnuthBox generateNonInlinedBox(LayoutContext layoutContext) {
        Object object;
        boolean bl;
        BlockContainerBreaker blockContainerBreaker;
        if (this.blockProgressionDirectionChanges()) {
            blockContainerBreaker = this.applyBreakerWhenDirectionChanges(layoutContext);
            bl = blockContainerBreaker.isOverflow();
        } else {
            object = MinOptMax.getInstance((int)this.relDims.ipd);
            blockContainerBreaker = new BlockContainerBreaker(this, (MinOptMax)object, false);
            blockContainerBreaker.doLayout(this.relDims.bpd, this.autoHeight);
            bl = blockContainerBreaker.isOverflow();
            if (this.autoHeight) {
                int n2 = blockContainerBreaker.deferredAlg.totalWidth;
                if (this.blockProgressionDirectionChanges()) {
                    this.setContentAreaIPD(n2);
                } else {
                    this.vpContentBPD = n2;
                }
                this.updateRelDims();
            }
        }
        object = new BlockContainerPosition((LayoutManager)((Object)this), blockContainerBreaker);
        KnuthBox knuthBox = new KnuthBox(this.vpContentBPD, this.notifyPos((Position)object), false);
        if (bl && !this.ignoreImageOverflow()) {
            this.reportVerticalOverflow(blockContainerBreaker);
        }
        return knuthBox;
    }

    private boolean ignoreImageOverflow() {
        Boolean bl = null;
        if (!this.autoHeight) {
            Object object = this;
            for (Class clazz : IGNORABLE_IMAGE_OVERFLOW_PATH) {
                List<LayoutManager> list = ((AbstractLayoutManager)object).getChildLMs();
                if (list.size() != 1) {
                    bl = Boolean.FALSE;
                    break;
                }
                AbstractLayoutManager abstractLayoutManager = (AbstractLayoutManager)list.get(0);
                if (!clazz.isInstance(abstractLayoutManager)) {
                    bl = Boolean.FALSE;
                    break;
                }
                object = abstractLayoutManager;
            }
            if (bl == null && object instanceof ExternalGraphicLayoutManager) {
                ExternalGraphicLayoutManager externalGraphicLayoutManager = (ExternalGraphicLayoutManager)((Object)object);
                ExternalGraphic externalGraphic = (ExternalGraphic)externalGraphicLayoutManager.getFObj();
                bl = externalGraphic.getHeight().getEnum() != 9 ? Boolean.valueOf(externalGraphic.getHeight().getValue() == this.height.getValue()) : Boolean.valueOf(externalGraphic.getContentHeight().getValue() == this.height.getValue());
            }
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private void reportVerticalOverflow(BlockContainerBreaker blockContainerBreaker) {
        BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getBlockContainerFO().getUserAgent().getEventBroadcaster());
        boolean bl = this.getBlockContainerFO().getOverflow() != 42;
        blockLevelEventProducer.viewportBPDOverflow((Object)this, this.getNameAndContextInfo(), blockContainerBreaker.getOverflowAmount(), this.needClip(), bl, this.getBlockContainerFO().getLocator());
    }

    private void reportHorizontalContentOverflow(LayoutContext layoutContext) {
        if (this.horizontalOverflow > 0 && !layoutContext.isInRotatedBlockLayoutDeterminationMode() && !layoutContext.isInAutoLayoutDeterminationMode()) {
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getBlockContainerFO().getUserAgent().getEventBroadcaster());
            boolean bl = this.getBlockContainerFO().getOverflow() != 42;
            blockLevelEventProducer.viewportIPDOverflow((Object)this, this.getNameAndContextInfo(), this.horizontalOverflow, this.needClip(), bl, this.getBlockContainerFO().getLocator());
        }
    }

    private BlockContainerBreaker applyBreakerWhenDirectionChanges(LayoutContext layoutContext) {
        MinOptMax minOptMax = MinOptMax.getInstance((int)0);
        BlockContainerBreaker blockContainerBreaker = new BlockContainerBreaker(this, minOptMax, true);
        if (this.autoHeight) {
            blockContainerBreaker.doLayout(Integer.MAX_VALUE, this.autoHeight);
            this.vpContentBPD = super.getMinimumIPD();
            int n2 = blockContainerBreaker.deferredAlg.totalWidth;
            this.setContentAreaIPD(n2);
            this.updateRelDims();
            this.reset();
            minOptMax = MinOptMax.getInstance((int)this.relDims.ipd);
            blockContainerBreaker = new BlockContainerBreaker(this, minOptMax, false);
            blockContainerBreaker.doLayout(this.relDims.bpd, true);
            n2 = blockContainerBreaker.deferredAlg.totalWidth;
            this.setContentAreaIPD(n2);
            this.updateRelDims();
            if (n2 > layoutContext.getRefIPD()) {
                this.handleOverflow(n2 - layoutContext.getRefIPD());
            }
        } else {
            blockContainerBreaker.doLayout(this.relDims.bpd, this.autoHeight);
        }
        return blockContainerBreaker;
    }

    private boolean blockProgressionDirectionChanges() {
        return this.getBlockContainerFO().getReferenceOrientation() % 180 != 0;
    }

    public boolean isRestartable() {
        return true;
    }

    private List<ListElement> getNextKnuthElementsAbsolute(LayoutContext layoutContext) {
        int n2;
        int n3;
        int n4;
        this.autoHeight = false;
        boolean bl = this.blockProgressionDirectionChanges();
        Point point = this.getAbsOffset();
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            n4 = 0;
            if (this.abProps.bottom.getEnum() != 9) {
                n3 = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getHeight() : layoutContext.getStackLimitBP().getOpt();
                n4 = n3;
                n4 -= point.y;
                if (this.abProps.bottom.getEnum() != 9) {
                    if ((n4 -= this.abProps.bottom.getValue((PercentBaseContext)this)) < 0) {
                        n4 = 0;
                    }
                } else if (n4 < 0) {
                    n4 = 0;
                }
            } else {
                n4 = layoutContext.getStackLimitBP().getOpt();
                if (!bl) {
                    this.autoHeight = true;
                }
            }
        } else {
            n4 = this.height.getValue((PercentBaseContext)this);
            n4 += this.getBPIndents();
        }
        if (this.width.getEnum() == 9) {
            n3 = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getWidth() : layoutContext.getRefIPD();
            n2 = n3;
            if (this.abProps.left.getEnum() != 9) {
                n2 -= this.abProps.left.getValue((PercentBaseContext)this);
            }
            if (this.abProps.right.getEnum() != 9) {
                if ((n2 -= this.abProps.right.getValue((PercentBaseContext)this)) < 0) {
                    n2 = 0;
                }
            } else {
                if (n2 < 0) {
                    n2 = 0;
                }
                if (bl) {
                    this.autoHeight = true;
                }
            }
        } else {
            n2 = this.width.getValue((PercentBaseContext)this);
            n2 += this.getIPIndents();
        }
        this.vpContentBPD = n4 - this.getBPIndents();
        this.setContentAreaIPD(n2 - this.getIPIndents());
        this.contentRectOffsetX = 0.0;
        this.contentRectOffsetY = 0.0;
        this.updateRelDims();
        MinOptMax minOptMax = MinOptMax.getInstance((int)this.relDims.ipd);
        BlockContainerBreaker blockContainerBreaker = new BlockContainerBreaker(this, minOptMax, bl);
        blockContainerBreaker.doLayout(this.autoHeight ? 0 : this.relDims.bpd, this.autoHeight);
        boolean bl2 = blockContainerBreaker.isOverflow();
        if (this.autoHeight) {
            int n5 = blockContainerBreaker.deferredAlg.totalWidth;
            if (bl) {
                this.setContentAreaIPD(n5);
            } else {
                this.vpContentBPD = n5;
            }
            this.updateRelDims();
        }
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        if (!blockContainerBreaker.isEmpty()) {
            BlockContainerPosition blockContainerPosition = new BlockContainerPosition((LayoutManager)((Object)this), blockContainerBreaker);
            linkedList.add((ListElement)new KnuthBox(0, this.notifyPos((Position)blockContainerPosition), false));
            if (!this.autoHeight && bl2) {
                this.reportVerticalOverflow(blockContainerBreaker);
            }
        }
        this.reportHorizontalContentOverflow(layoutContext);
        this.setFinished(true);
        return linkedList;
    }

    private void updateRelDims() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.contentRectOffsetX, this.contentRectOffsetY, this.getContentAreaIPD(), this.vpContentBPD);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims((int)this.getBlockContainerFO().getReferenceOrientation(), (WritingMode)this.getBlockContainerFO().getWritingMode(), (Rectangle2D)double_, (FODimension)this.relDims);
    }

    private Point getAbsOffset() {
        int n2 = 0;
        int n3 = 0;
        if (this.abProps.left.getEnum() != 9) {
            n2 = this.abProps.left.getValue((PercentBaseContext)this);
        } else if (this.abProps.right.getEnum() != 9 && this.width.getEnum() != 9) {
            n2 = this.getReferenceAreaIPD() - this.abProps.right.getValue((PercentBaseContext)this) - this.width.getValue((PercentBaseContext)this);
        }
        if (this.abProps.top.getEnum() != 9) {
            n3 = this.abProps.top.getValue((PercentBaseContext)this);
        } else if (this.abProps.bottom.getEnum() != 9 && this.height.getEnum() != 9) {
            n3 = this.getReferenceAreaBPD() - this.abProps.bottom.getValue((PercentBaseContext)this) - this.height.getValue((PercentBaseContext)this);
        }
        return new Point(n2, n3);
    }

    private Point getRelOffset() {
        int n2 = 0;
        int n3 = 0;
        if (this.relProps.left.getEnum() != 9) {
            n2 = this.relProps.left.getValue((PercentBaseContext)this);
        } else if (this.relProps.right.getEnum() != 9) {
            n2 = -this.relProps.right.getValue((PercentBaseContext)this);
        }
        if (this.relProps.top.getEnum() != 9) {
            n3 = this.relProps.top.getValue((PercentBaseContext)this);
        } else if (this.relProps.bottom.getEnum() != 9) {
            n3 = -this.relProps.bottom.getValue((PercentBaseContext)this);
        }
        return new Point(n2, n3);
    }

    private Point getFixedOffset() {
        int n2 = 0;
        int n3 = 0;
        if (this.abProps.left.getEnum() != 9) {
            n2 = this.abProps.left.getValue((PercentBaseContext)this);
        } else if (this.abProps.right.getEnum() != 9 && this.width.getEnum() != 9) {
            n2 = this.getPageWidth() - this.abProps.right.getValue((PercentBaseContext)this) - this.width.getValue((PercentBaseContext)this);
        }
        if (this.abProps.top.getEnum() != 9) {
            n3 = this.abProps.top.getValue((PercentBaseContext)this);
        } else if (this.abProps.bottom.getEnum() != 9 && this.height.getEnum() != 9) {
            n3 = this.getReferenceAreaForFixedBPD() - this.abProps.bottom.getValue((PercentBaseContext)this) - this.height.getValue((PercentBaseContext)this);
        }
        return new Point(n2, n3);
    }

    public int getPageWidth() {
        return (int)this.getCurrentPV().getViewArea().getWidth();
    }

    protected int getReferenceAreaForFixedBPD() {
        return (int)this.getCurrentPV().getViewArea().getHeight();
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance((int)layoutContext.getSpaceBefore()));
        }
        LayoutManager layoutManager = null;
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            layoutContext2.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        BlockContainerPosition blockContainerPosition = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        Position position = null;
        Position position2 = null;
        int n2 = 0;
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            if (position3 instanceof MinHeightNonLeafPosition) {
                n2 = ((MinHeightNonLeafPosition)position3).getMinHeightDelta();
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            Position position4 = position3;
            if (position3 instanceof NonLeafPosition) {
                position4 = position3.getPosition();
            }
            if (position3 instanceof BlockContainerPosition) {
                if (blockContainerPosition != null) {
                    throw new IllegalStateException("Only one BlockContainerPosition allowed");
                }
                blockContainerPosition = (BlockContainerPosition)position3;
                continue;
            }
            if (position4 == null || position4.getLM() == this && !(position4 instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            linkedList.add(position4);
            layoutManager = position4.getLM();
        }
        this.addId();
        this.registerMarkers(true, this.isFirst(position), this.isLast(position2));
        if (blockContainerPosition == null) {
            LayoutManager layoutManager2;
            PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
            while ((layoutManager2 = positionIterator2.getNextChildLM()) != null) {
                layoutContext2.setFlags(8, layoutContext.isLastArea() && layoutManager2 == layoutManager);
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutManager2.addAreas(positionIterator2, layoutContext2);
            }
        } else {
            blockContainerPosition.getBreaker().addContainedAreas(layoutContext);
        }
        this.registerMarkers(false, this.isFirst(position), this.isLast(position2));
        if (n2 > 0) {
            this.referenceArea.setBPD(this.referenceArea.getAllocBPD() + n2);
        }
        TraitSetter.addSpaceBeforeAfter((Area)this.viewportBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        TraitSetter.addBorders((Area)this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
        this.viewportBlockArea = null;
        this.referenceArea = null;
        this.resetSpaces();
        this.notifyEndOfLayout();
    }

    public Area getParentArea(Area area) {
        if (this.referenceArea == null) {
            boolean bl = this.blockProgressionDirectionChanges();
            boolean bl2 = this.autoHeight && !bl;
            int n2 = this.getBlockContainerFO().getBidiLevel();
            this.viewportBlockArea = new BlockViewport(bl2);
            this.viewportBlockArea.setChangeBarList(this.getChangeBarList());
            this.viewportBlockArea.addTrait(Trait.IS_VIEWPORT_AREA, Boolean.TRUE);
            if (n2 >= 0) {
                this.viewportBlockArea.setBidiLevel(n2);
            }
            this.viewportBlockArea.setIPD(this.getContentAreaIPD());
            if (bl2) {
                this.viewportBlockArea.setBPD(0);
            } else {
                this.viewportBlockArea.setBPD(this.vpContentBPD);
            }
            this.transferForeignAttributes((AreaTreeObject)this.viewportBlockArea);
            TraitSetter.setProducerID((Area)this.viewportBlockArea, this.getBlockContainerFO().getId());
            TraitSetter.setLayer((Area)this.viewportBlockArea, this.getBlockContainerFO().getLayer());
            TraitSetter.addBorders((Area)this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addPadding((Area)this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addMargins((Area)this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, (PercentBaseContext)this);
            this.viewportBlockArea.setCTM(this.translateCTMConsideringBoderAndPaddingDiscards(this.absoluteCTM));
            this.viewportBlockArea.setClip(this.needClip());
            if (this.abProps.absolutePosition == 1) {
                Point point = this.getAbsOffset();
                this.viewportBlockArea.setXOffset(point.x);
                this.viewportBlockArea.setYOffset(point.y);
                this.viewportBlockArea.setAbsoluteTLBR(this.getAbsoluteTLBR());
            } else if (this.abProps.absolutePosition == 51) {
                Point point = this.getFixedOffset();
                this.viewportBlockArea.setXOffset(point.x);
                this.viewportBlockArea.setYOffset(point.y);
            } else if (this.relProps.relativePosition == 110) {
                Point point = this.getRelOffset();
                this.viewportBlockArea.setXOffset(point.x);
                this.viewportBlockArea.setYOffset(point.y);
            }
            this.referenceArea = new Block();
            this.referenceArea.setChangeBarList(this.getChangeBarList());
            this.referenceArea.addTrait(Trait.IS_REFERENCE_AREA, (Object)Boolean.TRUE);
            if (n2 >= 0) {
                this.referenceArea.setBidiLevel(n2);
            }
            TraitSetter.setProducerID((Area)this.referenceArea, this.getBlockContainerFO().getId());
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setPositioning(2);
            } else if (this.abProps.absolutePosition == 51) {
                this.viewportBlockArea.setPositioning(3);
            } else if (this.relProps.relativePosition == 110) {
                this.viewportBlockArea.setPositioning(1);
            }
            this.parentLayoutManager.getParentArea((Area)this.referenceArea);
            this.referenceArea.setIPD(this.relDims.ipd);
            this.setCurrentArea((BlockParent)this.viewportBlockArea);
        }
        return this.referenceArea;
    }

    private int[] getAbsoluteTLBR() {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        if (this.abProps.left.getEnum() != 9) {
            n4 = this.abProps.left.getValue((PercentBaseContext)this);
        }
        if (this.abProps.right.getEnum() != 9) {
            n5 = this.abProps.right.getValue((PercentBaseContext)this);
        }
        if (this.abProps.top.getEnum() != 9) {
            n2 = this.abProps.top.getValue((PercentBaseContext)this);
        }
        if (this.abProps.bottom.getEnum() != 9) {
            n3 = this.abProps.bottom.getValue((PercentBaseContext)this);
        }
        return new int[]{n2, n4, n3, n5};
    }

    public void addChildArea(Area area) {
        if (this.referenceArea != null) {
            this.referenceArea.addBlock((Block)area);
        }
    }

    protected void flush() {
        this.viewportBlockArea.addBlock(this.referenceArea, this.autoHeight);
        TraitSetter.addBackground((Area)this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), (PercentBaseContext)this);
        super.flush();
    }

    public int negotiateBPDAdjustment(int n2, KnuthElement knuthElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getBlockContainerFO().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getBlockContainerFO().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getBlockContainerFO().getKeepWithNext();
    }

    protected BlockContainer getBlockContainerFO() {
        return (BlockContainer)this.fobj;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    public boolean handleOverflow(int n2) {
        if (n2 > this.horizontalOverflow) {
            this.horizontalOverflow = n2;
        }
        return true;
    }

    public int getMaximumIPD() {
        if (this.blockProgressionDirectionChanges()) {
            return this.getContentAreaIPD() + this.getMBP();
        }
        int n2 = super.getMaximumIPD();
        int n3 = this.getCurrentWidthTakingIntoAccountAuto();
        int n4 = Math.max(n2, n3);
        return n4 + this.getMBP();
    }

    private int getCurrentWidthTakingIntoAccountAuto() {
        int n2 = 0;
        if (this.width.getEnum() != 9) {
            n2 = this.width.getValue((PercentBaseContext)this);
        }
        return n2;
    }

    public int getMinimumIPD() {
        if (this.blockProgressionDirectionChanges()) {
            return this.getContentAreaIPD() + this.getMBP();
        }
        int n2 = super.getMinimumIPD();
        int n3 = this.getCurrentWidthTakingIntoAccountAuto();
        int n4 = Math.max(n2, n3);
        return n4 + this.getMBP();
    }

    public int getMBP() {
        BlockContainer blockContainer = this.getBlockContainerFO();
        CommonMarginBlock commonMarginBlock = blockContainer.getCommonMarginBlock();
        CommonBorderPaddingBackground commonBorderPaddingBackground = blockContainer.getCommonBorderPaddingBackground();
        int n2 = (int)Math.ceil(commonMarginBlock.marginLeft.getNumericValue((PercentBaseContext)this) + commonMarginBlock.marginRight.getNumericValue((PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingStart(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingEnd(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getBorderStartWidth(false) + (double)commonBorderPaddingBackground.getBorderEndWidth(false));
        return n2;
    }

    private boolean shouldApplyMinHeightConstraint() {
        return this.height.getEnum() == 9 && this.minHeight.getEnum() != 9;
    }

    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n2, Stack stack, Position position, LayoutManager layoutManager2) {
        layoutContext2.copyPendingMarksFrom(layoutContext);
        return super.getNextChildElements(layoutManager, layoutContext, layoutContext2, n2, stack, position, layoutManager2);
    }

    private CTM translateCTMConsideringBoderAndPaddingDiscards(CTM cTM) {
        CTM cTM2 = cTM;
        if (this.contentRectOffsetY != 0.0) {
            int n2 = 0;
            if (this.discardBorderBefore) {
                n2 += this.getBlockContainerFO().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
            }
            if (this.discardPaddingBefore) {
                n2 += this.getBlockContainerFO().getCommonBorderPaddingBackground().getPaddingBefore(false, (PercentBaseContext)this);
            }
            cTM2 = cTM2.translate(0.0, (double)(-n2));
        }
        return cTM2;
    }

    protected void updateStartIndent(int n2) {
        this.startIndent = n2;
        this.contentRectOffsetX = n2;
        this.updateRelDims();
    }

    public boolean isFirst(Position position) {
        if (position instanceof MinHeightNonLeafPosition) {
            return false;
        }
        return super.isFirst(position);
    }

    public boolean isLast(Position position) {
        if (position instanceof MinHeightNonLeafPosition) {
            return false;
        }
        return super.isLast(position);
    }

    public void reset() {
        super.reset();
        this.horizontalOverflow = 0;
    }

    private class MinHeightNonLeafPosition
    extends NonLeafPosition {
        private int minHeightDelta;

        public MinHeightNonLeafPosition(int n2) {
            super((LayoutManager)((Object)BlockContainerLayoutManager.this), null);
            this.minHeightDelta = n2;
        }

        public String toString() {
            return "MinHeight" + super.toString();
        }

        public int getMinHeightDelta() {
            return this.minHeightDelta;
        }
    }

    private class BlockContainerBreaker
    extends AbstractBreaker {
        private BlockContainerLayoutManager bclm;
        private MinOptMax ipd;
        private PageBreakingAlgorithm deferredAlg;
        private AbstractBreaker.BlockSequence deferredOriginalList;
        private AbstractBreaker.BlockSequence deferredEffectiveList;
        boolean isInRotatedBlockLayoutDeterminationMode;

        public BlockContainerBreaker(BlockContainerLayoutManager blockContainerLayoutManager2, MinOptMax minOptMax, boolean bl) {
            this.bclm = blockContainerLayoutManager2;
            this.ipd = minOptMax;
            this.isInRotatedBlockLayoutDeterminationMode = bl;
        }

        protected void observeElementList(List list) {
            ElementListObserver.observe((List)list, (String)"block-container", (String)this.bclm.getBlockContainerFO().getId());
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        protected boolean isSinglePartFavored() {
            return true;
        }

        public int getDifferenceOfFirstPart() {
            AbstractBreaker.PageBreakPosition pageBreakPosition = (AbstractBreaker.PageBreakPosition)this.deferredAlg.getPageBreaks().getFirst();
            return pageBreakPosition.difference;
        }

        public boolean isOverflow() {
            return !this.isEmpty() && (this.deferredAlg.getPageBreaks().size() > 1 || this.deferredAlg.totalWidth - this.deferredAlg.totalShrink > this.deferredAlg.getLineWidth());
        }

        public int getOverflowAmount() {
            return this.deferredAlg.totalWidth - this.deferredAlg.totalShrink - this.deferredAlg.getLineWidth();
        }

        protected LayoutManager getTopLevelLM() {
            return this.bclm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext layoutContext = super.createLayoutContext();
            layoutContext.setRefIPD(this.ipd.getOpt());
            layoutContext.setWritingMode(BlockContainerLayoutManager.this.getBlockContainerFO().getWritingMode());
            layoutContext.setInRotatedBlockLayoutDeterminationMode(this.isInRotatedBlockLayoutDeterminationMode);
            return layoutContext;
        }

        protected List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
            LayoutManager layoutManager;
            LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
            while ((layoutManager = BlockContainerLayoutManager.this.getChildLM()) != null) {
                LayoutContext layoutContext2 = BlockContainerLayoutManager.this.makeChildLayoutContext(layoutContext);
                List list = null;
                if (!layoutManager.isFinished()) {
                    list = layoutManager.getNextKnuthElements(layoutContext2, n2);
                }
                if (list == null) continue;
                this.bclm.wrapPositionElements(list, linkedList);
            }
            SpaceResolver.resolveElementList(linkedList);
            BlockContainerLayoutManager.this.setFinished(true);
            return linkedList;
        }

        protected int getCurrentDisplayAlign() {
            return BlockContainerLayoutManager.this.getBlockContainerFO().getDisplayAlign();
        }

        protected boolean hasMoreContent() {
            return !BlockContainerLayoutManager.this.isFinished();
        }

        protected void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
            AreaAdditionUtil.addAreas((AbstractLayoutManager)((Object)this.bclm), (PositionIterator)positionIterator, (LayoutContext)layoutContext);
        }

        protected void doPhase3(PageBreakingAlgorithm pageBreakingAlgorithm, int n2, AbstractBreaker.BlockSequence blockSequence, AbstractBreaker.BlockSequence blockSequence2) {
            this.deferredAlg = pageBreakingAlgorithm;
            this.deferredOriginalList = blockSequence;
            this.deferredEffectiveList = blockSequence2;
        }

        protected void finishPart(PageBreakingAlgorithm pageBreakingAlgorithm, AbstractBreaker.PageBreakPosition pageBreakPosition) {
        }

        protected LayoutManager getCurrentChildLM() {
            return BlockContainerLayoutManager.this.curChildLM;
        }

        public void addContainedAreas(LayoutContext layoutContext) {
            if (this.isEmpty()) {
                return;
            }
            this.deferredAlg.removeAllPageBreaks();
            this.addAreas(this.deferredAlg, 0, this.deferredAlg.getPageBreaks().size(), this.deferredOriginalList, this.deferredEffectiveList, LayoutContext.offspringOf(layoutContext));
        }
    }

    private class BlockContainerPosition
    extends NonLeafPosition {
        private BlockContainerBreaker breaker;

        public BlockContainerPosition(LayoutManager layoutManager, BlockContainerBreaker blockContainerBreaker) {
            super(layoutManager, null);
            this.breaker = blockContainerBreaker;
        }

        public BlockContainerBreaker getBreaker() {
            return this.breaker;
        }
    }
}

