/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fop.hyphenation.ByteVector;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.PatternConsumer;
import org.apache.fop.hyphenation.PatternParser;
import org.apache.fop.hyphenation.TernaryTree;
import org.xml.sax.InputSource;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    private static final long serialVersionUID = -7842107987915665573L;
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    protected int packValues(String string) {
        int n2 = string.length();
        int n3 = (n2 & 1) == 1 ? (n2 >> 1) + 2 : (n2 >> 1) + 1;
        int n4 = this.vspace.alloc(n3);
        byte[] byArray = this.vspace.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 >> 1;
            byte by = (byte)(string.charAt(i2) - 48 + 1 & 0xF);
            byArray[n5 + n4] = (i2 & 1) == 1 ? (byte)(byArray[n5 + n4] | by) : (byte)(by << 4);
        }
        byArray[n3 - 1 + n4] = 0;
        return n4;
    }

    protected String unpackValues(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001' + 48);
            stringBuffer.append(c2);
            by = this.vspace.get(n2++);
        }
        return stringBuffer.toString();
    }

    public void loadPatterns(String string) throws HyphenationException {
        File file = new File(string);
        try {
            InputSource inputSource = new InputSource(file.toURI().toURL().toExternalForm());
            this.loadPatterns(inputSource);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HyphenationException("Error converting the File '" + file + "' to a URL: " + malformedURLException.getMessage());
        }
    }

    public void loadPatterns(InputSource inputSource) throws HyphenationException {
        PatternParser patternParser = new PatternParser((PatternConsumer)this);
        this.ivalues = new TernaryTree();
        patternParser.parse(inputSource);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n2 = super.find(string);
        if (n2 >= 0) {
            return this.unpackValues(n2);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        if (cArray2[n3] == '\u0000') {
            return 0;
        }
        return cArray[n2] - cArray2[n3];
    }

    protected byte[] getValues(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1);
            stringBuffer.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001');
            stringBuffer.append(c2);
            by = this.vspace.get(n2++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)stringBuffer.charAt(i2);
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n2, byte[] byArray) {
        int n3 = n2;
        char c2 = cArray[n3];
        char c3 = this.root;
        block0: while (c3 > '\u0000' && c3 < this.sc.length) {
            int n4;
            byte[] byArray2;
            if (this.sc[c3] == '\uffff') {
                if (this.hstrcmp(cArray, n3, this.kv.getArray(), this.lo[c3]) == 0) {
                    byArray2 = this.getValues(this.eq[c3]);
                    n4 = n2;
                    for (byte by : byArray2) {
                        if (n4 < byArray.length && by > byArray[n4]) {
                            byArray[n4] = by;
                        }
                        ++n4;
                    }
                }
                return;
            }
            n4 = c2 - this.sc[c3];
            if (n4 == 0) {
                if (c2 == '\u0000') break;
                c2 = cArray[++n3];
                char c4 = c3 = this.eq[c3];
                while (c4 > '\u0000' && c4 < this.sc.length && this.sc[c4] != '\uffff') {
                    if (this.sc[c4] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c4]);
                        int n6 = n2;
                        for (byte by : byArray2) {
                            if (n6 < byArray.length && by > byArray[n6]) {
                                byArray[n6] = by;
                            }
                            ++n6;
                        }
                        continue block0;
                    }
                    c4 = this.lo[c4];
                }
                continue;
            }
            c3 = n4 < 0 ? this.lo[c3] : this.hi[c3];
        }
    }

    public Hyphenation hyphenate(String string, int n2, int n3) {
        char[] cArray = string.toCharArray();
        if (this.isMultiPartWord(cArray, cArray.length)) {
            List<char[]> list = this.splitOnNonCharacters(cArray);
            return new Hyphenation(new String(cArray), this.getHyphPointsForWords(list, n2, n3));
        }
        return this.hyphenate(cArray, 0, cArray.length, n2, n3);
    }

    private boolean isMultiPartWord(char[] cArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char[] cArray2 = new char[2];
            cArray2[0] = cArray[i2];
            int n4 = this.classmap.find(cArray2, 0);
            if (n4 > 0) {
                if (n3 > 1) {
                    return true;
                }
                n3 = 1;
                continue;
            }
            if (n3 != true) continue;
            ++n3;
        }
        return false;
    }

    private List<char[]> splitOnNonCharacters(char[] cArray) {
        List<Integer> list = this.getNonLetterBreaks(cArray);
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            char[] cArray2 = this.getWordFromCharArray(cArray, i2 == 0 ? 0 : list.get(i2 - 1), list.get(i2));
            arrayList.add(cArray2);
        }
        if (cArray.length - list.get(list.size() - 1) - 1 > 1) {
            char[] cArray3 = this.getWordFromCharArray(cArray, list.get(list.size() - 1), cArray.length);
            arrayList.add(cArray3);
        }
        return arrayList;
    }

    private List<Integer> getNonLetterBreaks(char[] cArray) {
        char[] cArray2 = new char[2];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray2[0] = cArray[i2];
            if (this.classmap.find(cArray2, 0) < 0) {
                if (!bl) continue;
                arrayList.add(i2);
                continue;
            }
            bl = true;
        }
        return arrayList;
    }

    private char[] getWordFromCharArray(char[] cArray, int n2, int n3) {
        int n4;
        char[] cArray2 = new char[n3 - (n2 == 0 ? n2 : n2 + 1)];
        int n5 = 0;
        int n6 = n4 = n2 == 0 ? 0 : n2 + 1;
        while (n4 < n3) {
            cArray2[n5++] = cArray[n4];
            ++n4;
        }
        return cArray2;
    }

    private int[] getHyphPointsForWords(List<char[]> list, int n2, int n3) {
        int[] nArray = new int[]{};
        for (int i2 = 0; i2 < list.size(); ++i2) {
            char[] cArray = list.get(i2);
            Hyphenation hyphenation = this.hyphenate(cArray, 0, cArray.length, i2 == 0 ? n2 : 1, i2 == list.size() - 1 ? n3 : 1);
            if (hyphenation == null) continue;
            int[] nArray2 = new int[nArray.length + hyphenation.getHyphenationPoints().length];
            int[] nArray3 = hyphenation.getHyphenationPoints();
            int n4 = this.calcForeWordsSize(list, i2);
            int n5 = 0;
            while (n5 < nArray3.length) {
                int n6 = n5++;
                nArray3[n6] = nArray3[n6] + n4;
            }
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            System.arraycopy(nArray3, 0, nArray2, nArray.length, nArray3.length);
            nArray = nArray2;
        }
        return nArray;
    }

    private int calcForeWordsSize(List<char[]> list, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += list.get(i2).length + 1;
        }
        return n3;
    }

    public Hyphenation hyphenate(char[] cArray, int n2, int n3, int n4, int n5) {
        Object object;
        int n6;
        int n7;
        char[] cArray2 = new char[n3 + 3];
        boolean bl = !this.stoplist.isEmpty();
        char[] cArray3 = null;
        char[] cArray4 = new char[2];
        int n8 = 0;
        int n9 = n3;
        boolean bl2 = false;
        for (n7 = 1; n7 <= n3; ++n7) {
            cArray4[0] = cArray[n2 + n7 - 1];
            int n10 = this.classmap.find(cArray4, 0);
            if (n10 < 0) {
                if (n7 == 1 + n8) {
                    ++n8;
                } else {
                    bl2 = true;
                }
                --n9;
                continue;
            }
            if (!bl2) {
                n6 = n7 - n8;
                cArray2[n6] = (char)n10;
                if (bl && n10 != cArray4[0] && cArray3 == null) {
                    cArray3 = (char[])cArray2.clone();
                }
                if (cArray3 == null) continue;
                cArray3[n6] = cArray4[0];
                continue;
            }
            return null;
        }
        n3 = n9;
        if (n3 < n4 + n5) {
            return null;
        }
        int[] nArray = new int[n3 + 1];
        n6 = 0;
        String string = new String(cArray2, 1, n3);
        String string2 = null;
        String string3 = null;
        if (bl && cArray3 != null) {
            string2 = new String(cArray3, 1, n3);
            string3 = string2.toLowerCase();
        }
        if (this.stoplist.containsKey(string) || string2 != null && this.stoplist.containsKey(string2) || string3 != null && this.stoplist.containsKey(string3)) {
            object = (ArrayList)this.stoplist.get(string);
            if (object == null && bl && (object = (ArrayList)this.stoplist.get(string2)) == null) {
                object = (ArrayList)this.stoplist.get(string3);
            }
            int n11 = 0;
            for (n7 = 0; n7 < ((ArrayList)object).size(); ++n7) {
                Object e2 = ((ArrayList)object).get(n7);
                if (!(e2 instanceof String) || (n11 += ((String)e2).length()) < n4 || n11 >= n3 - n5) continue;
                nArray[n6++] = n11 + n8;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n3 + 1] = 46;
            cArray2[n3 + 2] = '\u0000';
            object = new byte[n3 + 3];
            for (n7 = 0; n7 < n3 + 1; ++n7) {
                this.searchPatterns(cArray2, n7, (byte[])object);
            }
            for (n7 = 0; n7 < n3; ++n7) {
                if ((object[n7 + 1] & 1) != 1 || n7 < n4 || n7 > n3 - n5) continue;
                nArray[n6++] = n7 + n8;
            }
        }
        if (n6 > 0) {
            object = new int[n6];
            System.arraycopy(nArray, 0, object, 0, n6);
            return new Hyphenation(new String(cArray, n2, n3), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c2 = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            for (int i2 = 0; i2 < string.length(); ++i2) {
                cArray[0] = string.charAt(i2);
                this.classmap.insert(cArray, 0, c2);
            }
        }
    }

    public void addException(String string, ArrayList arrayList) {
        String string2 = this.classNormalize(string);
        if (!string.equals(string2)) {
            this.stoplist.put(string2, arrayList);
        }
        this.stoplist.put(string, arrayList);
    }

    private String classNormalize(String string) {
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        char[] cArray = new char[2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[0] = string.charAt(i2);
            char c2 = (char)this.classmap.find(cArray, 0);
            if (c2 == cArray[0]) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
            }
            stringBuilder.setCharAt(i2, c2);
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    public void addPattern(String string, String string2) {
        int n2 = this.ivalues.find(string2);
        if (n2 <= 0) {
            n2 = this.packValues(string2);
            this.ivalues.insert(string2, (char)n2);
        }
        this.insert(string, (char)n2);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Exception {
        block46: {
            var1_1 = null;
            var2_2 = 2;
            var3_3 = new BufferedReader(new InputStreamReader(System.in));
            while (true) lbl-1000:
            // 17 sources

            {
                block47: {
                    System.out.print("l:\tload patterns from XML\nL:\tload patterns from serialized object\ns:\tset minimum character count\nw:\twrite hyphenation tree to object file\nh:\thyphenate\nf:\tfind pattern\nb:\tbenchmark\nq:\tquit\n\nCommand:");
                    var4_4 = var3_3.readLine();
                    if (var4_4 == null) break block46;
                    if ((var4_4 = var4_4.trim()).equals("f")) {
                        System.out.print("Pattern: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 != null) {
                            var4_4 = var4_4.trim();
                            System.out.println("Values: " + var1_1.findPattern(var4_4));
                            continue;
                        }
                        break;
                    }
                    if (var4_4.equals("s")) {
                        System.out.print("Minimun value: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 != null) {
                            var4_4 = var4_4.trim();
                            var2_2 = Integer.parseInt(var4_4);
                            continue;
                        }
                        break;
                    }
                    if (var4_4.equals("l")) {
                        var1_1 = new HyphenationTree();
                        System.out.print("XML file name: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 != null) {
                            var4_4 = var4_4.trim();
                            var1_1.loadPatterns(var4_4);
                            continue;
                        }
                        break;
                    }
                    if (var4_4.equals("L")) {
                        var5_5 = null;
                        System.out.print("Object file name: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 == null) break block46;
                        var4_4 = var4_4.trim();
                        try {
                            var5_5 = new ObjectInputStream(new FileInputStream(var4_4));
                            var1_1 = (HyphenationTree)var5_5.readObject();
                        }
                        catch (Exception var6_10) {
                            var6_10.printStackTrace();
                        }
                        finally {
                            if (var5_5 == null) ** GOTO lbl-1000
                            try {
                                var5_5.close();
                            }
                            catch (IOException var6_11) {}
                        }
                        continue;
                    }
                    if (var4_4.equals("w")) {
                        System.out.print("Object file name: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 == null) break block46;
                        var4_4 = var4_4.trim();
                        var5_6 = null;
                        try {
                            var5_6 = new ObjectOutputStream(new FileOutputStream(var4_4));
                            var5_6.writeObject((Object)var1_1);
                        }
                        catch (Exception var6_14) {
                            var6_14.printStackTrace();
                        }
                        finally {
                            if (var5_6 == null) ** GOTO lbl-1000
                            try {
                                var5_6.flush();
                            }
                            catch (IOException var6_15) {}
                            try {
                                var5_6.close();
                            }
                            catch (IOException var6_16) {}
                        }
                        continue;
                    }
                    if (var4_4.equals("h")) {
                        System.out.print("Word: ");
                        var4_4 = var3_3.readLine();
                        if (var4_4 != null) {
                            var4_4 = var4_4.trim();
                            System.out.print("Hyphenation points: ");
                            System.out.println(var1_1.hyphenate(var4_4, var2_2, var2_2));
                            continue;
                        }
                        break;
                    }
                    if (!var4_4.equals("b")) break block47;
                    if (var1_1 == null) {
                        System.out.println("No patterns have been loaded.");
                        break;
                    }
                    System.out.print("Word list filename: ");
                    var4_4 = var3_3.readLine();
                    if (var4_4 == null) break block46;
                    var4_4 = var4_4.trim();
                    var5_7 = 0L;
                    var7_17 = 0;
                    var8_19 = null;
                    try {
                        var8_19 = new BufferedReader(new FileReader(var4_4));
                        var5_7 = System.currentTimeMillis();
                        while ((var9_23 = var8_19.readLine()) != null) {
                            var10_25 = var1_1.hyphenate(var9_23, var2_2, var2_2);
                            if (var10_25 != null) {
                                var11_29 = var10_25.toString();
                            }
                            ++var7_17;
                        }
                    }
                    catch (Exception var9_24) {
                        try {
                            System.out.println("Exception " + var9_24);
                            var9_24.printStackTrace();
                        }
                        catch (Throwable var12_30) {
                            IOUtils.closeQuietly(var8_19);
                            throw var12_30;
                        }
                        IOUtils.closeQuietly((Reader)var8_19);
                    }
                    IOUtils.closeQuietly((Reader)var8_19);
                    var9_21 = System.currentTimeMillis();
                    var11_28 = var9_21 - var5_7;
                    System.out.println(var7_17 + " words in " + var11_28 + " Milliseconds hyphenated");
                    continue;
                }
                if (var4_4.equals("q")) ** break;
            }
        }
    }
}

