/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.List;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.OpenFont;

public class OTFFile
extends OpenFont {
    protected CFFFont fileFont;

    public OTFFile() throws IOException {
        this(true, false);
    }

    public OTFFile(boolean bl, boolean bl2) throws IOException {
        super(bl, bl2);
        this.checkForFontbox();
    }

    private void checkForFontbox() throws IOException {
        try {
            Class.forName("org.apache.fontbox.cff.CFFFont");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("The Fontbox jar was not found in the classpath. This is required for OTF CFF ssupport.");
        }
    }

    @Override
    protected void updateBBoxAndOffset() throws IOException {
        Object v2 = this.fileFont.getTopDict().get("FontBBox");
        if (v2 != null) {
            List list = (List)v2;
            int[] nArray = new int[4];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = (Integer)list.get(i2);
            }
            for (OFMtxEntry oFMtxEntry : this.mtxTab) {
                oFMtxEntry.setBoundingBox(nArray);
            }
        }
    }

    @Override
    protected void initializeFont(FontFileReader fontFileReader) throws IOException {
        this.fontFile = fontFileReader;
    }

    @Override
    protected void initializeFontAfterTTCSeek(FontFileReader fontFileReader) throws IOException {
        int n2 = fontFileReader.getCurrentPos();
        CFFParser cFFParser = new CFFParser();
        this.fileFont = cFFParser.parse(fontFileReader.getAllBytes(), n2).get(0);
        this.embedFontName = this.fileFont.getName();
    }

    @Override
    protected void readName() throws IOException {
        this.seekTab(this.fontFile, OFTableName.NAME, 2L);
        int n2 = this.fontFile.getCurrentPos();
        int n3 = this.fontFile.readTTFUShort();
        int n4 = this.fontFile.readTTFUShort() + n2 - 2;
        n2 += 4;
        while (n3-- > 0) {
            this.fontFile.seekSet((long)n2);
            int n5 = this.fontFile.readTTFUShort();
            int n6 = this.fontFile.readTTFUShort();
            int n7 = this.fontFile.readTTFUShort();
            int n8 = this.fontFile.readTTFUShort();
            int n9 = this.fontFile.readTTFUShort();
            if (!(n5 != 1 && n5 != 3 || n6 != 0 && n6 != 1)) {
                this.fontFile.seekSet((long)(n4 + this.fontFile.readTTFUShort()));
                String string = n5 == 3 ? this.fontFile.readTTFString(n9, n6) : this.fontFile.readTTFString(n9);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(n5 + " " + n6 + " " + n7 + " " + n8 + " " + string));
                }
                switch (n8) {
                    case 0: {
                        if (this.notice.length() != 0) break;
                        this.notice = string;
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.familyNames.add(string);
                        break;
                    }
                    case 2: {
                        if (this.subFamilyName.length() != 0) break;
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        if (this.fullName.length() != 0 && (n5 != 3 || n7 != 1033)) break;
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        if (this.postScriptName.length() != 0) break;
                        this.postScriptName = string;
                        break;
                    }
                }
            }
            n2 += 12;
        }
    }

    public static byte[] getCFFData(FontFileReader fontFileReader) throws IOException {
        byte[] byArray = fontFileReader.getAllBytes();
        CFFDataInput cFFDataInput = new CFFDataInput(fontFileReader.getAllBytes());
        cFFDataInput.setPosition(fontFileReader.getCurrentPos());
        cFFDataInput.readBytes(4);
        int n2 = cFFDataInput.readShort();
        cFFDataInput.readShort();
        cFFDataInput.readShort();
        cFFDataInput.readShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = new String(cFFDataInput.readBytes(4));
            OTFFile.readLong(cFFDataInput);
            long l2 = OTFFile.readLong(cFFDataInput);
            long l3 = OTFFile.readLong(cFFDataInput);
            if (!string.equals("CFF ")) continue;
            byArray = new byte[(int)l3];
            System.arraycopy(fontFileReader.getAllBytes(), (int)l2, byArray, 0, byArray.length);
            break;
        }
        return byArray;
    }

    private static long readLong(CFFDataInput cFFDataInput) throws IOException {
        return cFFDataInput.readCard16() << 16 | cFFDataInput.readCard16();
    }

    public boolean isType1() {
        return this.fileFont instanceof CFFType1Font;
    }

    private static class Mapping {
        private int sid;
        private String name;
        private byte[] bytes;

        private Mapping() {
        }

        public void setSID(int n2) {
            this.sid = n2;
        }

        public int getSID() {
            return this.sid;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setBytes(byte[] byArray) {
            this.bytes = byArray;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

