/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.xmlgraphics.io.Resource;

public class FontInfoFinder {
    private final Log log = LogFactory.getLog(FontInfoFinder.class);
    private FontEventListener eventListener;
    private final Pattern quotePattern = Pattern.compile("'");

    public void setEventListener(FontEventListener fontEventListener) {
        this.eventListener = fontEventListener;
    }

    private void generateTripletsFromFont(CustomFont customFont, Collection<FontTriplet> collection) {
        int n2;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Font: " + customFont.getFullName() + ", family: " + customFont.getFamilyNames() + ", PS: " + customFont.getFontName() + ", EmbedName: " + customFont.getEmbedFontName()));
        }
        String string = this.stripQuotes(customFont.getStrippedFontName());
        String string2 = this.stripQuotes(customFont.getFullName());
        String string3 = string2.toLowerCase();
        String string4 = this.guessStyle(customFont, string3);
        int n3 = n2 = FontUtil.guessWeight((String)string3);
        collection.add(new FontTriplet(string2, "normal", 400));
        if (!string2.equals(string)) {
            collection.add(new FontTriplet(string, "normal", 400));
        }
        Set set = customFont.getFamilyNames();
        for (String string5 : set) {
            if (string2.equals(string5 = this.stripQuotes(string5))) continue;
            int n4 = string2.startsWith(string5) ? string2.length() - string5.length() : string2.length();
            collection.add(new FontTriplet(string5, string4, n3, n4));
        }
    }

    private String stripQuotes(String string) {
        return this.quotePattern.matcher(string).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String string) {
        String string2 = "normal";
        string2 = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle((String)string);
        return string2;
    }

    private EmbedFontInfo getFontInfoFromCustomFont(URI uRI, CustomFont customFont, FontCache fontCache, InternalResourceResolver internalResourceResolver) {
        FontUris fontUris = new FontUris(uRI, null);
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        this.generateTripletsFromFont(customFont, arrayList);
        String string = null;
        if (customFont instanceof MultiByteFont) {
            string = ((MultiByteFont)customFont).getTTCName();
        }
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(fontUris, customFont.isKerningEnabled(), customFont.isAdvancedEnabled(), arrayList, string);
        embedFontInfo.setPostScriptName(customFont.getFontName());
        if (fontCache != null) {
            fontCache.addFont(embedFontInfo, internalResourceResolver);
        }
        return embedFontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo[] find(URI uRI, InternalResourceResolver internalResourceResolver, FontCache fontCache) {
        FontUris fontUris;
        CustomFont customFont;
        URI uRI2 = internalResourceResolver.resolveFromBase(uRI);
        String string = uRI2.toASCIIString();
        boolean bl = true;
        boolean bl2 = true;
        long l2 = -1L;
        if (fontCache != null) {
            l2 = FontCache.getLastModified((URI)uRI);
            if (fontCache.containsFont(string)) {
                customFont = fontCache.getFontInfos(string, l2);
                if (customFont != null) {
                    return customFont;
                }
            } else if (fontCache.isFailedFont(string, l2)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping font file that failed to load previously: " + uRI2));
                }
                return null;
            }
        }
        customFont = null;
        if (uRI.toASCIIString().toLowerCase().endsWith(".ttc")) {
            Object object;
            Object object2;
            List list = null;
            Resource resource = null;
            try {
                resource = internalResourceResolver.getResource(uRI);
                try {
                    object2 = new TTFFile(false, false);
                    object = new FontFileReader((InputStream)resource);
                    list = object2.getTTCnames((FontFileReader)object);
                    if (list == null) {
                        EmbedFontInfo[] embedFontInfoArray = null;
                        return embedFontInfoArray;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.handleOOM(uRI);
                }
            }
            catch (Throwable throwable) {
                if (this.eventListener != null) {
                    this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, uRI.toASCIIString(), (Exception)new RuntimeException(throwable));
                }
                object = null;
                return object;
            }
            finally {
                IOUtils.closeQuietly((InputStream)resource);
            }
            object2 = new ArrayList();
            for (String string2 : list) {
                Object object3;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading " + string2));
                }
                try {
                    try {
                        object3 = new OFFontLoader(uRI, string2, true, EmbeddingMode.AUTO, EncodingMode.AUTO, bl, bl2, internalResourceResolver, false, false, true);
                        customFont = object3.getFont();
                        if (this.eventListener != null) {
                            customFont.setEventListener(this.eventListener);
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.handleOOM(uRI);
                    }
                }
                catch (Throwable throwable) {
                    if (fontCache != null) {
                        fontCache.registerFailedFont(uRI2.toASCIIString(), l2);
                    }
                    if (this.eventListener == null) continue;
                    this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, uRI2.toASCIIString(), (Exception)new RuntimeException(throwable));
                    continue;
                }
                if ((object3 = this.getFontInfoFromCustomFont(uRI, customFont, fontCache, internalResourceResolver)) == null) continue;
                object2.add(object3);
            }
            return object2.toArray(new EmbedFontInfo[object2.size()]);
        }
        try {
            fontUris = new FontUris(uRI, null);
            customFont = FontLoader.loadFont((FontUris)fontUris, null, (boolean)true, (EmbeddingMode)EmbeddingMode.AUTO, (EncodingMode)EncodingMode.AUTO, (boolean)bl, (boolean)bl2, (InternalResourceResolver)internalResourceResolver, (boolean)false, (boolean)false, (boolean)true);
            if (this.eventListener != null) {
                customFont.setEventListener(this.eventListener);
            }
        }
        catch (Throwable throwable) {
            if (fontCache != null) {
                fontCache.registerFailedFont(uRI2.toASCIIString(), l2);
            }
            if (this.eventListener != null) {
                this.eventListener.fontLoadingErrorAtAutoDetection((Object)this, uRI2.toASCIIString(), (Exception)new RuntimeException(throwable));
            }
            return null;
        }
        fontUris = this.getFontInfoFromCustomFont(uRI, customFont, fontCache, internalResourceResolver);
        if (fontUris != null) {
            return new EmbedFontInfo[]{fontUris};
        }
        return null;
    }

    private void handleOOM(URI uRI) throws IOException {
        Object object = "";
        if ("file".equals(uRI.getScheme())) {
            object = "The font file size was: " + new File(uRI).length() + " bytes";
        }
        throw new IOException("Font is too large. If you need this font in your PDF, see the userguide about increasing the maximum memory size for the publishing process. " + (String)object);
    }
}

