/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;

public class FontInfo {
    protected static final Log log = LogFactory.getLog(FontInfo.class);
    private Map<String, Typeface> usedFonts;
    private Map<FontTriplet, String> triplets = new HashMap<FontTriplet, String>();
    private Map<FontTriplet, Integer> tripletPriorities = new HashMap<FontTriplet, Integer>();
    private Map<String, Typeface> fonts = new HashMap<String, Typeface>();
    private Map<FontTriplet, Map<Integer, Font>> fontInstanceCache;
    private FontEventListener eventListener;

    public FontInfo() {
        this.usedFonts = new HashMap<String, Typeface>();
    }

    public void setEventListener(FontEventListener fontEventListener) {
        this.eventListener = fontEventListener;
    }

    public boolean isSetupValid() {
        this.tripletPriorities = null;
        return this.triplets.containsKey(Font.DEFAULT_FONT);
    }

    public void addFontProperties(String string, String string2, String string3, int n2) {
        this.addFontProperties(string, FontInfo.createFontKey(string2, string3, n2));
    }

    public void addFontProperties(String string, String[] stringArray, String string2, int n2) {
        for (String string3 : stringArray) {
            this.addFontProperties(string, string3, string2, n2);
        }
    }

    public void addFontProperties(String string, FontTriplet fontTriplet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering: " + fontTriplet + " under " + string));
        }
        String string2 = this.triplets.get(fontTriplet);
        int n2 = fontTriplet.getPriority();
        if (string2 != null) {
            int n3 = this.tripletPriorities.get(fontTriplet);
            if (n3 < n2) {
                this.logDuplicateFont(fontTriplet, false, string2, n3, string, n2);
                return;
            }
            this.logDuplicateFont(fontTriplet, true, string2, n3, string, n2);
        }
        this.triplets.put(fontTriplet, string);
        this.tripletPriorities.put(fontTriplet, n2);
    }

    private void logDuplicateFont(FontTriplet fontTriplet, boolean bl, String string, int n2, String string2, int n3) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(fontTriplet + (bl ? ": Replacing " : ": Not replacing ") + this.fonts.get(this.triplets.get(fontTriplet)).getFullName() + " (priority=" + n2 + ") by " + this.fonts.get(string2).getFullName() + " (priority=" + n3 + ")"));
        }
    }

    public void addMetrics(String string, FontMetrics fontMetrics) {
        if (fontMetrics instanceof Typeface) {
            ((Typeface)fontMetrics).setEventListener(this.eventListener);
        }
        this.fonts.put(string, (Typeface)fontMetrics);
    }

    private FontTriplet fontLookup(String string, String string2, int n2, boolean bl) {
        FontTriplet fontTriplet;
        FontTriplet fontTriplet2;
        String string3;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Font lookup: " + string + " " + string2 + " " + n2 + (bl ? " substitutable" : "")));
        }
        if ((string3 = this.getInternalFontKey(fontTriplet2 = (fontTriplet = FontInfo.createFontKey(string, string2, n2)))) == null) {
            fontTriplet2 = this.fuzzyFontLookup(string, string2, n2, fontTriplet, bl);
        }
        if (fontTriplet2 != null) {
            if (fontTriplet2 != fontTriplet) {
                this.notifyFontReplacement(fontTriplet, fontTriplet2);
            }
            return fontTriplet2;
        }
        return null;
    }

    private FontTriplet fuzzyFontLookup(String string, String string2, int n2, FontTriplet fontTriplet, boolean bl) {
        FontTriplet fontTriplet2;
        String string3 = null;
        if (!string.equals(fontTriplet.getName()) && (string3 = this.getInternalFontKey(fontTriplet2 = FontInfo.createFontKey(string, string2, n2))) != null) {
            return fontTriplet2;
        }
        fontTriplet2 = this.findAdjustWeight(string, string2, n2);
        if (fontTriplet2 != null) {
            string3 = this.getInternalFontKey(fontTriplet2);
        }
        if (!bl && string3 == null) {
            return null;
        }
        if (string3 == null && !string2.equals("normal")) {
            fontTriplet2 = FontInfo.createFontKey(string, "normal", n2);
            string3 = this.getInternalFontKey(fontTriplet2);
        }
        if (string3 == null && !string2.equals("normal") && (fontTriplet2 = this.findAdjustWeight(string, "normal", n2)) != null) {
            string3 = this.getInternalFontKey(fontTriplet2);
        }
        if (string3 == null) {
            return this.fuzzyFontLookup("any", string2, n2, fontTriplet, false);
        }
        if (fontTriplet2 == null && string3 == null) {
            fontTriplet2 = Font.DEFAULT_FONT;
            string3 = this.getInternalFontKey(fontTriplet2);
        }
        if (string3 != null) {
            return fontTriplet2;
        }
        return null;
    }

    public void useFont(String string) {
        this.usedFonts.put(string, this.fonts.get(string));
    }

    private Map<FontTriplet, Map<Integer, Font>> getFontInstanceCache() {
        if (this.fontInstanceCache == null) {
            this.fontInstanceCache = new HashMap<FontTriplet, Map<Integer, Font>>();
        }
        return this.fontInstanceCache;
    }

    public Font getFontInstance(FontTriplet fontTriplet, int n2) {
        Integer n3;
        Font font;
        Map<Integer, Font> map = this.getFontInstanceCache().get(fontTriplet);
        if (map == null) {
            map = new HashMap<Integer, Font>();
            this.getFontInstanceCache().put(fontTriplet, map);
        }
        if ((font = map.get(n3 = Integer.valueOf(n2))) == null) {
            String string = this.getInternalFontKey(fontTriplet);
            this.useFont(string);
            FontMetrics fontMetrics = this.getMetricsFor(string);
            font = new Font(string, fontTriplet, fontMetrics, n2);
            map.put(n3, font);
        }
        return font;
    }

    private List<FontTriplet> getTripletsForName(String string) {
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        for (FontTriplet fontTriplet : this.triplets.keySet()) {
            String string2 = fontTriplet.getName();
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            arrayList.add(fontTriplet);
        }
        return arrayList;
    }

    public Font getFontInstanceForAWTFont(java.awt.Font font) {
        String string = font.getName();
        String string2 = font.getFamily();
        String string3 = font.isItalic() ? "italic" : "normal";
        int n2 = font.isBold() ? 700 : 400;
        FontTriplet fontTriplet = null;
        List<FontTriplet> list = this.getTripletsForName(string);
        if (!list.isEmpty()) {
            for (FontTriplet fontTriplet2 : list) {
                boolean bl;
                boolean bl2 = fontTriplet2.getStyle().equals(string3);
                boolean bl3 = bl = fontTriplet2.getWeight() == n2;
                if (!bl2 || !bl) continue;
                fontTriplet = fontTriplet2;
                break;
            }
        }
        if (fontTriplet == null) {
            if (string2.equals("sanserif")) {
                string2 = "sans-serif";
            }
            fontTriplet = this.fontLookup(string2, string3, n2);
        }
        int n3 = Math.round(font.getSize2D() * 1000.0f);
        return this.getFontInstance(fontTriplet, n3);
    }

    public FontTriplet fontLookup(String string, String string2, int n2) {
        return this.fontLookup(string, string2, n2, true);
    }

    private List<FontTriplet> fontLookup(String[] stringArray, String string, int n2, boolean bl) {
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        FontTriplet fontTriplet = null;
        for (String string2 : stringArray) {
            fontTriplet = this.fontLookup(string2, string, n2, bl);
            if (fontTriplet == null) continue;
            arrayList.add(fontTriplet);
        }
        return arrayList;
    }

    public FontTriplet[] fontLookup(String[] stringArray, String string, int n2) {
        Object object;
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Specify at least one font family");
        }
        List<FontTriplet> list = this.fontLookup(stringArray, string, n2, false);
        if (list.size() != 0 && !string.equals("normal")) {
            object = this.fontLookup(stringArray, "normal", n2, false);
            list.addAll((Collection<FontTriplet>)object);
        }
        if (list.size() == 0) {
            list = this.fontLookup(stringArray, string, n2, true);
        }
        if (list.size() == 0) {
            object = new StringBuffer();
            int n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (i2 > 0) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(stringArray[i2]);
            }
            throw new IllegalStateException("fontLookup must return an array with at least one FontTriplet on the last call. Lookup: " + (StringBuffer)object);
        }
        object = new FontTriplet[list.size()];
        list.toArray((T[])object);
        return object;
    }

    private void notifyFontReplacement(FontTriplet fontTriplet, FontTriplet fontTriplet2) {
        if (this.eventListener != null) {
            this.eventListener.fontSubstituted((Object)this, fontTriplet, fontTriplet2);
        }
    }

    public void notifyStrokingSVGTextAsShapes(String string) {
        if (this.eventListener != null) {
            this.eventListener.svgTextStrokedAsShapes((Object)this, string);
        }
    }

    public FontTriplet findAdjustWeight(String string, String string2, int n2) {
        FontTriplet fontTriplet = null;
        String string3 = null;
        int n3 = n2;
        if (n3 < 400) {
            while (string3 == null && n3 > 100) {
                fontTriplet = FontInfo.createFontKey(string, string2, n3 -= 100);
                string3 = this.getInternalFontKey(fontTriplet);
            }
            n3 = n2;
            while (string3 == null && n3 < 400) {
                fontTriplet = FontInfo.createFontKey(string, string2, n3 += 100);
                string3 = this.getInternalFontKey(fontTriplet);
            }
        } else if (n3 == 400 || n3 == 500) {
            fontTriplet = FontInfo.createFontKey(string, string2, 400);
            string3 = this.getInternalFontKey(fontTriplet);
        } else if (n3 > 500) {
            while (string3 == null && n3 < 1000) {
                fontTriplet = FontInfo.createFontKey(string, string2, n3 += 100);
                string3 = this.getInternalFontKey(fontTriplet);
            }
            n3 = n2;
            while (string3 == null && n3 > 400) {
                fontTriplet = FontInfo.createFontKey(string, string2, n3 -= 100);
                string3 = this.getInternalFontKey(fontTriplet);
            }
        }
        if (string3 == null && n2 != 400) {
            fontTriplet = FontInfo.createFontKey(string, string2, 400);
            string3 = this.getInternalFontKey(fontTriplet);
        }
        if (string3 != null) {
            return fontTriplet;
        }
        return null;
    }

    public boolean hasFont(String string, String string2, int n2) {
        FontTriplet fontTriplet = FontInfo.createFontKey(string, string2, n2);
        return this.triplets.containsKey(fontTriplet);
    }

    public String getInternalFontKey(FontTriplet fontTriplet) {
        return this.triplets.get(fontTriplet);
    }

    public static FontTriplet createFontKey(String string, String string2, int n2) {
        return new FontTriplet(string, string2, n2);
    }

    public Map<String, Typeface> getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map<FontTriplet, String> getFontTriplets() {
        return this.triplets;
    }

    public Map<String, Typeface> getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String string) {
        Typeface typeface = this.fonts.get(string);
        this.usedFonts.put(string, typeface);
        return typeface;
    }

    public List<FontTriplet> getTripletsFor(String string) {
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        for (Map.Entry<FontTriplet, String> entry : this.triplets.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public FontTriplet getTripletFor(String string) {
        List<FontTriplet> list = this.getTripletsFor(string);
        if (list.size() > 0) {
            Collections.sort(list);
            return list.get(0);
        }
        return null;
    }

    public String getFontStyleFor(String string) {
        FontTriplet fontTriplet = this.getTripletFor(string);
        if (fontTriplet != null) {
            return fontTriplet.getStyle();
        }
        return "";
    }

    public int getFontWeightFor(String string) {
        FontTriplet fontTriplet = this.getTripletFor(string);
        if (fontTriplet != null) {
            return fontTriplet.getWeight();
        }
        return 0;
    }

    public void dumpAllTripletsToSystemOut() {
        TreeSet<CallSite> treeSet = new TreeSet<CallSite>();
        for (FontTriplet object : this.triplets.keySet()) {
            String string = this.getInternalFontKey(object);
            FontMetrics fontMetrics = this.getMetricsFor(string);
            treeSet.add((CallSite)((Object)(object.toString() + " -> " + string + " -> " + fontMetrics.getFontName() + "\n")));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : treeSet) {
            stringBuffer.append(string);
        }
        System.out.println(stringBuffer.toString());
    }
}

