/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.Property;

public class FontFeatureSettings {
    public static final String LIGA = "liga";
    public static final String DLIG = "dlig";
    public static final String CLIG = "clig";
    public static final String HLIG = "hlig";
    public static final String CALT = "calt";
    public static final String LNUM = "lnum";
    public static final String ONUM = "onum";
    public static final String PNUM = "pnum";
    public static final String TNUM = "tnum";
    public static final String FRAC = "frac";
    public static final String AFRC = "afrc";
    public static final String ORDN = "ordn";
    public static final String ZERO = "zero";
    private LinkedHashMap<String, Integer> featuresMap;
    private String stylesetName;

    FontFeatureSettings() {
    }

    public FontFeatureSettings(ListProperty listProperty, String string, ListProperty listProperty2) {
        this.setFontVariantLigatures(listProperty);
        this.setFontVariantAlternates(string);
        this.setFontVariantNumeric(listProperty2);
    }

    void setFontVariantLigatures(ListProperty listProperty) {
        List list = listProperty.getList();
        for (Property property : list) {
            if (property == null) continue;
            int n2 = property.getEnum();
            switch (n2) {
                case 95: {
                    this.put(LIGA, 0);
                    this.put(DLIG, 0);
                    this.put(HLIG, 0);
                    this.put(CALT, 0);
                    break;
                }
                case 97: {
                    this.put(LIGA, 1);
                    break;
                }
                case 208: {
                    this.put(CLIG, 1);
                    this.put(LIGA, 1);
                    break;
                }
                case 209: {
                    this.put(LIGA, 1);
                    this.put(CLIG, 0);
                    break;
                }
                case 210: {
                    this.put(DLIG, 1);
                    break;
                }
                case 211: {
                    this.put(DLIG, 0);
                    break;
                }
                case 212: {
                    this.put(HLIG, 1);
                    break;
                }
                case 213: {
                    this.put(HLIG, 0);
                    break;
                }
                case 214: {
                    this.put(CALT, 1);
                    break;
                }
                case 215: {
                    this.put(CALT, 0);
                    break;
                }
            }
        }
    }

    void setFontVariantNumeric(ListProperty listProperty) {
        List list = listProperty.getList();
        for (Property property : list) {
            if (property == null) continue;
            switch (property.getEnum()) {
                case 95: 
                case 97: {
                    this.put(LNUM, 0);
                    this.put(ONUM, 0);
                    this.put(PNUM, 0);
                    this.put(TNUM, 0);
                    this.put(FRAC, 0);
                    this.put(AFRC, 0);
                    this.put(ORDN, 0);
                    this.put(ZERO, 0);
                    break;
                }
                case 216: {
                    this.put(LNUM, 1);
                    break;
                }
                case 217: {
                    this.put(ONUM, 1);
                    break;
                }
                case 218: {
                    this.put(PNUM, 1);
                    break;
                }
                case 219: {
                    this.put(TNUM, 1);
                    break;
                }
                case 220: {
                    this.put(FRAC, 1);
                    break;
                }
                case 221: {
                    this.put(AFRC, 1);
                    break;
                }
                case 222: {
                    this.put(ORDN, 1);
                    break;
                }
                case 223: {
                    this.put(ZERO, 1);
                    break;
                }
            }
        }
    }

    void setFontVariantAlternates(String string) {
        if ("normal".equalsIgnoreCase(string)) {
            this.stylesetName = null;
        } else {
            String string2 = "styleset(";
            if (string.startsWith(string2)) {
                String string3 = string.substring(string2.length());
                int n2 = string3.indexOf(41);
                if (n2 != -1) {
                    string3 = string3.substring(0, n2);
                }
                this.stylesetName = string3;
            }
        }
    }

    void put(String string, int n2) {
        if (this.featuresMap == null) {
            this.featuresMap = new LinkedHashMap();
        }
        this.featuresMap.put(string, n2);
    }

    public String[] filter(String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray != null && this.featuresMap != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                arrayList.add(string);
            }
            this.filterRemoveFeatures(stringArray, arrayList);
            this.filterAddFeatures(arrayList);
            stringArray2 = arrayList.toArray(new String[0]);
        }
        return stringArray2;
    }

    private void filterAddFeatures(ArrayList<String> arrayList) {
        Set<Map.Entry<String, Integer>> set = this.featuresMap.entrySet();
        for (Map.Entry<String, Integer> entry : set) {
            String string = entry.getKey();
            Integer n2 = entry.getValue();
            if (n2 == null || n2 != 1 || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (this.stylesetName != null && !arrayList.contains(this.stylesetName)) {
            arrayList.add(this.stylesetName);
        }
    }

    private void filterRemoveFeatures(String[] stringArray, ArrayList<String> arrayList) {
        for (String string : stringArray) {
            Integer n2 = this.featuresMap.get(string);
            if (n2 == null || n2 != 0) continue;
            arrayList.remove(string);
        }
    }
}

