/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.GlyphMapping;
import org.apache.fop.fonts.MultiByteFont;

public class CIDSubset
implements CIDSet {
    private Map<Integer, Integer> usedGlyphs = new LinkedHashMap<Integer, Integer>();
    private Map<Integer, Integer> usedGlyphsIndex = new HashMap<Integer, Integer>();
    private int usedGlyphsCount;
    private Map<Integer, Integer> usedCharsIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> charToGIDs = new HashMap<Integer, Integer>();
    private final MultiByteFont font;
    private static final Log LOG = LogFactory.getLog(GlyphMapping.class);
    private int virtualCount = 0;
    private static final int VIRTUAL_BASE = 0x100000;
    private HashMap<UsedGlyphsKey, Integer> virtualKeyToGlyphIndexes = new HashMap();
    private HashMap<Integer, UsedGlyphsKey> virtualGlyphIndexesToKey = new HashMap();
    private Map<UsedGlyphsKey, Integer> usedGlyphsAndCodePointCombinations = new LinkedHashMap<UsedGlyphsKey, Integer>();

    public CIDSubset(MultiByteFont multiByteFont) {
        this.font = multiByteFont;
        this.usedGlyphs.put(0, 0);
        this.usedGlyphsAndCodePointCombinations.put(new UsedGlyphsKey(0, 0), 0);
        this.usedGlyphsIndex.put(0, 0);
        ++this.usedGlyphsCount;
    }

    @Override
    public int getOriginalGlyphIndex(int n2) {
        Integer n3 = this.usedGlyphsIndex.get(n2);
        if (n3 != null) {
            if (this.virtualGlyphIndexesToKey.containsKey(n3)) {
                return this.virtualGlyphIndexesToKey.get((Object)n3).glyphIndex;
            }
            return n3;
        }
        return -1;
    }

    @Override
    public int getUnicode(int n2) {
        Integer n3 = this.usedCharsIndex.get(n2);
        if (n3 != null) {
            return n3;
        }
        return 65535;
    }

    @Override
    public int mapChar(int n2, char c2) {
        return this.mapCodePoint(n2, c2);
    }

    @Override
    public int mapCodePoint(int n2, int n3) {
        UsedGlyphsKey usedGlyphsKey = new UsedGlyphsKey(n2, n3);
        if (this.shouldMakeVirtualGlyphIndex(usedGlyphsKey)) {
            n2 = this.makeVirtualGlyphIndex(usedGlyphsKey);
        }
        int n4 = 0;
        Integer n5 = this.usedGlyphsAndCodePointCombinations.get(usedGlyphsKey);
        if (n5 != null) {
            n4 = n5;
        } else {
            Integer n6 = this.usedGlyphs.get(n2);
            if (n6 == null) {
                int n7 = this.usedGlyphsCount++;
                this.usedGlyphs.put(n2, n7);
                this.usedGlyphsAndCodePointCombinations.put(usedGlyphsKey, n7);
                this.usedGlyphsIndex.put(n7, n2);
                this.usedCharsIndex.put(n7, n3);
                this.charToGIDs.put(n3, n2);
                n4 = n7;
            } else {
                n4 = n6;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Map codepoint  " + Integer.toHexString(n2) + " " + Integer.toHexString(n3) + " cid = " + n4));
        }
        return n4;
    }

    @Override
    public Map<Integer, Integer> getGlyphs() {
        return Collections.unmodifiableMap(this.usedGlyphs);
    }

    @Override
    public char getUnicodeFromGID(int n2) {
        int n3 = this.usedGlyphs.get(n2);
        return (char)this.usedCharsIndex.get(n3).intValue();
    }

    @Override
    public int getGIDFromChar(char c2) {
        return this.charToGIDs.get(c2);
    }

    @Override
    public char[] getChars() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.usedGlyphsCount; ++i2) {
            stringBuilder.appendCodePoint(this.getUnicode(i2));
        }
        return stringBuilder.toString().toCharArray();
    }

    @Override
    public int getNumberOfGlyphs() {
        return this.usedGlyphsCount;
    }

    @Override
    public BitSet getGlyphIndices() {
        BitSet bitSet = new BitSet();
        for (Integer n2 : this.usedGlyphs.keySet()) {
            if (this.isVirtualGlyphIndex(n2)) continue;
            bitSet.set(n2);
        }
        return bitSet;
    }

    @Override
    public int[] getWidths() {
        int[] nArray = this.font.getWidths();
        int[] nArray2 = new int[this.getNumberOfGlyphs()];
        int n2 = this.getNumberOfGlyphs();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = Math.max(0, this.getOriginalGlyphIndex(i2));
            nArray2[i2] = nArray[n3];
        }
        return nArray2;
    }

    @Override
    public boolean isVirtualGlyphIndex(int n2) {
        return this.virtualGlyphIndexesToKey.containsKey(n2);
    }

    @Override
    public int getOriginalGlyphIndexForVirtual(int n2) {
        return this.virtualGlyphIndexesToKey.get((Object)Integer.valueOf((int)n2)).glyphIndex;
    }

    private int makeVirtualGlyphIndex(UsedGlyphsKey usedGlyphsKey) {
        Integer n2 = this.virtualKeyToGlyphIndexes.get(usedGlyphsKey);
        if (n2 == null) {
            n2 = 0x100000 + this.virtualCount;
            ++this.virtualCount;
            this.virtualKeyToGlyphIndexes.put(usedGlyphsKey, n2);
            this.virtualGlyphIndexesToKey.put(n2, usedGlyphsKey);
        }
        return n2;
    }

    private boolean shouldMakeVirtualGlyphIndex(UsedGlyphsKey usedGlyphsKey) {
        return this.usedGlyphs.get(usedGlyphsKey.glyphIndex) != null && this.usedGlyphsAndCodePointCombinations.get(usedGlyphsKey) == null;
    }

    private static final class UsedGlyphsKey {
        private final int glyphIndex;
        private final int codePoint;

        public UsedGlyphsKey(int n2, int n3) {
            this.glyphIndex = n2;
            this.codePoint = n3;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof UsedGlyphsKey) {
                UsedGlyphsKey usedGlyphsKey = (UsedGlyphsKey)object;
                bl = this.glyphIndex == usedGlyphsKey.glyphIndex && this.codePoint == usedGlyphsKey.codePoint;
            }
            return bl;
        }

        public int hashCode() {
            return this.glyphIndex;
        }

        public String toString() {
            return "(gi:" + this.glyphIndex + " cp:" + this.codePoint + ")";
        }
    }
}

