/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.MultiByteFont;

public class CIDFull
implements CIDSet {
    private BitSet glyphIndices;
    private final MultiByteFont font;

    public CIDFull(MultiByteFont multiByteFont) {
        this.font = multiByteFont;
    }

    private void initGlyphIndices() {
        if (this.glyphIndices == null) {
            this.glyphIndices = this.font.getGlyphIndices();
        }
    }

    @Override
    public int getOriginalGlyphIndex(int n2) {
        return n2;
    }

    @Override
    public char getUnicodeFromGID(int n2) {
        return ' ';
    }

    @Override
    public int getGIDFromChar(char c2) {
        return c2;
    }

    @Override
    public int getUnicode(int n2) {
        this.initGlyphIndices();
        if (this.glyphIndices.get(n2)) {
            return n2;
        }
        return 65535;
    }

    @Override
    public int mapChar(int n2, char c2) {
        return n2;
    }

    @Override
    public int mapCodePoint(int n2, int n3) {
        return n2;
    }

    @Override
    public Map<Integer, Integer> getGlyphs() {
        this.initGlyphIndices();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        for (int i2 = 0; i2 < this.glyphIndices.cardinality(); ++i2) {
            n2 = this.glyphIndices.nextSetBit(n2);
            hashMap.put(n2, n2);
            ++n2;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public char[] getChars() {
        return this.font.getChars();
    }

    @Override
    public int getNumberOfGlyphs() {
        this.initGlyphIndices();
        return this.glyphIndices.length();
    }

    @Override
    public BitSet getGlyphIndices() {
        this.initGlyphIndices();
        return this.glyphIndices;
    }

    @Override
    public int[] getWidths() {
        return this.font.getWidths();
    }

    @Override
    public boolean isVirtualGlyphIndex(int n2) {
        return false;
    }

    @Override
    public int getOriginalGlyphIndexForVirtual(int n2) {
        return 0;
    }
}

