/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.ChangeBar;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageProductionException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.xml.sax.Locator;

public class PageSequence
extends AbstractPageSequence
implements WritingModeTraitsGetter {
    private String masterReference;
    private Numeric referenceOrientation;
    private WritingModeTraits writingModeTraits;
    private Locale locale;
    private Map<String, FONode> flowMap;
    private SimplePageMaster simplePageMaster;
    private PageSequenceMaster pageSequenceMaster;
    private Title titleFO;
    private Flow mainFlow;
    private final List<ChangeBar> changeBarList = new LinkedList<ChangeBar>();
    private boolean restOfASequence;

    public PageSequence(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        String string = propertyList.get(81).getString();
        String string2 = propertyList.get(134).getString();
        this.locale = CommonHyphenation.toLocale(string2, string);
        this.masterReference = propertyList.get(154).getString();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.writingModeTraits = new WritingModeTraits(WritingMode.valueOf((int)propertyList.get(267).getEnum()), propertyList.getExplicit(267) != null);
        if (this.masterReference == null || this.masterReference.equals("")) {
            this.missingPropertyError("master-reference");
        }
        if ("rest".equals(propertyList.getFObj().getForeignAttributes().get(ChemistryExtensions.ATT_QNAME_REST_OF_SEQUENCE))) {
            this.restOfASequence = true;
        }
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.flowMap = new HashMap<String, FONode>();
        this.simplePageMaster = this.getRoot().getLayoutMasterSet().getSimplePageMaster(this.masterReference);
        if (this.simplePageMaster == null) {
            this.pageSequenceMaster = this.getRoot().getLayoutMasterSet().getPageSequenceMaster(this.masterReference);
            if (this.pageSequenceMaster == null) {
                this.getFOValidationEventProducer().masterNotFound((Object)this, this.getName(), this.masterReference, this.getLocator());
            }
        }
        this.getRoot().addPageSequence(this);
        this.getFOEventHandler().startPageSequence(this);
    }

    public void endOfNode() throws FOPException {
        if (this.mainFlow == null) {
            this.missingChildElementError("(title?,static-content*,flow)");
        }
        this.getFOEventHandler().endPageSequence(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("title".equals(string2)) {
                if (this.titleFO != null) {
                    this.tooManyNodesError(locator, "fo:title");
                } else if (!this.flowMap.isEmpty()) {
                    this.nodesOutOfOrderError(locator, "fo:title", "fo:static-content");
                } else if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(locator, "fo:title", "fo:flow");
                }
            } else if ("static-content".equals(string2)) {
                if (this.mainFlow != null) {
                    this.nodesOutOfOrderError(locator, "fo:static-content", "fo:flow");
                }
            } else if ("flow".equals(string2)) {
                if (this.mainFlow != null) {
                    this.tooManyNodesError(locator, "fo:flow");
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public void addChildNode(FONode fONode) throws FOPException {
        int n2 = fONode.getNameId();
        switch (n2) {
            case 80: {
                this.titleFO = (Title)fONode;
                break;
            }
            case 16: {
                this.mainFlow = (Flow)fONode;
                this.addFlow(this.mainFlow);
                break;
            }
            case 70: {
                this.addFlow((Flow)((StaticContent)fONode));
                this.flowMap.put(((Flow)fONode).getFlowName(), (FONode)((Flow)fONode));
                break;
            }
            default: {
                super.addChildNode(fONode);
            }
        }
    }

    private void addFlow(Flow flow) throws ValidationException {
        String string = flow.getFlowName();
        if (this.hasFlowName(string)) {
            this.getFOValidationEventProducer().duplicateFlowNameInPageSequence((Object)this, flow.getName(), string, flow.getLocator());
        }
        if (!(this.hasRegion(string) || string.equals("xsl-before-float-separator") || string.equals("xsl-footnote-separator"))) {
            this.getFOValidationEventProducer().flowNameNotMapped((Object)this, flow.getName(), string, flow.getLocator());
        }
    }

    private boolean hasRegion(String string) {
        LayoutMasterSet layoutMasterSet = this.getRoot().getLayoutMasterSet();
        PageSequenceMaster pageSequenceMaster = layoutMasterSet.getPageSequenceMaster(this.masterReference);
        return pageSequenceMaster != null ? pageSequenceMaster.getLayoutMasterSet().regionNameExists(string) : layoutMasterSet.getSimplePageMaster(this.masterReference).regionNameExists(string);
    }

    public StaticContent getStaticContent(String string) {
        return (StaticContent)this.flowMap.get(string);
    }

    public Title getTitleFO() {
        return this.titleFO;
    }

    public Flow getMainFlow() {
        return this.mainFlow;
    }

    public boolean hasFlowName(String string) {
        return this.flowMap.containsKey(string);
    }

    public Map<String, FONode> getFlowMap() {
        return this.flowMap;
    }

    public SimplePageMaster getNextSimplePageMaster(int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PageProductionException {
        boolean bl5;
        if (this.pageSequenceMaster == null) {
            return this.simplePageMaster;
        }
        boolean bl6 = bl5 = n2 % 2 != 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextSimplePageMaster(page=" + n2 + " isOdd=" + bl5 + " isFirst=" + bl + " isLast=" + bl2 + " isBlank=" + bl3 + ")"));
        }
        if (this.restOfASequence) {
            bl = false;
        }
        return this.pageSequenceMaster.getNextSimplePageMaster(bl5, bl, bl2, bl3, this.getMainFlow().getFlowName(), bl4 && this.forcePageCount != 99);
    }

    public boolean goToPreviousSimplePageMaster() {
        return this.pageSequenceMaster == null || this.pageSequenceMaster.goToPreviousSimplePageMaster();
    }

    public boolean hasPagePositionLast() {
        return this.pageSequenceMaster != null && this.pageSequenceMaster.hasPagePositionLast();
    }

    public boolean hasPagePositionOnly() {
        return this.pageSequenceMaster != null && this.pageSequenceMaster.hasPagePositionOnly();
    }

    public String getMasterReference() {
        return this.masterReference;
    }

    public String getLocalName() {
        return "page-sequence";
    }

    public int getNameId() {
        return 53;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getReferenceOrientation() {
        if (this.referenceOrientation != null) {
            return this.referenceOrientation.getValue();
        }
        return 0;
    }

    public Direction getInlineProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getInlineProgressionDirection();
        }
        return Direction.LR;
    }

    public Direction getBlockProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getBlockProgressionDirection();
        }
        return Direction.TB;
    }

    public Direction getColumnProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getColumnProgressionDirection();
        }
        return Direction.LR;
    }

    public Direction getRowProgressionDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getRowProgressionDirection();
        }
        return Direction.TB;
    }

    public Direction getShiftDirection() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getShiftDirection();
        }
        return Direction.TB;
    }

    public WritingMode getWritingMode() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getWritingMode();
        }
        return WritingMode.LR_TB;
    }

    public boolean getExplicitWritingMode() {
        if (this.writingModeTraits != null) {
            return this.writingModeTraits.getExplicitWritingMode();
        }
        return false;
    }

    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> stack, DelimitedTextRange delimitedTextRange) {
        Object object;
        Map<String, FONode> map = this.getFlowMap();
        if (map != null) {
            object = map.values().iterator();
            while (object.hasNext()) {
                FONode fONode = (FONode)object.next();
                if (!(fONode instanceof StaticContent)) continue;
                stack = ((StaticContent)fONode).collectDelimitedTextRanges(stack);
            }
        }
        if ((object = this.getMainFlow()) != null) {
            stack = object.collectDelimitedTextRanges(stack);
        }
        return stack;
    }

    protected boolean isBidiBoundary(boolean bl) {
        return true;
    }

    public void releasePageSequence() {
        this.mainFlow = null;
        this.flowMap.clear();
    }

    public SimplePageMaster getLastSimplePageMaster(int n2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = n2 % 2 != 0;
        if (this.restOfASequence) {
            bl = false;
        }
        log.debug((Object)("getNextSimplePageMaster(page=" + n2 + " isOdd=" + bl3 + " isFirst=" + bl + " isLast=true isBlank=" + bl2 + ")"));
        if (this.pageSequenceMaster == null) {
            return this.simplePageMaster;
        }
        return this.pageSequenceMaster.getLastSimplePageMaster(bl3, bl, bl2, this.getMainFlow().getFlowName());
    }

    public void pushChangeBar(ChangeBar changeBar) {
        this.changeBarList.add(changeBar);
    }

    public void popChangeBar(ChangeBar changeBar) {
        ChangeBar changeBar2 = this.getChangeBarBegin(changeBar);
        if (changeBar2 != null) {
            this.changeBarList.remove(changeBar2);
        }
    }

    public ChangeBar getChangeBarBegin(ChangeBar changeBar) {
        if (this.changeBarList.isEmpty()) {
            return null;
        }
        String string = changeBar.getChangeBarClass();
        for (int i2 = this.changeBarList.size() - 1; i2 >= 0; --i2) {
            ChangeBar changeBar2 = this.changeBarList.get(i2);
            if (!changeBar2.getChangeBarClass().equals(string)) continue;
            return changeBar2;
        }
        return null;
    }

    public boolean hasChangeBars() {
        return !this.changeBarList.isEmpty();
    }

    public List<ChangeBar> getChangeBarList() {
        return this.changeBarList;
    }

    public List<ChangeBar> getClonedChangeBarList() {
        return new LinkedList<ChangeBar>(this.changeBarList);
    }

    public void setOnlyTryInfinite(boolean bl) {
        if (this.pageSequenceMaster != null) {
            this.pageSequenceMaster.onlyTryInfinite = bl;
        }
    }
}

