/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.xml.sax.Locator;

public class TableAndCaption
extends BlockContainer {
    private CommonAccessibility commonAccessibility;
    static boolean notImplementedWarningGiven;
    private boolean tableCaptionFound;
    private boolean tableFound;
    private boolean tableCaptionForNextPageFound;

    public TableAndCaption(FONode fONode) {
        super(fONode);
    }

    @Override
    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance((PropertyList)propertyList);
    }

    @Override
    public void endOfNode() throws FOPException {
        if (!this.tableFound) {
            this.missingChildElementError("marker* table-caption? table");
        }
    }

    @Override
    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.tableCaptionFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "fo:table-caption");
                } else if (this.tableFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "fo:table");
                }
            } else if (string2.equals("table-caption")) {
                this.tableCaptionFound = true;
            } else if (string2.equals("table-caption-for-next-page")) {
                this.tableCaptionForNextPageFound = true;
            } else if (string2.equals("table")) {
                if (this.tableFound) {
                    this.tooManyNodesError(locator, "fo:table");
                } else {
                    this.tableFound = true;
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    @Override
    public String getLocalName() {
        return "table-and-caption";
    }

    @Override
    public int getNameId() {
        return 72;
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public boolean isTableAndCaptionFound() {
        return this.tableCaptionFound && this.tableFound;
    }

    public boolean isRepeatingCaptionsOnNextPages() {
        return this.tableCaptionForNextPageFound;
    }
}

