/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

public class EffRow {
    public static final int FIRST_IN_PART = 0;
    public static final int LAST_IN_PART = 1;
    private List<GridUnit> gridUnits = new ArrayList<GridUnit>();
    private int index;
    private int bodyType;
    private MinOptMax height;
    private MinOptMax explicitHeight;

    public EffRow(int n2, int n3, List list) {
        this.index = n2;
        this.bodyType = n3;
        this.gridUnits = list;
        for (Object e2 : list) {
            if (!(e2 instanceof PrimaryGridUnit)) continue;
            ((PrimaryGridUnit)((Object)e2)).setRowIndex(n2);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public TableRow getTableRow() {
        return this.getGridUnit(0).getRow();
    }

    public MinOptMax getHeight() {
        return this.height;
    }

    public void setHeight(MinOptMax minOptMax) {
        this.height = minOptMax;
    }

    public MinOptMax getExplicitHeight() {
        return this.explicitHeight;
    }

    public void setExplicitHeight(MinOptMax minOptMax) {
        this.explicitHeight = minOptMax;
    }

    public List<GridUnit> getGridUnits() {
        return this.gridUnits;
    }

    public GridUnit getGridUnit(int n2) {
        return this.gridUnits.get(n2);
    }

    public GridUnit safelyGetGridUnit(int n2) {
        if (n2 < this.gridUnits.size()) {
            return this.gridUnits.get(n2);
        }
        return null;
    }

    public boolean getFlag(int n2) {
        if (n2 == 0) {
            return this.getGridUnit(0).getFlag(0);
        }
        if (n2 == 1) {
            return this.getGridUnit(0).getFlag(1);
        }
        throw new IllegalArgumentException("Illegal flag queried: " + n2);
    }

    public Keep getKeepWithPrevious() {
        Keep keep = Keep.KEEP_AUTO;
        TableRow tableRow = this.getTableRow();
        if (tableRow != null) {
            keep = Keep.getKeep((KeepProperty)tableRow.getKeepWithPrevious());
        }
        for (GridUnit gridUnit : this.gridUnits) {
            GridUnit gridUnit2 = gridUnit;
            if (!gridUnit2.isPrimary()) continue;
            keep = keep.compare(gridUnit2.getPrimary().getKeepWithPrevious());
        }
        return keep;
    }

    public Keep getKeepWithNext() {
        Keep keep = Keep.KEEP_AUTO;
        TableRow tableRow = this.getTableRow();
        if (tableRow != null) {
            keep = Keep.getKeep((KeepProperty)tableRow.getKeepWithNext());
        }
        for (GridUnit gridUnit : this.gridUnits) {
            GridUnit gridUnit2 = gridUnit;
            if (gridUnit2.isEmpty() || gridUnit2.getColSpanIndex() != 0 || !gridUnit2.isLastGridUnitRowSpan()) continue;
            keep = keep.compare(gridUnit2.getPrimary().getKeepWithNext());
        }
        return keep;
    }

    public Keep getKeepTogether() {
        TableRow tableRow = this.getTableRow();
        Keep keep = Keep.KEEP_AUTO;
        if (tableRow != null) {
            keep = Keep.getKeep((KeepProperty)tableRow.getKeepTogether());
        }
        return keep;
    }

    public int getBreakBefore() {
        int n2 = 9;
        for (GridUnit gridUnit : this.gridUnits) {
            GridUnit gridUnit2 = gridUnit;
            if (!gridUnit2.isPrimary()) continue;
            n2 = BreakUtil.compareBreakClasses((int)n2, (int)gridUnit2.getPrimary().getBreakBefore());
        }
        return n2;
    }

    public int getBreakAfter() {
        int n2 = 9;
        for (GridUnit gridUnit : this.gridUnits) {
            GridUnit gridUnit2 = gridUnit;
            if (gridUnit2.isEmpty() || gridUnit2.getColSpanIndex() != 0 || !gridUnit2.isLastGridUnitRowSpan()) continue;
            n2 = BreakUtil.compareBreakClasses((int)n2, (int)gridUnit2.getPrimary().getBreakAfter());
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EffRow {");
        stringBuffer.append(this.index);
        if (this.getBodyType() == 0) {
            stringBuffer.append(" in body");
        } else if (this.getBodyType() == 1) {
            stringBuffer.append(" in header");
        } else {
            stringBuffer.append(" in footer");
        }
        stringBuffer.append(", ").append(this.height);
        stringBuffer.append(", ").append(this.explicitHeight);
        stringBuffer.append(", ").append(this.gridUnits.size()).append(" gu");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

