/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Iterator;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.table.Table;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class AbstractRetrieveMarker
extends FObjMixed {
    private PropertyList propertyList;
    private String retrieveClassName;
    private int position;
    private String positionLabel;
    private int boundary;
    private String boundaryLabel;
    private StructureTreeElement structureTreeElement;

    public AbstractRetrieveMarker(FONode fONode) {
        super(fONode);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.retrieveClassName = propertyList.get(207).getString();
        if (this.retrieveClassName == null || this.retrieveClassName.equals("")) {
            this.missingPropertyError("retrieve-class-name");
        }
        this.propertyList = propertyList.getParentPropertyList();
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    private PropertyList createPropertyListFor(FObj fObj, PropertyList propertyList) {
        return this.getBuilderContext().getPropertyListMaker().make(fObj, propertyList);
    }

    private void cloneSingleNode(FONode fONode, FONode fONode2, Marker marker, PropertyList propertyList) throws FOPException {
        if (fONode != null) {
            FONode fONode3 = fONode.clone(fONode2, true);
            if (fONode instanceof FObj) {
                PropertyList propertyList2 = this.createPropertyListFor((FObj)fONode3, propertyList);
                Marker.MarkerPropertyList markerPropertyList = marker.getPropertyListFor(fONode);
                fONode3.processNode(fONode.getLocalName(), this.getLocator(), (Attributes)markerPropertyList, propertyList2);
                AbstractRetrieveMarker.addChildTo((FONode)fONode3, (FONode)fONode2);
                fONode3.startOfNode();
                switch (fONode3.getNameId()) {
                    case 71: {
                        Table table = (Table)((Object)fONode);
                        this.cloneSubtree(table.getColumns().iterator(), fONode3, marker, propertyList2);
                        this.cloneSingleNode((FONode)table.getTableHeader(), fONode3, marker, propertyList2);
                        this.cloneSingleNode((FONode)table.getTableFooter(), fONode3, marker, propertyList2);
                        this.cloneSubtree(fONode.getChildNodes(), fONode3, marker, propertyList2);
                        break;
                    }
                    case 41: {
                        ListItem listItem = (ListItem)((Object)fONode);
                        this.cloneSingleNode((FONode)((Object)listItem.getLabel()), fONode3, marker, propertyList2);
                        this.cloneSingleNode((FONode)listItem.getBody(), fONode3, marker, propertyList2);
                        break;
                    }
                    default: {
                        this.cloneSubtree(fONode.getChildNodes(), fONode3, marker, propertyList2);
                    }
                }
                fONode3.endOfNode();
            } else if (fONode instanceof FOText) {
                FOText fOText = (FOText)fONode3;
                fOText.bind(propertyList);
                AbstractRetrieveMarker.addChildTo((FONode)fONode3, (FONode)fONode2);
                if (fONode2 instanceof AbstractRetrieveMarker) {
                    fONode3.endOfNode();
                }
            } else if (fONode instanceof XMLObj) {
                AbstractRetrieveMarker.addChildTo((FONode)fONode3, (FONode)fONode2);
            }
        }
    }

    private void cloneSubtree(Iterator iterator, FONode fONode, Marker marker, PropertyList propertyList) throws FOPException {
        if (iterator != null) {
            while (iterator.hasNext()) {
                FONode fONode2 = (FONode)iterator.next();
                this.cloneSingleNode(fONode2, fONode, marker, propertyList);
            }
        }
    }

    private void cloneFromMarker(Marker marker) throws FOPException {
        this.cloneSubtree(marker.getChildNodes(), (FONode)((Object)this), marker, this.propertyList);
        if (this.getUserAgent().isComplexScriptFeaturesEnabled()) {
            FONode.FONodeIterator fONodeIterator = this.getChildNodes();
            while (fONodeIterator.hasNext()) {
                FONode fONode = (FONode)fONodeIterator.next();
                Stack<DelimitedTextRange> stack = new Stack<DelimitedTextRange>();
                stack.add(new DelimitedTextRange((FONode)((Object)this)));
                BidiResolver.resolveInlineDirectionality(fONode, stack);
            }
        }
        AbstractRetrieveMarker.handleWhiteSpaceFor(this, null);
    }

    public void bindMarker(Marker marker) {
        if (this.firstChild != null) {
            this.currentTextNode = null;
            this.firstChild = null;
        }
        if (marker.getChildNodes() != null) {
            try {
                this.restoreFOEventHandlerState();
                this.cloneFromMarker(marker);
            }
            catch (FOPException fOPException) {
                this.getFOValidationEventProducer().markerCloningFailed((Object)this, marker.getMarkerClassName(), fOPException, this.getLocator());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Empty marker retrieved...");
        }
    }

    protected abstract void restoreFOEventHandlerState();

    public String getRetrieveClassName() {
        return this.retrieveClassName;
    }

    protected void setBoundaryLabel(String string) {
        this.boundaryLabel = string;
    }

    protected void setPositionLabel(String string) {
        this.positionLabel = string;
    }

    public String getBoundaryLabel() {
        return this.boundaryLabel;
    }

    public String getPositionLabel() {
        return this.positionLabel;
    }

    protected void setPosition(int n2) {
        this.position = n2;
    }

    protected void setBoundary(int n2) {
        this.boundary = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public int getBoundary() {
        return this.boundary;
    }

    public abstract String getLocalName();

    public abstract int getNameId();

    public void changePositionTo(int n2) {
        this.position = n2;
    }
}

