/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.ChemistryExtensions;

public class GatherContextInfoUtil {
    private static final int LIMIT = 80;

    private GatherContextInfoUtil() {
    }

    public static String gatherContextInfo(FONode fONode) {
        StringBuilder stringBuilder = new StringBuilder();
        GatherContextInfoUtil.gatherContextInfoRecurse(fONode, stringBuilder);
        if (stringBuilder.length() > 80) {
            stringBuilder.setLength(80);
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }

    private static void gatherContextInfoRecurse(FONode fONode, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 80) {
            return;
        }
        if ("#PCDATA".equals(fONode.getLocalName())) {
            GatherContextInfoUtil.gatherFromTextNode(fONode, stringBuilder);
        } else {
            FONode.FONodeIterator fONodeIterator;
            if (fONode instanceof FObj) {
                GatherContextInfoUtil.gatherFromId((FObj)fONode, stringBuilder);
            }
            if ((fONodeIterator = fONode.getChildNodes()) != null) {
                while (fONodeIterator.hasNext()) {
                    FONode fONode2 = fONodeIterator.next();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    GatherContextInfoUtil.gatherContextInfoRecurse(fONode2, stringBuilder2);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
        }
    }

    private static void gatherFromId(FObj fObj, StringBuilder stringBuilder) {
        String string = (String)fObj.getForeignAttributes().get(ChemistryExtensions.ATT_QNAME_ND_ID);
        if (string == null) {
            string = fObj.getId();
        }
        if (string != null && !string.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("id=");
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("'");
        }
    }

    private static void gatherFromTextNode(FONode fONode, StringBuilder stringBuilder) {
        String string = GatherContextInfoUtil.normalize(fONode.toString());
        if (string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append('\"');
        }
    }

    static String normalize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (!bl) {
                    stringBuilder.append(" ");
                }
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
            bl = false;
        }
        if (bl && stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

