/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.table.properties;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelperBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocbookCALSTableHelper
extends TablePropertiesHelperBase {
    private static final String CELL_ELEMENT = "<entry></entry>";
    private static final String ROW_ELEMENT = "<row></row>";
    private static final String FOOTER_ELEMENT = "<tfoot></tfoot>";
    private static final String HEADER_ELEMENT = "<thead></thead>";
    private static final String BODY_ELEMENT = "<tbody></tbody>";

    @Override
    public boolean isTableBody(AuthorElement node) {
        return "tbody".equals(node.getLocalName());
    }

    @Override
    public boolean isTableRow(AuthorElement node) {
        return "row".equals(node.getLocalName());
    }

    @Override
    public boolean isTableHead(AuthorElement node) {
        return "thead".equals(node.getLocalName());
    }

    @Override
    public boolean isTableFoot(AuthorElement element) {
        return "tfoot".equals(element.getLocalName());
    }

    @Override
    public boolean isTable(AuthorElement element) {
        return "table".equals(element.getLocalName()) || "tgroup".equals(element.getLocalName());
    }

    @Override
    public boolean isTableGroup(AuthorElement element) {
        return "tgroup".equals(element.getLocalName());
    }

    @Override
    public boolean isTableColspec(AuthorElement element) {
        return "colspec".equals(element.getLocalName());
    }

    @Override
    public boolean isTableCell(AuthorElement element) {
        return "entry".equals(element.getLocalName());
    }

    @Override
    public String getElementTag(int elementType) {
        String elementName = "";
        switch (elementType) {
            case 1: {
                elementName = BODY_ELEMENT;
                break;
            }
            case 2: {
                elementName = HEADER_ELEMENT;
                break;
            }
            case 3: {
                elementName = FOOTER_ELEMENT;
                break;
            }
            case 0: {
                elementName = ROW_ELEMENT;
                break;
            }
            case 6: {
                elementName = CELL_ELEMENT;
                break;
            }
        }
        return elementName;
    }

    @Override
    public boolean allowsFooter() {
        return true;
    }
}

