/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook.link;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.docbook.link.InsertLinkUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
@WebappRestSafe
public class InsertULink
implements AuthorOperation {
    private static final String ARGUMENT_URL_VALUE = "url_value";

    public String getDescription() {
        return "Insert an ulink";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String urlValue = (String)args.getArgumentValue(ARGUMENT_URL_VALUE);
        if (urlValue == null) {
            urlValue = InsertLinkUtil.chooseURLForLink(authorAccess, authorAccess.getAuthorResourceBundle().getMessage("insert.web.ulink"));
        }
        InsertULink.insertULink(urlValue, authorAccess, true);
    }

    private static void insertULink(String url, AuthorAccess authorAccess, boolean schemaAware) throws AuthorOperationException {
        if (url != null) {
            CommonsOperationsUtil.surroundWithFragment(authorAccess, schemaAware, "<ulink url=\"" + url + "\"/>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }
}

