/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.docbook.PromoteDemoteSectionUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class PromoteDemoteSectionOperation
implements AuthorOperation {
    public static final String ARGUMENT_ACTION = "Action";
    public static final String ARG_VALUE_PROMOTE = "Promote";
    public static final String ARG_VALUE_DEMOTE = "Demote";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("Action", 3, "The argument specifies if the section will be promoted or demoted.", new String[]{"Promote", "Demote"}, "Promote")};

    public String getDescription() {
        return "Promote/demote section elements for Docbook.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object argumentValue = args.getArgumentValue(ARGUMENT_ACTION);
        try {
            authorAccess.getDocumentController().beginCompoundEdit();
            if (ARG_VALUE_PROMOTE.equals(argumentValue)) {
                PromoteDemoteSectionUtil.processPromoteDemote(authorAccess, PromoteDemoteSectionUtil.PromoteDemote.PROMOTE);
            } else {
                PromoteDemoteSectionUtil.processPromoteDemote(authorAccess, PromoteDemoteSectionUtil.PromoteDemote.DEMOTE);
            }
        }
        finally {
            authorAccess.getDocumentController().endCompoundEdit();
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

