/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.MediaFileChooser;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public abstract class InsertMediaDataOperationBase
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)InsertMediaDataOperationBase.class.getName());
    public static final String ARGUMENT_MEDIA_URL = "mediaUrl";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("mediaUrl", 0, "The URL of the media file. If not defined, a file chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object mediaUrl = args.getArgumentValue(ARGUMENT_MEDIA_URL);
        String ref = null;
        ref = mediaUrl instanceof String ? MediaFileChooser.makeUrlRelative(authorAccess, (String)mediaUrl) : MediaFileChooser.chooseMediaFile(authorAccess);
        if (ref != null) {
            this.insertMediaRef(authorAccess, ref);
        }
    }

    public SchemaAwareHandlerResult insertMediaRef(AuthorAccess authorAccess, String ref) throws AuthorOperationException {
        SchemaAwareHandlerResult result = null;
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        ref = authorAccess.getXMLUtilAccess().escapeAttributeValue(ref);
        ref = MediaObjectsUtil.correctMediaEmbeddedReference(ref);
        String mediaObjectType = "videoobject";
        String mediaDataType = "videodata";
        if (MediaObjectsUtil.isAudioReference(ref)) {
            mediaObjectType = "audioobject";
            mediaDataType = "audiodata";
        }
        StringBuilder fragment = new StringBuilder();
        boolean isInlineMediaObjectAccepted = false;
        try {
            isInlineMediaObjectAccepted = CommonsOperationsUtil.isAllowedElement("inlinemediaobject", editorAccess.getCaretOffset(), authorSchemaManager);
        }
        catch (BadLocationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (isInlineMediaObjectAccepted) {
            fragment.append("<inlinemediaobject ");
            fragment.append(this.insertNamespace());
            fragment.append("><").append(mediaObjectType).append("><").append(mediaDataType);
        } else {
            fragment = new StringBuilder();
            fragment.append("<mediaobject");
            fragment.append(this.insertNamespace());
            fragment.append("><");
            fragment.append(mediaObjectType).append("><").append(mediaDataType);
        }
        fragment.append(" fileref=\"");
        fragment.append(ref);
        fragment.append("\"/></").append(mediaObjectType).append(">");
        if (isInlineMediaObjectAccepted) {
            fragment.append("</inlinemediaobject>");
        } else {
            fragment.append("</mediaobject>");
        }
        result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(fragment.toString(), editorAccess.getCaretOffset());
        return result;
    }

    protected abstract String insertNamespace();

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a DocBook media object";
    }
}

