/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandlerAdapter;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResultsImpl;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocbookSchemaAwareEditingHandler
extends AuthorSchemaAwareEditingHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookSchemaAwareEditingHandler.class.getName());
    protected final String documentNamespace;
    private static final String ITEMIZED_LIST = "itemizedlist";
    private static final String LIST_ITEM = "listitem";
    private static final String SECT1 = "sect1";
    private static final String SECT2 = "sect2";
    private static final String SECT3 = "sect3";
    private static final String SECT4 = "sect4";
    private static final String SECT5 = "sect5";
    private static final String SECTION = "section";
    private static final String ORDERED_LIST = "orderedlist";
    private static final String HTML_TABLE = "table";
    private static final String CALS_TABLE = "tgroup";
    private static final String TABLE_HEAD = "thead";
    private static final String TABLE_FOOT = "tfoot";
    private static final String TABLE_BODY = "tbody";
    private static final String CALS_TABLE_ROW = "row";
    private static final String CALS_TABLE_ENTRY = "entry";
    private static final String HTML_TABLE_ROW = "tr";
    private static final String HTML_TABLE_ENTRY = "td";
    protected static final String PARA = "para";
    protected static final String TITLE = "title";
    protected static final String INFO_SUFIX = "info";

    public DocbookSchemaAwareEditingHandler(String documentNamespace) {
        this.documentNamespace = documentNamespace;
    }

    public boolean handleTyping(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleTyping = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartTyping()) {
            try {
                AuthorDocumentFragment characterFragment = authorAccess.getDocumentController().createNewDocumentTextFragment(String.valueOf(ch));
                handleTyping = this.handleInsertionEvent(offset, new AuthorDocumentFragment[]{characterFragment}, authorAccess);
            }
            catch (AuthorOperationException e) {
                throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), (Throwable)e, false);
            }
        }
        return handleTyping;
    }

    public boolean handleTypingFallback(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleEvent = false;
        try {
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            if (context != null) {
                StringBuilder xmlFragment = new StringBuilder("<");
                xmlFragment.append(PARA);
                xmlFragment.append(this.getCurrentDocNsAttrFrag());
                xmlFragment.append("/>");
                boolean canInsertRow = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), offset)}, context, (short)4);
                if (canInsertRow) {
                    authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                    authorAccess.getDocumentController().insertText(offset + 1, String.valueOf(ch));
                    this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                    ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)(offset + 1));
                    handleEvent = true;
                } else {
                    logger.debug("Fragments cannot be inserted in a para element.");
                }
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    public boolean handlePasteFragment(int offset, AuthorDocumentFragment[] fragmentsToInsert, int actionId, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleInsertionEvent = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartPaste()) {
            handleInsertionEvent = this.handleInsertionEvent(offset, fragmentsToInsert, authorAccess);
        }
        return handleInsertionEvent;
    }

    private boolean handleInsertionEvent(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess) throws InvalidEditException {
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        boolean handleEvent = false;
        try {
            AuthorNode nodeAtInsertionOffset = authorAccess.getDocumentController().getNodeAtOffset(offset);
            logger.debug("nodeAtInsertionOffset {}", (Object)nodeAtInsertionOffset);
            if (this.isElementWithNameAndNamespace(nodeAtInsertionOffset, ITEMIZED_LIST) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, ORDERED_LIST)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInLists(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (this.isElementWithNameAndNamespace(nodeAtInsertionOffset, TABLE_BODY) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, TABLE_FOOT) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, TABLE_HEAD) || this.isHTMLTable(nodeAtInsertionOffset)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInTable(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECT1) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECT2) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECT3) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECT4) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECT5) || this.isElementWithNameAndNamespace(nodeAtInsertionOffset, SECTION)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInSect(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventSurroundingInPara(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    private boolean isHTMLTable(AuthorNode node) {
        boolean htmlTable = false;
        if (this.isElementWithNameAndNamespace(node, HTML_TABLE)) {
            htmlTable = true;
            AuthorElement element = (AuthorElement)node;
            List contentNodes = element.getContentNodes();
            for (AuthorNode authorNode : contentNodes) {
                if (!this.isElementWithNameAndNamespace(authorNode, CALS_TABLE)) continue;
                htmlTable = false;
                break;
            }
        }
        return htmlTable;
    }

    private boolean handleInvalidInsertionEventInSect(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        AuthorElement sectElement = (AuthorElement)authorAccess.getDocumentController().getNodeAtOffset(offset);
        if (sectElement.getStartOffset() + 1 == sectElement.getEndOffset()) {
            handleEvent = this.handleInvalidInsertionEventInEmptySect(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
        } else {
            List contentNodes = sectElement.getContentNodes();
            if (contentNodes.size() == 1) {
                boolean isTitleChild;
                AuthorNode child = (AuthorNode)contentNodes.get(0);
                boolean bl = isTitleChild = this.isElementWithNameAndNamespace(child, TITLE) || this.isElementWithNameAndNamespace(child, this.getInfoElementChildOfSect(sectElement.getLocalName()));
                if (isTitleChild && child.getEndOffset() < offset) {
                    WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
                    this.pushContextElement(context, PARA);
                    if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
                        StringBuilder xmlFragment = new StringBuilder("<").append(PARA);
                        xmlFragment.append(this.getCurrentDocNsAttrFrag());
                        xmlFragment.append('>').append("</").append(PARA).append('>');
                        authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                        int insertionOffset = -1;
                        AuthorNode newParaNode = authorAccess.getDocumentController().getNodeAtOffset(offset + 1);
                        for (int i = 0; i < fragmentsToInsert.length; ++i) {
                            if (insertionOffset == -1) {
                                insertionOffset = newParaNode.getEndOffset();
                            }
                            authorAccess.getDocumentController().insertFragment(newParaNode.getEndOffset(), fragmentsToInsert[i]);
                        }
                        this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                        ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
                        handleEvent = true;
                    } else {
                        logger.debug("Fragments cannot be inserted in a para element.");
                    }
                }
            }
        }
        return handleEvent;
    }

    private boolean handleInvalidInsertionEventInEmptySect(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        this.pushContextElement(context, TITLE);
        if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
            StringBuilder xmlFragment = new StringBuilder("<").append(TITLE);
            xmlFragment.append(this.getCurrentDocNsAttrFrag());
            xmlFragment.append(">").append("</").append(TITLE).append(">");
            logger.debug("Insert {}", (Object)xmlFragment);
            authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
            AuthorNode newParaNode = authorAccess.getDocumentController().getNodeAtOffset(offset + 1);
            int insertionOffset = -1;
            for (int i = 0; i < fragmentsToInsert.length; ++i) {
                if (insertionOffset == -1) {
                    insertionOffset = newParaNode.getEndOffset();
                }
                authorAccess.getDocumentController().insertFragment(newParaNode.getEndOffset(), fragmentsToInsert[i]);
            }
            this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
            ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
            handleEvent = true;
        } else {
            logger.debug("Fragments cannot be inserted in a para element.");
        }
        return handleEvent;
    }

    protected String getInfoElementChildOfSect(String sectElementName) {
        return sectElementName.concat(INFO_SUFIX);
    }

    private boolean handleInvalidInsertionEventInLists(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        this.pushContextElement(context, LIST_ITEM);
        this.pushContextElement(context, PARA);
        if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
            StringBuilder xmlFragment = new StringBuilder("<").append(LIST_ITEM);
            xmlFragment.append(this.getCurrentDocNsAttrFrag());
            xmlFragment.append("><").append(PARA).append("/></").append(LIST_ITEM).append(">");
            logger.debug("Insert {}", (Object)xmlFragment);
            authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
            int insertionOffset = -1;
            AuthorNode newParaNode = authorAccess.getDocumentController().getNodeAtOffset(offset + 2);
            for (int i = 0; i < fragmentsToInsert.length; ++i) {
                if (insertionOffset == -1) {
                    insertionOffset = newParaNode.getEndOffset();
                }
                authorAccess.getDocumentController().insertFragment(newParaNode.getEndOffset(), fragmentsToInsert[i]);
            }
            this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
            ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
            handleEvent = true;
        } else {
            logger.debug("Fragments cannot be inserted in a para element.");
        }
        return handleEvent;
    }

    protected void pushContextElement(WhatElementsCanGoHereContext context, String elementName) {
        ContextElement contextElement = new ContextElement();
        contextElement.setQName(elementName);
        contextElement.setNamespace(this.documentNamespace);
        context.pushContextElement(contextElement, null);
    }

    protected boolean isElementWithNameAndNamespace(AuthorNode node, String elementLocalName) {
        boolean result = false;
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            result = elementLocalName.equals(element.getLocalName()) && element.getNamespace().equals(this.documentNamespace);
        }
        return result;
    }

    private boolean handleInvalidInsertionEventSurroundingInPara(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        if (context != null) {
            boolean allowsPara = false;
            List whatElementsCanGoHere = authorSchemaManager.whatElementsCanGoHere(context);
            if (whatElementsCanGoHere != null) {
                for (CIElement ciElement : whatElementsCanGoHere) {
                    if (!PARA.equals(ciElement.getName()) || !this.documentNamespace.equals(ciElement.getNamespace() != null ? ciElement.getNamespace() : "")) continue;
                    allowsPara = true;
                    break;
                }
            }
            if (allowsPara) {
                this.pushContextElement(context, PARA);
                if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
                    StringBuilder xmlFragment = new StringBuilder("<").append(PARA);
                    xmlFragment.append(this.getCurrentDocNsAttrFrag());
                    xmlFragment.append("/>");
                    logger.debug("Insert {}", (Object)xmlFragment);
                    authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                    AuthorNode newParaNode = authorAccess.getDocumentController().getNodeAtOffset(offset + 1);
                    int insertionOffset = -1;
                    for (int i = 0; i < fragmentsToInsert.length; ++i) {
                        if (insertionOffset == -1) {
                            insertionOffset = newParaNode.getEndOffset();
                        }
                        authorAccess.getDocumentController().insertFragment(newParaNode.getEndOffset(), fragmentsToInsert[i]);
                    }
                    this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                    ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
                    handleEvent = true;
                } else {
                    logger.debug("Fragments cannot be inserted in a para element.");
                }
            }
        }
        return handleEvent;
    }

    private boolean handleInvalidInsertionEventInTable(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        AuthorNode tablePart = authorAccess.getDocumentController().getNodeAtOffset(offset);
        AuthorNode table = ((AuthorElement)tablePart).getParent();
        boolean isCALS = this.isElementWithNameAndNamespace(table, CALS_TABLE);
        StringBuilder xmlFragment = new StringBuilder("<");
        if (isCALS) {
            xmlFragment.append(CALS_TABLE_ROW);
        } else {
            xmlFragment.append(HTML_TABLE_ROW);
        }
        xmlFragment.append(this.getCurrentDocNsAttrFrag());
        xmlFragment.append("/>");
        boolean canInsertRow = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), offset)}, context, (short)4);
        if (canInsertRow) {
            if (isCALS) {
                this.pushContextElement(context, CALS_TABLE_ROW);
                this.pushContextElement(context, CALS_TABLE_ENTRY);
            } else {
                this.pushContextElement(context, HTML_TABLE_ROW);
                this.pushContextElement(context, HTML_TABLE_ENTRY);
            }
            if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
                xmlFragment = new StringBuilder("<");
                if (isCALS) {
                    xmlFragment.append(CALS_TABLE_ROW);
                } else {
                    xmlFragment.append(HTML_TABLE_ROW);
                }
                xmlFragment.append(this.getCurrentDocNsAttrFrag());
                xmlFragment.append("><");
                if (isCALS) {
                    xmlFragment.append(CALS_TABLE_ENTRY);
                } else {
                    xmlFragment.append(HTML_TABLE_ENTRY);
                }
                xmlFragment.append("/></");
                if (isCALS) {
                    xmlFragment.append(CALS_TABLE_ROW);
                } else {
                    xmlFragment.append(HTML_TABLE_ROW);
                }
                xmlFragment.append(">");
                logger.debug("Insert {}", (Object)xmlFragment);
                authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                AuthorNode newCell = authorAccess.getDocumentController().getNodeAtOffset(offset + 2);
                int insertionOffset = -1;
                for (int i = 0; i < fragmentsToInsert.length; ++i) {
                    if (insertionOffset == -1) {
                        insertionOffset = newCell.getEndOffset();
                    }
                    authorAccess.getDocumentController().insertFragment(newCell.getEndOffset(), fragmentsToInsert[i]);
                }
                this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
                handleEvent = true;
            } else {
                logger.debug("Fragments cannot be inserted in a para element.");
            }
        }
        return handleEvent;
    }

    public boolean changeElementsToMoveUpDown(List<AuthorNode> selectedElements) {
        AuthorNode parent;
        boolean elementsChanged = false;
        AuthorNode authorNode = selectedElements.get(0);
        if (this.isElementWithNameAndNamespace(authorNode, TITLE) && (parent = authorNode.getParent()) != null) {
            selectedElements.clear();
            selectedElements.add(parent);
            elementsChanged = true;
        }
        return elementsChanged;
    }

    public AuthorSchemaAwareEditingHandlerAdapter.WrapInAncestorsOptions getAncestorDetectionOptions() {
        return new AuthorSchemaAwareEditingHandlerAdapter.WrapInAncestorsOptions(){

            public Set<QName> getForbiddenParents(QName elementName, Collection<QName> possibleParents) {
                return null;
            }

            public Set<QName> getPreferredParents(QName elementName, Collection<QName> possibleParents) {
                QName[] prefs = null;
                String localPart = elementName.getLocalPart();
                if (DocbookSchemaAwareEditingHandler.CALS_TABLE_ENTRY.equals(localPart)) {
                    prefs = new QName[]{new QName(DocbookSchemaAwareEditingHandler.TABLE_BODY)};
                } else if ("colspec".equals(localPart) || DocbookSchemaAwareEditingHandler.TABLE_FOOT.equals(localPart) || DocbookSchemaAwareEditingHandler.TABLE_BODY.equals(localPart) || DocbookSchemaAwareEditingHandler.TABLE_HEAD.equals(localPart)) {
                    prefs = new QName[]{new QName(DocbookSchemaAwareEditingHandler.CALS_TABLE)};
                } else if (DocbookSchemaAwareEditingHandler.CALS_TABLE.equals(localPart)) {
                    prefs = new QName[]{new QName(DocbookSchemaAwareEditingHandler.HTML_TABLE)};
                } else {
                    Arrays.asList(new QName("p"));
                }
                return prefs != null ? new HashSet<QName>(Arrays.asList(prefs)) : null;
            }
        };
    }

    public QName getPreferredElement(AuthorDocumentController ctrl, int offset) {
        return new QName(this.documentNamespace, PARA);
    }

    private String getCurrentDocNsAttrFrag() {
        Object nsFrag = "";
        if (this.documentNamespace != null && this.documentNamespace.length() != 0) {
            nsFrag = " xmlns=\"" + this.documentNamespace + "\"";
        }
        return nsFrag;
    }
}

