/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.docbook;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandler;
import ro.sync.ecss.extensions.api.ProfilingConditionalTextProvider;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentProcessor;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.docbook.DocBookExtensionsBundleBase;
import ro.sync.ecss.extensions.docbook.Docbook5ExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.docbook.Docbook5SchemaAwareEditingHandler;
import ro.sync.ecss.extensions.docbook.DocbookAuthorTableOperationsHandler;
import ro.sync.ecss.extensions.docbook.id.Docbook5UniqueAttributesRecognizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DocBook5ExtensionsBundle
extends DocBookExtensionsBundleBase {
    private static final String DOCBOOK5_NAMESPACE = "http://docbook.org/ns/docbook";
    private DocbookAuthorTableOperationsHandler docbookAuthorTableOperationsHandler;
    private Docbook5UniqueAttributesRecognizer uniqueAttributesRecognizer;
    private Docbook5SchemaAwareEditingHandler schemaAwareEditingSupport;

    public AuthorExtensionStateListener createAuthorExtensionStateListener() {
        this.uniqueAttributesRecognizer = new Docbook5UniqueAttributesRecognizer();
        return this.uniqueAttributesRecognizer;
    }

    public String getDescription() {
        return "DocBook 5 extensions bundle implementation";
    }

    public String getDocumentTypeID() {
        return "DocBook.5.document.type";
    }

    public UniqueAttributesRecognizer getUniqueAttributesIdentifier() {
        return this.uniqueAttributesRecognizer;
    }

    public ClipboardFragmentProcessor getClipboardFragmentProcessor() {
        return this.uniqueAttributesRecognizer;
    }

    @Override
    protected String getDocumentNamespace() {
        return DOCBOOK5_NAMESPACE;
    }

    public AuthorSchemaAwareEditingHandler getAuthorSchemaAwareEditingHandler() {
        if (this.schemaAwareEditingSupport == null) {
            this.schemaAwareEditingSupport = new Docbook5SchemaAwareEditingHandler(this.getDocumentNamespace());
        }
        return this.schemaAwareEditingSupport;
    }

    public AuthorExternalObjectInsertionHandler createExternalObjectInsertionHandler() {
        return new Docbook5ExternalObjectInsertionHandler();
    }

    public ProfilingConditionalTextProvider getProfilingConditionalTextProvider() {
        return new ProfilingConditionalTextProvider(){

            public String getXMLFragmentForContentProfiling(int startOffset, int endOffset, AuthorAccess authorAccess) {
                return "<phrase xmlns=\"http://docbook.org/ns/docbook\"/>";
            }
        };
    }

    public AuthorTableOperationsHandler getAuthorTableOperationsHandler() {
        if (this.docbookAuthorTableOperationsHandler == null) {
            this.docbookAuthorTableOperationsHandler = new DocbookAuthorTableOperationsHandler(DOCBOOK5_NAMESPACE);
        }
        return this.docbookAuthorTableOperationsHandler;
    }

    public String getHelpPageID(String currentEditorPage) {
        return "author-docbook5-doc-type";
    }
}

