/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.spansupport;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEITableCellSpanProvider
implements AuthorTableCellSpanProvider {
    public Integer getColSpan(AuthorElement cellElement) {
        Integer colspan = null;
        AttrValue attrValue = cellElement.getAttribute("cols");
        if (attrValue != null) {
            try {
                int value = NumberParserUtil.parseInt((String)attrValue.getValue());
                colspan = Math.max(value, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colspan;
    }

    public Integer getRowSpan(AuthorElement cellElement) {
        Integer rowspan = null;
        AttrValue attrValue = cellElement.getAttribute("rows");
        if (attrValue != null) {
            try {
                int value = NumberParserUtil.parseInt((String)attrValue.getValue());
                rowspan = Math.max(value, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rowspan;
    }

    public void init(AuthorElement tableElement) {
    }

    public String getDescription() {
        return "Provides cell spanning information about a TEI table.";
    }

    public boolean hasColumnSpecifications(AuthorElement tableElement) {
        return true;
    }
}

