/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLConstants;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements XHTMLConstants {
    public DeleteColumnOperation() {
        super(new XHTMLDocumentTypeHelper());
    }

    @Override
    public void updateColspec(AuthorAccess authorAccess, Integer deletedColumnIndex) {
        AuthorElement toRemove;
        HTMLTableCellInfoProvider spanProvider = (HTMLTableCellInfoProvider)this.tableHelper.getTableCellSpanProvider(this.tableElem);
        if (deletedColumnIndex >= 0 && (toRemove = spanProvider.getColSpec(deletedColumnIndex)) != null) {
            int newCaretOffset = authorAccess.getEditorAccess().getCaretOffset() - (toRemove.getEndOffset() - toRemove.getStartOffset() + 1);
            boolean decreasedSpan = false;
            AttrValue span = toRemove.getAttribute("span");
            if (span != null && span.getValue() != null) {
                try {
                    int colNum = NumberParserUtil.parseInt((String)span.getValue());
                    if (colNum > 2) {
                        authorAccess.getDocumentController().setAttribute("span", new AttrValue("" + (colNum - 1)), toRemove);
                        decreasedSpan = true;
                    } else if (colNum == 2) {
                        authorAccess.getDocumentController().removeAttribute("span", toRemove);
                        decreasedSpan = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!decreasedSpan) {
                authorAccess.getDocumentController().deleteNode((AuthorNode)toRemove);
            }
            authorAccess.getEditorAccess().setCaretPosition(newCaretOffset);
        }
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider spanProvider, AuthorElement cell, int colStartIndex, int colEndIndex) throws AuthorOperationException {
        this.tableHelper.updateTableColSpan(authorAccess, spanProvider, cell, colStartIndex, colEndIndex - 1);
    }
}

