/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class DeleteRowOperationBase
extends AbstractTableOperation {
    public DeleteRowOperationBase(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performDeleteRows(AuthorAccess authorAccess, List<ContentInterval> contentIntervals) throws AuthorOperationException {
        boolean handled = false;
        try {
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            boolean rowsFromContentIntervals = contentIntervals != null && !contentIntervals.isEmpty();
            AuthorNode nodeAtCaret = authorDocumentController.getNodeAtOffset(rowsFromContentIntervals ? contentIntervals.get(0).getStartOffset() : authorAccess.getEditorAccess().getCaretOffset());
            AuthorElement tableElement = this.getElementAncestor(nodeAtCaret, 2);
            if (tableElement == null) throw new AuthorOperationException("The caret must be inside a table");
            List<Object> selectedRows = new ArrayList<AuthorElement>(1);
            if (rowsFromContentIntervals) {
                ArrayList<Integer[]> intervals = new ArrayList<Integer[]>(contentIntervals.size());
                for (ContentInterval cInterval : contentIntervals) {
                    intervals.add(new Integer[]{cInterval.getStartOffset(), cInterval.getEndOffset()});
                }
                selectedRows = TableOperationsUtil.getTableElementsOfType(authorAccess, intervals, 0, TableOperationsUtil.createTableHelper(this.tableHelper));
            } else if (authorEditorAccess.hasSelection()) {
                selectedRows = TableOperationsUtil.getTableElementsOfTypeFromSelection(authorAccess, 0, TableOperationsUtil.createTableHelper(this.tableHelper), tableElement);
            } else {
                selectedRows.add(this.getElementAncestor(nodeAtCaret, 1));
            }
            if (selectedRows.isEmpty()) return handled;
            AuthorTableAccess authorTableAccess = authorAccess.getTableAccess();
            if (selectedRows.size() == authorTableAccess.getTableRowCount(tableElement)) {
                AuthorNode tableElementForDeletion = this.tableHelper.getTableElementForDeletion((AuthorNode)tableElement);
                if (tableElementForDeletion == null) return handled;
                authorDocumentController.deleteNode(tableElementForDeletion);
                return handled;
            } else {
                AuthorElement lastSelectedRow = (AuthorElement)selectedRows.get(selectedRows.size() - 1);
                ArrayList<Integer> rowsToBeDeletedIndices = new ArrayList<Integer>();
                int tableRowsCount = authorTableAccess.getTableRowCount(tableElement);
                AuthorElement beforeElement = null;
                AuthorElement afterElement = null;
                boolean foundLastSelElement = false;
                for (int i = 0; i < tableRowsCount; ++i) {
                    AuthorElement currentRow = authorTableAccess.getTableRow(i, tableElement);
                    if (selectedRows.contains(currentRow)) {
                        rowsToBeDeletedIndices.add(i);
                        if (!Equaler.verifyEquals((Object)lastSelectedRow, (Object)currentRow)) continue;
                        foundLastSelElement = true;
                        continue;
                    }
                    if (!foundLastSelElement) {
                        beforeElement = currentRow;
                        continue;
                    }
                    if (afterElement != null) continue;
                    afterElement = currentRow;
                }
                Position caretPos = null;
                if (afterElement != null) {
                    caretPos = authorDocumentController.createPositionInContent(afterElement.getStartOffset() + 1);
                } else if (beforeElement != null) {
                    caretPos = authorDocumentController.createPositionInContent(beforeElement.getStartOffset() + 1);
                }
                HashMap<AuthorElement, Integer> rowspans = new HashMap<AuthorElement, Integer>();
                int deleteRowsCount = rowsToBeDeletedIndices.size();
                int currentDeleteRowIndex = -1;
                int tableColumnsCount = authorTableAccess.getTableNumberOfColumns(tableElement);
                LinkedHashSet<AuthorElement> rowsToDeleteSet = new LinkedHashSet<AuthorElement>();
                AuthorTableCellSpanProvider spanProvider = this.tableHelper.getTableCellSpanProvider(tableElement);
                for (int j = 0; j < deleteRowsCount; ++j) {
                    currentDeleteRowIndex = (Integer)rowsToBeDeletedIndices.get(j);
                    Object splitCellOp = null;
                    for (int i = tableColumnsCount - 1; i >= 0; --i) {
                        int rowSpan;
                        AuthorElement cell = authorTableAccess.getTableCellAt(currentDeleteRowIndex, i, tableElement);
                        if (cell == null) continue;
                        int[] indices = authorTableAccess.getTableCellIndex(cell);
                        Integer colSpanInteger = spanProvider.getColSpan(cell);
                        Integer rowSpanInteger = spanProvider.getRowSpan(cell);
                        int colSpan = colSpanInteger != null ? colSpanInteger : 1;
                        int n = rowSpan = rowSpanInteger != null ? rowSpanInteger : 1;
                        if (rowSpan > 1) {
                            if (indices[0] == currentDeleteRowIndex) {
                                if (splitCellOp == null) {
                                    splitCellOp = this.createSplitCellOperation();
                                }
                                ((SplitCellAboveBelowOperationBase)splitCellOp).splitCell(cell, authorAccess, true);
                            } else {
                                Integer currentSpan = (Integer)rowspans.get(cell);
                                if (currentSpan == null) {
                                    rowspans.put(cell, rowSpan - 1);
                                } else {
                                    rowspans.put(cell, currentSpan - 1);
                                }
                            }
                        }
                        if (colSpan <= 1) continue;
                        i -= colSpan - 1;
                    }
                    AuthorElement tableRow = authorTableAccess.getTableRow(((Integer)rowsToBeDeletedIndices.get(j)).intValue(), tableElement);
                    rowsToDeleteSet.add(tableRow);
                    if (!rowsToDeleteSet.containsAll(tableRow.getParentElement().getContentNodes())) continue;
                    rowsToDeleteSet.add((AuthorElement)tableRow.getParentElement());
                    rowsToDeleteSet.removeAll(tableRow.getParentElement().getContentNodes());
                }
                Set keySet = rowspans.keySet();
                for (AuthorElement cell : keySet) {
                    this.tableHelper.updateTableRowSpan(authorAccess, cell, (Integer)rowspans.get(cell));
                }
                ArrayList rowsToDelete = new ArrayList(rowsToDeleteSet);
                Collections.sort(rowsToDelete, new Comparator<AuthorElement>(){

                    @Override
                    public int compare(AuthorElement o1, AuthorElement o2) {
                        int toRet = 0;
                        toRet = o1.getStartOffset() < o2.getStartOffset() ? -1 : 1;
                        return toRet;
                    }
                });
                int[] startOffsets = new int[rowsToDelete.size()];
                int[] endOffsets = new int[rowsToDelete.size()];
                int n = rowsToDelete.size();
                for (int j = 0; j < n; ++j) {
                    startOffsets[j] = ((AuthorElement)rowsToDelete.get(j)).getStartOffset();
                    endOffsets[j] = ((AuthorElement)rowsToDelete.get(j)).getEndOffset();
                }
                authorAccess.getDocumentController().multipleDelete(tableElement, startOffsets, endOffsets);
                handled = true;
                this.tableHelper.updateTableRowNumber(authorAccess, tableElement, -rowsToBeDeletedIndices.size());
                int remainingRowsCount = authorTableAccess.getTableRowCount(tableElement);
                if (remainingRowsCount <= 0) return handled;
                if (caretPos != null) {
                    authorEditorAccess.setCaretPosition(caretPos.getOffset());
                    return handled;
                } else {
                    AuthorElement tableRow = authorTableAccess.getTableRow(0, tableElement);
                    if (tableRow == null) return handled;
                    authorEditorAccess.setCaretPosition(tableRow.getStartOffset() + 1);
                    return handled;
                }
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean performDeleteRows(AuthorAccess authorAccess, int startRowOffset, int endRowOffset) throws AuthorOperationException {
        ArrayList<ContentInterval> contentIntervals = null;
        if (startRowOffset >= 0 && endRowOffset >= 0) {
            contentIntervals = new ArrayList<ContentInterval>(1);
            contentIntervals.add(new ContentInterval(startRowOffset, endRowOffset));
        }
        return this.performDeleteRows(authorAccess, contentIntervals);
    }

    @Override
    public final void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        this.performDeleteRows(authorAccess, -1, -1);
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{CHANGE_TRACKING_BEHAVIOR_ARGUMENT};
    }

    public String getDescription() {
        return "Delete table rows. If there is a selection in the table all the rows that intersect that selection are removed. If there is no selection in the table, the row at caret is deleted.";
    }

    protected abstract SplitCellAboveBelowOperationBase createSplitCellOperation();
}

