/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.sort.CriterionComposite;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.KeysController;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortCustomizer;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class ECSortCustomizerDialog
extends TrayDialog
implements SortCustomizer,
KeysController {
    private Button sortSelectedElementsRadio;
    private List<CriterionInformation> criteriaInformation;
    private boolean hasSelectedSortableElements;
    private boolean cannotSortAllElements;
    private CriterionComposite firstCriterionComposite;
    private CriterionComposite secondCriterionComposite;
    private CriterionComposite thirdCriterionComposite;
    private ArrayList<CriterionInformation> info;
    private boolean onlySelectedEntries;
    private final AuthorResourceBundle authorResourceBundle;
    private final String selectedElemensString;
    private final String allElementsString;
    private String helpPageID;

    public ECSortCustomizerDialog(Shell parentFrame, AuthorResourceBundle authorResourceBundle, String selectedElemensString, String allElementsString) {
        this(parentFrame, authorResourceBundle, selectedElemensString, allElementsString, null);
    }

    public ECSortCustomizerDialog(Shell parentFrame, AuthorResourceBundle authorResourceBundle, String selectedElemensString, String allElementsString, String helpPageID) {
        super(parentFrame);
        this.selectedElemensString = selectedElemensString;
        this.allElementsString = allElementsString;
        this.helpPageID = helpPageID;
        int style = 2144;
        style |= 0x10;
        this.setShellStyle(style |= 0x10000);
        this.authorResourceBundle = authorResourceBundle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        Composite scopeSection = ECSortCustomizerDialog.createSection(mainComposite, this.authorResourceBundle.getMessage("Range"));
        GridData data = new GridData(4, 0, true, false, 4, 1);
        scopeSection.setLayoutData((Object)data);
        this.sortSelectedElementsRadio = new Button(mainComposite, 16400);
        this.sortSelectedElementsRadio.setText(this.selectedElemensString);
        data = new GridData(16384, 0, true, false, 2, 1);
        data.horizontalIndent = 5;
        this.sortSelectedElementsRadio.setLayoutData((Object)data);
        Button sortAllElementsRadio = new Button(mainComposite, 16400);
        sortAllElementsRadio.setText(this.allElementsString);
        data = new GridData(16384, 0, true, false, 2, 1);
        this.sortSelectedElementsRadio.setLayoutData((Object)data);
        Composite criterionSection = ECSortCustomizerDialog.createSection(mainComposite, this.authorResourceBundle.getMessage("Criteria"));
        data = new GridData(4, 0x1000000, true, false, 4, 1);
        criterionSection.setLayoutData((Object)data);
        int numberOfCriteria = this.criteriaInformation.size();
        if (this.hasSelectedSortableElements) {
            this.sortSelectedElementsRadio.setEnabled(true);
            this.sortSelectedElementsRadio.setSelection(true);
        } else {
            sortAllElementsRadio.setSelection(true);
            sortAllElementsRadio.setEnabled(true);
            this.sortSelectedElementsRadio.setEnabled(false);
        }
        if (this.cannotSortAllElements) {
            sortAllElementsRadio.setEnabled(false);
            sortAllElementsRadio.setSelection(false);
        }
        CriterionInformation firstSel = this.criteriaInformation.isEmpty() ? null : this.criteriaInformation.get(0);
        for (int i = 0; i < this.criteriaInformation.size(); ++i) {
            CriterionInformation criterionInformation = this.criteriaInformation.get(i);
            if (!criterionInformation.isInitiallySelected()) continue;
            firstSel = criterionInformation;
            break;
        }
        this.firstCriterionComposite = new CriterionComposite(mainComposite, this.authorResourceBundle, this.criteriaInformation, firstSel, true, this, this.criteriaInformation);
        if (numberOfCriteria > 1) {
            this.firstCriterionComposite.enableSortcriterion();
        }
        CriterionInformation secondSel = null;
        if (numberOfCriteria >= 2) {
            ArrayList<CriterionInformation> secondCriteria = new ArrayList<CriterionInformation>();
            boolean computeSel = true;
            for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                CriterionInformation criterionInformation = this.criteriaInformation.get(i);
                if (criterionInformation == firstSel) continue;
                secondCriteria.add(criterionInformation);
                if (!criterionInformation.isInitiallySelected() || !computeSel) continue;
                secondSel = criterionInformation;
                computeSel = false;
            }
            if (secondSel == null && !secondCriteria.isEmpty()) {
                secondSel = (CriterionInformation)secondCriteria.get(0);
            }
            this.secondCriterionComposite = new CriterionComposite(mainComposite, this.authorResourceBundle, secondCriteria, secondSel, false, this, this.criteriaInformation);
        }
        if (numberOfCriteria >= 3) {
            ArrayList<CriterionInformation> thirdCriteria = new ArrayList<CriterionInformation>();
            CriterionInformation thirdSel = null;
            boolean computeSel = true;
            for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                CriterionInformation criterionInformation = this.criteriaInformation.get(i);
                if (criterionInformation == firstSel || criterionInformation == secondSel) continue;
                thirdCriteria.add(criterionInformation);
                if (!criterionInformation.isInitiallySelected() || !computeSel) continue;
                thirdSel = criterionInformation;
                computeSel = false;
            }
            if (thirdSel == null && !thirdCriteria.isEmpty()) {
                thirdSel = (CriterionInformation)thirdCriteria.get(0);
            }
            this.thirdCriterionComposite = new CriterionComposite(mainComposite, this.authorResourceBundle, thirdCriteria, thirdSel, false, this, this.criteriaInformation);
        }
        return mainComposite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        EclipseHelpUtils.installHelp(newShell, this.helpPageID);
        newShell.setText(this.authorResourceBundle.getMessage("Sort"));
    }

    @Override
    public SortCriteriaInformation getSortInformation(List<CriterionInformation> criteriaInformation, boolean hasSelectedSortableElements, boolean cannotSortAllElements) {
        this.criteriaInformation = criteriaInformation;
        this.hasSelectedSortableElements = hasSelectedSortableElements;
        this.cannotSortAllElements = cannotSortAllElements;
        SortCriteriaInformation sortInformation = null;
        if (this.open() == 0) {
            sortInformation = new SortCriteriaInformation(this.info.toArray(new CriterionInformation[0]), this.onlySelectedEntries);
        }
        return sortInformation;
    }

    protected void okPressed() {
        this.info = new ArrayList();
        boolean bl = this.onlySelectedEntries = this.sortSelectedElementsRadio != null && this.sortSelectedElementsRadio.getSelection();
        if (this.firstCriterionComposite.getInformation() != null) {
            this.info.add(this.firstCriterionComposite.getInformation());
        }
        if (this.secondCriterionComposite != null && this.secondCriterionComposite.getInformation() != null) {
            this.info.add(this.secondCriterionComposite.getInformation());
        }
        if (this.thirdCriterionComposite != null && this.thirdCriterionComposite.getInformation() != null) {
            this.info.add(this.thirdCriterionComposite.getInformation());
        }
        super.okPressed();
    }

    private static Composite createSection(Composite parent, String text) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16448);
        label.setText(text);
        FontData fontData = label.getFont().getFontData()[0];
        fontData.setStyle(1);
        final Font font = new Font((Device)Display.getDefault(), fontData);
        label.setFont(font);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        label = new Label(composite, 0x1000102);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 1;
        data.verticalIndent = 8;
        label.setLayoutData((Object)data);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public void selectionChanged(String newSelection, String oldSelection) {
        if (this.criteriaInformation.size() > 1 && newSelection != null) {
            if (this.firstCriterionComposite != null && this.firstCriterionComposite.getKeyCombo() != null && this.firstCriterionComposite.getKeyCombo().getItem(this.firstCriterionComposite.getKeyCombo().getSelectionIndex()).equals(newSelection) && this.secondCriterionComposite != null) {
                String secondSel = this.secondCriterionComposite.getKeyCombo().getItem(this.secondCriterionComposite.getKeyCombo().getSelectionIndex());
                this.secondCriterionComposite.getKeyCombo().removeAll();
                ArrayList<String> items = new ArrayList<String>();
                int selectionIndex = -1;
                for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                    String displayName = this.criteriaInformation.get(i).getDisplayName();
                    if (newSelection.equals(displayName)) continue;
                    items.add(displayName);
                    if (!displayName.equals(secondSel) || selectionIndex != -1) continue;
                    selectionIndex = items.size() - 1;
                }
                this.secondCriterionComposite.getKeyCombo().setItems(items.toArray(new String[0]));
                if (selectionIndex != -1) {
                    this.secondCriterionComposite.getKeyCombo().select(selectionIndex);
                } else if (this.secondCriterionComposite.getKeyCombo().getItemCount() > 0) {
                    this.secondCriterionComposite.getKeyCombo().select(0);
                }
                if (this.thirdCriterionComposite != null && this.secondCriterionComposite != null) {
                    String thirdSel = this.thirdCriterionComposite.getKeyCombo().getItem(this.thirdCriterionComposite.getKeyCombo().getSelectionIndex());
                    this.thirdCriterionComposite.getKeyCombo().removeAll();
                    String selectedItem = this.secondCriterionComposite.getKeyCombo().getItem(this.secondCriterionComposite.getKeyCombo().getSelectionIndex());
                    items.clear();
                    selectionIndex = -1;
                    for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                        String displayName = this.criteriaInformation.get(i).getDisplayName();
                        if (newSelection.equals(displayName) || displayName.equals(selectedItem)) continue;
                        items.add(displayName);
                        if (!displayName.equals(thirdSel) || selectionIndex != -1) continue;
                        selectionIndex = items.size() - 1;
                    }
                    this.thirdCriterionComposite.getKeyCombo().setItems(items.toArray(new String[0]));
                    if (selectionIndex != -1) {
                        this.thirdCriterionComposite.getKeyCombo().select(selectionIndex);
                    } else if (this.thirdCriterionComposite.getKeyCombo().getItemCount() > 0) {
                        this.thirdCriterionComposite.getKeyCombo().select(0);
                    }
                }
            } else if (this.secondCriterionComposite != null && this.secondCriterionComposite.getKeyCombo().getItem(this.secondCriterionComposite.getKeyCombo().getSelectionIndex()).equals(newSelection) && this.thirdCriterionComposite != null) {
                String thirdSel = this.thirdCriterionComposite.getKeyCombo().getItem(this.thirdCriterionComposite.getKeyCombo().getSelectionIndex());
                this.thirdCriterionComposite.getKeyCombo().removeAll();
                ArrayList<String> items = new ArrayList<String>();
                int selectionIndex = -1;
                String selectedItem = this.firstCriterionComposite.getKeyCombo() != null ? this.firstCriterionComposite.getKeyCombo().getItem(this.firstCriterionComposite.getKeyCombo().getSelectionIndex()) : "";
                for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                    String displayName = this.criteriaInformation.get(i).getDisplayName();
                    if (newSelection.equals(displayName) || displayName.equals(selectedItem)) continue;
                    items.add(displayName);
                    if (!displayName.equals(thirdSel) || selectionIndex != -1) continue;
                    selectionIndex = items.size() - 1;
                }
                this.thirdCriterionComposite.getKeyCombo().setItems(items.toArray(new String[0]));
                if (selectionIndex != -1) {
                    this.thirdCriterionComposite.getKeyCombo().select(selectionIndex);
                } else if (this.thirdCriterionComposite.getKeyCombo().getItemCount() > 0) {
                    this.thirdCriterionComposite.getKeyCombo().select(0);
                }
            }
        }
    }
}

