/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class OpenInSystemAppOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)OpenInSystemAppOperation.class.getName());
    static final String ARGUMENT_RESOURCE_PATH = "resourcePath";
    private static final String ARGUMENT_UNPARSED_ENTITY = "isUnparsedEntity";
    private static final String ARGUMENT_MEDIA_TYPE = "mediaType";
    public static final String MEDIA_TYPE_VIDEO = "video";
    public static final String MEDIA_TYPE_AUDIO = "audio";
    public static final String MEDIA_TYPE_MEDIA = "media";
    public static final String MEDIA_TYPE_IMAGE = "image";
    public static final String MEDIA_TYPE_HTML = "html";
    public static final String MEDIA_TYPE_PDF = "pdf";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];

    public OpenInSystemAppOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RESOURCE_PATH, 2, "An XPath expression that gives the path of the resource that must be opened.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_UNPARSED_ENTITY, 3, "True if the value returned by the resourcePath argument represents the name of an unparsed entity.", new String[]{"true", "false"}, "false");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_MEDIA_TYPE, 3, "The media type of the file to be opened. ", new String[]{MEDIA_TYPE_VIDEO, MEDIA_TYPE_AUDIO, MEDIA_TYPE_MEDIA, MEDIA_TYPE_IMAGE, MEDIA_TYPE_HTML, MEDIA_TYPE_PDF}, MEDIA_TYPE_HTML);
    }

    public String getDescription() {
        return "Open in default system application";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object resourcePathXPath = args.getArgumentValue(ARGUMENT_RESOURCE_PATH);
        if (resourcePathXPath != null && ((String)resourcePathXPath).trim().length() > 0) {
            resourcePathXPath = authorAccess.getUtilAccess().expandEditorVariables((String)resourcePathXPath, authorAccess.getEditorAccess().getEditorLocation());
            Object[] results = authorAccess.getDocumentController().evaluateXPath((String)resourcePathXPath, null, false, true, true, false, XPathVersion.XPATH_3_0);
            if (results != null && results.length > 0) {
                String toOpenVal = null;
                if (results[0] instanceof String) {
                    toOpenVal = (String)results[0];
                } else if (results[0] instanceof Node) {
                    toOpenVal = ((Node)results[0]).getNodeValue();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Relative location " + toOpenVal);
                }
                if (toOpenVal != null) {
                    OpenInSystemAppOperation.open(toOpenVal, authorAccess, args);
                }
            } else {
                throw new AuthorOperationException("The resource path XPath must evaluate to a string or node: " + resourcePathXPath);
            }
        }
    }

    private static void open(String toOpenVal, AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object unparsedEntity;
        URL toOpen = null;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        AuthorNode contextNode = null;
        if (caretOffset > 0) {
            try {
                contextNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (contextNode == null) {
            contextNode = authorAccess.getDocumentController().getAuthorDocumentNode();
        }
        if ("true".equals(unparsedEntity = args.getArgumentValue(ARGUMENT_UNPARSED_ENTITY))) {
            String systemID = authorAccess.getDocumentController().getUnparsedEntityUri(contextNode, toOpenVal);
            if (systemID != null) {
                try {
                    toOpen = new URL(systemID);
                }
                catch (MalformedURLException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        } else {
            toOpen = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(contextNode != null ? contextNode.getXMLBaseURL() : authorAccess.getEditorAccess().getEditorLocation(), toOpenVal, true, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Absolute location to open: " + URLUtil.filterPasswords((String)String.valueOf(toOpen)));
        }
        String mediaType = (String)args.getArgumentValue(ARGUMENT_MEDIA_TYPE);
        if (toOpen != null) {
            File localFile = authorAccess.getUtilAccess().locateFile(toOpen);
            if (localFile != null && !localFile.exists()) {
                throw new AuthorOperationException("Resource does not exists: " + toOpen);
            }
            authorAccess.getWorkspaceAccess().openInExternalApplication(toOpen, true, mediaType);
        } else {
            String systemID;
            String toOpenString = toOpenVal;
            if ("true".equals(unparsedEntity) && (systemID = authorAccess.getDocumentController().getUnparsedEntityUri(contextNode, toOpenVal)) != null) {
                toOpenString = systemID;
            }
            authorAccess.getWorkspaceAccess().openInExternalApplication(toOpenString, true, mediaType);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

