/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.function.Supplier;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class InplaceEditorUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)InplaceEditorUtil.class.getName());

    private InplaceEditorUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JPanel panel, AuthorInplaceContext context) {
        Dimension preferredSize = InplaceEditorUtil.getPreferredSize((Component)panel, (Container)context.getParentHost());
        int width = preferredSize.width;
        int imposedWidth = context.getPropertyEvaluator().evaluateWidthProperty(context.getArguments(), context.getStyles().getFont().getSize());
        if (imposedWidth != -1) {
            width = imposedWidth;
        } else {
            Integer columns = (Integer)context.getArguments().get("columns");
            if (columns != null && columns > 0) {
                FontMetrics fontMetrics = panel.getFontMetrics(panel.getFont());
                width = InplaceEditorUtil.getApproximativeCharsWidth(columns, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(width, preferredSize.height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JComboBox comboBox, AuthorInplaceContext context) {
        Dimension preferredSize = InplaceEditorUtil.getPreferredSize((Component)comboBox, (Container)context.getParentHost());
        int width = preferredSize.width;
        int imposedWidth = context.getPropertyEvaluator().evaluateWidthProperty(context.getArguments(), context.getStyles().getFont().getSize());
        if (imposedWidth != -1) {
            width = imposedWidth;
        } else {
            Integer columns = (Integer)context.getArguments().get("columns");
            if (columns != null && columns > 0) {
                FontMetrics fontMetrics = comboBox.getFontMetrics(comboBox.getFont());
                width = InplaceEditorUtil.getApproximativeCharsWidth(columns, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(width, preferredSize.height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JTextField textField, AuthorInplaceContext context) {
        FontMetrics fontMetrics = textField.getFontMetrics(textField.getFont());
        Dimension preferredSize = InplaceEditorUtil.getPreferredSize((Component)textField, (Container)context.getParentHost());
        int width = preferredSize.width + InplaceEditorUtil.getApproximativeCharsWidth(1, fontMetrics);
        int imposedWidth = context.getPropertyEvaluator().evaluateWidthProperty(context.getArguments(), context.getStyles().getFont().getSize());
        if (imposedWidth != -1) {
            width = imposedWidth;
        } else {
            Integer columns = (Integer)context.getArguments().get("columns");
            if (columns != null && columns > 0) {
                width = InplaceEditorUtil.getApproximativeCharsWidth(columns, fontMetrics);
            } else if (textField.getText().length() == 0) {
                width = InplaceEditorUtil.getApproximativeCharsWidth(2, fontMetrics);
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(width, preferredSize.height);
    }

    public static void relayout(JComboBox comboBox, AuthorInplaceContext context) {
        ro.sync.exml.view.graphics.Dimension size = InplaceEditorUtil.getPreferredSize(comboBox, context);
        comboBox.setSize(size.width, size.height);
        comboBox.doLayout();
        InplaceEditorUtil.setCaretAtEnd((JTextField)comboBox.getEditor().getEditorComponent(), context);
    }

    public static void relayout(JTextField textField, AuthorInplaceContext context) {
        ro.sync.exml.view.graphics.Dimension size = InplaceEditorUtil.getPreferredSize(textField, context);
        textField.setSize(size.width, size.height);
        textField.doLayout();
        InplaceEditorUtil.setCaretAtEnd(textField, context);
    }

    public static void setCaretAtEnd(final JTextComponent textField, AuthorInplaceContext context) {
        boolean isSA = true;
        if (context.getAuthorAccess() != null && context.getAuthorAccess().getWorkspaceAccess() != null) {
            isSA = Platform.STANDALONE == context.getAuthorAccess().getWorkspaceAccess().getPlatform();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (textField != null) {
                        try {
                            int length = textField.getText(0, textField.getDocument().getLength()).length();
                            textField.setCaretPosition(length);
                            Rectangle modelToView = textField.modelToView(length);
                            if (modelToView != null) {
                                textField.scrollRectToVisible(modelToView);
                            }
                        }
                        catch (IllegalArgumentException | BadLocationException e) {
                            if (!logger.isDebugEnabled()) break block4;
                            logger.debug((Object)e, (Throwable)e);
                        }
                    }
                }
            }
        };
        if (isSA || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static int getApproximativeCharsWidth(int numberOfChars, FontMetrics fontMetrics) {
        char[] chars = new char[numberOfChars];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 119;
        }
        return fontMetrics.charsWidth(chars, 0, chars.length);
    }

    public static Dimension getPreferredSize(final Component component, Container parent) {
        return InplaceEditorUtil.addToParent(component, parent, new Supplier<Dimension>(){

            @Override
            public Dimension get() {
                return component.getPreferredSize();
            }
        });
    }

    public static <T> T addToParent(Component component, Container parent, Supplier<T> supplier) {
        return supplier.get();
    }
}

