/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.zip.epub;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DPIDetailedExceptionUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.zip.errorscanner.ArchiveErrorScannerInterface;

public class EpubErrorScanner
implements ArchiveErrorScannerInterface {
    private static final String ENGINE_NAME = "EPUBCheck 5.1.0";
    private static final String FILE_PROTOCOL = "file";

    public List<DocumentPositionedInfo> scan(String systemID) {
        ArrayList<DocumentPositionedInfo> errors = new ArrayList<DocumentPositionedInfo>();
        File archiveFile = null;
        try {
            URL url = new URL(systemID);
            if (!FILE_PROTOCOL.equals(url.getProtocol())) {
                DocumentPositionedInfo dpi = new DocumentPositionedInfo(1, "EPUBCheck validation is available only for local archives", EpubErrorScanner.getArchiveResourceSystemID(new URL(systemID), null), 0, -1);
                dpi.setEngineName(ENGINE_NAME);
                errors.add(dpi);
            } else {
                archiveFile = URLUtil.getAbsoluteFileFromFileUrl((URL)url);
                if (archiveFile != null) {
                    EpubCheck checker = new EpubCheck(archiveFile, (Report)new DefaultReportImpl(systemID, archiveFile.getAbsolutePath(), errors));
                    EpubErrorScanner.safeValidate(checker, systemID, errors);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return errors;
    }

    private static void safeValidate(EpubCheck checker, String systemID, Collection<DocumentPositionedInfo> errors) {
        try {
            checker.check();
        }
        catch (Throwable t) {
            while (t.getCause() != null) {
                t = t.getCause();
            }
            DocumentPositionedInfo dpi = new DocumentPositionedInfo(2, "Unexpected error returned from EPUBCheck 5.1.0: " + t.getClass().getName() + " - " + t.getMessage(), systemID);
            dpi.setEngineName("oXygen");
            dpi.setDetailedExceptionInfo(DPIDetailedExceptionUtil.getDetailedExceptionStackTrace((Throwable)t));
            errors.add(dpi);
        }
    }

    public static String getArchiveResourceSystemID(URL archiveURL, String resource) {
        Object systemID = archiveURL.toString();
        if (resource != null && resource.length() > 0) {
            systemID = "zip:" + archiveURL.toString() + "!/" + resource;
        }
        return systemID;
    }

    private static class DefaultReportImpl
    extends MasterReport {
        private final List<DocumentPositionedInfo> errors;
        private final String systemID;
        private static final Pattern COLLAPSE_SPACES_PATTERN = Pattern.compile("[\\s]+");

        DefaultReportImpl(String systemID, String ePubName, List<DocumentPositionedInfo> errors) {
            this.systemID = systemID;
            this.errors = errors;
            this.setEpubFileName(PathUtil.removeWorkingDirectory((String)ePubName));
        }

        private static String fixMessage(String message) {
            return message == null ? "" : COLLAPSE_SPACES_PATTERN.matcher(message).replaceAll(" ");
        }

        public void message(Message message, EPUBLocation location, Object ... args) {
            int dpiSeverity;
            Severity severity = message.getSeverity();
            String text = DefaultReportImpl.fixMessage(args != null && args.length > 0 ? message.getMessage(args) : message.getMessage());
            switch (severity) {
                case ERROR: {
                    dpiSeverity = 2;
                    break;
                }
                case WARNING: {
                    dpiSeverity = 1;
                    break;
                }
                case FATAL: {
                    dpiSeverity = 3;
                    break;
                }
                default: {
                    dpiSeverity = 0;
                }
            }
            try {
                DocumentPositionedInfo dpi = new DocumentPositionedInfo(dpiSeverity, text, EpubErrorScanner.getArchiveResourceSystemID(new URL(this.systemID), location.getPath()), location.getLine(), location.getColumn());
                dpi.setEngineName(EpubErrorScanner.ENGINE_NAME);
                this.errors.add(dpi);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        public void info(String resource, FeatureEnum feature, String value) {
            if (2 >= this.getReportingLevel()) {
                // empty if block
            }
        }

        public int generate() {
            return 0;
        }

        public void initialize() {
        }
    }
}

