/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.util.ResourceUtil;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReaderFactory;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaReaderFactorySchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.schematron.NewSaxonSchemaReaderFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trans.SymbolicName;
import org.idpf.epubcheck.util.saxon.ColumnNumberFunction;
import org.idpf.epubcheck.util.saxon.LineNumberFunction;
import org.idpf.epubcheck.util.saxon.SystemIdFunction;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidator {
    String schemaName;
    Schema schema;
    private final boolean isNormative;

    private static boolean isFunctionAvailable(XPathStaticContext xpathContext, SymbolicName.F functionName) {
        FunctionLibrary functionLibrary = xpathContext.getFunctionLibrary();
        try {
            Method method = functionLibrary.getClass().getMethod("isAvailable", SymbolicName.F.class);
            return (Boolean)method.invoke((Object)functionLibrary, functionName);
        }
        catch (Exception method) {
            try {
                Method method2 = functionLibrary.getClass().getMethod("isAvailable", SymbolicName.F.class, Integer.TYPE);
                return (Boolean)method2.invoke((Object)functionLibrary, functionName, 31);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public XMLValidator(String schemaName, boolean isNormative) {
        this.isNormative = isNormative;
        try {
            String resourcePath = ResourceUtil.getResourcePath((String)schemaName);
            URL systemIdURL = ResourceUtil.getResourceURL((String)resourcePath);
            if (systemIdURL == null) {
                throw new RuntimeException("Could not find resource " + resourcePath);
            }
            InputSource schemaSource = new InputSource(systemIdURL.toString());
            PropertyMapBuilder mapBuilder = new PropertyMapBuilder();
            mapBuilder.put(ValidateProperty.RESOLVER, (Object)BasicResolver.getInstance());
            mapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)new ErrorHandlerImpl());
            Object schemaReader = schemaName.endsWith(".rnc") ? CompactSchemaReader.getInstance() : (schemaName.endsWith(".sch") ? new AutoSchemaReader((SchemaReceiverFactory)new SchemaReaderFactorySchemaReceiverFactory((SchemaReaderFactory)new ExtendedSaxonSchemaReaderFactory())) : new AutoSchemaReader());
            this.schemaName = schemaName;
            this.schema = schemaReader.createSchema(schemaSource, mapBuilder.toPropertyMap());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Internal error: " + e + " " + schemaName);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isNormative() {
        return this.isNormative;
    }

    public static class BasicResolver
    implements Resolver {
        private static final BasicResolver theInstance = new BasicResolver();

        protected BasicResolver() {
        }

        public static BasicResolver getInstance() {
            return theInstance;
        }

        public void resolve(Identifier id, Input input) throws IOException, ResolverException {
            if (!input.isResolved()) {
                input.setUri(BasicResolver.resolveUri(id));
            }
        }

        public void open(Input input) throws IOException, ResolverException {
            URI uri;
            if (!input.isUriDefinitive()) {
                return;
            }
            try {
                uri = new URI(input.getUri());
            }
            catch (URISyntaxException e) {
                throw new ResolverException((Throwable)e);
            }
            if (!uri.isAbsolute()) {
                throw new ResolverException("cannot open relative URI: " + uri);
            }
            URL url = new URL(uri.toASCIIString());
            input.setByteStream(url.openStream());
        }

        public static String resolveUri(Identifier id) throws ResolverException {
            try {
                String base;
                String uriRef = id.getUriReference();
                URI uri = new URI(uriRef);
                if (!uri.isAbsolute() && (base = id.getBase()) != null) {
                    URI baseURI = new URI(base);
                    uriRef = "zip".equals(baseURI.getScheme()) || "jar".equals(baseURI.getScheme()) ? new URL(new URL(base), uriRef).toExternalForm() : baseURI.resolve(uri).toString();
                }
                return uriRef;
            }
            catch (URISyntaxException e) {
                throw new ResolverException((Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ResolverException((Throwable)e);
            }
        }
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }

    public static class ExtendedSaxonSchemaReaderFactory
    extends NewSaxonSchemaReaderFactory {
        public void initTransformerFactory(TransformerFactory factory) {
            super.initTransformerFactory(factory);
            if (factory instanceof TransformerFactoryImpl) {
                Configuration configuration = ((TransformerFactoryImpl)factory).getConfiguration();
                IndependentContext xpathContext = new IndependentContext(configuration);
                SymbolicName.F lineNumberName = new SymbolicName.F(LineNumberFunction.QNAME, 1);
                SymbolicName.F columnNumberName = new SymbolicName.F(ColumnNumberFunction.QNAME, 1);
                SymbolicName.F systemIDName = new SymbolicName.F(SystemIdFunction.QNAME, 0);
                if (!XMLValidator.isFunctionAvailable((XPathStaticContext)xpathContext, lineNumberName)) {
                    configuration.registerExtensionFunction((ExtensionFunctionDefinition)new LineNumberFunction());
                }
                if (!XMLValidator.isFunctionAvailable((XPathStaticContext)xpathContext, columnNumberName)) {
                    configuration.registerExtensionFunction((ExtensionFunctionDefinition)new ColumnNumberFunction());
                }
                if (!XMLValidator.isFunctionAvailable((XPathStaticContext)xpathContext, systemIDName)) {
                    configuration.registerExtensionFunction((ExtensionFunctionDefinition)new SystemIdFunction());
                }
            }
        }
    }
}

