/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.parser;

import java.util.Map;
import org.xml.sax.SAXException;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;
import ro.sync.exml.indexer.parser.ReviewAwareContentHandler;
import ro.sync.exml.indexer.utils.BlankRemover;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

class TitleExtractor
extends ReviewAwareContentHandler {
    private IKeywordsRepository keywordsRepository;
    private boolean isInsideHeadElement;
    private String metaSearchTitle = null;

    public TitleExtractor(IndexedFileInfo fileInfo, IKeywordsRepository keywordsRepository) {
        super(fileInfo);
        this.keywordsRepository = keywordsRepository;
    }

    @Override
    public void startElementInternal(String uri, String localName, String qName, Map<String, String> atts) {
        if (qName.equalsIgnoreCase("head")) {
            this.isInsideHeadElement = true;
        }
        if (this.isTitle(qName)) {
            this.setCaptureText(true);
        } else if (this.isSearchTitleMetaElem(qName, atts)) {
            this.metaSearchTitle = atts.get("content");
        }
    }

    private boolean isTitle(String qName) {
        return this.isInsideHeadElement && qName.equalsIgnoreCase("title");
    }

    boolean isSearchTitleMetaElem(String qName, Map<String, String> atts) {
        String nameAttr;
        boolean isSearchTitle = false;
        if (atts != null && qName.equalsIgnoreCase("meta") && (nameAttr = atts.get("name")) != null) {
            isSearchTitle = nameAttr.equalsIgnoreCase("wh-search-title");
        }
        return isSearchTitle;
    }

    @Override
    public void endElementInternal(String uri, String localName, String qName, Map<String, String> atts) {
        if (qName.equalsIgnoreCase("head")) {
            this.isInsideHeadElement = false;
        }
        if (this.isTitle(qName)) {
            this.setCaptureText(false);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        String title = this.buffer.toString().trim();
        if (this.metaSearchTitle != null) {
            title = this.metaSearchTitle.trim();
        }
        title = BlankRemover.rmWhiteSpace(title);
        this.fileInfo.setTitle(title);
        if (this.keywordsRepository != null) {
            this.keywordsRepository.addTopicTitle(title);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isCaptureText()) {
            this.buffer.append(ch, start, length);
        }
    }
}

