/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import ro.sync.exml.indexer.ITextIndexer;
import ro.sync.exml.indexer.score.ScoreRepository;

public class MetaTagIndexer {
    private String attrName;
    private String wordSeparator;
    private ITextIndexer textIndexer;

    public MetaTagIndexer(String name, String wordSeparator, ITextIndexer textIndexer) {
        this.attrName = name;
        this.wordSeparator = wordSeparator;
        this.textIndexer = textIndexer;
    }

    private String getTextToIndex(String qName, Attributes attributes) {
        String attrName;
        String toReturn = null;
        if (qName != null && qName.equalsIgnoreCase("meta") && (attrName = attributes.getValue("name")) != null && attrName.equalsIgnoreCase(this.attrName)) {
            toReturn = attributes.getValue("content");
        }
        if (toReturn == null) {
            toReturn = "";
        }
        return toReturn;
    }

    public void index(String tagName, Attributes attributes, ScoreRepository scoreRepository) {
        String text = this.getTextToIndex(tagName, attributes);
        StringTokenizer st = new StringTokenizer(text, this.wordSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (scoreRepository.startElementScore("meta_".concat(this.attrName))) {
                this.textIndexer.indexText(token, true);
            }
            scoreRepository.endElementScore();
        }
    }
}

