/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.exml.indexer.AttributeValueIndexer;
import ro.sync.exml.indexer.ITextIndexer;
import ro.sync.exml.indexer.IndexToken;
import ro.sync.exml.indexer.NonCJKAnalyzer;
import ro.sync.exml.indexer.StopWordsPreferences;
import ro.sync.exml.indexer.WebHelpJapaneseAnalyzer;
import ro.sync.exml.indexer.score.ScoreRepository;
import ro.sync.exml.indexer.stem.SnowballStemmer;
import ro.sync.exml.indexer.stem.Stemmer;
import ro.sync.exml.indexer.stem.StemmerLanguageNotSupportedException;

public class ElementIndexer
extends DefaultHandler
implements ITextIndexer {
    private static final Logger logger = LoggerFactory.getLogger((String)ElementIndexer.class.getName());
    protected ScoreRepository scoreRepository;
    private String currentElName = "";
    private int ignoredDepth;
    private AttributeValueIndexer atributeIndexer;
    private String languageCode;
    private File userDictionary;
    private boolean userMessageDisplayed;
    private int wordIdx = 0;
    private Stemmer stemmer;
    private StopWordsPreferences stopWordsPreferences;
    private StringBuilder buffer = new StringBuilder();

    public ElementIndexer(ScoreRepository scoreRepository, String languageCode, String userDictionary, boolean stem, StopWordsPreferences stopWordsPreferences) {
        this.stopWordsPreferences = stopWordsPreferences;
        this.atributeIndexer = new AttributeValueIndexer(scoreRepository, this);
        this.ignoredDepth = 0;
        this.scoreRepository = scoreRepository;
        this.languageCode = languageCode;
        File file = this.userDictionary = userDictionary == null || userDictionary.contains("${") ? null : new File(userDictionary);
        if (stem) {
            logger.debug("Use stemming with language " + languageCode);
            try {
                this.stemmer = new SnowballStemmer(languageCode);
            }
            catch (StemmerLanguageNotSupportedException e) {
                logger.warn("WARNING: Stemmer is disabled, cannot find stemmer for language: " + languageCode);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.indexBuffer();
        this.currentElName = qName;
        String classAttr = attributes.getValue("class");
        String fullName = qName;
        if (classAttr != null) {
            fullName = qName.concat(".").concat(classAttr);
        }
        if (this.ignoredDepth > 0 || !this.scoreRepository.startElementScore(fullName)) {
            ++this.ignoredDepth;
            return;
        }
        this.atributeIndexer.indexAttribute(qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.ignoredDepth == 0) {
            this.indexBuffer();
            this.scoreRepository.endElementScore();
        }
        if (this.ignoredDepth > 0) {
            --this.ignoredDepth;
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoredDepth > 0) {
            return;
        }
        if (!this.currentElName.equalsIgnoreCase("script") && !this.currentElName.equalsIgnoreCase("style")) {
            String text = new String(ch, start, length);
            text = text.replaceAll("\n", " ");
            text = text.replaceAll("\t", " ");
            this.buffer.append(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexText(String textToIndex, boolean inAttribute) {
        block41: {
            logger.debug("textToIndex: [" + textToIndex + "]");
            String txt = textToIndex.replaceAll(" {2,}", " ");
            if (txt.length() <= 0) break block41;
            logger.debug("txt: '" + txt + "'");
            StringReader reader = new StringReader(txt);
            Object analyzer = null;
            WebHelpJapaneseAnalyzer webhelpJapaneseAnalyzer = null;
            CharArraySet stopWordsSet = null;
            if ("zh".equals(this.languageCode) || "ko".equals(this.languageCode)) {
                stopWordsSet = this.stopWordsPreferences.getStopWords(CJKAnalyzer.getDefaultStopSet());
                analyzer = new CJKAnalyzer(stopWordsSet);
            } else if ("ja".equals(this.languageCode)) {
                try {
                    UserDictionary userDict;
                    block39: {
                        userDict = null;
                        try {
                            if (this.userDictionary != null) {
                                userDict = UserDictionary.open((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.userDictionary), "UTF8")));
                            }
                            if (!this.userMessageDisplayed) {
                                if (userDict == null) {
                                    logger.info("INFO: No Japanese user dictionary file was set by user.");
                                } else {
                                    logger.info("INFO: Using Japanese user dictionary file set by user: " + this.userDictionary.getPath());
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            if (!this.userMessageDisplayed) {
                                logger.warn("WARNING: User dictionary file not found, indexing without any user dictionary: " + this.userDictionary.getPath());
                            }
                        }
                        catch (IOException e) {
                            if (this.userMessageDisplayed) break block39;
                            logger.warn("WARNING: User dictionary file cannot be loaded because: " + e.getMessage());
                            logger.warn("WARNING: Indexing without any user dictionary: " + this.userDictionary.getPath());
                        }
                    }
                    stopWordsSet = this.stopWordsPreferences.getStopWords(JapaneseAnalyzer.getDefaultStopSet());
                    analyzer = new JapaneseAnalyzer(userDict, JapaneseTokenizer.Mode.SEARCH, stopWordsSet, JapaneseAnalyzer.getDefaultStopTags());
                    webhelpJapaneseAnalyzer = new WebHelpJapaneseAnalyzer(userDict, JapaneseTokenizer.Mode.SEARCH, stopWordsSet, JapaneseAnalyzer.getDefaultStopTags());
                    if (!this.userMessageDisplayed) {
                        logger.info("INFO: Kuromoji analyzer detected and loaded, indexing WebHelp pages with Kuromoji analyzer.");
                        this.userMessageDisplayed = true;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!this.userMessageDisplayed) {
                        logger.warn("WARNING: Could not create Kuromoji analyzer: " + e.getMessage());
                        this.userMessageDisplayed = true;
                    }
                    stopWordsSet = this.stopWordsPreferences.getStopWords(JapaneseAnalyzer.getDefaultStopSet());
                    analyzer = new CJKAnalyzer(stopWordsSet);
                }
                catch (SecurityException e) {
                    if (!this.userMessageDisplayed) {
                        logger.warn("WARNING: Could not create Kuromoji analyzer: " + e.getMessage());
                        this.userMessageDisplayed = true;
                    }
                    analyzer = new CJKAnalyzer(this.stopWordsPreferences.getStopWords(JapaneseAnalyzer.getDefaultStopSet()));
                }
            } else {
                analyzer = new NonCJKAnalyzer(this.languageCode, this.stopWordsPreferences);
                stopWordsSet = ((NonCJKAnalyzer)((Object)analyzer)).getStopwordSet();
            }
            this.scoreRepository.setStopWords(stopWordsSet);
            if ("ja".equals(this.languageCode)) {
                List<IndexToken> indexTokens = this.tokenize((Analyzer)analyzer, txt, inAttribute);
                this.wordIdx -= indexTokens.size();
                List<IndexToken> japanCustomTokens = this.tokenize((Analyzer)webhelpJapaneseAnalyzer, txt, inAttribute);
                for (IndexToken token : japanCustomTokens) {
                    if (indexTokens.contains(token)) continue;
                    indexTokens.add(token);
                }
                for (IndexToken token : indexTokens) {
                    this.scoreRepository.updateWordScore(token.getWord(), inAttribute ? -1 : token.getPosition());
                }
            } else {
                TokenStream stream = null;
                try {
                    stream = analyzer.tokenStream("indexer", (Reader)reader);
                    CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                    PositionIncrementAttribute positionIncrementAttr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                    stream.reset();
                    while (stream.incrementToken()) {
                        int positionIncrement;
                        boolean isPartOfPreviousCompoundWord;
                        String word = termAtt.toString();
                        String toBeUpdated = word.toLowerCase();
                        if (this.stemmer != null) {
                            toBeUpdated = this.stemmer.stem(toBeUpdated);
                        }
                        boolean bl = isPartOfPreviousCompoundWord = (positionIncrement = positionIncrementAttr.getPositionIncrement()) == 0;
                        if (isPartOfPreviousCompoundWord) {
                            if (inAttribute) {
                                this.scoreRepository.updateWordScore(toBeUpdated, -1);
                                continue;
                            }
                            int compoundWordIndex = Math.max(0, this.wordIdx - 1);
                            this.scoreRepository.updateWordScore(toBeUpdated, compoundWordIndex);
                            continue;
                        }
                        int position = inAttribute ? -1 : this.wordIdx;
                        this.scoreRepository.updateWordScore(toBeUpdated, position);
                        if (inAttribute) continue;
                        ++this.wordIdx;
                    }
                }
                catch (IOException e) {
                    logger.error("Error creating token stream for language: " + this.languageCode, (Throwable)e);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.end();
                            stream.close();
                        }
                        catch (IOException e) {
                            logger.error("Error closing token stream for language: " + this.languageCode, (Throwable)e);
                        }
                    }
                    if (analyzer != null) {
                        analyzer.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexToken> tokenize(Analyzer analyzer, String text, boolean inAttribute) {
        ArrayList<IndexToken> tokens = new ArrayList<IndexToken>();
        TokenStream stream = null;
        try {
            stream = analyzer.tokenStream("indexer", (Reader)new StringReader(text));
            CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                int n;
                String word = termAtt.toString();
                String toBeUpdated = word.toLowerCase();
                if (this.stemmer != null) {
                    toBeUpdated = this.stemmer.stem(toBeUpdated);
                }
                if (inAttribute) {
                    n = -1;
                } else {
                    int n2 = this.wordIdx;
                    n = n2;
                    this.wordIdx = n2 + 1;
                }
                tokens.add(new IndexToken(toBeUpdated, n));
            }
        }
        catch (IOException e) {
            logger.error("Error creating token stream for language: " + this.languageCode, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.end();
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("Error closing token stream for language: " + this.languageCode, (Throwable)e);
                }
            }
            if (analyzer != null) {
                analyzer.close();
            }
        }
        return tokens;
    }

    public void startIndexingFile() {
        this.wordIdx = 0;
    }

    private void indexBuffer() {
        if (this.buffer.length() > 0) {
            this.indexText(this.buffer.toString().trim(), false);
            this.buffer.setLength(0);
        }
    }
}

