/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.ant;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class AntNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)AntNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();
    private static final Set<String> tasksSet = new HashSet<String>();
    private static final Set<String> typesSet = new HashSet<String>();
    private static final String TASKS_IMAGE_PATH = AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntTask16.png");
    private static final String TYPES_IMAGE_PATH = AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntType16.png");
    private static final String PROPERTY_IMAGE_PATH = AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntProperty16.png");

    private static String getImageURL(String path) {
        URL imageURL = AntNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(AntNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String iconPath = null;
            String imageKey = nodeName;
            int index = nodeName.indexOf(58);
            if (index != -1) {
                imageKey = nodeName.substring(index + 1);
            }
            if ((iconPath = nameToIconPath.get(imageKey)) == null) {
                if (tasksSet.contains(imageKey)) {
                    iconPath = TASKS_IMAGE_PATH;
                } else if (typesSet.contains(imageKey)) {
                    iconPath = TYPES_IMAGE_PATH;
                }
            }
            renderingInfo.setIconPath(iconPath);
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "Ant Node Renderer Customizer";
    }

    static {
        String[] tasks = new String[]{"ant", "antcall", "antstructure", "antversion", "apply", "apt", "attributenamespacedef", "augment", "available", "basename", "bindtargets", "buildnumber", "bunzip2", "bzip2", "checksum", "chmod", "classloader", "commandlauncher", "componentdef", "concat", "condition", "copy", "cvs", "cvschangelog", "cvspass", "cvstagdiff", "cvsversion", "defaultexcludes", "delete", "dependset", "diagnostics", "dirname", "ear", "echo", "echoproperties", "echoxml", "exec", "fail", "filter", "fixcrlf", "genkey", "get", "gunzip", "gzip", "hostinfo", "import", "include", "input", "jar", "java", "javac", "javadoc", "length", "loadfile", "loadproperties", "loadresource", "local", "macrodef", "mail", "makeurl", "manifest", "manifestclasspath", "mkdir", "move", "nice", "parallel", "patch", "pathconvert", "presetdef", "projecthelper", "property", "propertyhelper", "record", "replace", "resourcecount", "retry", "rmic", "sequential", "signjar", "sleep", "sql", "subant", "sync", "tar", "taskdef", "tempfile", "touch", "tstamp", "truncate", "typedef", "unjar", "untar", "unwar", "unzip", "uptodate", "waitfor", "war", "whichresource", "xmlproperty", "xslt", "zip", "antlr", "attrib", "blgenclient", "cab", "cccheckin", "cccheckout", "cclock", "ccmcheckin", "ccmcheckintask", "ccmcheckout", "ccmcreatetask", "ccmkattr", "ccmkbl", "ccmkdir", "ccmkelem", "ccmklabel", "ccmklbtype", "ccmreconfigure", "ccrmtype", "ccuncheckout", "ccunlock", "ccupdate", "chgrp", "chown", "depend", "ejbjar", "ftp", "image", "iplanet-ejbc", "jarlib-available", "jarlib-display", "jarlib-manifest", "jarlib-resolve", "javacc", "javah", "jdepend", "jjdoc", "jjtree", "junit", "junitreport", "native2ascii", "netrexxc", "propertyfile", "pvcs", "replaceregexp", "rexec", "rpm", "schemavalidate", "scp", "script", "scriptdef", "serverdeploy", "setproxy", "soscheckin", "soscheckout", "sosget", "soslabel", "sound", "splash", "sshexec", "sshsession", "symlink", "telnet", "translate", "verifyjar", "vssadd", "vsscheckin", "vsscheckout", "vsscp", "vsscreate", "vssget", "vsshistory", "vsslabel", "wljspc", "xmlvalidate", "copydir", "copyfile", "copypath", "deltree", "execon", "javadoc2", "jlink", "jspc", "mimemail", "rename", "renameext", "style"};
        String[] types = new String[]{"description", "filterchain", "filterreader", "filterset", "mapper", "redirector", "patternset", "regexp", "substitution", "xmlcatalog", "extensionSet", "extension", "selector", "signedselector", "scriptfilter", "assertions", "concatfilter", "mavenrepository", "scriptselector", "scriptmapper", "identitymapper", "flattenmapper", "globmapper", "mergemapper", "regexpmapper", "packagemapper", "unpackagemapper", "compositemapper", "chainedmapper", "filtermapper", "firstmatchmapper", "cutdirsmapper", "isfileselected", "scriptcondition", "dirset", "filelist", "fileset", "path", "propertyset", "zipfileset", "classfileset", "libfileset", "files", "restrict", "union", "difference", "intersect", "sort", "resources", "first", "last", "tarfileset", "tokens", "mappedresources", "archives", "resourcelist", "resource", "file", "url", "string", "zipentry", "propertyresource", "tarentry", "gzipresource", "bzip2resource", "javaresource", "linetokenizer", "stringtokenizer", "filetokenizer"};
        tasksSet.addAll(Arrays.asList(tasks));
        typesSet.addAll(Arrays.asList(types));
        nameToIconPath.put("typedef", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntDefinition16.png"));
        nameToIconPath.put("taskdef", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntDefinition16.png"));
        nameToIconPath.put("extension-point", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntExtensionPoint16.png"));
        nameToIconPath.put("project", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntProject16.png"));
        nameToIconPath.put("property", PROPERTY_IMAGE_PATH);
        nameToIconPath.put("target", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/AntTarget16.png"));
        nameToIconPath.put("condition", PROPERTY_IMAGE_PATH);
        nameToIconPath.put("available", PROPERTY_IMAGE_PATH);
        nameToIconPath.put("uptodate", PROPERTY_IMAGE_PATH);
        nameToIconPath.put("import", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/Import16.png"));
        nameToIconPath.put("include", AntNodeRendererCustomizer.getImageURL("/images/node-customizer/Include16.png"));
    }
}

