/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.dtd;

import com.oxygenxml.tokenmarker.AbstractLexer;
import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class DTDLexer
extends AbstractLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int DTD_DECLARATION = 2;
    public static final int EMBEDED_DOCTYPE = 4;
    public static final int SAFE_MODE = 6;
    public static final int SQ_STRING = 8;
    public static final int DQ_STRING = 10;
    public static final int COMMENT = 12;
    public static final int INSTR = 14;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\f\u0001-\u0001-\u0001-\u0001-\u0012\u0000\u0001\t\u0001\u000e\u0001\u0001\u0001\u001e\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u0003\u0001+\u0001+\u0001%\u0001,\u0001(\u0001&\r\u0000\u0001\r\u0001\u0004\u0001\u0000\u0001\n\u0001\u0005\u0001\u0000\u0001\u0014\u0001#\u0001\u0019\u0001\u001b\u0001\u000f\u0001\u001f\u0001\u001c\u0001\u0000\u0001\u0015\u0001\u0000\u0001$\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0018\u0001\"\u0001!\u0001\u001d\u0001\u0016\u0001\u0013\u0001\u001a\u0002\u0000\u0001 \u0001\u0017\u0001\u0000\u0001'\u0001\u0002\u0001*\u000e\u0000\u0001\b\u0001\u0007\n\u0000\u0001\u0006\u0003\u0000\u0001)\b\u0000\u0001-\u1fa2\u0000\u0001-\u0001-\udfd6\u0000";
    private static final char[] ZZ_CMAP = DTDLexer.zzUnpackCMap("\t\u0000\u0001\f\u0001-\u0001-\u0001-\u0001-\u0012\u0000\u0001\t\u0001\u000e\u0001\u0001\u0001\u001e\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u0003\u0001+\u0001+\u0001%\u0001,\u0001(\u0001&\r\u0000\u0001\r\u0001\u0004\u0001\u0000\u0001\n\u0001\u0005\u0001\u0000\u0001\u0014\u0001#\u0001\u0019\u0001\u001b\u0001\u000f\u0001\u001f\u0001\u001c\u0001\u0000\u0001\u0015\u0001\u0000\u0001$\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0018\u0001\"\u0001!\u0001\u001d\u0001\u0016\u0001\u0013\u0001\u001a\u0002\u0000\u0001 \u0001\u0017\u0001\u0000\u0001'\u0001\u0002\u0001*\u000e\u0000\u0001\b\u0001\u0007\n\u0000\u0001\u0006\u0003\u0000\u0001)\b\u0000\u0001-\u1fa2\u0000\u0001-\u0001-\udfd6\u0000");
    private static final int[] ZZ_ACTION = DTDLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\b\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0003\u0001\u0006\u0001\u0007\u0007\u0003\u0001\u0000\u0001\u0003\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0003\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0013\u0001\u0016\u0001\u0017\u0001\u0013\u0002\u0018\u0001\u0000\u0001\u0019\u0001\u0018\u0001\u001a\u0001\u001b\u0001\u0000\u0001\u001c\u0001\u001d\u0001\u0004\u0001\u0005\u0001\u001e\u0001\u0000\u0001\u001c\u0004\u0000\u0004\u0003\u0001\u001f\u0001\u0003\u0004\u0000\u0001\u0003\u0001\u000e\u0001\u000f\u0001\u0000\u0001 \u0004\u0000\u0001!\u0002\u0000\u0001\"\u0001\u001c\u0001\u001d\u0001\u001e\u0007\u0000\u0003\u0003\u0001\u001f\u0002\u0003\u0004\u0000\u0001\u0003\u0001\u001d\u0001\u001e\u0002\u0000\u0001#\u0001$\u0001\u0000\u0001%\u0001&\u0006\u0000\u0004\u0003\u0004\u0000\u0001\u0003\u0001'\u0001(\u0007\u0000\u0002\u0003\u0001\u001f\u0004\u0000\u0001\u0003\u0007\u0000\u0002\u0003\u0001\u0000\u0001)\u0003\u0000\u0001*\u0001\u0000\u0001\u0003\u0001\u001f\u0001+\u0001\u0000";
    private static final int[] ZZ_ROWMAP = DTDLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000.\u0000\\\u0000\u008a\u0000\u00b8\u0000\u00e6\u0000\u0114\u0000\u0142\u0000\u0170\u0000\u019e\u0000\u01cc\u0000\u01fa\u0000\u0228\u0000\u0256\u0000\u0284\u0000\u02b2\u0000\u02e0\u0000\u02e0\u0000\u030e\u0000\u033c\u0000\u036a\u0000\u0398\u0000\u03c6\u0000\u03f4\u0000\u0422\u0000\u0450\u0000\u047e\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u04ac\u0000\u04da\u0000\u0508\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u02e0\u0000\u0536\u0000\u02e0\u0000\u02e0\u0000\u0564\u0000\u0592\u0000\u05c0\u0000\u0592\u0000\u05ee\u0000\u061c\u0000\u064a\u0000\u0678\u0000\u06a6\u0000\u01fa\u0000\u02e0\u0000\u06d4\u0000\u0702\u0000\u02e0\u0000\u0730\u0000\u030e\u0000\u075e\u0000\u078c\u0000\u07ba\u0000\u07e8\u0000\u0816\u0000\u0844\u0000\u0872\u0000\u08a0\u0000\u08ce\u0000\u08fc\u0000\u092a\u0000\u0958\u0000\u0986\u0000\u09b4\u0000\u09e2\u0000\u0a10\u0000\u0a3e\u0000\u0a6c\u0000\u02e0\u0000\u0a9a\u0000\u0ac8\u0000\u0af6\u0000\u0b24\u0000\u02e0\u0000\u0b52\u0000\u0b80\u0000\u02e0\u0000\u06a6\u0000\u0256\u0000\u0284\u0000\u0bae\u0000\u0bdc\u0000\u0c0a\u0000\u0c38\u0000\u0c66\u0000\u0c94\u0000\u0cc2\u0000\u0cf0\u0000\u0d1e\u0000\u0d4c\u0000\u0228\u0000\u0d7a\u0000\u0da8\u0000\u0dd6\u0000\u0e04\u0000\u0e32\u0000\u0e60\u0000\u0e8e\u0000\u04ac\u0000\u04da\u0000\u0ebc\u0000\u0eea\u0000\u02e0\u0000\u02e0\u0000\u0f18\u0000\u02e0\u0000\u02e0\u0000\u0f46\u0000\u0f74\u0000\u0fa2\u0000\u0fd0\u0000\u0ffe\u0000\u102c\u0000\u105a\u0000\u1088\u0000\u10b6\u0000\u10e4\u0000\u1112\u0000\u1140\u0000\u116e\u0000\u119c\u0000\u11ca\u0000\u02e0\u0000\u02e0\u0000\u11f8\u0000\u1226\u0000\u1254\u0000\u1282\u0000\u12b0\u0000\u12de\u0000\u130c\u0000\u133a\u0000\u1368\u0000\u1396\u0000\u13c4\u0000\u13f2\u0000\u1420\u0000\u144e\u0000\u147c\u0000\u14aa\u0000\u14d8\u0000\u1506\u0000\u1534\u0000\u1562\u0000\u1590\u0000\u15be\u0000\u15ec\u0000\u161a\u0000\u1648\u0000\u02e0\u0000\u1676\u0000\u16a4\u0000\u16d2\u0000\u02e0\u0000\u1700\u0000\u1396\u0000\u02e0\u0000\u02e0\u0000\u172e";
    private static final int[] ZZ_TRANS = DTDLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\n\u0001\u0000\u0003\t\u0001\u000b\u0001\u0000\u0001\f\u0001\u000b\u0001\t\u0001\u0000\u000f\t\u0001\u0000\u0006\t\u0001\u0000\u0001\t\u0006\u0000\u0001\t\u0001\r\u0001\u000e\u0001\r\u0001\u000f\u0001\u0010\u0001\u0011\u0003\r\u0001\u000b\u0001\u0012\u0001\u0013\u0001\u000b\u0001\r\u0001\u0014\u0001\u0015\u0002\r\u0001\u0016\u0001\r\u0001\u0017\u0001\u0018\u0003\r\u0001\u0019\u0004\r\u0001\u001a\u0003\r\u0001\u001b\u0002\r\u0001\u001c\u0001\r\u0001\u001d\u0001\u001e\u0001\u001f\u0001\u001d\u0001 \u0001!\u0002\r\u0001\"\u0001\r\u0001#\u0001$\u0001\u0011\u0003\r\u0001\u000b\u0001%\u0001\u0013\u0001\u000b\u0001\r\u0001\u0014\u0001\u0015\u0002\r\u0001\u0016\u0001\r\u0001\u0017\u0001\u0018\u0003\r\u0001\u0019\u0004\r\u0001\u001a\u0003\r\u0001\u001b\u0002\r\u0001\u001c\u0001\r\u0001&\u0001\u001e\u0001\u001f\u0001'\u0001 \u0001!\u0001\r\u0004(\u0001)\u0005(\u0001*\"(\u0001\u0000\u0002(\u0001+\u0001,)(\u0001\u0000\u0001(\u0001-\u0001.*(\u0001\u0000&/\u00010\u0006/\u00011\u00052\u00013(2\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0003\t\u0002\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u000f\t\u0001\u0000\u0006\t\u0001\u0000\u0001\t\u0006\u0000\u0001\t\u0005\u0000\u00014\b\u0000\u00015(\u0000\u0001\u000b\u0002\u0000\u0001\u000b!\u0000\u0001\f\u00016\u0001\f\u00036\u0003\f\u0001\u0000\u00016\u0001\t\u0001\u0000\u00017\u00016\u000f\f\u00016\u0006\f\u00016\u0001\f\u00066\u0001\f\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000f\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0001\u000e\u00018\u00019+\u000e\u0002\u000f\u0001:\u0001;*\u000f\u000e\u0000\u0001<M\u0000\u0001\u0013\u00016\u0001\u0013\u00036\u0003\u0013\u0001\u0000\u00016\u0001\r\u0001\u0000\u0001=\u00016\u000f\u0013\u00016\u0006\u0013\u00016\u0001\u0013\u00066\u0001\u0013\u000f\u0000\u0001>\u0002\u0000\u0001?\u0001\u0000\u0001@\u0001A\u0018\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0002\r\u0001B\u0001C\u000b\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0002\r\u0001D\f\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0003\r\u0001E\u000b\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\f\r\u0001F\u0002\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\f\r\u0001G\u0002\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0015\u0000\u0001H\u0007\u0000\u0001I\u0001\u0000\u0001J\u0002\u0000\u0001K\u000b\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000b\r\u0001L\u0003\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0001\"\u00018\u0001M+\"\u0002#\u0001N\u0001;*#\u000e\u0000\u0001O\"\u0000\u0001P+\u0000\u0001P,\u0000&1\u0001Q-1\u0001R\u00071\u00052\u0001S(2\u0005T\u0001S\u0004T\u0001U#T\u0006\u0000\u0001VM\u0000\u0001W\u0001X\u0006\u0000\t6\u0001\u0000\u00016\u0002\u0000\u0001Y 6\u0001\u000e\u0001Z\u00019+\u000e\u0002\u000f\u0001:\u0001[*\u000f&\u0000\u0001\\\u0017\u0000\u0001]\u0001\u0000\u0001^3\u0000\u0001_(\u0000\u0001`,\u0000\u0001a\t\u0000\u0001b\u0011\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000f\r\u0001\u0000\u0003\r\u0001c\u0002\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0001d\n\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0001e\n\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\b\r\u0001f\u0006\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000e\r\u0001g\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0005\r\u0001h\t\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0011\u0000\u0001i+\u0000\u0001j3\u0000\u0001k1\u0000\u0001l\u0014\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000f\r\u0001\u0000\u0004\r\u0001m\u0001\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0001\"\u0001n\u0001M+\"\u0002#\u0001N\u0001o*#&\u0000\u0001p\u0007\u0000&1\u0001q\u00111\u0001r\u001b1\u0001q\u00071\u0005T\u0001S\u0004T\u0001s(T\u0001S(T\u0007\u0000\u0001tL\u0000\u0001u-\u0000\u0001v\u0016\u0000\u0001w1\u0000\u0001x-\u0000\u0001y-\u0000\u0001z3\u0000\u0001{&\u0000\u0001|\u001b\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0001E\n\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0006\r\u0001}\b\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\t\r\u0001~\u0005\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0001\u007f\u000e\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0001\u0080\n\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\"\u0000\u0001\u0081,\u0000\u0001\u0082,\u0000\u0001\u0083(\u0000\u0001\u0084\u0012\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0085\r\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r&\u0000\u0001\u0086\u0007\u0000\n1\u0001\u0087\u001b1\u0001q\u00071\b\u0000\u0001\u00886\u0000\u0001\u00891\u0000\u0001\u008a,\u0000\u0001\u008b)\u0000\u0001\u008c-\u0000\u0001\u008d5\u0000\u0001\u008e\u0015\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0004\r\u0001\u008f\n\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000f\r\u0001\u0000\u0005\r\u0001\u0090\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u000f\r\u0001\u0000\u0001\u0091\u0005\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0005\r\u0001f\t\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0010\u0000\u0001\u00927\u0000\u0001\u0093\"\u0000\u0001\u00942\u0000\u0001\u0095\u0019\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0006\r\u0001\u0096\b\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\t\u0000\u0001\u00973\u0000\u0001\u00981\u0000\u0001\u0099-\u0000\u0001\u009a/\u0000\u0001\u009b2\u0000\u0001\u009c0\u0000\u0001\u009d\u0010\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0006\r\u0001\u009e\u0001\r\u0001f\u0006\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0001\u009f\u000e\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0007\r\u0001f\u0007\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0015\u0000\u0001\u0083-\u0000\u0001\u00a03\u0000\u0001\u00a1%\u0000\u0001\u00a2\u001a\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\n\r\u0001f\u0004\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u0005\u0097\u0001\u00a3(\u0097\u0012\u0000\u0001\u00a42\u0000\u0001\u00a5+\u0000\u0001\u00a6.\u0000\u0001\u00a42\u0000\u0001\u009d!\u0000\u0001\u00a5\u001e\u0000\u0001\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0001\u00a7\u000e\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0002\r\u0001\u0000\u0001\r\u0003\u0000\u0003\r\u0002\u0000\u0001\r\u0001\u0000\u0001\r\u0001\u0000\u0003\r\u0001\u0091\u000b\r\u0001\u0000\u0006\r\u0001\u0000\u0001\r\u0006\u0000\u0001\r\u001d\u0000\u0001\u0083$\u0000\u0001\u00a8#\u0000\u0001\u00a96\u0000\u0001\u00a52\u0000\u0001\u00aa'\u0000\u0001\u00a5\u001b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = DTDLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\b\u0000\b\u0001\u0002\t\u0007\u0001\u0001\u0000\u0001\u0001\u0006\t\u0003\u0001\u0006\t\u0001\u0001\u0002\t\u0003\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0001\u0000\u0001\u0001\u0004\u0000\u0006\u0001\u0004\u0000\u0003\u0001\u0001\u0000\u0001\t\u0004\u0000\u0001\t\u0002\u0000\u0001\t\u0003\u0001\u0007\u0000\u0006\u0001\u0004\u0000\u0003\u0001\u0002\u0000\u0002\t\u0001\u0000\u0002\t\u0006\u0000\u0004\u0001\u0004\u0000\u0001\u0001\u0002\t\u0007\u0000\u0003\u0001\u0004\u0000\u0001\u0001\u0007\u0000\u0002\u0001\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0001\u0001\u0002\t\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private static final byte SYM_COMMA = 9;
    private static final byte SYM_BRACKET = 20;
    private static final byte SYM_SQUARE_BRACKET = 23;
    private static final byte SYM_PIPE = 9;
    private static final byte SYM_QUESTION = 9;
    private static final byte SYM_ASTERISK = 9;
    private static final byte SYM_PLUS = 9;
    private static final byte SYM_KEYWORD1 = 6;
    private static final byte SYM_KEYWORD2 = 7;
    private static final byte SYM_KEYWORD3 = 8;
    private static final byte SYM_XML_HEADER = 16;
    private static final byte SYM_STRING_DQ = 3;
    private static final byte SYM_STRING_SQ = 4;
    public static final byte SYM_INSTR_START = 5;
    public static final byte SYM_INSTR = 5;
    public static final byte SYM_INSTR_END = 5;
    private static final byte SYM_COMMENT = 1;
    private static final byte SYM_PARAM_ENTITY = 2;
    private static final byte SYM_DOCTYPE = 12;
    private static final byte SYM_INVALID = 10;
    private byte embededDoctypeLevel = 0;

    private static int[] zzUnpackAction() {
        int[] result = new int[170];
        int offset = 0;
        offset = DTDLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[170];
        int offset = 0;
        offset = DTDLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[5980];
        int offset = 0;
        offset = DTDLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[170];
        int offset = 0;
        offset = DTDLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public DTDLexer() {
    }

    @Override
    public String getName() {
        return "DTD";
    }

    public DTDLexer(Reader in) {
        this.zzReader = in;
    }

    public DTDLexer(InputStream in) {
        this(new InputStreamReader(in, Charset.forName("UTF-8")));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 138) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    @Override
    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    @Override
    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) throws LexerException {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new LexerException(message);
    }

    public void yypushback(int number) throws LexerException {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public Symbol yylex() throws IOException, LexerException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block100: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.symbol((byte)10);
                }
                case 44: {
                    continue block100;
                }
                case 2: {
                    this.yybegin(6);
                    return this.symbol((byte)10);
                }
                case 45: {
                    continue block100;
                }
                case 3: {
                    return this.symbol((byte)12);
                }
                case 46: {
                    continue block100;
                }
                case 4: {
                    this.pushState(2);
                    this.yybegin(10);
                    return this.symbol((byte)3);
                }
                case 47: {
                    continue block100;
                }
                case 5: {
                    this.pushState(2);
                    this.yybegin(8);
                    return this.symbol((byte)4);
                }
                case 48: {
                    continue block100;
                }
                case 6: {
                    return this.symbol((byte)9);
                }
                case 49: {
                    continue block100;
                }
                case 7: {
                    this.yybegin(0);
                    return this.symbol((byte)12);
                }
                case 50: {
                    continue block100;
                }
                case 8: {
                    return this.symbol((byte)9);
                }
                case 51: {
                    continue block100;
                }
                case 9: {
                    return this.symbol((byte)23);
                }
                case 52: {
                    continue block100;
                }
                case 10: {
                    return this.symbol((byte)9);
                }
                case 53: {
                    continue block100;
                }
                case 11: {
                    return this.symbol((byte)9);
                }
                case 54: {
                    continue block100;
                }
                case 12: {
                    return this.symbol((byte)20);
                }
                case 55: {
                    continue block100;
                }
                case 13: {
                    return this.symbol((byte)9);
                }
                case 56: {
                    continue block100;
                }
                case 14: {
                    this.pushState(4);
                    this.yybegin(10);
                    return this.symbol((byte)3);
                }
                case 57: {
                    continue block100;
                }
                case 15: {
                    this.pushState(4);
                    this.yybegin(8);
                    return this.symbol((byte)4);
                }
                case 58: {
                    continue block100;
                }
                case 16: {
                    if (this.embededDoctypeLevel <= 0) {
                        this.yybegin(0);
                    }
                    return this.symbol((byte)12);
                }
                case 59: {
                    continue block100;
                }
                case 17: {
                    this.embededDoctypeLevel = (byte)(this.embededDoctypeLevel + 1);
                    return this.symbol((byte)23);
                }
                case 60: {
                    continue block100;
                }
                case 18: {
                    this.embededDoctypeLevel = (byte)(this.embededDoctypeLevel - 1);
                    return this.symbol((byte)23);
                }
                case 61: {
                    continue block100;
                }
                case 19: {
                    ++this.cLen;
                }
                case 62: {
                    continue block100;
                }
                case 20: {
                    this.yypushback(1);
                    this.yybegin(0);
                    return this.flush((byte)10);
                }
                case 63: {
                    continue block100;
                }
                case 21: {
                    ++this.cLen;
                    this.yybegin(0);
                    return this.flush((byte)10);
                }
                case 64: {
                    continue block100;
                }
                case 22: {
                    this.yybegin(this.popState());
                    ++this.cLen;
                    return this.flush((byte)4);
                }
                case 65: {
                    continue block100;
                }
                case 23: {
                    this.yybegin(this.popState());
                    ++this.cLen;
                    return this.flush((byte)3);
                }
                case 66: {
                    continue block100;
                }
                case 24: {
                    ++this.cLen;
                }
                case 67: {
                    continue block100;
                }
                case 25: {
                    this.cLen += this.yylength();
                }
                case 68: {
                    continue block100;
                }
                case 26: {
                    this.yybegin(14);
                    return this.symbol((byte)5);
                }
                case 69: {
                    continue block100;
                }
                case 27: {
                    this.yypushback(this.yylength());
                    this.yybegin(2);
                }
                case 70: {
                    continue block100;
                }
                case 28: {
                    return this.symbol((byte)2);
                }
                case 71: {
                    continue block100;
                }
                case 29: {
                    return this.symbol((byte)3);
                }
                case 72: {
                    continue block100;
                }
                case 30: {
                    return this.symbol((byte)4);
                }
                case 73: {
                    continue block100;
                }
                case 31: {
                    return this.symbol((byte)8);
                }
                case 74: {
                    continue block100;
                }
                case 32: {
                    this.cLen += 2;
                }
                case 75: {
                    continue block100;
                }
                case 33: {
                    this.yybegin(0);
                    return this.symbol((byte)5);
                }
                case 76: {
                    continue block100;
                }
                case 34: {
                    this.yypushback(this.yylength());
                    this.yybegin(4);
                }
                case 77: {
                    continue block100;
                }
                case 35: {
                    this.yybegin(this.popState());
                    return this.symbol((byte)1);
                }
                case 78: {
                    continue block100;
                }
                case 36: {
                    this.yypushback(2);
                    return this.symbol((byte)5);
                }
                case 79: {
                    continue block100;
                }
                case 37: {
                    this.pushState(0);
                    this.yybegin(12);
                    return this.symbol((byte)1);
                }
                case 80: {
                    continue block100;
                }
                case 38: {
                    this.pushState(2);
                    this.yybegin(12);
                    return this.symbol((byte)1);
                }
                case 81: {
                    continue block100;
                }
                case 39: {
                    this.pushState(4);
                    this.yybegin(12);
                    return this.symbol((byte)1);
                }
                case 82: {
                    continue block100;
                }
                case 40: {
                    this.yypushback(3);
                    return this.symbol((byte)1);
                }
                case 83: {
                    continue block100;
                }
                case 41: {
                    return this.symbol((byte)7);
                }
                case 84: {
                    continue block100;
                }
                case 42: {
                    return this.symbol((byte)6);
                }
                case 85: {
                    continue block100;
                }
                case 43: {
                    return this.symbol((byte)16);
                }
                case 86: {
                    continue block100;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 6: {
                        return this.flush((byte)10);
                    }
                    case 171: {
                        continue block100;
                    }
                    case 8: {
                        return this.flush((byte)4);
                    }
                    case 172: {
                        continue block100;
                    }
                    case 10: {
                        return this.flush((byte)3);
                    }
                    case 173: {
                        continue block100;
                    }
                    case 12: {
                        return this.flush((byte)1);
                    }
                    case 174: {
                        continue block100;
                    }
                    case 14: {
                        return this.flush((byte)5);
                    }
                    case 175: {
                        continue block100;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

