/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import com.oxygenxml.tokenmarker.LexicalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LexicalStateOverLong
implements LexicalState {
    private static final Logger logger = LoggerFactory.getLogger((String)LexicalStateOverLong.class.getName());
    private static final int HASH_CODE = 15;
    protected long bits = 0L;
    private static final long BYTE_LENGTH = 8L;
    private static final long MAX_STACK_SIZE = 5L;
    private static final long NESTING_LEVEL_OFFSET = 8L;
    private static final long STACK_LENGTH_OFFSET = 16L;
    private static final long BYTE_ONE_OFFSET = 24L;
    private static final long BYTE_TWO_OFFSET = 32L;
    private static final long BYTE_THREE_OFFSET = 40L;
    private static final long BYTE_FOUR_OFFSET = 48L;
    private static final long BYTE_FIVE_OFFSET = 56L;
    private static final long STACK_LEN_DISPLACEMENT = 40L;
    private static final long NESTING_LEVEL_DISPLACEMENT = 48L;
    private static final long YYSTATE_DISPLACEMENT = 56L;
    private static final long BIT_MASK_YYSTATE = -72057594037927936L;
    private static final long BIT_MASK_YYSTATE_NEGATED = 0xFFFFFFFFFFFFFFL;
    private static final long BIT_MASK_NESTING_LEVEL = -72057594037927936L >>> 8;
    private static final long BIT_MASK_NESTING_LEVEL_NEGATED = BIT_MASK_NESTING_LEVEL ^ 0xFFFFFFFFFFFFFFFFL;
    private static final long BIT_MASK_STACK_LEN = -72057594037927936L >>> 16;
    private static final long BIT_MASK_STACK_LEN_NEGATED = BIT_MASK_STACK_LEN ^ 0xFFFFFFFFFFFFFFFFL;
    private static final long[] BIT_MASK_STACK_ENTRIES = new long[]{-72057594037927936L >>> 24, -72057594037927936L >>> 32, -72057594037927936L >>> 40, -72057594037927936L >>> 48, -72057594037927936L >>> 56};
    private static final long[] BIT_MASK_STACK_ENTRIES_NEGATED = new long[]{-72057594037927936L >>> 24 ^ 0xFFFFFFFFFFFFFFFFL, -72057594037927936L >>> 32 ^ 0xFFFFFFFFFFFFFFFFL, -72057594037927936L >>> 40 ^ 0xFFFFFFFFFFFFFFFFL, -72057594037927936L >>> 48 ^ 0xFFFFFFFFFFFFFFFFL, -72057594037927936L >>> 56 ^ 0xFFFFFFFFFFFFFFFFL};

    @Override
    public int pop() {
        int s = 0;
        byte stackLen = (byte)((this.bits & BIT_MASK_STACK_LEN) >>> 40);
        if (stackLen > 0) {
            s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> (int)(8L * (5L - (long)stackLen)));
            stackLen = (byte)(stackLen - 1);
            this.bits &= BIT_MASK_STACK_LEN_NEGATED;
            this.bits |= (long)stackLen << 40;
        }
        return s;
    }

    @Override
    public int peek() {
        int s = -1;
        byte stackLen = (byte)((this.bits & BIT_MASK_STACK_LEN) >>> 40);
        if (stackLen > 0) {
            s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> (int)(8L * (5L - (long)stackLen)));
        }
        return s;
    }

    @Override
    public void push(int val) {
        byte stackLen = (byte)((this.bits & BIT_MASK_STACK_LEN) >>> 40);
        if ((long)stackLen < 5L) {
            stackLen = (byte)(stackLen + 1);
            this.bits &= BIT_MASK_STACK_ENTRIES_NEGATED[stackLen - 1];
            this.bits |= (long)val << (int)(8L * (5L - (long)stackLen));
            this.bits &= BIT_MASK_STACK_LEN_NEGATED;
            this.bits |= (long)stackLen << 40;
        } else {
            logger.error("Lexical state stack overflow. State: {}", (Object)val);
        }
    }

    @Override
    public int contains(int state) {
        byte stackLen = (byte)((this.bits & BIT_MASK_STACK_LEN) >>> 40);
        if (stackLen > 0) {
            for (int i = stackLen - 1; i >= 0; --i) {
                byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[i]) >>> (int)(8L * (5L - (long)(i + 1))));
                if (state != s) continue;
                return stackLen - i;
            }
        }
        return -1;
    }

    @Override
    public int getYYState() {
        return (int)((this.bits & 0xFF00000000000000L) >>> 56);
    }

    @Override
    public void setYYState(int yystate) {
        this.bits &= 0xFFFFFFFFFFFFFFL;
        this.bits |= (long)yystate << 56;
    }

    @Override
    public int getNestingLevel() {
        return (int)((this.bits & BIT_MASK_NESTING_LEVEL) >>> 48);
    }

    @Override
    public void setNestingLevel(int nestingLevel) {
        this.bits &= BIT_MASK_NESTING_LEVEL_NEGATED;
        this.bits |= (long)nestingLevel << 48;
    }

    public String toString() {
        byte stackLen = (byte)((this.bits & BIT_MASK_STACK_LEN) >>> 40);
        byte nestingLevel = (byte)((this.bits & BIT_MASK_NESTING_LEVEL) >>> 48);
        return "{ yystate = " + this.getYYState() + ", nestingLevel = " + nestingLevel + ", sl = " + stackLen + ", bits = " + Long.toBinaryString(this.bits) + "}";
    }

    public boolean equals(Object obj) {
        if (obj instanceof LexicalStateOverLong) {
            LexicalStateOverLong lsw = (LexicalStateOverLong)obj;
            return this.bits == lsw.bits;
        }
        return false;
    }

    public int hashCode() {
        return 15;
    }

    @Override
    public LexicalState clone() {
        LexicalStateOverLong lsw;
        try {
            lsw = (LexicalStateOverLong)super.clone();
        }
        catch (CloneNotSupportedException e) {
            lsw = new LexicalStateOverLong();
        }
        lsw.bits = this.bits;
        return lsw;
    }
}

