/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.ant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathMLConverter
extends MatchingTask {
    private static final String CURRENT_DIR = "./";
    private static final char EXTENSION_SEP = '.';
    private File mdestDir;
    private File mbaseDir;
    private File minFile;
    private File moutFile;
    private String moutType = "image/png";
    private boolean mforce;
    private final MutableLayoutContext context = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
    private final FileUtils fileUtils = FileUtils.getFileUtils();

    public void execute() {
        if (this.mbaseDir == null) {
            this.mbaseDir = this.getProject().resolveFile(CURRENT_DIR);
            this.log("Base is not sets, sets to " + this.mbaseDir, 1);
        }
        if (this.minFile != null && this.moutFile != null) {
            this.log("Transforming file: " + this.minFile + " --> " + this.moutFile, 3);
            try {
                Converter.getInstance().convert(this.minFile, this.moutFile, this.moutType, (LayoutContext)this.context);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            return;
        }
        if (this.mdestDir == null) {
            throw new BuildException("m_destDir attributes must be set!");
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.mbaseDir);
        this.log("Transforming into " + this.mdestDir, 2);
        Object[] objectArray = directoryScanner.getIncludedFiles();
        this.log("Included files: " + Arrays.toString(objectArray), 3);
        this.process(this.mbaseDir, Arrays.asList(objectArray), this.mdestDir);
        Object[] objectArray2 = directoryScanner.getIncludedDirectories();
        this.log("Included directories: " + Arrays.toString(objectArray2), 3);
        for (Object object : objectArray2) {
            objectArray = this.fileUtils.resolveFile(this.mbaseDir, (String)object).list();
            this.process(this.mbaseDir, Arrays.asList(objectArray), this.mdestDir);
        }
    }

    public void setAntiAlias(boolean bl) {
        this.setOption(Parameter.ANTIALIAS, bl);
    }

    public void setAntiAliasMinSize(float f) {
        this.setOption(Parameter.ANTIALIAS_MINSIZE, Float.valueOf(f));
    }

    public void setBackgroundColor(String string) {
        if (this.isNullOrEmpty(string)) {
            this.log("Attribute \"backgroundcolor\" is empty, not used", 1);
        } else {
            this.setOption(Parameter.MATHBACKGROUND, string);
        }
    }

    public void setDebug(boolean bl) {
        this.setOption(Parameter.DEBUG, bl);
    }

    public void setDisplay(String string) {
        this.setOption(Parameter.DISPLAY, string);
    }

    public void setFontsDoublestruck(String string) {
        this.setOption(Parameter.FONTS_DOUBLESTRUCK, string);
    }

    public void setFontsFraktur(String string) {
        this.setOption(Parameter.FONTS_FRAKTUR, string);
    }

    public void setFontSize(float f) {
        this.setOption(Parameter.MATHSIZE, Float.valueOf(f));
    }

    public void setFontsMonospaced(String string) {
        this.setOption(Parameter.FONTS_MONOSPACED, string);
    }

    public void setFontsSansSerif(String string) {
        this.setOption(Parameter.FONTS_SANSSERIF, string);
    }

    public void setFontsScript(String string) {
        this.setOption(Parameter.FONTS_SCRIPT, string);
    }

    public void setFontsSerif(String string) {
        this.setOption(Parameter.FONTS_SERIF, string);
    }

    public void setForegroundColor(String string) {
        if (this.isNullOrEmpty(string)) {
            this.log("Attribute \"foregroundcolor\" is empty, use default color", 1);
        } else {
            this.setOption(Parameter.MATHCOLOR, string);
        }
    }

    public void setMfracKeepScriptLevel(boolean bl) {
        this.setOption(Parameter.MFRAC_KEEP_SCRIPTLEVEL, bl);
    }

    public void setScriptLevel(int n) {
        this.setOption(Parameter.SCRIPTLEVEL, n);
    }

    public void setScriptMinSize(float f) {
        this.setOption(Parameter.SCRIPTMINSIZE, Float.valueOf(f));
    }

    public void setScriptSizeMult(float f) {
        this.setOption(Parameter.SCRIPTSIZEMULTIPLIER, Float.valueOf(f));
    }

    public void setForce(boolean bl) {
        this.logProperty("force", bl);
        this.mforce = bl;
    }

    public void setBasedir(File file) {
        this.logProperty("basedir", file);
        this.mbaseDir = file;
    }

    public void setDestdir(File file) {
        this.logProperty("destdir", file);
        this.mdestDir = file;
    }

    public void setOut(File file) {
        this.logProperty("out", file);
        this.moutFile = file;
    }

    public void setIn(File file) {
        this.logProperty("in", file);
        this.minFile = file;
    }

    public void setType(String string) {
        this.logProperty("type", string);
        this.moutType = string;
    }

    private void process(File file, List<String> list, File file2) {
        for (String string : list) {
            File file3 = null;
            File file4 = null;
            String string2 = '.' + ConverterRegistry.getInstance().getSuffixForMimeType(this.moutType);
            this.log("Found extension: " + string2, 4);
            try {
                file4 = this.fileUtils.resolveFile(file, string);
                int n = string.lastIndexOf(46);
                file3 = n > 0 ? this.fileUtils.resolveFile(file2, string.substring(0, n) + string2) : this.fileUtils.resolveFile(file2, string + string2);
                this.log("Input file: " + file4, 4);
                this.log("Output file: " + file3, 4);
                if (!this.mforce && this.fileUtils.isUpToDate(file4, file3)) continue;
                this.fileUtils.createNewFile(file3, true);
                Converter.getInstance().convert(file4, file3, this.moutType, (LayoutContext)this.context);
            }
            catch (IOException iOException) {
                this.log("Failed to process " + file4, 0);
                FileUtils.delete(file3);
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    private void setOption(Parameter parameter, String string) {
        this.setOption(parameter, parameter.fromString(string));
    }

    private void setOption(Parameter parameter, Object object) {
        this.logProperty(parameter.getOptionName(), object);
        this.context.setParameter(parameter, object);
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void logProperty(String string, Object object) {
        this.log("Sets property \"" + string + "\" with value: " + object, 4);
    }
}

